/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.handlers;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageSizeEstimator;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.ServerProt;
import net.rsprot.protocol.api.repositories.MessageEncoderRepositories;
import net.rsprot.protocol.client.ClientType;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.message.OutgoingGameMessage;
import net.rsprot.protocol.message.OutgoingJs5Message;
import net.rsprot.protocol.message.OutgoingLoginMessage;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.outgoing.MessageEncoderRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;", "Lio/netty/channel/MessageSizeEstimator;", "repositories", "Lnet/rsprot/protocol/api/repositories/MessageEncoderRepositories;", "(Lnet/rsprot/protocol/api/repositories/MessageEncoderRepositories;)V", "gameEncoder", "Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "Lnet/rsprot/protocol/ServerProt;", "loginEncoder", "singleton", "Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator$OutgoingMessageSizeEstimatorHandle;", "supportsMultiplePlatforms", "", "newHandle", "Lio/netty/channel/MessageSizeEstimator$Handle;", "Companion", "OutgoingMessageSizeEstimatorHandle", "osrs-225-api"})
@SourceDebugExtension(value={"SMAP\nOutgoingMessageSizeEstimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutgoingMessageSizeEstimator.kt\nnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,143:1\n11#2,2:144\n*S KotlinDebug\n*F\n+ 1 OutgoingMessageSizeEstimator.kt\nnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator\n*L\n140#1:144,2\n*E\n"})
public final class OutgoingMessageSizeEstimator
implements MessageSizeEstimator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean supportsMultiplePlatforms;
    @NotNull
    private final MessageEncoderRepository<ServerProt> gameEncoder;
    @NotNull
    private final MessageEncoderRepository<ServerProt> loginEncoder;
    @NotNull
    private final OutgoingMessageSizeEstimatorHandle singleton;
    @NotNull
    private static final OldSchoolClientType ESTIMATOR_CLIENT_TYPE = OldSchoolClientType.DESKTOP;
    private static final int TWO_BYTE_OPCODE_THRESHOLD = 128;
    private static final int FILE_REGION_SIZE = 0;
    private static final int UNKNOWN_MESSAGE_SIZE = 8;
    private static final int UNKNOWN_JS5_MESSAGE_PAYLOAD_SIZE = 512;
    @NotNull
    private static final Logger logger;

    public OutgoingMessageSizeEstimator(@NotNull MessageEncoderRepositories repositories) {
        Intrinsics.checkNotNullParameter((Object)repositories, (String)"repositories");
        this.supportsMultiplePlatforms = repositories.getGameMessageEncoderRepositories().getNotNullSize() > 1;
        this.gameEncoder = (MessageEncoderRepository)repositories.getGameMessageEncoderRepositories().get((ClientType)ESTIMATOR_CLIENT_TYPE);
        this.loginEncoder = repositories.getLoginMessageEncoderRepository();
        this.singleton = new OutgoingMessageSizeEstimatorHandle();
    }

    @NotNull
    public MessageSizeEstimator.Handle newHandle() {
        return this.singleton;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator$Companion;", "", "()V", "ESTIMATOR_CLIENT_TYPE", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "FILE_REGION_SIZE", "", "TWO_BYTE_OPCODE_THRESHOLD", "UNKNOWN_JS5_MESSAGE_PAYLOAD_SIZE", "UNKNOWN_MESSAGE_SIZE", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-225-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator$OutgoingMessageSizeEstimatorHandle;", "Lio/netty/channel/MessageSizeEstimator$Handle;", "(Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;)V", "estimateGameMessageSize", "", "msg", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "estimateJs5MessageSize", "Lnet/rsprot/protocol/message/OutgoingJs5Message;", "estimateLoginMessageSize", "Lnet/rsprot/protocol/message/OutgoingLoginMessage;", "estimateRegularProtocolMessage", "Lnet/rsprot/protocol/message/OutgoingMessage;", "prot", "Lnet/rsprot/protocol/ServerProt;", "size", "", "osrs-225-api"})
    @SourceDebugExtension(value={"SMAP\nOutgoingMessageSizeEstimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutgoingMessageSizeEstimator.kt\nnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator$OutgoingMessageSizeEstimatorHandle\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n*L\n1#1,143:1\n134#2,4:144\n*S KotlinDebug\n*F\n+ 1 OutgoingMessageSizeEstimator.kt\nnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator$OutgoingMessageSizeEstimatorHandle\n*L\n60#1:144,4\n*E\n"})
    private final class OutgoingMessageSizeEstimatorHandle
    implements MessageSizeEstimator.Handle {
        public int size(@NotNull Object msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            try {
                Object object = msg;
                if (object instanceof OutgoingGameMessage) {
                    return this.estimateGameMessageSize((OutgoingGameMessage)msg);
                }
                if (object instanceof OutgoingLoginMessage) {
                    return this.estimateLoginMessageSize((OutgoingLoginMessage)msg);
                }
                if (object instanceof OutgoingJs5Message) {
                    return this.estimateJs5MessageSize((OutgoingJs5Message)msg);
                }
                if (msg instanceof ByteBuf) {
                    return ((ByteBuf)msg).readableBytes();
                }
                if (msg instanceof ByteBufHolder) {
                    return ((ByteBufHolder)msg).content().readableBytes();
                }
                if (msg instanceof FileRegion) {
                    return 0;
                }
                return 8;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Unable to estimate the size of message " + msg), t);
                }
                return 8;
            }
        }

        private final int estimateGameMessageSize(OutgoingGameMessage msg) {
            ServerProt prot = OutgoingMessageSizeEstimator.this.gameEncoder.getEncoder(msg.getClass()).getProt();
            return this.estimateRegularProtocolMessage((OutgoingMessage)msg, prot);
        }

        private final int estimateLoginMessageSize(OutgoingLoginMessage msg) {
            ServerProt prot = OutgoingMessageSizeEstimator.this.loginEncoder.getEncoder(msg.getClass()).getProt();
            return this.estimateRegularProtocolMessage((OutgoingMessage)msg, prot);
        }

        private final int estimateJs5MessageSize(OutgoingJs5Message msg) {
            int estimate = msg.estimateSize();
            if (estimate != -1) {
                return estimate;
            }
            if (msg instanceof ByteBufHolder) {
                return ((ByteBufHolder)msg).content().readableBytes();
            }
            return 512;
        }

        private final int estimateRegularProtocolMessage(OutgoingMessage msg, ServerProt prot) {
            int n;
            int headerSize = OutgoingMessageSizeEstimator.this.supportsMultiplePlatforms || prot.getOpcode() >= 128 ? 2 : 1;
            int constantSize = prot.getSize();
            switch (constantSize) {
                case -1: {
                    n = 1;
                    break;
                }
                case -2: {
                    n = 2;
                    break;
                }
                default: {
                    return headerSize + constantSize;
                }
            }
            headerSize += n;
            int estimate = msg.estimateSize();
            if (estimate != -1) {
                return headerSize + estimate;
            }
            if (msg instanceof ByteBufHolder) {
                return headerSize + ((ByteBufHolder)msg).content().readableBytes();
            }
            return headerSize + 8;
        }
    }
}

