/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.game;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.Session;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.game.GameDisconnectionReason;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.metrics.ChannelTrafficHandlerExtensionsKt;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.message.IncomingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u0019B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/rsprot/protocol/api/game/GameMessageHandler;", "R", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingGameMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "session", "Lnet/rsprot/protocol/api/Session;", "(Lnet/rsprot/protocol/api/NetworkService;Lnet/rsprot/protocol/api/Session;)V", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelWritabilityChanged", "exceptionCaught", "cause", "", "handlerAdded", "handlerRemoved", "userEventTriggered", "evt", "", "Companion", "osrs-225-api"})
@SourceDebugExtension(value={"SMAP\nGameMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameMessageHandler.kt\nnet/rsprot/protocol/api/game/GameMessageHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,133:1\n20#2:134\n44#2,6:135\n52#2:145\n55#2:150\n58#2:155\n61#2:160\n64#2:165\n21#2:166\n20#2:167\n44#2,6:168\n52#2:178\n55#2:183\n58#2:188\n61#2:193\n64#2:198\n21#2:199\n44#2,9:200\n55#2:213\n58#2:218\n61#2:223\n64#2:228\n21#2:229\n20#2:230\n44#2,6:231\n52#2:241\n55#2:246\n58#2:251\n61#2:256\n64#2:261\n21#2:262\n20#2:263\n44#2,6:264\n52#2:274\n55#2:279\n58#2:284\n61#2:289\n64#2:294\n21#2:295\n20#2:296\n44#2,6:297\n52#2:307\n55#2:312\n58#2:317\n61#2:322\n64#2:327\n21#2:328\n32#3,4:141\n56#3,4:146\n80#3,4:151\n104#3,4:156\n128#3,4:161\n32#3,4:174\n56#3,4:179\n80#3,4:184\n104#3,4:189\n128#3,4:194\n56#3,4:209\n80#3,4:214\n104#3,4:219\n128#3,4:224\n32#3,4:237\n56#3,4:242\n80#3,4:247\n104#3,4:252\n128#3,4:257\n32#3,4:270\n56#3,4:275\n80#3,4:280\n104#3,4:285\n128#3,4:290\n32#3,4:303\n56#3,4:308\n80#3,4:313\n104#3,4:318\n128#3,4:323\n11#4,2:329\n*S KotlinDebug\n*F\n+ 1 GameMessageHandler.kt\nnet/rsprot/protocol/api/game/GameMessageHandler\n*L\n44#1:134\n44#1:135,6\n44#1:145\n44#1:150\n44#1:155\n44#1:160\n44#1:165\n44#1:166\n61#1:167\n61#1:168,6\n61#1:178\n61#1:183\n61#1:188\n61#1:193\n61#1:198\n61#1:199\n61#1:200,9\n61#1:213\n61#1:218\n61#1:223\n61#1:228\n61#1:229\n71#1:230\n71#1:231,6\n71#1:241\n71#1:246\n71#1:251\n71#1:256\n71#1:261\n71#1:262\n79#1:263\n79#1:264,6\n79#1:274\n79#1:279\n79#1:284\n79#1:289\n79#1:294\n79#1:295\n115#1:296\n115#1:297,6\n115#1:307\n115#1:312\n115#1:317\n115#1:322\n115#1:327\n115#1:328\n44#1:141,4\n44#1:146,4\n44#1:151,4\n44#1:156,4\n44#1:161,4\n61#1:174,4\n61#1:179,4\n61#1:184,4\n61#1:189,4\n61#1:194,4\n61#1:209,4\n61#1:214,4\n61#1:219,4\n61#1:224,4\n71#1:237,4\n71#1:242,4\n71#1:247,4\n71#1:252,4\n71#1:257,4\n79#1:270,4\n79#1:275,4\n79#1:280,4\n79#1:285,4\n79#1:290,4\n115#1:303,4\n115#1:308,4\n115#1:313,4\n115#1:318,4\n115#1:323,4\n130#1:329,2\n*E\n"})
public final class GameMessageHandler<R>
extends SimpleChannelInboundHandler<IncomingGameMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private final Session<R> session;
    @NotNull
    private static final Logger logger;

    public GameMessageHandler(@NotNull NetworkService<R> networkService, @NotNull Session<R> session) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter(session, (String)"session");
        this.networkService = networkService;
        this.session = session;
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
        this.networkService.getTrafficMonitor().getGameChannelTrafficMonitor().incrementConnections(ChannelExtensionsKt.inetAddress(ctx));
    }

    public void handlerRemoved(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getTrafficMonitor().getGameChannelTrafficMonitor().decrementConnections(ChannelExtensionsKt.inetAddress(ctx));
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_225_api().getGameInetAddressTracker().register(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            this.session.triggerIdleClosing$osrs_225_api();
        }
        finally {
            ctx.fireChannelInactive();
            this.networkService.getINetAddressHandlers$osrs_225_api().getGameInetAddressTracker().deregister(ChannelExtensionsKt.inetAddress(ctx));
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Channel is now inactive: " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Channel is now inactive: " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Channel is now inactive: " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Channel is now inactive: " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Channel is now inactive: " + ctx.channel()));
                    }
                    break;
                }
            }
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingGameMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Incoming game message accepted from channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Incoming game message accepted from channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Incoming game message accepted from channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Incoming game message accepted from channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Incoming game message accepted from channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
        }
        this.session.addIncomingMessage(msg);
    }

    public void channelWritabilityChanged(@NotNull ChannelHandlerContext ctx) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (!ctx.channel().isWritable()) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Channel '" + ctx.channel() + "' is now writable again, continuing to write game packets"));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Channel '" + ctx.channel() + "' is now writable again, continuing to write game packets"));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Channel '" + ctx.channel() + "' is now writable again, continuing to write game packets"));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Channel '" + ctx.channel() + "' is now writable again, continuing to write game packets"));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Channel '" + ctx.channel() + "' is now writable again, continuing to write game packets"));
                    }
                    break;
                }
            }
            this.session.flush();
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_225_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getGameChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), GameDisconnectionReason.EXCEPTION);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getGameChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), GameDisconnectionReason.IDLE);
            ctx.close();
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/game/GameMessageHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-225-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

