/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.worldentityinfo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.game.outgoing.info.ByteBufRecycler;
import net.rsprot.protocol.game.outgoing.info.exceptions.InfoProcessException;
import net.rsprot.protocol.game.outgoing.info.util.BuildArea;
import net.rsprot.protocol.game.outgoing.info.util.ReferencePooledObject;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatar;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatarRepository;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityInfoExtensionsKt;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityInfoPacket;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityProtocol;
import net.rsprot.protocol.game.outgoing.zone.payload.util.CoordInBuildArea;
import net.rsprot.protocol.internal.game.outgoing.info.CoordGrid;
import net.rsprot.protocol.internal.game.outgoing.info.util.ZoneIndexStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0017\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 `2\u00020\u0001:\u0001`B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00100\u001a\u00020\u0016H\u0002J\u0006\u00101\u001a\u00020\u0016J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0003J\b\u00105\u001a\u000203H\u0002J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000307J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000307J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000307J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u00020;H\u0016J\u0010\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020\u0003H\u0002J\u0010\u0010A\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J \u0010B\u001a\u0002032\u0006\u0010@\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010C\u001a\u00020;H\u0016J\b\u0010D\u001a\u000203H\u0016J\u0006\u0010E\u001a\u000203J\u001a\u0010F\u001a\u00020;2\u0006\u0010\u0015\u001a\u00020GH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bH\u0010IJ\u001a\u0010J\u001a\u0002032\u0006\u0010\u0015\u001a\u00020GH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bK\u0010LJ\u0006\u0010M\u001a\u000203J\u001e\u0010N\u001a\u0002032\u0006\u0010O\u001a\u00020\u00032\u0006\u0010P\u001a\u00020\u00032\u0006\u0010Q\u001a\u00020\u0003J\u0006\u0010R\u001a\u00020SJ,\u0010T\u001a\u0002032\u0006\u0010U\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u00032\b\b\u0002\u0010W\u001a\u00020\u00032\b\b\u0002\u0010X\u001a\u00020\u0003H\u0007J\u0018\u0010T\u001a\u0002032\u0006\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00a2\u0006\u0004\bY\u0010ZJ&\u0010[\u001a\u0002032\u0006\u00104\u001a\u00020\u00032\u0006\u0010O\u001a\u00020\u00032\u0006\u0010P\u001a\u00020\u00032\u0006\u0010Q\u001a\u00020\u0003J\u000e\u0010\\\u001a\u0002032\u0006\u0010]\u001a\u00020\u0003J\r\u0010^\u001a\u000203H\u0000\u00a2\u0006\u0002\b_R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0010j\b\u0012\u0004\u0012\u00020\u0003`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0010j\b\u0012\u0004\u0012\u00020\u0003`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0010j\b\u0012\u0004\u0012\u00020\u0003`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\u00020\u001bX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010.\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006a"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo;", "Lnet/rsprot/protocol/game/outgoing/info/util/ReferencePooledObject;", "localIndex", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "avatarRepository", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository;", "zoneIndexStorage", "Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;", "recycler", "Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;", "(ILio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/common/client/OldSchoolClientType;Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository;Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;)V", "addedWorldEntities", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "allWorldEntities", "getAllocator$osrs_224_model", "()Lio/netty/buffer/ByteBufAllocator;", "buffer", "Lio/netty/buffer/ByteBuf;", "buildArea", "Lnet/rsprot/protocol/game/outgoing/info/util/BuildArea;", "J", "currentCoord", "Lnet/rsprot/protocol/internal/game/outgoing/info/CoordGrid;", "I", "currentWorldEntityId", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getException$osrs_224_model", "()Ljava/lang/Exception;", "setException$osrs_224_model", "(Ljava/lang/Exception;)V", "highResolutionIndices", "", "highResolutionIndicesCount", "getLocalIndex$osrs_224_model", "()I", "setLocalIndex$osrs_224_model", "(I)V", "removedWorldEntities", "renderCoord", "renderDistance", "temporaryHighResolutionIndices", "allocBuffer", "backingBuffer", "clearEntities", "", "worldId", "defragmentIndices", "getAddedWorldEntityIndices", "", "getAllWorldEntityIndices", "getRemovedWorldEntityIndices", "inRange", "", "avatar", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatar;", "isDestroyed", "isHighResolution", "index", "isReallocated", "onAlloc", "newInstance", "onDealloc", "onReconnect", "processHighResolution", "Lnet/rsprot/buffer/JagByteBuf;", "processHighResolution-lwEbYT4", "(Lio/netty/buffer/ByteBuf;)Z", "processLowResolution", "processLowResolution-lwEbYT4", "(Lio/netty/buffer/ByteBuf;)V", "resetRenderCoord", "setRenderCoord", "level", "x", "z", "toPacket", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfoPacket;", "updateBuildArea", "zoneX", "zoneZ", "widthInZones", "heightInZones", "updateBuildArea-4IFMqhs", "(J)V", "updateCoord", "updateRenderDistance", "distance", "updateWorldEntities", "updateWorldEntities$osrs_224_model", "Companion", "osrs-224-model"})
@SourceDebugExtension(value={"SMAP\nWorldEntityInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldEntityInfo.kt\nnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo\n+ 2 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n*L\n1#1,531:1\n164#2,2:532\n164#2,2:534\n164#2,2:536\n216#2,2:538\n164#2,2:540\n164#2,2:542\n164#2,2:544\n164#2,2:546\n216#2,2:548\n216#2,2:550\n*S KotlinDebug\n*F\n+ 1 WorldEntityInfo.kt\nnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo\n*L\n299#1:532,2\n308#1:534,2\n311#1:536,2\n368#1:538,2\n369#1:540,2\n370#1:542,2\n372#1:544,2\n373#1:546,2\n374#1:548,2\n376#1:550,2\n*E\n"})
public final class WorldEntityInfo
implements ReferencePooledObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int localIndex;
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private OldSchoolClientType oldSchoolClientType;
    @NotNull
    private final WorldEntityAvatarRepository avatarRepository;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final ByteBufRecycler recycler;
    private int renderDistance;
    private int currentWorldEntityId;
    private int currentCoord;
    private long buildArea;
    private int highResolutionIndicesCount;
    @NotNull
    private short[] highResolutionIndices;
    @NotNull
    private short[] temporaryHighResolutionIndices;
    @NotNull
    private final ArrayList<Integer> allWorldEntities;
    @NotNull
    private final ArrayList<Integer> addedWorldEntities;
    @NotNull
    private final ArrayList<Integer> removedWorldEntities;
    @Nullable
    private ByteBuf buffer;
    @Nullable
    private volatile Exception exception;
    private int renderCoord;
    private static final short INDEX_TERMINATOR = -1;
    private static final int WORLDENTITY_LOOKUP_TERMINATOR = 65535;
    private static final int MAX_HIGH_RES_COUNT = 255;
    public static final int ROOT_WORLD = -1;
    private static final int DEFAULT_RENDER_DISTANCE = 15;
    private static final int BUF_CAPACITY = 2806;

    public WorldEntityInfo(int localIndex, @NotNull ByteBufAllocator allocator, @NotNull OldSchoolClientType oldSchoolClientType, @NotNull WorldEntityAvatarRepository avatarRepository, @NotNull ZoneIndexStorage zoneIndexStorage, @NotNull ByteBufRecycler recycler) {
        int n;
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        Intrinsics.checkNotNullParameter((Object)avatarRepository, (String)"avatarRepository");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        this.localIndex = localIndex;
        this.allocator = allocator;
        this.oldSchoolClientType = oldSchoolClientType;
        this.avatarRepository = avatarRepository;
        this.zoneIndexStorage = zoneIndexStorage;
        this.recycler = recycler;
        this.renderDistance = 15;
        this.currentWorldEntityId = -1;
        this.currentCoord = CoordGrid.Companion.getINVALID-aQXte_c();
        this.buildArea = BuildArea.Companion.getINVALID-RDuwMps();
        int n2 = 0;
        short[] sArray = new short[2048];
        WorldEntityInfo worldEntityInfo = this;
        while (n2 < 2048) {
            n = n2++;
            sArray[n] = -1;
        }
        worldEntityInfo.highResolutionIndices = sArray;
        n2 = 0;
        sArray = new short[2048];
        worldEntityInfo = this;
        while (n2 < 2048) {
            n = n2++;
            sArray[n] = -1;
        }
        worldEntityInfo.temporaryHighResolutionIndices = sArray;
        this.allWorldEntities = new ArrayList();
        this.addedWorldEntities = new ArrayList();
        this.removedWorldEntities = new ArrayList();
        this.renderCoord = CoordGrid.Companion.getINVALID-aQXte_c();
    }

    public /* synthetic */ WorldEntityInfo(int n, ByteBufAllocator byteBufAllocator, OldSchoolClientType oldSchoolClientType, WorldEntityAvatarRepository worldEntityAvatarRepository, ZoneIndexStorage zoneIndexStorage, ByteBufRecycler byteBufRecycler, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            byteBufRecycler = new ByteBufRecycler(0, 1, null);
        }
        this(n, byteBufAllocator, oldSchoolClientType, worldEntityAvatarRepository, zoneIndexStorage, byteBufRecycler);
    }

    public final int getLocalIndex$osrs_224_model() {
        return this.localIndex;
    }

    public final void setLocalIndex$osrs_224_model(int n) {
        this.localIndex = n;
    }

    @NotNull
    public final ByteBufAllocator getAllocator$osrs_224_model() {
        return this.allocator;
    }

    @Nullable
    public final Exception getException$osrs_224_model() {
        return this.exception;
    }

    public final void setException$osrs_224_model(@Nullable Exception exception) {
        this.exception = exception;
    }

    @Override
    public boolean isDestroyed() {
        return this.exception != null;
    }

    public final void updateRenderDistance(int distance) {
        if (this.isDestroyed()) {
            return;
        }
        this.renderDistance = distance;
    }

    public final void updateBuildArea-4IFMqhs(long buildArea) {
        if (this.isDestroyed()) {
            return;
        }
        this.buildArea = buildArea;
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ, int widthInZones, int heightInZones) {
        if (this.isDestroyed()) {
            return;
        }
        this.buildArea = BuildArea.constructor-impl(zoneX, zoneZ, widthInZones, heightInZones);
    }

    public static /* synthetic */ void updateBuildArea$default(WorldEntityInfo worldEntityInfo, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n3 = 13;
        }
        if ((n5 & 8) != 0) {
            n4 = 13;
        }
        worldEntityInfo.updateBuildArea(n, n2, n3, n4);
    }

    @NotNull
    public final List<Integer> getAllWorldEntityIndices() {
        if (this.isDestroyed()) {
            return CollectionsKt.emptyList();
        }
        return this.allWorldEntities;
    }

    @NotNull
    public final List<Integer> getAddedWorldEntityIndices() {
        if (this.isDestroyed()) {
            return CollectionsKt.emptyList();
        }
        return this.addedWorldEntities;
    }

    @NotNull
    public final List<Integer> getRemovedWorldEntityIndices() {
        if (this.isDestroyed()) {
            return CollectionsKt.emptyList();
        }
        return this.removedWorldEntities;
    }

    public final void updateCoord(int worldId, int level, int x, int z) {
        if (this.isDestroyed()) {
            return;
        }
        this.currentWorldEntityId = worldId;
        this.currentCoord = CoordGrid.constructor-impl((int)level, (int)x, (int)z);
    }

    public final void setRenderCoord(int level, int x, int z) {
        if (this.isDestroyed()) {
            return;
        }
        this.renderCoord = CoordGrid.constructor-impl((int)level, (int)x, (int)z);
    }

    public final void resetRenderCoord() {
        if (this.isDestroyed()) {
            return;
        }
        this.renderCoord = CoordGrid.Companion.getINVALID-aQXte_c();
    }

    @NotNull
    public final ByteBuf backingBuffer() throws IllegalStateException {
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return byteBuf;
    }

    @NotNull
    public final WorldEntityInfoPacket toPacket() {
        Exception exception = this.exception;
        if (exception != null) {
            throw new InfoProcessException("Exception occurred during player info processing for index " + this.localIndex, exception);
        }
        return new WorldEntityInfoPacket(this.backingBuffer());
    }

    private final ByteBuf allocBuffer() {
        ByteBuf buffer;
        this.buffer = buffer = this.allocator.buffer(2806, 2806);
        Intrinsics.checkNotNull((Object)buffer);
        this.recycler.plusAssign(buffer);
        this.addedWorldEntities.clear();
        this.removedWorldEntities.clear();
        return buffer;
    }

    private final void defragmentIndices() {
        int count = 0;
        int n = this.highResolutionIndices.length;
        for (int i = 0; i < n && count < this.highResolutionIndicesCount; ++i) {
            short index = this.highResolutionIndices[i];
            if (index == -1) continue;
            this.temporaryHighResolutionIndices[count++] = index;
        }
        short[] uncompressed = this.highResolutionIndices;
        this.highResolutionIndices = this.temporaryHighResolutionIndices;
        this.temporaryHighResolutionIndices = uncompressed;
    }

    public final void updateWorldEntities$osrs_224_model() {
        ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)this.allocBuffer());
        boolean fragmented = this.processHighResolution-lwEbYT4(buffer);
        if (fragmented) {
            this.defragmentIndices();
        }
        this.processLowResolution-lwEbYT4(buffer);
    }

    private final boolean processHighResolution-lwEbYT4(ByteBuf buffer) {
        int count = this.highResolutionIndicesCount;
        boolean bl = false;
        JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)count);
        for (int i = 0; i < count; ++i) {
            ByteBuf precomputedBuffer;
            short index = this.highResolutionIndices[i];
            WorldEntityAvatar avatar = this.avatarRepository.getOrNull(index);
            if (avatar == null || !this.inRange(avatar) || this.isReallocated(avatar)) {
                this.highResolutionIndices[i] = -1;
                int n = this.highResolutionIndicesCount;
                this.highResolutionIndicesCount = n + -1;
                Integer n2 = index;
                ((Collection)this.removedWorldEntities).add(n2);
                n2 = index;
                ((Collection)this.allWorldEntities).remove(n2);
                int value$iv = 0;
                $i$f$p1-JhZ6y6I = false;
                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
                continue;
            }
            int value$iv = 1;
            $i$f$p1-JhZ6y6I = false;
            JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
            if (avatar.getHighResolutionBuffer$osrs_224_model() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            buffer.writeBytes(precomputedBuffer, precomputedBuffer.readerIndex(), precomputedBuffer.readableBytes());
        }
        return count != this.highResolutionIndicesCount;
    }

    private final void processLowResolution-lwEbYT4(ByteBuf buffer) {
        int n;
        if (this.highResolutionIndicesCount >= 255) {
            return;
        }
        int currentWorld = this.currentWorldEntityId;
        if (currentWorld == -1) {
            n = this.currentCoord;
        } else {
            WorldEntityAvatar worldEntityAvatar = this.avatarRepository.getOrNull(currentWorld);
            if (worldEntityAvatar == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            WorldEntityAvatar worldEntity = worldEntityAvatar;
            n = worldEntity.getCurrentCoord-aQXte_c$osrs_224_model();
        }
        int n2 = n;
        int level = CoordGrid.component1-impl((int)n2);
        int centerX = CoordGrid.component2-impl((int)n2);
        int centerZ = CoordGrid.component3-impl((int)n2);
        int startX = RangesKt.coerceAtLeast((int)(centerX - this.renderDistance >> 3), (int)0);
        int startZ = RangesKt.coerceAtLeast((int)(centerZ - this.renderDistance >> 3), (int)0);
        int endX = RangesKt.coerceAtMost((int)(centerX + this.renderDistance >> 3), (int)2047);
        int endZ = RangesKt.coerceAtMost((int)(centerZ + this.renderDistance >> 3), (int)2047);
        int x = startX;
        if (x <= endX) {
            while (true) {
                int z;
                if ((z = startZ) <= endZ) {
                    while (true) {
                        if (this.zoneIndexStorage.get(level, x, z) != null) {
                            int index;
                            short[] npcs;
                            int n3 = npcs.length;
                            for (int k = 0; k < n3 && (index = npcs[k] & 0xFFFF) != 65535; ++k) {
                                WorldEntityAvatar avatar;
                                if (this.isHighResolution(index)) continue;
                                if (this.highResolutionIndicesCount >= 255) break;
                                if (this.avatarRepository.getOrNull(index) == null || !this.inRange(avatar)) continue;
                                Integer n4 = index;
                                ((Collection)this.addedWorldEntities).add(n4);
                                n4 = index;
                                ((Collection)this.allWorldEntities).add(n4);
                                int n5 = this.highResolutionIndicesCount;
                                this.highResolutionIndicesCount = n5 + 1;
                                int i = n5;
                                this.highResolutionIndices[i] = (short)index;
                                int value$iv = avatar.getIndex$osrs_224_model();
                                boolean bl = false;
                                JagexByteBufExtensionsKt.p2((ByteBuf)buffer, (int)value$iv);
                                value$iv = avatar.getSizeX$osrs_224_model();
                                boolean bl2 = false;
                                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
                                value$iv = avatar.getSizeZ$osrs_224_model();
                                bl2 = false;
                                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
                                short buildAreaCoord = BuildArea.localize-lfZmNRY$osrs_224_model(this.buildArea, avatar.getCurrentCoord-aQXte_c$osrs_224_model());
                                int value$iv2 = CoordInBuildArea.getXInBuildArea-impl(buildAreaCoord);
                                $i$f$p1-JhZ6y6I = false;
                                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv2);
                                value$iv2 = CoordInBuildArea.getZInBuildArea-impl(buildAreaCoord);
                                $i$f$p1-JhZ6y6I = false;
                                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv2);
                                value$iv2 = avatar.getAngle$osrs_224_model();
                                $i$f$p2-JhZ6y6I = false;
                                JagexByteBufExtensionsKt.p2((ByteBuf)buffer, (int)value$iv2);
                                value$iv2 = 0;
                                $i$f$p2-JhZ6y6I = false;
                                JagexByteBufExtensionsKt.p2((ByteBuf)buffer, (int)value$iv2);
                            }
                        }
                        if (z == endZ) break;
                        ++z;
                    }
                }
                if (x == endX) break;
                ++x;
            }
        }
    }

    private final boolean isHighResolution(int index) {
        int n = this.highResolutionIndicesCount;
        for (int i = 0; i < n; ++i) {
            if (this.highResolutionIndices[i] != index) continue;
            return true;
        }
        return false;
    }

    private final boolean inRange(WorldEntityAvatar avatar) {
        if (avatar.getIndex$osrs_224_model() == this.currentWorldEntityId) {
            return true;
        }
        if (!WorldEntityInfoExtensionsKt.contains-eQawg54(this.buildArea, avatar)) {
            return false;
        }
        return CoordGrid.inDistance-XODtI-Q((int)avatar.getCurrentCoord-aQXte_c$osrs_224_model(), (int)this.currentCoord, (int)this.renderDistance) || !CoordGrid.equals-impl0((int)this.renderCoord, (int)CoordGrid.Companion.getINVALID-aQXte_c()) && CoordGrid.inDistance-XODtI-Q((int)avatar.getCurrentCoord-aQXte_c$osrs_224_model(), (int)this.renderCoord, (int)this.renderDistance);
    }

    private final boolean isReallocated(WorldEntityAvatar avatar) {
        return avatar.getAllocateCycle$osrs_224_model() == WorldEntityProtocol.Companion.getCycleCount$osrs_224_model();
    }

    @Override
    public void onAlloc(int index, @NotNull OldSchoolClientType oldSchoolClientType, boolean newInstance) {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        this.localIndex = index;
        this.oldSchoolClientType = oldSchoolClientType;
        this.renderDistance = 15;
        this.currentWorldEntityId = -1;
        this.currentCoord = CoordGrid.Companion.getINVALID-aQXte_c();
        this.buildArea = BuildArea.Companion.getINVALID-RDuwMps();
        this.renderCoord = CoordGrid.Companion.getINVALID-aQXte_c();
        this.highResolutionIndicesCount = 0;
        ArraysKt.fill$default((short[])this.highResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((short[])this.temporaryHighResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        this.allWorldEntities.clear();
        this.addedWorldEntities.clear();
        this.removedWorldEntities.clear();
        this.buffer = null;
        this.exception = null;
    }

    public final void onReconnect() {
        if (this.isDestroyed()) {
            return;
        }
        this.buffer = null;
        this.exception = null;
        this.highResolutionIndicesCount = 0;
        ArraysKt.fill$default((short[])this.highResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((short[])this.temporaryHighResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        this.allWorldEntities.clear();
        this.addedWorldEntities.clear();
        this.removedWorldEntities.clear();
    }

    @Override
    public void onDealloc() {
        this.buffer = null;
    }

    /*
     * Unable to fully structure code
     */
    public final void clearEntities(int worldId) {
        if (this.isDestroyed()) {
            return;
        }
        if (worldId == -1) ** GOTO lbl-1000
        v0 = 0 <= worldId ? worldId < 2048 : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-WorldEntityInfo$clearEntities$1 = false;
            var2_3 = "World id must be -1 or in range of 0..<2048";
            throw new IllegalArgumentException(var2_3.toString());
        }
        if (worldId == -1) {
            this.onReconnect();
        }
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ, int widthInZones) {
        WorldEntityInfo.updateBuildArea$default(this, zoneX, zoneZ, widthInZones, 0, 8, null);
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ) {
        WorldEntityInfo.updateBuildArea$default(this, zoneX, zoneZ, 0, 0, 12, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo$Companion;", "", "()V", "BUF_CAPACITY", "", "DEFAULT_RENDER_DISTANCE", "INDEX_TERMINATOR", "", "MAX_HIGH_RES_COUNT", "ROOT_WORLD", "WORLDENTITY_LOOKUP_TERMINATOR", "osrs-224-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

