/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.worldentityinfo;

import io.netty.buffer.ByteBufAllocator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatar;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityProtocol;
import net.rsprot.protocol.internal.game.outgoing.info.CoordGrid;
import net.rsprot.protocol.internal.game.outgoing.info.util.ZoneIndexStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository;", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "zoneIndexStorage", "Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;)V", "elements", "", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatar;", "[Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatar;", "queue", "Ljava/lang/ref/ReferenceQueue;", "getOrAlloc", "index", "", "sizeX", "sizeZ", "x", "z", "level", "angle", "getOrNull", "idx", "release", "", "avatar", "Companion", "osrs-224-model"})
public final class WorldEntityAvatarRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final WorldEntityAvatar[] elements;
    @NotNull
    private final ReferenceQueue<WorldEntityAvatar> queue;
    public static final int AVATAR_CAPACITY = 2048;

    public WorldEntityAvatarRepository(@NotNull ByteBufAllocator allocator, @NotNull ZoneIndexStorage zoneIndexStorage) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        this.allocator = allocator;
        this.zoneIndexStorage = zoneIndexStorage;
        this.elements = new WorldEntityAvatar[2048];
        this.queue = new ReferenceQueue();
    }

    @Nullable
    public final WorldEntityAvatar getOrNull(int idx) throws ArrayIndexOutOfBoundsException {
        return this.elements[idx];
    }

    @NotNull
    public final WorldEntityAvatar getOrAlloc(int index, int sizeX, int sizeZ, int x, int z, int level, int angle) {
        WorldEntityAvatar existing;
        if (!(this.elements[index] == null)) {
            boolean $i$a$-require-WorldEntityAvatarRepository$getOrAlloc$22 = false;
            String $i$a$-require-WorldEntityAvatarRepository$getOrAlloc$22 = "WorldEntity avatar with index " + index + " is already allocated!";
            throw new IllegalArgumentException($i$a$-require-WorldEntityAvatarRepository$getOrAlloc$22.toString());
        }
        Reference<WorldEntityAvatar> reference = this.queue.poll();
        WorldEntityAvatar worldEntityAvatar = existing = reference != null ? reference.get() : null;
        if (existing != null) {
            existing.setIndex$osrs_224_model(index);
            existing.setSizeX$osrs_224_model(sizeX);
            existing.setSizeZ$osrs_224_model(sizeZ);
            existing.setCurrentCoord-1IQ_v9c$osrs_224_model(CoordGrid.constructor-impl((int)level, (int)x, (int)z));
            existing.setLastCoord-1IQ_v9c$osrs_224_model(existing.getCurrentCoord-aQXte_c$osrs_224_model());
            existing.setAngle$osrs_224_model(angle);
            existing.setAllocateCycle$osrs_224_model(WorldEntityProtocol.Companion.getCycleCount$osrs_224_model());
            this.zoneIndexStorage.add-262OtJs(index, existing.getCurrentCoord-aQXte_c$osrs_224_model());
            this.elements[index] = existing;
            return existing;
        }
        WorldEntityAvatar avatar = new WorldEntityAvatar(this.allocator, this.zoneIndexStorage, index, sizeX, sizeZ, CoordGrid.constructor-impl((int)level, (int)x, (int)z), angle, null);
        this.zoneIndexStorage.add-262OtJs(index, avatar.getCurrentCoord-aQXte_c$osrs_224_model());
        this.elements[index] = avatar;
        return avatar;
    }

    public final void release(@NotNull WorldEntityAvatar avatar) {
        Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
        int index = avatar.getIndex$osrs_224_model();
        if (!(this.elements[index] == avatar)) {
            boolean bl = false;
            String string = "Attempting to release an invalid WorldEntity avatar: " + avatar + ", " + this.elements[index];
            throw new IllegalArgumentException(string.toString());
        }
        this.zoneIndexStorage.remove-262OtJs(index, avatar.getCurrentCoord-aQXte_c$osrs_224_model());
        this.elements[index] = null;
        SoftReference<WorldEntityAvatar> reference = new SoftReference<WorldEntityAvatar>(avatar, this.queue);
        reference.enqueue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository$Companion;", "", "()V", "AVATAR_CAPACITY", "", "osrs-224-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

