/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.worker;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.game.outgoing.info.worker.ProtocolWorker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worker/DefaultProtocolWorker;", "Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;", "()V", "asynchronousThreshold", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "(ILjava/util/concurrent/ExecutorService;)V", "execute", "", "callables", "", "Ljava/util/concurrent/Callable;", "osrs-224-model"})
public final class DefaultProtocolWorker
implements ProtocolWorker {
    private final int asynchronousThreshold;
    @NotNull
    private final ExecutorService executorService;

    public DefaultProtocolWorker(int asynchronousThreshold, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.asynchronousThreshold = asynchronousThreshold;
        this.executorService = executorService;
    }

    public DefaultProtocolWorker() {
        int n = Runtime.getRuntime().availableProcessors() * 4;
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        Intrinsics.checkNotNullExpressionValue((Object)forkJoinPool, (String)"commonPool(...)");
        this(n, forkJoinPool);
    }

    @Override
    public void execute(@NotNull List<? extends Callable<Unit>> callables) {
        Intrinsics.checkNotNullParameter(callables, (String)"callables");
        if (callables.size() < this.asynchronousThreshold) {
            for (Callable<Unit> callable : callables) {
                callable.call();
            }
        } else {
            this.executorService.invokeAll((Collection)callables);
        }
    }
}

