/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.worldentityinfo;

import io.netty.buffer.ByteBufAllocator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.common.game.outgoing.info.util.ZoneIndexStorage;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatar;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatarRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarFactory;", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "zoneIndexStorage", "Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;)V", "avatarRepository", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository;", "getAvatarRepository$osrs_224_model", "()Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository;", "alloc", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatar;", "index", "", "sizeX", "sizeZ", "x", "z", "level", "angle", "release", "", "avatar", "osrs-224-model"})
public final class WorldEntityAvatarFactory {
    @NotNull
    private final WorldEntityAvatarRepository avatarRepository;

    public WorldEntityAvatarFactory(@NotNull ByteBufAllocator allocator, @NotNull ZoneIndexStorage zoneIndexStorage) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        this.avatarRepository = new WorldEntityAvatarRepository(allocator, zoneIndexStorage);
    }

    @NotNull
    public final WorldEntityAvatarRepository getAvatarRepository$osrs_224_model() {
        return this.avatarRepository;
    }

    @NotNull
    public final WorldEntityAvatar alloc(int index, int sizeX, int sizeZ, int x, int z, int level, int angle) {
        if (!(0 <= index ? index < 2048 : false)) {
            boolean $i$a$-require-WorldEntityAvatarFactory$alloc$82 = false;
            String $i$a$-require-WorldEntityAvatarFactory$alloc$82 = "World entity index cannot be outside of 0..2047";
            throw new IllegalArgumentException($i$a$-require-WorldEntityAvatarFactory$alloc$82.toString());
        }
        if (!(0 <= sizeX ? sizeX < 256 : false)) {
            boolean $i$a$-require-WorldEntityAvatarFactory$alloc$92 = false;
            String $i$a$-require-WorldEntityAvatarFactory$alloc$92 = "Size x cannot be outside of 0..255 range";
            throw new IllegalArgumentException($i$a$-require-WorldEntityAvatarFactory$alloc$92.toString());
        }
        if (!(0 <= sizeZ ? sizeZ < 256 : false)) {
            boolean $i$a$-require-WorldEntityAvatarFactory$alloc$102 = false;
            String $i$a$-require-WorldEntityAvatarFactory$alloc$102 = "Size z cannot be outside of 0..255 range";
            throw new IllegalArgumentException($i$a$-require-WorldEntityAvatarFactory$alloc$102.toString());
        }
        if (!(0 <= level ? level < 4 : false)) {
            boolean $i$a$-require-WorldEntityAvatarFactory$alloc$112 = false;
            String $i$a$-require-WorldEntityAvatarFactory$alloc$112 = "Level cannot be outside of 0..3 range";
            throw new IllegalArgumentException($i$a$-require-WorldEntityAvatarFactory$alloc$112.toString());
        }
        if (!(0 <= x ? x < 16384 : false)) {
            boolean $i$a$-require-WorldEntityAvatarFactory$alloc$122 = false;
            String $i$a$-require-WorldEntityAvatarFactory$alloc$122 = "X coordinate cannot be outside of 0..16383 range";
            throw new IllegalArgumentException($i$a$-require-WorldEntityAvatarFactory$alloc$122.toString());
        }
        if (!(0 <= z ? z < 16384 : false)) {
            boolean $i$a$-require-WorldEntityAvatarFactory$alloc$132 = false;
            String $i$a$-require-WorldEntityAvatarFactory$alloc$132 = "Z coordinate cannot be outside of 0..16383 range";
            throw new IllegalArgumentException($i$a$-require-WorldEntityAvatarFactory$alloc$132.toString());
        }
        if (!(0 <= angle ? angle < 2048 : false)) {
            boolean bl = false;
            String string = "Angle must be in range of 0..2047";
            throw new IllegalArgumentException(string.toString());
        }
        return this.avatarRepository.getOrAlloc(index, sizeX, sizeZ, x, z, level, angle);
    }

    public final void release(@NotNull WorldEntityAvatar avatar) {
        Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
        this.avatarRepository.release(avatar);
    }
}

