/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.internal.game.outgoing.info.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.internal.game.outgoing.info.util.ZoneIndexArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0003J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexDictionary;", "", "maxKeyCount", "", "(I)V", "capacity", "containsNullKey", "", "keys", "", "mask", "values", "", "Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexArray;", "[Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexArray;", "find", "k", "get", "insert", "", "pos", "key", "value", "put", "remove", "removeEntry", "removeNullEntry", "osrs-224-internal"})
public final class ZoneIndexDictionary {
    private final int capacity;
    private final int mask;
    private boolean containsNullKey;
    @NotNull
    private final int[] keys;
    @NotNull
    private final ZoneIndexArray[] values;

    public ZoneIndexDictionary(int maxKeyCount) {
        this.capacity = maxKeyCount * 4;
        this.mask = this.capacity - 1;
        this.keys = new int[this.capacity];
        this.values = new ZoneIndexArray[this.capacity];
    }

    public final void put(int key, @NotNull ZoneIndexArray value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int pos = this.find(key);
        if (pos < 0) {
            this.insert(-pos - 1, key, value);
            return;
        }
        this.values[pos] = value;
    }

    private final void insert(int pos, int key, ZoneIndexArray value) {
        if (pos == this.mask) {
            this.containsNullKey = true;
        }
        this.keys[pos] = key;
        this.values[pos] = value;
    }

    private final int find(int k) {
        if (k == 0) {
            return this.containsNullKey ? this.mask : -(this.mask + 1);
        }
        int[] key = this.keys;
        int pos = k & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    public final void remove(int k) {
        if (k == 0) {
            if (this.containsNullKey) {
                this.removeNullEntry();
            }
            return;
        }
        int[] key = this.keys;
        int pos = k & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return;
        }
        if (k == curr) {
            this.removeEntry(pos);
            return;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return;
        } while (k != curr);
        this.removeEntry(pos);
    }

    @Nullable
    public final ZoneIndexArray get(int k) {
        if (k == 0) {
            return this.containsNullKey ? this.values[this.mask] : null;
        }
        int[] key = this.keys;
        int pos = k & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return null;
        }
        if (k == curr) {
            return this.values[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return null;
        } while (k != curr);
        return this.values[pos];
    }

    private final void removeNullEntry() {
        this.containsNullKey = false;
        this.values[this.mask] = null;
    }

    private final void removeEntry(int pos) {
        this.values[pos] = null;
    }
}

