/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.internal.client;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.client.ClientType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u0016*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0001\u0016B\u0017\b\u0001\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0016\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004X\u0088\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/protocol/internal/client/ClientTypeMap;", "T", "", "array", "", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "notNullSize", "", "getNotNullSize", "()I", "size", "getSize", "contains", "", "clientType", "Lnet/rsprot/protocol/client/ClientType;", "get", "(Lnet/rsprot/protocol/client/ClientType;)Ljava/lang/Object;", "getOrNull", "clientId", "(I)Ljava/lang/Object;", "Companion", "osrs-224-internal"})
@SourceDebugExtension(value={"SMAP\nClientTypeMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientTypeMap.kt\nnet/rsprot/protocol/internal/client/ClientTypeMap\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,75:1\n12634#2,3:76\n*S KotlinDebug\n*F\n+ 1 ClientTypeMap.kt\nnet/rsprot/protocol/internal/client/ClientTypeMap\n*L\n14#1:76,3\n*E\n"})
public final class ClientTypeMap<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T[] array;

    @PublishedApi
    public ClientTypeMap(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.array = array;
    }

    public final int getSize() {
        return this.array.length;
    }

    /*
     * WARNING - void declaration
     */
    public final int getNotNullSize() {
        void var3_3;
        T[] $this$count$iv = this.array;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n = $this$count$iv.length;
        for (int i = 0; i < n; ++i) {
            T element$iv;
            T it = element$iv = $this$count$iv[i];
            boolean bl = false;
            if (!(it != null)) continue;
            ++count$iv;
        }
        return (int)var3_3;
    }

    public final T get(@NotNull ClientType clientType) {
        Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
        T t = this.array[clientType.getId()];
        if (t == null) {
            boolean bl = false;
            String string = "Client type " + clientType + " not initialized!";
            throw new IllegalArgumentException(string.toString());
        }
        return t;
    }

    @Nullable
    public final T getOrNull(@NotNull ClientType clientType) {
        Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
        return this.array[clientType.getId()];
    }

    @Nullable
    public final T getOrNull(int clientId) {
        return this.array[clientId];
    }

    public final boolean contains(@NotNull ClientType clientType) {
        Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
        return this.array[clientType.getId()] != null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0001\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00050\n0\tH\u0086\bJD\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004\"\u0006\b\u0001\u0010\f\u0018\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\f0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u000eH\u0086\b\u00f8\u0001\u0000JV\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\f\"\u0006\b\u0002\u0010\u0005\u0018\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\f0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u001e\u0010\r\u001a\u001a\u0012\u0004\u0012\u0002H\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00050\n0\u000eH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"Lnet/rsprot/protocol/internal/client/ClientTypeMap$Companion;", "", "()V", "of", "Lnet/rsprot/protocol/internal/client/ClientTypeMap;", "E", "clientCapacity", "", "elements", "", "Lkotlin/Pair;", "Lnet/rsprot/protocol/client/ClientType;", "T", "clientTypeSelector", "Lkotlin/Function1;", "ofType", "osrs-224-internal"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <T> ClientTypeMap<T> of(List<? extends T> elements, int clientCapacity, Function1<? super T, ? extends ClientType> clientTypeSelector) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(clientTypeSelector, (String)"clientTypeSelector");
            boolean $i$f$of = false;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] array = new Object[clientCapacity];
            for (T element : elements) {
                ClientType clientType = (ClientType)clientTypeSelector.invoke(element);
                if (!(array[clientType.getId()] == null)) {
                    boolean bl = false;
                    String string = "A client is registered more than once: " + elements;
                    throw new IllegalStateException(string.toString());
                }
                array[clientType.getId()] = element;
            }
            return new ClientTypeMap<Object>(array);
        }

        public final /* synthetic */ <E> ClientTypeMap<E> of(int clientCapacity, List<? extends Pair<? extends ClientType, ? extends E>> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean $i$f$of = false;
            Intrinsics.reifiedOperationMarker((int)0, (String)"E?");
            Object[] array = new Object[clientCapacity];
            for (Pair<ClientType, E> pair : elements) {
                ClientType clientType = (ClientType)pair.component1();
                Object element = pair.component2();
                if (!(array[clientType.getId()] == null)) {
                    boolean bl = false;
                    String string = "A client is registered more than once: " + elements;
                    throw new IllegalStateException(string.toString());
                }
                array[clientType.getId()] = element;
            }
            return new ClientTypeMap<Object>(array);
        }

        public final /* synthetic */ <T, E> ClientTypeMap<E> ofType(List<? extends T> elements, int clientCapacity, Function1<? super T, ? extends Pair<? extends ClientType, ? extends E>> clientTypeSelector) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(clientTypeSelector, (String)"clientTypeSelector");
            boolean $i$f$ofType = false;
            Intrinsics.reifiedOperationMarker((int)0, (String)"E?");
            Object[] array = new Object[clientCapacity];
            for (T pair : elements) {
                Pair pair2 = (Pair)clientTypeSelector.invoke(pair);
                ClientType clientType = (ClientType)pair2.component1();
                Object element = pair2.component2();
                if (!(array[clientType.getId()] == null)) {
                    boolean bl = false;
                    String string = "A client is registered more than once: " + elements;
                    throw new IllegalStateException(string.toString());
                }
                array[clientType.getId()] = element;
            }
            return new ClientTypeMap<Object>(array);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

