/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.text.NumberFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.crypto.xtea.XteaKey;
import net.rsprot.protocol.api.ChannelExceptionHandler;
import net.rsprot.protocol.api.GameConnectionHandler;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.GameLoginResponseHandler;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.common.loginprot.incoming.codec.shared.exceptions.InvalidVersionException;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.GameLogin;
import net.rsprot.protocol.loginprot.incoming.GameReconnect;
import net.rsprot.protocol.loginprot.incoming.ProofOfWorkReply;
import net.rsprot.protocol.loginprot.incoming.RemainingBetaArchives;
import net.rsprot.protocol.loginprot.incoming.pow.ProofOfWork;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.ChallengeMetaData;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.ChallengeType;
import net.rsprot.protocol.loginprot.incoming.util.AuthenticationType;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlockDecodingFunction;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.IncomingLoginMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 @*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002@AB\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0002J0\u0010!\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0002JB\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0%0$\"\u0004\b\u0001\u0010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H&0,H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.J\u001a\u0010/\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u00100\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u00104\u001a\u00020\u0011H\u0002J\u0010\u00105\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u00106\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u000208H\u0016JD\u00109\u001a\b\u0012\u0004\u0012\u00020*0$\"\u000e\b\u0001\u0010:*\b\u0012\u0004\u0012\u0002H<0;\"\b\b\u0002\u0010<*\u00020=2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u0002H<0\u000f2\u0006\u0010?\u001a\u00020\u0007H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006B"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler;", "R", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingLoginMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "sessionId", "", "(Lnet/rsprot/protocol/api/NetworkService;J)V", "loginHeader", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock$Header;", "loginPacket", "loginState", "Lnet/rsprot/protocol/api/login/LoginConnectionHandler$LoginState;", "proofOfWork", "Lnet/rsprot/protocol/loginprot/incoming/pow/ProofOfWork;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelReadComplete", "channelUnregistered", "continueLogin", "decodeGameLoginBuffer", "packet", "Lnet/rsprot/protocol/loginprot/incoming/GameLogin;", "remainingBetaArchives", "Lnet/rsprot/protocol/loginprot/incoming/RemainingBetaArchives;", "responseHandler", "Lnet/rsprot/protocol/api/login/GameLoginResponseHandler;", "decodeGameReconnectBuffer", "Lnet/rsprot/protocol/loginprot/incoming/GameReconnect;", "decodeLogin", "Ljava/util/concurrent/CompletableFuture;", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "Fun", "buf", "Lnet/rsprot/buffer/JagByteBuf;", "betaWorld", "", "function", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlockDecodingFunction;", "decodeLogin-6j-XqWU", "(Lio/netty/buffer/ByteBuf;ZLnet/rsprot/protocol/loginprot/incoming/util/LoginBlockDecodingFunction;)Ljava/util/concurrent/CompletableFuture;", "decodeLoginPacket", "exceptionCaught", "cause", "", "handlerAdded", "releaseLoginBlock", "requestProofOfWork", "userEventTriggered", "evt", "", "verifyProofOfWork", "T", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/ChallengeType;", "MetaData", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/ChallengeMetaData;", "pow", "result", "Companion", "LoginState", "osrs-224-api"})
@SourceDebugExtension(value={"SMAP\nLoginConnectionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginConnectionHandler.kt\nnet/rsprot/protocol/api/login/LoginConnectionHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,459:1\n20#2:460\n44#2,6:461\n52#2:471\n55#2:476\n58#2:481\n61#2:486\n64#2:491\n21#2:492\n20#2:493\n44#2,6:494\n52#2:504\n55#2:509\n58#2:514\n61#2:519\n64#2:524\n21#2:525\n20#2:526\n44#2,6:527\n52#2:537\n55#2:542\n58#2:547\n61#2:552\n64#2:557\n21#2:558\n20#2:559\n44#2,6:560\n52#2:570\n55#2:575\n58#2:580\n61#2:585\n64#2:590\n21#2:591\n20#2:592\n44#2,6:593\n52#2:603\n55#2:608\n58#2:613\n61#2:618\n64#2:623\n21#2:624\n20#2:625\n44#2,6:626\n52#2:636\n55#2:641\n58#2:646\n61#2:651\n64#2:656\n21#2:657\n32#3,4:467\n56#3,4:472\n80#3,4:477\n104#3,4:482\n128#3,4:487\n32#3,4:500\n56#3,4:505\n80#3,4:510\n104#3,4:515\n128#3,4:520\n32#3,4:533\n56#3,4:538\n80#3,4:543\n104#3,4:548\n128#3,4:553\n32#3,4:566\n56#3,4:571\n80#3,4:576\n104#3,4:581\n128#3,4:586\n32#3,4:599\n56#3,4:604\n80#3,4:609\n104#3,4:614\n128#3,4:619\n32#3,4:632\n56#3,4:637\n80#3,4:642\n104#3,4:647\n128#3,4:652\n11#4,2:658\n*S KotlinDebug\n*F\n+ 1 LoginConnectionHandler.kt\nnet/rsprot/protocol/api/login/LoginConnectionHandler\n*L\n52#1:460\n52#1:461,6\n52#1:471\n52#1:476\n52#1:481\n52#1:486\n52#1:491\n52#1:492\n63#1:493\n63#1:494,6\n63#1:504\n63#1:509\n63#1:514\n63#1:519\n63#1:524\n63#1:525\n100#1:526\n100#1:527,6\n100#1:537\n100#1:542\n100#1:547\n100#1:552\n100#1:557\n100#1:558\n254#1:559\n254#1:560,6\n254#1:570\n254#1:575\n254#1:580\n254#1:585\n254#1:590\n254#1:591\n193#1:592\n193#1:593,6\n193#1:603\n193#1:608\n193#1:613\n193#1:618\n193#1:623\n193#1:624\n215#1:625\n215#1:626,6\n215#1:636\n215#1:641\n215#1:646\n215#1:651\n215#1:656\n215#1:657\n52#1:467,4\n52#1:472,4\n52#1:477,4\n52#1:482,4\n52#1:487,4\n63#1:500,4\n63#1:505,4\n63#1:510,4\n63#1:515,4\n63#1:520,4\n100#1:533,4\n100#1:538,4\n100#1:543,4\n100#1:548,4\n100#1:553,4\n254#1:566,4\n254#1:571,4\n254#1:576,4\n254#1:581,4\n254#1:586,4\n193#1:599,4\n193#1:604,4\n193#1:609,4\n193#1:614,4\n193#1:619,4\n215#1:632,4\n215#1:637,4\n215#1:642,4\n215#1:647,4\n215#1:652,4\n456#1:658,2\n*E\n"})
public final class LoginConnectionHandler<R>
extends SimpleChannelInboundHandler<IncomingLoginMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    private final long sessionId;
    @NotNull
    private LoginState loginState;
    @Nullable
    private IncomingLoginMessage loginPacket;
    @Nullable
    private LoginBlock.Header loginHeader;
    private ProofOfWork<?, ?> proofOfWork;
    @NotNull
    private static final Logger logger;

    public LoginConnectionHandler(@NotNull NetworkService<R> networkService, long sessionId) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingLoginMessage.class);
        this.networkService = networkService;
        this.sessionId = sessionId;
        this.loginState = LoginState.UNINITIALIZED;
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_224_api().getGameInetAddressTracker().register(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
        }
        ctx.fireChannelActive();
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_224_api().getGameInetAddressTracker().deregister(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
        }
        ctx.fireChannelInactive();
    }

    public void channelUnregistered(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.releaseLoginBlock();
    }

    private final void releaseLoginBlock() {
        ByteBuf jagBuffer;
        ByteBuf byteBuf;
        IncomingLoginMessage incomingLoginMessage = this.loginPacket;
        if (incomingLoginMessage == null) {
            return;
        }
        IncomingLoginMessage loginPacket = incomingLoginMessage;
        this.loginPacket = null;
        this.loginHeader = null;
        IncomingLoginMessage packet = loginPacket;
        if (packet instanceof GameLogin) {
            byteBuf = ((GameLogin)packet).getBuffer-07mC048();
        } else if (packet instanceof GameReconnect) {
            byteBuf = ((GameReconnect)packet).getBuffer-07mC048();
        } else {
            return;
        }
        ByteBuf buffer = jagBuffer = byteBuf;
        int refCnt = buffer.refCnt();
        if (refCnt > 0) {
            buffer.release(refCnt);
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingLoginMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
        }
        IncomingLoginMessage incomingLoginMessage = msg;
        if (incomingLoginMessage instanceof RemainingBetaArchives) {
            if (this.loginState != LoginState.AWAITING_BETA_RESPONSE) {
                ctx.close();
                return;
            }
            this.decodeLoginPacket(ctx, (RemainingBetaArchives)msg);
        } else if (incomingLoginMessage instanceof GameLogin) {
            if (this.loginState != LoginState.UNINITIALIZED) {
                ctx.close();
                return;
            }
            this.loginPacket = msg;
            this.loginHeader = this.networkService.getLoginHandlers$osrs_224_api().getLoginDecoderService().decodeHeader-14qJkCs(((GameLogin)msg).getBuffer-07mC048(), ((GameLogin)msg).getDecoder());
            this.requestProofOfWork(ctx);
        } else if (incomingLoginMessage instanceof GameReconnect) {
            this.loginPacket = msg;
            this.loginHeader = this.networkService.getLoginHandlers$osrs_224_api().getLoginDecoderService().decodeHeader-14qJkCs(((GameReconnect)msg).getBuffer-07mC048(), ((GameReconnect)msg).getDecoder());
            this.continueLogin(ctx);
        } else if (incomingLoginMessage instanceof ProofOfWorkReply) {
            if (this.loginState != LoginState.REQUESTED_PROOF_OF_WORK) {
                ctx.close();
                return;
            }
            ProofOfWork<?, ?> proofOfWork = this.proofOfWork;
            if (proofOfWork == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"proofOfWork");
                proofOfWork = null;
            }
            ProofOfWork<?, ?> pow = proofOfWork;
            this.verifyProofOfWork(pow, ((ProofOfWorkReply)msg).getResult()).handle((arg_0, arg_1) -> LoginConnectionHandler.channelRead0$lambda$3((Function2)new Function2<Boolean, Throwable, Unit>(ctx, this, msg, pow){
                final /* synthetic */ ChannelHandlerContext $ctx;
                final /* synthetic */ LoginConnectionHandler<R> this$0;
                final /* synthetic */ IncomingLoginMessage $msg;
                final /* synthetic */ ProofOfWork<?, ?> $pow;
                {
                    this.$ctx = $ctx;
                    this.this$0 = $receiver;
                    this.$msg = $msg;
                    this.$pow = $pow;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(Boolean success, Throwable exception) {
                    try {
                        Logger logger;
                        Logger arg0$iv;
                        ChannelHandlerContext channelHandlerContext;
                        Logger logger$iv2;
                        block33: {
                            if (Intrinsics.areEqual((Object)success, (Object)true)) break block33;
                            Logger logger2 = LoginConnectionHandler.access$getLogger$cp();
                            ChannelHandlerContext channelHandlerContext2 = this.$ctx;
                            IncomingLoginMessage incomingLoginMessage = this.$msg;
                            ProofOfWork<?, ?> proofOfWork = this.$pow;
                            boolean bl = false;
                            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                            boolean bl2 = false;
                            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    void logger$iv2;
                                    boolean bl3 = false;
                                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv2)) {
                                        void var12_40 = logger$iv2;
                                        boolean bl4 = false;
                                        var12_40.trace(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                    }
                                    break;
                                }
                                case 3: {
                                    void logger$iv2;
                                    boolean bl5 = false;
                                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                                        void var12_41 = logger$iv2;
                                        boolean bl6 = false;
                                        var12_41.debug(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                    }
                                    break;
                                }
                                case 4: {
                                    void logger$iv2;
                                    boolean bl7 = false;
                                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv2)) {
                                        void var12_42 = logger$iv2;
                                        boolean bl8 = false;
                                        var12_42.info(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                    }
                                    break;
                                }
                                case 5: {
                                    void logger$iv2;
                                    boolean bl9 = false;
                                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv2)) {
                                        void var12_43 = logger$iv2;
                                        boolean bl10 = false;
                                        var12_43.warn(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                    }
                                    break;
                                }
                                case 6: {
                                    void logger$iv2;
                                    boolean bl11 = false;
                                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv2)) {
                                        void var12_44 = logger$iv2;
                                        boolean bl12 = false;
                                        var12_44.error(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                    }
                                    break;
                                }
                            }
                            this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail1.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (exception != null) {
                            logger$iv2 = LoginConnectionHandler.access$getLogger$cp();
                            channelHandlerContext = this.$ctx;
                            boolean bl = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                                logger = arg0$iv;
                                boolean bl13 = false;
                                logger.error(String.valueOf("Exception during proof of work verification from channel '" + channelHandlerContext.channel() + "': " + exception), exception);
                            }
                            this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail1.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        }
                        arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        channelHandlerContext = this.$ctx;
                        IncomingLoginMessage bl = this.$msg;
                        boolean bl14 = false;
                        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                        boolean bl15 = false;
                        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                boolean bl16 = false;
                                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv2)) {
                                    logger = logger$iv2;
                                    boolean bl17 = false;
                                    logger.trace(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)bl).getResult()));
                                }
                                break;
                            }
                            case 3: {
                                boolean bl18 = false;
                                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                                    logger = logger$iv2;
                                    boolean bl19 = false;
                                    logger.debug(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)bl).getResult()));
                                }
                                break;
                            }
                            case 4: {
                                boolean bl20 = false;
                                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv2)) {
                                    logger = logger$iv2;
                                    boolean bl21 = false;
                                    logger.info(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)bl).getResult()));
                                }
                                break;
                            }
                            case 5: {
                                boolean bl22 = false;
                                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv2)) {
                                    logger = logger$iv2;
                                    boolean bl23 = false;
                                    logger.warn(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)bl).getResult()));
                                }
                                break;
                            }
                            case 6: {
                                boolean bl24 = false;
                                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv2)) {
                                    logger = logger$iv2;
                                    boolean bl25 = false;
                                    logger.error(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)bl).getResult()));
                                }
                                break;
                            }
                        }
                        LoginConnectionHandler.access$continueLogin(this.this$0, this.$ctx);
                    }
                    catch (Exception e) {
                        Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl26 = false;
                            logger.error(String.valueOf("Error in handling processed proof of work."), (Throwable)e);
                        }
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl27 = false;
                            logger.error(String.valueOf("Fatal error in handling processed proof of work."), t);
                        }
                        throw t;
                    }
                }
            }, arg_0, arg_1));
        } else {
            throw new IllegalStateException("Unknown login connection handler");
        }
    }

    private final void requestProofOfWork(ChannelHandlerContext ctx) {
        LoginBlock.Header header = this.loginHeader;
        if (header == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ProofOfWork proofOfWork = this.networkService.getLoginHandlers$osrs_224_api().getProofOfWorkProvider().provide(ChannelExtensionsKt.inetAddress(ctx), header);
        if (proofOfWork == null) {
            this.continueLogin(ctx);
            return;
        }
        ProofOfWork pow = proofOfWork;
        this.loginState = LoginState.REQUESTED_PROOF_OF_WORK;
        this.proofOfWork = pow;
        ctx.writeAndFlush((Object)new LoginResponse.ProofOfWork(pow)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginConnectionHandler.requestProofOfWork$lambda$5(ctx, arg_0)));
    }

    private final void continueLogin(ChannelHandlerContext ctx) {
        if (this.networkService.getBetaWorld$osrs_224_api()) {
            this.loginState = LoginState.AWAITING_BETA_RESPONSE;
            ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(2)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginConnectionHandler.continueLogin$lambda$7(ctx, arg_0)));
        } else {
            this.decodeLoginPacket(ctx, null);
        }
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_224_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.close();
        }
    }

    private final void decodeLoginPacket(ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives) {
        IncomingLoginMessage incomingLoginMessage = this.loginPacket;
        if (incomingLoginMessage == null) {
            return;
        }
        IncomingLoginMessage loginPacket = incomingLoginMessage;
        this.loginPacket = null;
        GameLoginResponseHandler<R> responseHandler = new GameLoginResponseHandler<R>(this.networkService, ctx);
        IncomingLoginMessage packet = loginPacket;
        if (packet instanceof GameLogin) {
            this.decodeGameLoginBuffer((GameLogin)packet, ctx, remainingBetaArchives, responseHandler);
        } else if (packet instanceof GameReconnect) {
            this.decodeGameReconnectBuffer((GameReconnect)packet, ctx, remainingBetaArchives, responseHandler);
        } else {
            throw new IllegalStateException("Unknown login packet: " + packet);
        }
    }

    private final void decodeGameLoginBuffer(GameLogin packet, ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives, GameLoginResponseHandler<R> responseHandler) {
        this.decodeLogin-6j-XqWU(packet.getBuffer-07mC048(), this.networkService.getBetaWorld$osrs_224_api(), packet.getDecoder()).handle((arg_0, arg_1) -> LoginConnectionHandler.decodeGameLoginBuffer$lambda$9((Function2)new Function2<LoginBlock<AuthenticationType>, Throwable, Unit>(ctx, this, remainingBetaArchives, responseHandler){
            final /* synthetic */ ChannelHandlerContext $ctx;
            final /* synthetic */ LoginConnectionHandler<R> this$0;
            final /* synthetic */ RemainingBetaArchives $remainingBetaArchives;
            final /* synthetic */ GameLoginResponseHandler<R> $responseHandler;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                this.$remainingBetaArchives = $remainingBetaArchives;
                this.$responseHandler = $responseHandler;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(LoginBlock<AuthenticationType> block, Throwable exception) {
                try {
                    block36: {
                        if (block == null || exception != null) {
                            if (exception instanceof CompletionException && Intrinsics.areEqual((Object)exception.getCause(), (Object)InvalidVersionException.INSTANCE)) {
                                this.$ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                            ChannelExceptionHandler channelExceptionHandler = LoginConnectionHandler.access$getNetworkService$p(this.this$0).getExceptionHandlers$osrs_224_api().getChannelExceptionHandler();
                            Intrinsics.checkNotNull((Object)exception);
                            channelExceptionHandler.exceptionCaught(this.$ctx, exception);
                            return;
                        }
                        if (LoginConnectionHandler.access$getSessionId$p(this.this$0) == block.getSessionId()) break block36;
                        Logger logger = LoginConnectionHandler.access$getLogger$cp();
                        ChannelHandlerContext channelHandlerContext = this.$ctx;
                        LoginConnectionHandler<R> loginConnectionHandler = this.this$0;
                        boolean bl = false;
                        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                        boolean bl2 = false;
                        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                void logger$iv;
                                boolean bl3 = false;
                                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                    void var11_37 = logger$iv;
                                    boolean bl4 = false;
                                    var11_37.trace(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                                }
                                break;
                            }
                            case 3: {
                                void logger$iv;
                                boolean bl5 = false;
                                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                    void var11_38 = logger$iv;
                                    boolean bl6 = false;
                                    var11_38.debug(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                                }
                                break;
                            }
                            case 4: {
                                void logger$iv;
                                boolean bl7 = false;
                                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                    void var11_39 = logger$iv;
                                    boolean bl8 = false;
                                    var11_39.info(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                                }
                                break;
                            }
                            case 5: {
                                void logger$iv;
                                boolean bl9 = false;
                                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                    void var11_40 = logger$iv;
                                    boolean bl10 = false;
                                    var11_40.warn(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                                }
                                break;
                            }
                            case 6: {
                                void logger$iv;
                                boolean bl11 = false;
                                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                    void var11_41 = logger$iv;
                                    boolean bl12 = false;
                                    var11_41.error(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                                }
                                break;
                            }
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    if (this.$remainingBetaArchives != null) {
                        block.mergeBetaCrcs(this.$remainingBetaArchives);
                    }
                    Logger logger$iv = LoginConnectionHandler.access$getLogger$cp();
                    ChannelHandlerContext channelHandlerContext = this.$ctx;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl13 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl14 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl15 = false;
                                logger.trace(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl16 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl17 = false;
                                logger.debug(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl18 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl19 = false;
                                logger.info(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl20 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl21 = false;
                                logger.warn(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl22 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl23 = false;
                                logger.error(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                    }
                    ExecutorService executor = LoginConnectionHandler.access$getNetworkService$p(this.this$0).getLoginHandlers$osrs_224_api().getLoginFlowExecutor();
                    if (executor != null) {
                        executor.submit(() -> decodeGameLoginBuffer.1.invoke$lambda$2(this.this$0, this.$responseHandler, block, this.$ctx));
                    } else {
                        LoginConnectionHandler.access$getNetworkService$p(this.this$0).getGameConnectionHandler$osrs_224_api().onLogin(this.$responseHandler, block);
                    }
                }
                catch (Exception e) {
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        Logger logger = arg0$iv;
                        boolean bl24 = false;
                        logger.error(String.valueOf("Error in handling decoded login block."), (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        Logger logger = arg0$iv;
                        boolean bl25 = false;
                        logger.error(String.valueOf("Fatal error in handling decoded login block."), t);
                    }
                    throw t;
                }
            }

            private static final void invoke$lambda$2(LoginConnectionHandler this$0, GameLoginResponseHandler $responseHandler, LoginBlock $block, ChannelHandlerContext $ctx) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$responseHandler, (String)"$responseHandler");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                try {
                    GameConnectionHandler<R> gameConnectionHandler = LoginConnectionHandler.access$getNetworkService$p(this$0).getGameConnectionHandler$osrs_224_api();
                    Intrinsics.checkNotNull((Object)$block);
                    gameConnectionHandler.onLogin($responseHandler, (LoginBlock<AuthenticationType>)$block);
                }
                catch (Throwable t) {
                    this$0.exceptionCaught($ctx, t);
                }
            }
        }, arg_0, arg_1));
    }

    private final void decodeGameReconnectBuffer(GameReconnect packet, ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives, GameLoginResponseHandler<R> responseHandler) {
        this.decodeLogin-6j-XqWU(packet.getBuffer-07mC048(), this.networkService.getBetaWorld$osrs_224_api(), packet.getDecoder()).handle((arg_0, arg_1) -> LoginConnectionHandler.decodeGameReconnectBuffer$lambda$10((Function2)new Function2<LoginBlock<XteaKey>, Throwable, Unit>(ctx, this, remainingBetaArchives, responseHandler){
            final /* synthetic */ ChannelHandlerContext $ctx;
            final /* synthetic */ LoginConnectionHandler<R> this$0;
            final /* synthetic */ RemainingBetaArchives $remainingBetaArchives;
            final /* synthetic */ GameLoginResponseHandler<R> $responseHandler;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                this.$remainingBetaArchives = $remainingBetaArchives;
                this.$responseHandler = $responseHandler;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(LoginBlock<XteaKey> block, Throwable exception) {
                try {
                    block37: {
                        if (block == null || exception != null) {
                            void arg0$iv;
                            if (exception instanceof CompletionException && Intrinsics.areEqual((Object)exception.getCause(), (Object)InvalidVersionException.INSTANCE)) {
                                this.$ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                            Logger logger = LoginConnectionHandler.access$getLogger$cp();
                            ChannelHandlerContext channelHandlerContext = this.$ctx;
                            boolean bl = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                                void var11_18 = arg0$iv;
                                boolean bl2 = false;
                                var11_18.error(String.valueOf("Failed to decode game reconnect block for channel " + channelHandlerContext.channel()), exception);
                            }
                            this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail2.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (LoginConnectionHandler.access$getSessionId$p(this.this$0) == block.getSessionId()) break block37;
                        Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        ChannelHandlerContext channelHandlerContext = this.$ctx;
                        LoginConnectionHandler<R> bl = this.this$0;
                        boolean bl3 = false;
                        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                        boolean bl4 = false;
                        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                void logger$iv;
                                boolean bl5 = false;
                                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                    void var11_19 = logger$iv;
                                    boolean bl6 = false;
                                    var11_19.trace(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                                }
                                break;
                            }
                            case 3: {
                                void logger$iv;
                                boolean bl7 = false;
                                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                    void var11_20 = logger$iv;
                                    boolean bl8 = false;
                                    var11_20.debug(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                                }
                                break;
                            }
                            case 4: {
                                void logger$iv;
                                boolean bl9 = false;
                                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                    void var11_21 = logger$iv;
                                    boolean bl10 = false;
                                    var11_21.info(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                                }
                                break;
                            }
                            case 5: {
                                void logger$iv;
                                boolean bl11 = false;
                                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                    void var11_22 = logger$iv;
                                    boolean bl12 = false;
                                    var11_22.warn(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                                }
                                break;
                            }
                            case 6: {
                                void logger$iv;
                                boolean bl13 = false;
                                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                    void var11_23 = logger$iv;
                                    boolean bl14 = false;
                                    var11_23.error(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                                }
                                break;
                            }
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    if (this.$remainingBetaArchives != null) {
                        block.mergeBetaCrcs(this.$remainingBetaArchives);
                    }
                    Logger logger$iv = LoginConnectionHandler.access$getLogger$cp();
                    ChannelHandlerContext channelHandlerContext = this.$ctx;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl15 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl16 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl17 = false;
                                logger.trace(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl18 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl19 = false;
                                logger.debug(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl20 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl21 = false;
                                logger.info(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl22 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl23 = false;
                                logger.warn(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl24 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl25 = false;
                                logger.error(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                            }
                            break;
                        }
                    }
                    ExecutorService executor = LoginConnectionHandler.access$getNetworkService$p(this.this$0).getLoginHandlers$osrs_224_api().getLoginFlowExecutor();
                    if (executor != null) {
                        executor.submit(() -> decodeGameReconnectBuffer.1.invoke$lambda$3(this.this$0, this.$responseHandler, block, this.$ctx));
                    } else {
                        LoginConnectionHandler.access$getNetworkService$p(this.this$0).getGameConnectionHandler$osrs_224_api().onReconnect(this.$responseHandler, block);
                    }
                }
                catch (Exception e) {
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        Logger logger = arg0$iv;
                        boolean bl26 = false;
                        logger.error(String.valueOf("Error in handling decoded login block."), (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        Logger logger = arg0$iv;
                        boolean bl27 = false;
                        logger.error(String.valueOf("Fatal error in handling decoded login block."), t);
                    }
                    throw t;
                }
            }

            private static final void invoke$lambda$3(LoginConnectionHandler this$0, GameLoginResponseHandler $responseHandler, LoginBlock $block, ChannelHandlerContext $ctx) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$responseHandler, (String)"$responseHandler");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                try {
                    GameConnectionHandler<R> gameConnectionHandler = LoginConnectionHandler.access$getNetworkService$p(this$0).getGameConnectionHandler$osrs_224_api();
                    Intrinsics.checkNotNull((Object)$block);
                    gameConnectionHandler.onReconnect($responseHandler, (LoginBlock<XteaKey>)$block);
                }
                catch (Throwable t) {
                    this$0.exceptionCaught($ctx, t);
                }
            }
        }, arg_0, arg_1));
    }

    private final <Fun> CompletableFuture<LoginBlock<Fun>> decodeLogin-6j-XqWU(ByteBuf buf, boolean betaWorld, LoginBlockDecodingFunction<Fun> function) {
        LoginBlock.Header header = this.loginHeader;
        if (header == null) {
            throw new IllegalStateException("Login header not set".toString());
        }
        return this.networkService.getLoginHandlers$osrs_224_api().getLoginDecoderService().decode-jOnPCEM(buf, betaWorld, header, function);
    }

    private final <T extends ChallengeType<? super MetaData>, MetaData extends ChallengeMetaData> CompletableFuture<Boolean> verifyProofOfWork(ProofOfWork<T, ? super MetaData> pow, long result) {
        return this.networkService.getLoginHandlers$osrs_224_api().getProofOfWorkChallengeWorker().verify(result, pow.getChallengeType(), pow.getChallengeVerifier());
    }

    private static final Unit channelRead0$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final void requestProofOfWork$lambda$5(ChannelHandlerContext $ctx, ChannelFuture future2) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
            if (future2.isSuccess()) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
            }
            future2.channel().pipeline().fireExceptionCaught(future2.cause());
            future2.channel().close();
            return;
        }
        $ctx.read();
    }

    private static final void continueLogin$lambda$7(ChannelHandlerContext $ctx, ChannelFuture future2) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
            if (future2.isSuccess()) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
            }
            future2.channel().pipeline().fireExceptionCaught(future2.cause());
            future2.channel().close();
            return;
        }
        $ctx.read();
    }

    private static final Unit decodeGameLoginBuffer$lambda$9(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit decodeGameReconnectBuffer$lambda$10(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$continueLogin(LoginConnectionHandler $this, ChannelHandlerContext ctx) {
        $this.continueLogin(ctx);
    }

    public static final /* synthetic */ NetworkService access$getNetworkService$p(LoginConnectionHandler $this) {
        return $this.networkService;
    }

    public static final /* synthetic */ long access$getSessionId$p(LoginConnectionHandler $this) {
        return $this.sessionId;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-224-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler$LoginState;", "", "(Ljava/lang/String;I)V", "UNINITIALIZED", "REQUESTED_PROOF_OF_WORK", "AWAITING_BETA_RESPONSE", "osrs-224-api"})
    private static final class LoginState
    extends Enum<LoginState> {
        public static final /* enum */ LoginState UNINITIALIZED = new LoginState();
        public static final /* enum */ LoginState REQUESTED_PROOF_OF_WORK = new LoginState();
        public static final /* enum */ LoginState AWAITING_BETA_RESPONSE = new LoginState();
        private static final /* synthetic */ LoginState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LoginState[] values() {
            return (LoginState[])$VALUES.clone();
        }

        public static LoginState valueOf(String value) {
            return Enum.valueOf(LoginState.class, value);
        }

        @NotNull
        public static EnumEntries<LoginState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = loginStateArray = new LoginState[]{LoginState.UNINITIALIZED, LoginState.REQUESTED_PROOF_OF_WORK, LoginState.AWAITING_BETA_RESPONSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

