/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.js5.Js5ChannelHandler;
import net.rsprot.protocol.api.js5.Js5MessageDecoder;
import net.rsprot.protocol.api.js5.Js5MessageEncoder;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.InitGameConnection;
import net.rsprot.protocol.loginprot.incoming.InitJs5RemoteConnection;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.IncomingLoginMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingLoginMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "channelReadComplete", "exceptionCaught", "cause", "", "handleInitGameConnection", "handleInitJs5RemoteConnection", "revision", "", "seed", "", "userEventTriggered", "evt", "", "Companion", "osrs-224-api"})
@SourceDebugExtension(value={"SMAP\nLoginChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 ChannelExtensions.kt\nnet/rsprot/protocol/api/channel/ChannelExtensionsKt\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,236:1\n20#2:237\n44#2,6:238\n52#2:248\n55#2:253\n58#2:258\n61#2:263\n64#2:268\n21#2:269\n20#2:270\n44#2,6:271\n52#2:281\n55#2:286\n58#2:291\n61#2:296\n64#2:301\n21#2:302\n20#2:303\n44#2,6:304\n52#2:314\n55#2:319\n58#2:324\n61#2:329\n64#2:334\n21#2:335\n20#2:336\n44#2,6:337\n52#2:347\n55#2:352\n58#2:357\n61#2:362\n64#2:367\n21#2:368\n20#2:369\n44#2,6:370\n52#2:380\n55#2:385\n58#2:390\n61#2:395\n64#2:400\n21#2:401\n20#2:402\n44#2,6:403\n52#2:413\n55#2:418\n58#2:423\n61#2:428\n64#2:433\n21#2:434\n20#2:435\n44#2,6:436\n52#2:446\n55#2:451\n58#2:456\n61#2:461\n64#2:466\n21#2:467\n20#2:468\n44#2,6:469\n52#2:479\n55#2:484\n58#2:489\n61#2:494\n64#2:499\n21#2:500\n20#2:501\n44#2,6:502\n52#2:512\n55#2:517\n58#2:522\n61#2:527\n64#2:532\n21#2:533\n20#2:536\n44#2,6:537\n52#2:547\n55#2:552\n58#2:557\n61#2:562\n64#2:567\n21#2:568\n20#2:569\n44#2,6:570\n52#2:580\n55#2:585\n58#2:590\n61#2:595\n64#2:600\n21#2:601\n32#3,4:244\n56#3,4:249\n80#3,4:254\n104#3,4:259\n128#3,4:264\n32#3,4:277\n56#3,4:282\n80#3,4:287\n104#3,4:292\n128#3,4:297\n32#3,4:310\n56#3,4:315\n80#3,4:320\n104#3,4:325\n128#3,4:330\n32#3,4:343\n56#3,4:348\n80#3,4:353\n104#3,4:358\n128#3,4:363\n32#3,4:376\n56#3,4:381\n80#3,4:386\n104#3,4:391\n128#3,4:396\n32#3,4:409\n56#3,4:414\n80#3,4:419\n104#3,4:424\n128#3,4:429\n32#3,4:442\n56#3,4:447\n80#3,4:452\n104#3,4:457\n128#3,4:462\n32#3,4:475\n56#3,4:480\n80#3,4:485\n104#3,4:490\n128#3,4:495\n32#3,4:508\n56#3,4:513\n80#3,4:518\n104#3,4:523\n128#3,4:528\n32#3,4:543\n56#3,4:548\n80#3,4:553\n104#3,4:558\n128#3,4:563\n32#3,4:576\n56#3,4:581\n80#3,4:586\n104#3,4:591\n128#3,4:596\n36#4:534\n36#4:535\n36#4:602\n36#4:603\n36#4:604\n36#4:605\n11#5,2:606\n*S KotlinDebug\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n*L\n35#1:237\n35#1:238,6\n35#1:248\n35#1:253\n35#1:258\n35#1:263\n35#1:268\n35#1:269\n44#1:270\n44#1:271,6\n44#1:281\n44#1:286\n44#1:291\n44#1:296\n44#1:301\n44#1:302\n74#1:303\n74#1:304,6\n74#1:314\n74#1:319\n74#1:324\n74#1:329\n74#1:334\n74#1:335\n87#1:336\n87#1:337,6\n87#1:347\n87#1:352\n87#1:357\n87#1:362\n87#1:367\n87#1:368\n133#1:369\n133#1:370,6\n133#1:380\n133#1:385\n133#1:390\n133#1:395\n133#1:400\n133#1:401\n153#1:402\n153#1:403,6\n153#1:413\n153#1:418\n153#1:423\n153#1:428\n153#1:433\n153#1:434\n224#1:435\n224#1:436,6\n224#1:446\n224#1:451\n224#1:456\n224#1:461\n224#1:466\n224#1:467\n95#1:468\n95#1:469,6\n95#1:479\n95#1:484\n95#1:489\n95#1:494\n95#1:499\n95#1:500\n104#1:501\n104#1:502,6\n104#1:512\n104#1:517\n104#1:522\n104#1:527\n104#1:532\n104#1:533\n166#1:536\n166#1:537,6\n166#1:547\n166#1:552\n166#1:557\n166#1:562\n166#1:567\n166#1:568\n175#1:569\n175#1:570,6\n175#1:580\n175#1:585\n175#1:590\n175#1:595\n175#1:600\n175#1:601\n35#1:244,4\n35#1:249,4\n35#1:254,4\n35#1:259,4\n35#1:264,4\n44#1:277,4\n44#1:282,4\n44#1:287,4\n44#1:292,4\n44#1:297,4\n74#1:310,4\n74#1:315,4\n74#1:320,4\n74#1:325,4\n74#1:330,4\n87#1:343,4\n87#1:348,4\n87#1:353,4\n87#1:358,4\n87#1:363,4\n133#1:376,4\n133#1:381,4\n133#1:386,4\n133#1:391,4\n133#1:396,4\n153#1:409,4\n153#1:414,4\n153#1:419,4\n153#1:424,4\n153#1:429,4\n224#1:442,4\n224#1:447,4\n224#1:452,4\n224#1:457,4\n224#1:462,4\n95#1:475,4\n95#1:480,4\n95#1:485,4\n95#1:490,4\n95#1:495,4\n104#1:508,4\n104#1:513,4\n104#1:518,4\n104#1:523,4\n104#1:528,4\n166#1:543,4\n166#1:548,4\n166#1:553,4\n166#1:558,4\n166#1:563,4\n175#1:576,4\n175#1:581,4\n175#1:586,4\n175#1:591,4\n175#1:596,4\n113#1:534\n114#1:535\n184#1:602\n185#1:603\n186#1:604\n187#1:605\n233#1:606,2\n*E\n"})
public final class LoginChannelHandler
extends SimpleChannelInboundHandler<IncomingLoginMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private static final Logger logger;

    public LoginChannelHandler(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingLoginMessage.class);
        this.networkService = networkService;
    }

    @NotNull
    public final NetworkService<?> getNetworkService() {
        return this.networkService;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
        ctx.fireChannelActive();
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingLoginMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
        }
        IncomingLoginMessage incomingLoginMessage = msg;
        if (Intrinsics.areEqual((Object)incomingLoginMessage, (Object)InitGameConnection.INSTANCE)) {
            this.handleInitGameConnection(ctx);
        } else if (incomingLoginMessage instanceof InitJs5RemoteConnection) {
            this.handleInitJs5RemoteConnection(ctx, ((InitJs5RemoteConnection)msg).getRevision(), ((InitJs5RemoteConnection)msg).getSeed());
        } else {
            throw new IllegalStateException("Unknown login channel message: " + msg);
        }
    }

    private final void handleInitGameConnection(ChannelHandlerContext ctx) {
        InetAddress address;
        block26: {
            address = ChannelExtensionsKt.inetAddress(ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_224_api().getGameInetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_224_api().getInetAddressValidator().acceptGameConnection(address, count);
            if (accepted) break block26;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.writeAndFlush((Object)LoginResponse.TooManyAttempts.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        long sessionId = this.networkService.getLoginHandlers$osrs_224_api().getSessionIdGenerator().generate(address);
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl13 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl14 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl15 = false;
                    logger.trace(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 3: {
                boolean bl16 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl17 = false;
                    logger.debug(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 4: {
                boolean bl18 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl19 = false;
                    logger.info(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 5: {
                boolean bl20 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl21 = false;
                    logger.warn(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 6: {
                boolean bl22 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl23 = false;
                    logger.error(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
        }
        ctx.writeAndFlush((Object)new LoginResponse.Successful(Long.valueOf(sessionId))).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitGameConnection$lambda$6(ctx, this, address, sessionId, arg_0)));
    }

    private final void handleInitJs5RemoteConnection(ChannelHandlerContext ctx, int revision, int[] seed) {
        InetAddress address;
        block28: {
            block26: {
                if (revision == 224) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                }
                ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            address = ChannelExtensionsKt.inetAddress(ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_224_api().getJs5InetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_224_api().getInetAddressValidator().acceptJs5Connection(address, count, seed);
            if (accepted) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.writeAndFlush((Object)LoginResponse.IPLimit.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.writeAndFlush((Object)new LoginResponse.Successful(null)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitJs5RemoteConnection$lambda$11(ctx, this, address, arg_0)));
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_224_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }

    private static final void handleInitGameConnection$lambda$6(ChannelHandlerContext $ctx, LoginChannelHandler this$0, InetAddress $address, long $sessionId, ChannelFuture future2) {
        ChannelPipeline $this$replace$iv;
        block28: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                if (future2.isSuccess()) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                }
                future2.channel().pipeline().fireExceptionCaught(future2.cause());
                future2.channel().close();
                return;
            }
            if (!$ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_224_api().getGameInetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = future2.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new LoginConnectionHandler(this$0.networkService, $sessionId);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 40L, 40L, 40L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    private static final void handleInitJs5RemoteConnection$lambda$11(ChannelHandlerContext $ctx, LoginChannelHandler this$0, InetAddress $address, ChannelFuture future2) {
        ChannelPipeline $this$replace$iv;
        block28: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                if (future2.isSuccess()) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                }
                future2.channel().pipeline().fireExceptionCaught(future2.cause());
                future2.channel().close();
                return;
            }
            if (!$ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_224_api().getJs5InetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = $ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new Js5MessageDecoder(this$0.networkService);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5MessageEncoder(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5ChannelHandler(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 30L, 30L, 30L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-224-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

