/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.lang.invoke.MethodHandles;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.compression.provider.HuffmanCodecProvider;
import net.rsprot.crypto.rsa.RsaKeyPair;
import net.rsprot.protocol.api.EntityInfoProtocols;
import net.rsprot.protocol.api.GameConnectionHandler;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.bootstrap.BootstrapFactory;
import net.rsprot.protocol.api.config.NetworkConfiguration;
import net.rsprot.protocol.api.handlers.ExceptionHandlers;
import net.rsprot.protocol.api.handlers.GameMessageHandlers;
import net.rsprot.protocol.api.handlers.INetAddressHandlers;
import net.rsprot.protocol.api.handlers.LoginHandlers;
import net.rsprot.protocol.api.js5.Js5Configuration;
import net.rsprot.protocol.api.js5.Js5GroupProvider;
import net.rsprot.protocol.api.obfuscation.OpcodeMapper;
import net.rsprot.protocol.api.suppliers.NpcInfoSupplier;
import net.rsprot.protocol.api.suppliers.PlayerInfoSupplier;
import net.rsprot.protocol.api.suppliers.WorldEntityInfoSupplier;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarFilter;
import net.rsprot.protocol.message.codec.incoming.provider.GameMessageConsumerRepositoryProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 B*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u001f\u0010\u001a\u001a\u00020\u001b2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020!H&J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H&J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H&J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H&J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H&J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u001bH\u0016J\n\u00107\u001a\u0004\u0018\u000108H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020>H&J\n\u0010?\u001a\u0004\u0018\u00010#H\u0016J\b\u0010@\u001a\u00020AH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006C"}, d2={"Lnet/rsprot/protocol/api/AbstractNetworkServiceFactory;", "R", "", "()V", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "getAllocator", "()Lio/netty/buffer/ByteBufAllocator;", "betaWorld", "", "getBetaWorld", "()Z", "host", "", "getHost", "()Ljava/lang/String;", "ports", "", "", "getPorts", "()Ljava/util/List;", "supportedClientTypes", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "getSupportedClientTypes", "build", "Lnet/rsprot/protocol/api/NetworkService;", "configure", "Lnet/rsprot/protocol/api/config/NetworkConfiguration$Builder;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getBootstrapFactory", "Lnet/rsprot/protocol/api/bootstrap/BootstrapFactory;", "getClientToServerOpcodeMapper", "Lnet/rsprot/protocol/api/obfuscation/OpcodeMapper;", "getExceptionHandlers", "Lnet/rsprot/protocol/api/handlers/ExceptionHandlers;", "getGameConnectionHandler", "Lnet/rsprot/protocol/api/GameConnectionHandler;", "getGameMessageConsumerRepositoryProvider", "Lnet/rsprot/protocol/message/codec/incoming/provider/GameMessageConsumerRepositoryProvider;", "getGameMessageHandlers", "Lnet/rsprot/protocol/api/handlers/GameMessageHandlers;", "getHuffmanCodecProvider", "Lnet/rsprot/compression/provider/HuffmanCodecProvider;", "getINetAddressHandlers", "Lnet/rsprot/protocol/api/handlers/INetAddressHandlers;", "getJs5Configuration", "Lnet/rsprot/protocol/api/js5/Js5Configuration;", "getJs5GroupProvider", "Lnet/rsprot/protocol/api/js5/Js5GroupProvider;", "getLoginHandlers", "Lnet/rsprot/protocol/api/handlers/LoginHandlers;", "getNetworkConfiguration", "getNpcAvatarFilter", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFilter;", "getNpcInfoSupplier", "Lnet/rsprot/protocol/api/suppliers/NpcInfoSupplier;", "getPlayerInfoSupplier", "Lnet/rsprot/protocol/api/suppliers/PlayerInfoSupplier;", "getRsaKeyPair", "Lnet/rsprot/crypto/rsa/RsaKeyPair;", "getServerToClientOpcodeMapper", "getWorldEntityInfoSupplier", "Lnet/rsprot/protocol/api/suppliers/WorldEntityInfoSupplier;", "Companion", "osrs-224-api"})
@ExperimentalUnsignedTypes
@SourceDebugExtension(value={"SMAP\nAbstractNetworkServiceFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractNetworkServiceFactory.kt\nnet/rsprot/protocol/api/AbstractNetworkServiceFactory\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,348:1\n134#2,4:349\n11#3,2:353\n*S KotlinDebug\n*F\n+ 1 AbstractNetworkServiceFactory.kt\nnet/rsprot/protocol/api/AbstractNetworkServiceFactory\n*L\n206#1:349,4\n345#1:353,2\n*E\n"})
public abstract class AbstractNetworkServiceFactory<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @NotNull
    public ByteBufAllocator getAllocator() {
        PooledByteBufAllocator pooledByteBufAllocator = PooledByteBufAllocator.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)pooledByteBufAllocator, (String)"DEFAULT");
        return (ByteBufAllocator)pooledByteBufAllocator;
    }

    @Nullable
    public String getHost() {
        return null;
    }

    @NotNull
    public abstract List<Integer> getPorts();

    @NotNull
    public abstract List<OldSchoolClientType> getSupportedClientTypes();

    public boolean getBetaWorld() {
        return false;
    }

    @NotNull
    public abstract BootstrapFactory getBootstrapFactory();

    @NotNull
    public abstract RsaKeyPair getRsaKeyPair();

    @NotNull
    public abstract HuffmanCodecProvider getHuffmanCodecProvider();

    @NotNull
    public Js5Configuration getJs5Configuration() {
        return new Js5Configuration(0, 0, 0, 0, 0, null, 63, null);
    }

    @NotNull
    public abstract Js5GroupProvider getJs5GroupProvider();

    @NotNull
    public abstract GameMessageConsumerRepositoryProvider<R> getGameMessageConsumerRepositoryProvider();

    @NotNull
    public abstract GameConnectionHandler<R> getGameConnectionHandler();

    @NotNull
    public NpcInfoSupplier getNpcInfoSupplier() {
        return new NpcInfoSupplier(null, null, null, 7, null);
    }

    @NotNull
    public PlayerInfoSupplier getPlayerInfoSupplier() {
        return new PlayerInfoSupplier(null, null, 3, null);
    }

    @NotNull
    public WorldEntityInfoSupplier getWorldEntityInfoSupplier() {
        return new WorldEntityInfoSupplier(null, null, 3, null);
    }

    @NotNull
    public ExceptionHandlers<R> getExceptionHandlers() {
        return new ExceptionHandlers(AbstractNetworkServiceFactory::getExceptionHandlers$lambda$1, null, 2, null);
    }

    @NotNull
    public INetAddressHandlers getINetAddressHandlers() {
        return new INetAddressHandlers(null, null, null, 7, null);
    }

    @NotNull
    public GameMessageHandlers getGameMessageHandlers() {
        return new GameMessageHandlers(null, null, null, 7, null);
    }

    @NotNull
    public LoginHandlers getLoginHandlers() {
        return new LoginHandlers(null, null, null, null, null, null, false, 127, null);
    }

    @NotNull
    public NetworkConfiguration.Builder getNetworkConfiguration() {
        return new NetworkConfiguration.Builder();
    }

    @Nullable
    public NpcAvatarFilter getNpcAvatarFilter() {
        return null;
    }

    @Nullable
    public OpcodeMapper getClientToServerOpcodeMapper() {
        return null;
    }

    @Nullable
    public OpcodeMapper getServerToClientOpcodeMapper() {
        return null;
    }

    public final /* synthetic */ NetworkConfiguration.Builder configure(Function1 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        NetworkConfiguration.Builder builder = new NetworkConfiguration.Builder();
        block.invoke((Object)builder);
        return builder;
    }

    @NotNull
    public final NetworkService<R> build() {
        ByteBufAllocator allocator = this.getAllocator();
        String host = this.getHost();
        List<Integer> ports = this.getPorts();
        List<OldSchoolClientType> supportedClientTypes = this.getSupportedClientTypes();
        HuffmanCodecProvider huffman = this.getHuffmanCodecProvider();
        EntityInfoProtocols entityInfoProtocols = EntityInfoProtocols.Companion.initialize(allocator, supportedClientTypes, huffman, this.getPlayerInfoSupplier(), this.getNpcInfoSupplier(), this.getWorldEntityInfoSupplier(), this.getNpcAvatarFilter());
        return new NetworkService<R>(allocator, host, ports, this.getBetaWorld(), this.getBootstrapFactory(), entityInfoProtocols, supportedClientTypes, this.getGameConnectionHandler(), this.getExceptionHandlers(), this.getINetAddressHandlers(), this.getGameMessageHandlers(), this.getLoginHandlers(), this.getNetworkConfiguration().build$osrs_224_api(), huffman, this.getGameMessageConsumerRepositoryProvider(), this.getClientToServerOpcodeMapper(), this.getServerToClientOpcodeMapper(), this.getRsaKeyPair(), this.getJs5Configuration(), this.getJs5GroupProvider());
    }

    private static final void getExceptionHandlers$lambda$1(ChannelHandlerContext ctx, Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (ctx.channel().isActive()) {
            ctx.close();
        }
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.error(String.valueOf("Exception in channel " + ctx.channel()), cause);
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/AbstractNetworkServiceFactory$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-224-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

