/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.encoder;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.protocol.ServerProt;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.outgoing.MessageEncoderRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder;", "Lio/netty/handler/codec/MessageToByteEncoder;", "Lnet/rsprot/protocol/message/OutgoingMessage;", "()V", "cipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "getCipher", "()Lnet/rsprot/crypto/cipher/StreamCipher;", "repository", "Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "getRepository", "()Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "validate", "", "getValidate", "()Z", "encode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "out", "Lio/netty/buffer/ByteBuf;", "pSmart1Or2Enc", "opcode", "", "Companion", "osrs-224-api"})
@SourceDebugExtension(value={"SMAP\nOutgoingMessageEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutgoingMessageEncoder.kt\nnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,151:1\n104#2,4:152\n104#2,4:156\n104#2,4:160\n11#3,2:164\n*S KotlinDebug\n*F\n+ 1 OutgoingMessageEncoder.kt\nnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder\n*L\n86#1:152,4\n99#1:156,4\n114#1:160,4\n148#1:164,2\n*E\n"})
public abstract class OutgoingMessageEncoder
extends MessageToByteEncoder<OutgoingMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final int MAX_USHORT_PAYLOAD_SIZE = 40000;
    private static final int MAX_UBYTE_PAYLOAD_SIZE = 255;
    @NotNull
    private static final Logger logger;

    public OutgoingMessageEncoder() {
        super(OutgoingMessage.class);
    }

    @NotNull
    protected abstract StreamCipher getCipher();

    @NotNull
    protected abstract MessageEncoderRepository<?> getRepository();

    protected abstract boolean getValidate();

    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull OutgoingMessage msg, @NotNull ByteBuf out) {
        int length;
        int n;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int startMarker = out.writerIndex();
        MessageEncoder encoder = this.getRepository().getEncoder(msg.getClass());
        ServerProt prot = encoder.getProt();
        int opcode = prot.getOpcode();
        if (encoder.getEncryptedPayload()) {
            this.pSmart1Or2Enc(out, opcode);
        } else if (opcode < 128) {
            JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)0);
        } else {
            JagexByteBufExtensionsKt.p2((ByteBuf)out, (int)0);
        }
        switch (prot.getSize()) {
            case -1: {
                JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)0);
                n = out.writerIndex() - 1;
                break;
            }
            case -2: {
                JagexByteBufExtensionsKt.p2((ByteBuf)out, (int)0);
                n = out.writerIndex() - 2;
                break;
            }
            default: {
                n = -1;
            }
        }
        int sizeMarker = n;
        int payloadMarker = out.writerIndex();
        encoder.encode-WFbGaZ8(this.getCipher(), JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)out), msg);
        int endMarker = out.writerIndex();
        if (sizeMarker != -1) {
            int length2 = 0;
            length2 = endMarker - payloadMarker;
            if (msg instanceof LoginResponse.Ok) {
                length2 += 3;
            }
            out.writerIndex(sizeMarker);
            switch (prot.getSize()) {
                case -1: {
                    if (this.getValidate()) {
                        if (!(0 <= length2 ? length2 < 256 : false)) {
                            out.writerIndex(startMarker);
                            Logger arg0$iv = logger;
                            boolean bl = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                Logger logger = arg0$iv;
                                boolean bl2 = false;
                                logger.warn(String.valueOf("Server prot " + prot + " length out of bounds; expected 0..255, received " + length2 + "; message: " + msg));
                            }
                            return;
                        }
                    }
                    JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)length2);
                    break;
                }
                case -2: {
                    if (this.getValidate()) {
                        if (!(0 <= length2 ? length2 < 40001 : false)) {
                            out.writerIndex(startMarker);
                            Logger arg0$iv = logger;
                            boolean bl = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                Logger logger = arg0$iv;
                                boolean bl3 = false;
                                logger.warn(String.valueOf("Server prot " + prot + " length out of bounds; expected 0..40_000, received " + length2 + "; message: " + msg));
                            }
                            return;
                        }
                    }
                    JagexByteBufExtensionsKt.p2((ByteBuf)out, (int)length2);
                }
            }
            out.writerIndex(endMarker);
        } else if (this.getValidate() && (length = endMarker - payloadMarker) != prot.getSize()) {
            out.writerIndex(startMarker);
            Logger arg0$iv = logger;
            boolean bl = false;
            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl4 = false;
                logger.warn(String.valueOf("Server prot " + prot + " length out of bounds; expected 0..40_000, received " + length + "; message: " + msg));
            }
            return;
        }
        if (!encoder.getEncryptedPayload()) {
            out.writerIndex(startMarker);
            this.pSmart1Or2Enc(out, opcode);
            out.writerIndex(endMarker);
        }
    }

    private final void pSmart1Or2Enc(ByteBuf out, int opcode) {
        if (opcode < 128) {
            JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)(opcode + this.getCipher().nextInt()));
        } else {
            JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)((opcode >>> 8 | 0x80) + this.getCipher().nextInt()));
            JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)((opcode & 0xFF) + this.getCipher().nextInt()));
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\t"}, d2={"Lnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder$Companion;", "", "()V", "MAX_UBYTE_PAYLOAD_SIZE", "", "MAX_USHORT_PAYLOAD_SIZE", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-224-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

