/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.bootstrap;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/rsprot/protocol/api/bootstrap/BootstrapFactory;", "", "alloc", "Lio/netty/buffer/ByteBufAllocator;", "(Lio/netty/buffer/ByteBufAllocator;)V", "createChildLoopGroup", "Lio/netty/channel/EventLoopGroup;", "nThreads", "", "createIoHandlerFactory", "Lio/netty/channel/IoHandlerFactory;", "createParentLoopGroup", "createServerBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "parentGroup", "childGroup", "Companion", "osrs-223-api"})
@SourceDebugExtension(value={"SMAP\nBootstrapFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootstrapFactory.kt\nnet/rsprot/protocol/api/bootstrap/BootstrapFactory\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,92:1\n20#2:93\n44#2,6:94\n52#2:104\n55#2:109\n58#2:114\n61#2:119\n64#2:124\n21#2:125\n32#3,4:100\n56#3,4:105\n80#3,4:110\n104#3,4:115\n128#3,4:120\n11#4,2:126\n*S KotlinDebug\n*F\n+ 1 BootstrapFactory.kt\nnet/rsprot/protocol/api/bootstrap/BootstrapFactory\n*L\n70#1:93\n70#1:94,6\n70#1:104\n70#1:109\n70#1:114\n70#1:119\n70#1:124\n70#1:125\n70#1:100,4\n70#1:105,4\n70#1:110,4\n70#1:115,4\n70#1:120,4\n89#1:126,2\n*E\n"})
public final class BootstrapFactory {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator alloc;
    @NotNull
    private static final Logger logger;

    public BootstrapFactory(@NotNull ByteBufAllocator alloc) {
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        this.alloc = alloc;
    }

    @NotNull
    public final IoHandlerFactory createIoHandlerFactory() {
        IoHandlerFactory ioHandlerFactory;
        if (IoUring.isAvailable()) {
            IoHandlerFactory ioHandlerFactory2 = IoUringIoHandler.newFactory();
            ioHandlerFactory = ioHandlerFactory2;
            Intrinsics.checkNotNullExpressionValue((Object)ioHandlerFactory2, (String)"newFactory(...)");
        } else if (Epoll.isAvailable()) {
            IoHandlerFactory ioHandlerFactory3 = EpollIoHandler.newFactory();
            ioHandlerFactory = ioHandlerFactory3;
            Intrinsics.checkNotNullExpressionValue((Object)ioHandlerFactory3, (String)"newFactory(...)");
        } else if (KQueue.isAvailable()) {
            IoHandlerFactory ioHandlerFactory4 = KQueueIoHandler.newFactory();
            ioHandlerFactory = ioHandlerFactory4;
            Intrinsics.checkNotNullExpressionValue((Object)ioHandlerFactory4, (String)"newFactory(...)");
        } else {
            IoHandlerFactory ioHandlerFactory5 = NioIoHandler.newFactory();
            ioHandlerFactory = ioHandlerFactory5;
            Intrinsics.checkNotNullExpressionValue((Object)ioHandlerFactory5, (String)"newFactory(...)");
        }
        return ioHandlerFactory;
    }

    @NotNull
    public final EventLoopGroup createParentLoopGroup(int nThreads) {
        return (EventLoopGroup)new MultiThreadIoEventLoopGroup(nThreads, this.createIoHandlerFactory());
    }

    public static /* synthetic */ EventLoopGroup createParentLoopGroup$default(BootstrapFactory bootstrapFactory, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return bootstrapFactory.createParentLoopGroup(n);
    }

    @NotNull
    public final EventLoopGroup createChildLoopGroup(int nThreads) {
        return (EventLoopGroup)new MultiThreadIoEventLoopGroup(nThreads, this.createIoHandlerFactory());
    }

    public static /* synthetic */ EventLoopGroup createChildLoopGroup$default(BootstrapFactory bootstrapFactory, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return bootstrapFactory.createChildLoopGroup(n);
    }

    @NotNull
    public final ServerBootstrap createServerBootstrap(@NotNull EventLoopGroup parentGroup, @NotNull EventLoopGroup childGroup) {
        Intrinsics.checkNotNullParameter((Object)parentGroup, (String)"parentGroup");
        Intrinsics.checkNotNullParameter((Object)childGroup, (String)"childGroup");
        Class channel = IoUring.isAvailable() ? IoUringServerSocketChannel.class : (Epoll.isAvailable() ? EpollServerSocketChannel.class : (KQueue.isAvailable() ? KQueueServerSocketChannel.class : NioServerSocketChannel.class));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Bootstrap event loop group: " + parentGroup.getClass().getSimpleName()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Bootstrap event loop group: " + parentGroup.getClass().getSimpleName()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Bootstrap event loop group: " + parentGroup.getClass().getSimpleName()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Bootstrap event loop group: " + parentGroup.getClass().getSimpleName()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Bootstrap event loop group: " + parentGroup.getClass().getSimpleName()));
                }
                break;
            }
        }
        ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(parentGroup, childGroup).channel(channel)).option(ChannelOption.ALLOCATOR, (Object)this.alloc)).option(ChannelOption.SO_BACKLOG, (Object)4096)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.ALLOCATOR, (Object)this.alloc).childOption(ChannelOption.AUTO_READ, (Object)false).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_RCVBUF, (Object)65536).childOption(ChannelOption.SO_SNDBUF, (Object)65536).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(524288, 0x200000));
        Intrinsics.checkNotNullExpressionValue((Object)serverBootstrap, (String)"childOption(...)");
        return serverBootstrap;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/bootstrap/BootstrapFactory$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-223-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

