/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.ExperimentalStdlibApi;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import net.rsprot.compression.provider.HuffmanCodecProvider;
import net.rsprot.crypto.rsa.RsaKeyPair;
import net.rsprot.protocol.api.EntityInfoProtocols;
import net.rsprot.protocol.api.GameConnectionHandler;
import net.rsprot.protocol.api.LoginChannelInitializer;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.bootstrap.BootstrapFactory;
import net.rsprot.protocol.api.config.NetworkConfiguration;
import net.rsprot.protocol.api.handlers.ExceptionHandlers;
import net.rsprot.protocol.api.handlers.GameMessageHandlers;
import net.rsprot.protocol.api.handlers.INetAddressHandlers;
import net.rsprot.protocol.api.handlers.LoginHandlers;
import net.rsprot.protocol.api.js5.ConcurrentJs5Authorizer;
import net.rsprot.protocol.api.js5.Js5Authorizer;
import net.rsprot.protocol.api.js5.Js5Configuration;
import net.rsprot.protocol.api.js5.Js5GroupProvider;
import net.rsprot.protocol.api.js5.Js5Service;
import net.rsprot.protocol.api.js5.NoopJs5Authorizer;
import net.rsprot.protocol.api.obfuscation.OpcodeMapper;
import net.rsprot.protocol.api.repositories.MessageDecoderRepositories;
import net.rsprot.protocol.api.repositories.MessageEncoderRepositories;
import net.rsprot.protocol.api.util.FutureExtensionsKt;
import net.rsprot.protocol.client.ClientType;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.game.outgoing.codec.zone.header.DesktopUpdateZonePartialEnclosedEncoder;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarFactory;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoProtocol;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerInfoProtocol;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatarFactory;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityProtocol;
import net.rsprot.protocol.internal.client.ClientTypeMap;
import net.rsprot.protocol.message.ZoneProt;
import net.rsprot.protocol.message.codec.UpdateZonePartialEnclosedCache;
import net.rsprot.protocol.message.codec.incoming.provider.GameMessageConsumerRepositoryProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0096\u0001*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0096\u0001B\u00db\u0001\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\t\u0012\u0006\u0010\u001f\u001a\u00020\t\u0012\u0006\u0010 \u001a\u00020!\u0012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#\u0012\b\u0010$\u001a\u0004\u0018\u00010%\u0012\b\u0010&\u001a\u0004\u0018\u00010%\u0012\u0006\u0010'\u001a\u00020(\u0012\u0006\u0010)\u001a\u00020*\u0012\u0006\u0010+\u001a\u00020,\u00a2\u0006\u0002\u0010-J0\u0010\u0085\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020A0\u0086\u0001\"\n\b\u0001\u0010\u0087\u0001*\u00030\u0088\u00012\u000e\u0010\u0089\u0001\u001a\t\u0012\u0005\u0012\u0003H\u0087\u00010\bJ\u000f\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020{0zH\u0002J\u0010\u0010\u008b\u0001\u001a\u00020\u000b2\u0007\u0010\u008c\u0001\u001a\u00020\u0011J\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001J\"\u0010\u008f\u0001\u001a\u00030\u008e\u00012\r\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020A0@2\u0007\u0010\u0091\u0001\u001a\u00020\u000bH\u0002J\b\u0010\u0092\u0001\u001a\u00030\u008e\u0001J\n\u0010\u0093\u0001\u001a\u00030\u008e\u0001H\u0007J\u000f\u0010\u0094\u0001\u001a\u00030\u008e\u0001*\u00030\u0095\u0001H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u00108\u001a\u000205X\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\u00020DX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0014\u0010G\u001a\u00020HX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010XR\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010ZR\u0011\u0010[\u001a\u00020\\\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010^R\u000e\u0010_\u001a\u00020`X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010a\u001a\u00020b\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010dR\u000e\u0010e\u001a\u00020fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010hR\u0011\u0010i\u001a\u00020j8F\u00a2\u0006\u0006\u001a\u0004\bk\u0010lR\u0011\u0010m\u001a\u00020n8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010pR\u0011\u0010q\u001a\u00020r8F\u00a2\u0006\u0006\u001a\u0004\bs\u0010tR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010<R\u0013\u0010&\u001a\u0004\u0018\u00010%\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010:R\u001a\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020A0@0xX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010y\u001a\b\u0012\u0004\u0012\u00020{0zX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010|\u001a\u00020}8F\u00a2\u0006\u0006\u001a\u0004\b~\u0010\u007fR\u0015\u0010\u0080\u0001\u001a\u00030\u0081\u00018F\u00a2\u0006\b\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001R\u0015\u0010\u001e\u001a\u00020\tX\u0080\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0084\u0001\u00107\u00a8\u0006\u0097\u0001"}, d2={"Lnet/rsprot/protocol/api/NetworkService;", "R", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "host", "", "ports", "", "", "betaWorld", "", "bootstrapFactory", "Lnet/rsprot/protocol/api/bootstrap/BootstrapFactory;", "entityInfoProtocols", "Lnet/rsprot/protocol/api/EntityInfoProtocols;", "clientTypes", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "gameConnectionHandler", "Lnet/rsprot/protocol/api/GameConnectionHandler;", "exceptionHandlers", "Lnet/rsprot/protocol/api/handlers/ExceptionHandlers;", "iNetAddressHandlers", "Lnet/rsprot/protocol/api/handlers/INetAddressHandlers;", "gameMessageHandlers", "Lnet/rsprot/protocol/api/handlers/GameMessageHandlers;", "loginHandlers", "Lnet/rsprot/protocol/api/handlers/LoginHandlers;", "configuration", "Lnet/rsprot/protocol/api/config/NetworkConfiguration;", "zoneCountBeforeLeakWarning", "bufRetentionCountBeforeRelease", "huffmanCodecProvider", "Lnet/rsprot/compression/provider/HuffmanCodecProvider;", "gameMessageConsumerRepositoryProvider", "Lnet/rsprot/protocol/message/codec/incoming/provider/GameMessageConsumerRepositoryProvider;", "clientToServerOpcodeMapper", "Lnet/rsprot/protocol/api/obfuscation/OpcodeMapper;", "serverToClientOpcodeMapper", "rsaKeyPair", "Lnet/rsprot/crypto/rsa/RsaKeyPair;", "js5Configuration", "Lnet/rsprot/protocol/api/js5/Js5Configuration;", "js5GroupProvider", "Lnet/rsprot/protocol/api/js5/Js5GroupProvider;", "(Lio/netty/buffer/ByteBufAllocator;Ljava/lang/String;Ljava/util/List;ZLnet/rsprot/protocol/api/bootstrap/BootstrapFactory;Lnet/rsprot/protocol/api/EntityInfoProtocols;Ljava/util/List;Lnet/rsprot/protocol/api/GameConnectionHandler;Lnet/rsprot/protocol/api/handlers/ExceptionHandlers;Lnet/rsprot/protocol/api/handlers/INetAddressHandlers;Lnet/rsprot/protocol/api/handlers/GameMessageHandlers;Lnet/rsprot/protocol/api/handlers/LoginHandlers;Lnet/rsprot/protocol/api/config/NetworkConfiguration;IILnet/rsprot/compression/provider/HuffmanCodecProvider;Lnet/rsprot/protocol/message/codec/incoming/provider/GameMessageConsumerRepositoryProvider;Lnet/rsprot/protocol/api/obfuscation/OpcodeMapper;Lnet/rsprot/protocol/api/obfuscation/OpcodeMapper;Lnet/rsprot/crypto/rsa/RsaKeyPair;Lnet/rsprot/protocol/api/js5/Js5Configuration;Lnet/rsprot/protocol/api/js5/Js5GroupProvider;)V", "getAllocator$osrs_223_api", "()Lio/netty/buffer/ByteBufAllocator;", "getBetaWorld$osrs_223_api", "()Z", "getBootstrapFactory$osrs_223_api", "()Lnet/rsprot/protocol/api/bootstrap/BootstrapFactory;", "bossGroup", "Lio/netty/channel/EventLoopGroup;", "getBufRetentionCountBeforeRelease$osrs_223_api", "()I", "childGroup", "getClientToServerOpcodeMapper", "()Lnet/rsprot/protocol/api/obfuscation/OpcodeMapper;", "getClientTypes$osrs_223_api", "()Ljava/util/List;", "getConfiguration$osrs_223_api", "()Lnet/rsprot/protocol/api/config/NetworkConfiguration;", "currentUpdateOnePartialEnclosedBuffers", "Ljava/util/LinkedList;", "Lio/netty/buffer/ByteBuf;", "currentZoneCallCount", "decoderRepositories", "Lnet/rsprot/protocol/api/repositories/MessageDecoderRepositories;", "getDecoderRepositories$osrs_223_api", "()Lnet/rsprot/protocol/api/repositories/MessageDecoderRepositories;", "encoderRepositories", "Lnet/rsprot/protocol/api/repositories/MessageEncoderRepositories;", "getEncoderRepositories$osrs_223_api", "()Lnet/rsprot/protocol/api/repositories/MessageEncoderRepositories;", "getEntityInfoProtocols$osrs_223_api", "()Lnet/rsprot/protocol/api/EntityInfoProtocols;", "getExceptionHandlers$osrs_223_api", "()Lnet/rsprot/protocol/api/handlers/ExceptionHandlers;", "getGameConnectionHandler$osrs_223_api", "()Lnet/rsprot/protocol/api/GameConnectionHandler;", "getGameMessageConsumerRepositoryProvider", "()Lnet/rsprot/protocol/message/codec/incoming/provider/GameMessageConsumerRepositoryProvider;", "getGameMessageHandlers$osrs_223_api", "()Lnet/rsprot/protocol/api/handlers/GameMessageHandlers;", "getHost$osrs_223_api", "()Ljava/lang/String;", "getHuffmanCodecProvider", "()Lnet/rsprot/compression/provider/HuffmanCodecProvider;", "getINetAddressHandlers$osrs_223_api", "()Lnet/rsprot/protocol/api/handlers/INetAddressHandlers;", "js5Authorizer", "Lnet/rsprot/protocol/api/js5/Js5Authorizer;", "getJs5Authorizer", "()Lnet/rsprot/protocol/api/js5/Js5Authorizer;", "js5PrefetchService", "Ljava/util/concurrent/ScheduledExecutorService;", "js5Service", "Lnet/rsprot/protocol/api/js5/Js5Service;", "getJs5Service", "()Lnet/rsprot/protocol/api/js5/Js5Service;", "js5ServiceExecutor", "Ljava/lang/Thread;", "getLoginHandlers$osrs_223_api", "()Lnet/rsprot/protocol/api/handlers/LoginHandlers;", "npcAvatarFactory", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFactory;", "getNpcAvatarFactory", "()Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFactory;", "npcInfoProtocol", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol;", "getNpcInfoProtocol", "()Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol;", "playerInfoProtocol", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol;", "getPlayerInfoProtocol", "()Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol;", "getPorts$osrs_223_api", "getServerToClientOpcodeMapper", "updateZonePartialEnclosedBufferList", "Ljava/util/ArrayDeque;", "updateZonePartialEnclosedCacheClientTypeMap", "Lnet/rsprot/protocol/internal/client/ClientTypeMap;", "Lnet/rsprot/protocol/message/codec/UpdateZonePartialEnclosedCache;", "worldEntityAvatarFactory", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarFactory;", "getWorldEntityAvatarFactory", "()Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarFactory;", "worldEntityInfoProtocol", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityProtocol;", "getWorldEntityInfoProtocol", "()Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityProtocol;", "getZoneCountBeforeLeakWarning$osrs_223_api", "computeUpdateZonePartialEnclosedCache", "Ljava/util/EnumMap;", "T", "Lnet/rsprot/protocol/message/ZoneProt;", "events", "initializeUpdateZonePartialEnclosedCacheClientMap", "isSupported", "clientType", "postUpdate", "", "releaseBuffers", "buffers", "forceRelease", "shutdown", "start", "safeShutdown", "Ljava/util/concurrent/ExecutorService;", "Companion", "osrs-223-api"})
@SourceDebugExtension(value={"SMAP\nNetworkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkService.kt\nnet/rsprot/protocol/api/NetworkService\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 6 ClientTypeMap.kt\nnet/rsprot/protocol/internal/client/ClientTypeMap$Companion\n+ 7 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,356:1\n18#2,4:357\n50#2,6:361\n56#2:377\n1549#3:367\n1620#3,3:368\n1549#3:371\n1620#3,3:372\n37#4,2:375\n80#5,4:378\n80#5,4:382\n80#5,4:386\n80#5,4:390\n80#5,4:394\n80#5,4:398\n104#5,4:410\n48#6,8:402\n11#7,2:414\n*S KotlinDebug\n*F\n+ 1 NetworkService.kt\nnet/rsprot/protocol/api/NetworkService\n*L\n157#1:357,4\n157#1:361,6\n157#1:377\n169#1:367\n169#1:368,3\n170#1:371\n170#1:372,3\n173#1:375,2\n191#1:378,4\n192#1:382,4\n193#1:386,4\n198#1:390,4\n202#1:394,4\n207#1:398,4\n262#1:410,4\n227#1:402,8\n353#1:414,2\n*E\n"})
public final class NetworkService<R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @Nullable
    private final String host;
    @NotNull
    private final List<Integer> ports;
    private final boolean betaWorld;
    @NotNull
    private final BootstrapFactory bootstrapFactory;
    @NotNull
    private final EntityInfoProtocols entityInfoProtocols;
    @NotNull
    private final List<OldSchoolClientType> clientTypes;
    @NotNull
    private final GameConnectionHandler<R> gameConnectionHandler;
    @NotNull
    private final ExceptionHandlers<R> exceptionHandlers;
    @NotNull
    private final INetAddressHandlers iNetAddressHandlers;
    @NotNull
    private final GameMessageHandlers gameMessageHandlers;
    @NotNull
    private final LoginHandlers loginHandlers;
    @NotNull
    private final NetworkConfiguration configuration;
    private final int zoneCountBeforeLeakWarning;
    private final int bufRetentionCountBeforeRelease;
    @NotNull
    private final HuffmanCodecProvider huffmanCodecProvider;
    @NotNull
    private final GameMessageConsumerRepositoryProvider<R> gameMessageConsumerRepositoryProvider;
    @Nullable
    private final OpcodeMapper clientToServerOpcodeMapper;
    @Nullable
    private final OpcodeMapper serverToClientOpcodeMapper;
    @NotNull
    private final MessageEncoderRepositories encoderRepositories;
    @NotNull
    private final Js5Authorizer js5Authorizer;
    @NotNull
    private final Js5Service js5Service;
    @NotNull
    private final Thread js5ServiceExecutor;
    @NotNull
    private final ClientTypeMap<UpdateZonePartialEnclosedCache> updateZonePartialEnclosedCacheClientTypeMap;
    @NotNull
    private final MessageDecoderRepositories decoderRepositories;
    private EventLoopGroup bossGroup;
    private EventLoopGroup childGroup;
    private ScheduledExecutorService js5PrefetchService;
    @NotNull
    private final ArrayDeque<LinkedList<ByteBuf>> updateZonePartialEnclosedBufferList;
    @NotNull
    private LinkedList<ByteBuf> currentUpdateOnePartialEnclosedBuffers;
    private int currentZoneCallCount;
    public static final long INITIAL_TIMEOUT_SECONDS = 30L;
    public static final long LOGIN_TIMEOUT_SECONDS = 40L;
    public static final long GAME_TIMEOUT_SECONDS = 15L;
    public static final long JS5_TIMEOUT_SECONDS = 30L;
    @NotNull
    private static final Logger logger;

    public NetworkService(@NotNull ByteBufAllocator allocator, @Nullable String host, @NotNull List<Integer> ports, boolean betaWorld, @NotNull BootstrapFactory bootstrapFactory, @NotNull EntityInfoProtocols entityInfoProtocols, @NotNull List<? extends OldSchoolClientType> clientTypes, @NotNull GameConnectionHandler<R> gameConnectionHandler, @NotNull ExceptionHandlers<R> exceptionHandlers, @NotNull INetAddressHandlers iNetAddressHandlers, @NotNull GameMessageHandlers gameMessageHandlers, @NotNull LoginHandlers loginHandlers, @NotNull NetworkConfiguration configuration, int zoneCountBeforeLeakWarning, int bufRetentionCountBeforeRelease, @NotNull HuffmanCodecProvider huffmanCodecProvider, @NotNull GameMessageConsumerRepositoryProvider<R> gameMessageConsumerRepositoryProvider, @Nullable OpcodeMapper clientToServerOpcodeMapper, @Nullable OpcodeMapper serverToClientOpcodeMapper, @NotNull RsaKeyPair rsaKeyPair, @NotNull Js5Configuration js5Configuration, @NotNull Js5GroupProvider js5GroupProvider) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter(ports, (String)"ports");
        Intrinsics.checkNotNullParameter((Object)bootstrapFactory, (String)"bootstrapFactory");
        Intrinsics.checkNotNullParameter((Object)entityInfoProtocols, (String)"entityInfoProtocols");
        Intrinsics.checkNotNullParameter(clientTypes, (String)"clientTypes");
        Intrinsics.checkNotNullParameter(gameConnectionHandler, (String)"gameConnectionHandler");
        Intrinsics.checkNotNullParameter(exceptionHandlers, (String)"exceptionHandlers");
        Intrinsics.checkNotNullParameter((Object)iNetAddressHandlers, (String)"iNetAddressHandlers");
        Intrinsics.checkNotNullParameter((Object)gameMessageHandlers, (String)"gameMessageHandlers");
        Intrinsics.checkNotNullParameter((Object)loginHandlers, (String)"loginHandlers");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)huffmanCodecProvider, (String)"huffmanCodecProvider");
        Intrinsics.checkNotNullParameter(gameMessageConsumerRepositoryProvider, (String)"gameMessageConsumerRepositoryProvider");
        Intrinsics.checkNotNullParameter((Object)rsaKeyPair, (String)"rsaKeyPair");
        Intrinsics.checkNotNullParameter((Object)js5Configuration, (String)"js5Configuration");
        Intrinsics.checkNotNullParameter((Object)js5GroupProvider, (String)"js5GroupProvider");
        this.allocator = allocator;
        this.host = host;
        this.ports = ports;
        this.betaWorld = betaWorld;
        this.bootstrapFactory = bootstrapFactory;
        this.entityInfoProtocols = entityInfoProtocols;
        this.clientTypes = clientTypes;
        this.gameConnectionHandler = gameConnectionHandler;
        this.exceptionHandlers = exceptionHandlers;
        this.iNetAddressHandlers = iNetAddressHandlers;
        this.gameMessageHandlers = gameMessageHandlers;
        this.loginHandlers = loginHandlers;
        this.configuration = configuration;
        this.zoneCountBeforeLeakWarning = zoneCountBeforeLeakWarning;
        this.bufRetentionCountBeforeRelease = bufRetentionCountBeforeRelease;
        this.huffmanCodecProvider = huffmanCodecProvider;
        this.gameMessageConsumerRepositoryProvider = gameMessageConsumerRepositoryProvider;
        this.clientToServerOpcodeMapper = clientToServerOpcodeMapper;
        this.serverToClientOpcodeMapper = serverToClientOpcodeMapper;
        this.encoderRepositories = new MessageEncoderRepositories(this.huffmanCodecProvider);
        this.js5Authorizer = this.betaWorld ? (Js5Authorizer)new ConcurrentJs5Authorizer() : (Js5Authorizer)NoopJs5Authorizer.INSTANCE;
        this.js5Service = new Js5Service(this, js5Configuration, js5GroupProvider, this.js5Authorizer);
        this.js5ServiceExecutor = new Thread(this.js5Service);
        this.updateZonePartialEnclosedCacheClientTypeMap = this.initializeUpdateZonePartialEnclosedCacheClientMap();
        this.decoderRepositories = MessageDecoderRepositories.Companion.initialize(this.clientTypes, rsaKeyPair, this.huffmanCodecProvider);
        this.updateZonePartialEnclosedBufferList = new ArrayDeque();
        this.currentUpdateOnePartialEnclosedBuffers = new LinkedList();
    }

    @NotNull
    public final ByteBufAllocator getAllocator$osrs_223_api() {
        return this.allocator;
    }

    @Nullable
    public final String getHost$osrs_223_api() {
        return this.host;
    }

    @NotNull
    public final List<Integer> getPorts$osrs_223_api() {
        return this.ports;
    }

    public final boolean getBetaWorld$osrs_223_api() {
        return this.betaWorld;
    }

    @NotNull
    public final BootstrapFactory getBootstrapFactory$osrs_223_api() {
        return this.bootstrapFactory;
    }

    @NotNull
    public final EntityInfoProtocols getEntityInfoProtocols$osrs_223_api() {
        return this.entityInfoProtocols;
    }

    @NotNull
    public final List<OldSchoolClientType> getClientTypes$osrs_223_api() {
        return this.clientTypes;
    }

    @NotNull
    public final GameConnectionHandler<R> getGameConnectionHandler$osrs_223_api() {
        return this.gameConnectionHandler;
    }

    @NotNull
    public final ExceptionHandlers<R> getExceptionHandlers$osrs_223_api() {
        return this.exceptionHandlers;
    }

    @NotNull
    public final INetAddressHandlers getINetAddressHandlers$osrs_223_api() {
        return this.iNetAddressHandlers;
    }

    @NotNull
    public final GameMessageHandlers getGameMessageHandlers$osrs_223_api() {
        return this.gameMessageHandlers;
    }

    @NotNull
    public final LoginHandlers getLoginHandlers$osrs_223_api() {
        return this.loginHandlers;
    }

    @NotNull
    public final NetworkConfiguration getConfiguration$osrs_223_api() {
        return this.configuration;
    }

    public final int getZoneCountBeforeLeakWarning$osrs_223_api() {
        return this.zoneCountBeforeLeakWarning;
    }

    public final int getBufRetentionCountBeforeRelease$osrs_223_api() {
        return this.bufRetentionCountBeforeRelease;
    }

    @NotNull
    public final HuffmanCodecProvider getHuffmanCodecProvider() {
        return this.huffmanCodecProvider;
    }

    @NotNull
    public final GameMessageConsumerRepositoryProvider<R> getGameMessageConsumerRepositoryProvider() {
        return this.gameMessageConsumerRepositoryProvider;
    }

    @Nullable
    public final OpcodeMapper getClientToServerOpcodeMapper() {
        return this.clientToServerOpcodeMapper;
    }

    @Nullable
    public final OpcodeMapper getServerToClientOpcodeMapper() {
        return this.serverToClientOpcodeMapper;
    }

    @NotNull
    public final MessageEncoderRepositories getEncoderRepositories$osrs_223_api() {
        return this.encoderRepositories;
    }

    @NotNull
    public final Js5Authorizer getJs5Authorizer() {
        return this.js5Authorizer;
    }

    @NotNull
    public final Js5Service getJs5Service() {
        return this.js5Service;
    }

    @NotNull
    public final MessageDecoderRepositories getDecoderRepositories$osrs_223_api() {
        return this.decoderRepositories;
    }

    @NotNull
    public final PlayerInfoProtocol getPlayerInfoProtocol() {
        return this.entityInfoProtocols.getPlayerInfoProtocol();
    }

    @NotNull
    public final NpcAvatarFactory getNpcAvatarFactory() {
        return this.entityInfoProtocols.getNpcAvatarFactory();
    }

    @NotNull
    public final NpcInfoProtocol getNpcInfoProtocol() {
        return this.entityInfoProtocols.getNpcInfoProtocol();
    }

    @NotNull
    public final WorldEntityAvatarFactory getWorldEntityAvatarFactory() {
        return this.entityInfoProtocols.getWorldEntityAvatarFactory();
    }

    @NotNull
    public final WorldEntityProtocol getWorldEntityInfoProtocol() {
        return this.entityInfoProtocols.getWorldEntityInfoProtocol();
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalUnsignedTypes
    @ExperimentalStdlibApi
    public final void start() {
        Logger logger;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        EventLoopGroup eventLoopGroup;
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.bossGroup = BootstrapFactory.createParentLoopGroup$default(this.bootstrapFactory, 0, 1, null);
        this.childGroup = BootstrapFactory.createChildLoopGroup$default(this.bootstrapFactory, 0, 1, null);
        EventLoopGroup eventLoopGroup2 = this.bossGroup;
        if (eventLoopGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bossGroup");
            eventLoopGroup2 = null;
        }
        if ((eventLoopGroup = this.childGroup) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"childGroup");
            eventLoopGroup = null;
        }
        ServerBootstrap initializer = this.bootstrapFactory.createServerBootstrap(eventLoopGroup2, eventLoopGroup).childHandler((ChannelHandler)new LoginChannelInitializer(this));
        String host = this.host;
        Iterable iterable = this.ports;
        boolean $i$f$map = false;
        void var13_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = host;
            collection.add(string != null ? initializer.bind(string, (int)it) : initializer.bind((int)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChannelFuture it = (ChannelFuture)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(FutureExtensionsKt.asCompletableFuture((Future)p0));
        }
        List futures = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] $i$f$map2 = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage future2 = CompletableFuture.allOf(Arrays.copyOf($i$f$map2, $i$f$map2.length)).handle((arg_0, arg_1) -> NetworkService.start$lambda$2$lambda$1((Function2)new Function2<Void, Throwable, Unit>(this){
            final /* synthetic */ NetworkService<R> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(Void void_, Throwable exception) {
                if (exception != null) {
                    EventLoopGroup eventLoopGroup = NetworkService.access$getBossGroup$p(this.this$0);
                    if (eventLoopGroup == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"bossGroup");
                        eventLoopGroup = null;
                    }
                    eventLoopGroup.shutdownGracefully();
                    EventLoopGroup eventLoopGroup2 = NetworkService.access$getChildGroup$p(this.this$0);
                    if (eventLoopGroup2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"childGroup");
                        eventLoopGroup2 = null;
                    }
                    eventLoopGroup2.shutdownGracefully();
                    throw exception;
                }
            }
        }, arg_0, arg_1));
        this.js5ServiceExecutor.start();
        this.js5PrefetchService = Js5Service.Companion.startPrefetching(this.js5Service);
        try {
            ((CompletableFuture)future2).join();
        }
        catch (Throwable t) {
            this.js5Service.triggerShutdown();
            throw t;
        }
        long time2 = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        Logger arg0$iv = NetworkService.logger;
        boolean bl4 = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl5 = false;
            logger.info(String.valueOf("Started in: " + Duration.toString-impl((long)time2)));
        }
        arg0$iv = NetworkService.logger;
        bl4 = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl6 = false;
            logger.info(String.valueOf("Bound to ports: " + CollectionsKt.joinToString$default((Iterable)this.ports, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
        }
        arg0$iv = NetworkService.logger;
        bl4 = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl7 = false;
            logger.info(String.valueOf("Revision: 223"));
        }
        String clientTypeNames2 = CollectionsKt.joinToString$default((Iterable)this.clientTypes, (CharSequence)", ", null, null, (int)0, null, (Function1)start.clientTypeNames.1.INSTANCE, (int)30, null);
        Logger arg0$iv2 = NetworkService.logger;
        $i$f$info-impl = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv2)) {
            logger = arg0$iv2;
            boolean bl8 = false;
            logger.info(String.valueOf("Supported client types: " + clientTypeNames2));
        }
    }

    public final void shutdown() {
        Logger logger;
        Logger arg0$iv = NetworkService.logger;
        boolean bl = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl2 = false;
            logger.info(String.valueOf("Attempting to shut down network service."));
        }
        this.js5Service.triggerShutdown();
        ScheduledExecutorService scheduledExecutorService = this.js5PrefetchService;
        if (scheduledExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"js5PrefetchService");
            scheduledExecutorService = null;
        }
        this.safeShutdown(scheduledExecutorService);
        EventLoopGroup eventLoopGroup = this.bossGroup;
        if (eventLoopGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bossGroup");
            eventLoopGroup = null;
        }
        eventLoopGroup.shutdownGracefully();
        EventLoopGroup eventLoopGroup2 = this.childGroup;
        if (eventLoopGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"childGroup");
            eventLoopGroup2 = null;
        }
        eventLoopGroup2.shutdownGracefully();
        arg0$iv = NetworkService.logger;
        bl = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl3 = false;
            logger.info(String.valueOf("Network service successfully shut down."));
        }
    }

    private final void safeShutdown(ExecutorService $this$safeShutdown) {
        $this$safeShutdown.shutdown();
        try {
            if (!$this$safeShutdown.awaitTermination(3L, TimeUnit.SECONDS)) {
                $this$safeShutdown.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            $this$safeShutdown.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private final ClientTypeMap<UpdateZonePartialEnclosedCache> initializeUpdateZonePartialEnclosedCacheClientMap() {
        List list = new ArrayList();
        if (this.clientTypes.contains(OldSchoolClientType.DESKTOP)) {
            ((Collection)list).add(TuplesKt.to((Object)OldSchoolClientType.DESKTOP, (Object)DesktopUpdateZonePartialEnclosedEncoder.Companion));
        }
        ClientTypeMap.Companion companion = ClientTypeMap.Companion;
        int clientCapacity$iv = 3;
        boolean $i$f$of = false;
        Object[] array$iv = new UpdateZonePartialEnclosedCache[clientCapacity$iv];
        for (Pair pair : list) {
            ClientType clientType$iv = (ClientType)pair.component1();
            Object element$iv = pair.component2();
            if (!(array$iv[clientType$iv.getId()] == null)) {
                boolean bl = false;
                String string = "A client is registered more than once: " + list;
                throw new IllegalStateException(string.toString());
            }
            array$iv[clientType$iv.getId()] = element$iv;
        }
        return new ClientTypeMap(array$iv);
    }

    @NotNull
    public final <T extends ZoneProt> EnumMap<OldSchoolClientType, ByteBuf> computeUpdateZonePartialEnclosedCache(@NotNull List<? extends T> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        EnumMap<OldSchoolClientType, ByteBuf> map = new EnumMap<OldSchoolClientType, ByteBuf>(OldSchoolClientType.class);
        for (OldSchoolClientType type : this.clientTypes) {
            ByteBuf buffer = ((UpdateZonePartialEnclosedCache)this.updateZonePartialEnclosedCacheClientTypeMap.get((ClientType)type)).buildCache(this.allocator, (Collection)events);
            ((Map)map).put(type, buffer);
            ((Collection)this.currentUpdateOnePartialEnclosedBuffers).add(buffer);
        }
        ++this.currentZoneCallCount;
        if (this.currentZoneCallCount >= this.zoneCountBeforeLeakWarning) {
            Logger arg0$iv = logger;
            boolean bl = false;
            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.warn(String.valueOf("Update zone partial enclosed buffers have not been correctly released!"));
            }
        }
        return map;
    }

    public final void postUpdate() {
        LinkedList<ByteBuf> curBuf;
        this.currentZoneCallCount = 0;
        ArrayDeque<LinkedList<ByteBuf>> bufferList = this.updateZonePartialEnclosedBufferList;
        if (bufferList.size() >= this.bufRetentionCountBeforeRelease) {
            LinkedList<ByteBuf> first = bufferList.removeFirst();
            Intrinsics.checkNotNull(first);
            this.releaseBuffers(first, true);
        }
        if ((curBuf = this.currentUpdateOnePartialEnclosedBuffers).size() > 0) {
            bufferList.addLast(curBuf);
            this.currentUpdateOnePartialEnclosedBuffers = new LinkedList();
        }
        for (LinkedList<ByteBuf> buffers : bufferList) {
            Intrinsics.checkNotNull(buffers);
            this.releaseBuffers(buffers, false);
        }
    }

    private final void releaseBuffers(LinkedList<ByteBuf> buffers, boolean forceRelease) {
        if (buffers.isEmpty()) {
            return;
        }
        Iterator iterator = buffers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            ByteBuf next = (ByteBuf)e;
            int refCount = next.refCnt();
            if (forceRelease) {
                if (refCount <= 0) continue;
                next.release(refCount);
                continue;
            }
            if (refCount > 1) continue;
            if (refCount == 1) {
                next.release();
            }
            iterator2.remove();
        }
    }

    public final boolean isSupported(@NotNull OldSchoolClientType clientType) {
        Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
        return this.clientTypes.contains(clientType);
    }

    private static final Unit start$lambda$2$lambda$1(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    public static final /* synthetic */ EventLoopGroup access$getBossGroup$p(NetworkService $this) {
        return $this.bossGroup;
    }

    public static final /* synthetic */ EventLoopGroup access$getChildGroup$p(NetworkService $this) {
        return $this.childGroup;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\tX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\n\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/api/NetworkService$Companion;", "", "()V", "GAME_TIMEOUT_SECONDS", "", "INITIAL_TIMEOUT_SECONDS", "JS5_TIMEOUT_SECONDS", "LOGIN_TIMEOUT_SECONDS", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-223-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

