/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import net.rsprot.protocol.ServerProtCategory;
import net.rsprot.protocol.api.GameMessageCounter;
import net.rsprot.protocol.api.IncomingGameMessageConsumerExceptionHandler;
import net.rsprot.protocol.api.MessageQueueProvider;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.game.GameMessageDecoder;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.game.outgoing.GameServerProtCategory;
import net.rsprot.protocol.game.outgoing.zone.payload.SoundArea;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.incoming.util.LoginClientType;
import net.rsprot.protocol.message.IncomingGameMessage;
import net.rsprot.protocol.message.OutgoingGameMessage;
import net.rsprot.protocol.message.codec.incoming.MessageConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 W*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002VWB\u008d\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012&\u0010\r\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u000e\u0012\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u0012\u0012\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0007J\b\u00102\u001a\u000200H\u0002J\u0006\u00103\u001a\u000200J\u0012\u00104\u001a\u0002002\b\b\u0002\u00105\u001a\u000206H\u0007J\u0006\u00107\u001a\u000200J\u0015\u00108\u001a\u0002002\u0006\u00101\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u000206H\u0002J\b\u0010;\u001a\u000200H\u0002J\r\u0010<\u001a\u000206H\u0000\u00a2\u0006\u0002\b=J\r\u0010>\u001a\u000200H\u0000\u00a2\u0006\u0002\b?J\b\u0010@\u001a\u000200H\u0002J\n\u0010A\u001a\u0004\u0018\u00010\u0007H\u0002J\u0013\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00028\u0000\u00a2\u0006\u0002\u0010EJ\u000e\u0010F\u001a\u0002002\u0006\u0010G\u001a\u00020\nJ\u0016\u0010F\u001a\u0002002\u0006\u0010G\u001a\u00020\n2\u0006\u0010H\u001a\u00020IJ\u0006\u0010J\u001a\u000206J\r\u0010K\u001a\u000200H\u0000\u00a2\u0006\u0002\bLJ\u000e\u0010M\u001a\u0002002\u0006\u0010N\u001a\u00020\u001eJ\u0010\u0010O\u001a\u0002002\u0006\u0010P\u001a\u000206H\u0002J\r\u0010P\u001a\u000200H\u0000\u00a2\u0006\u0002\bQJ\r\u0010R\u001a\u000200H\u0000\u00a2\u0006\u0002\bSJ\b\u0010T\u001a\u000200H\u0002J\b\u0010U\u001a\u000200H\u0002R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\r\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020$X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010%R\u0015\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010.\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006X"}, d2={"Lnet/rsprot/protocol/api/Session;", "R", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "incomingMessageQueue", "Ljava/util/Queue;", "Lnet/rsprot/protocol/message/IncomingGameMessage;", "outgoingMessageQueueProvider", "Lnet/rsprot/protocol/api/MessageQueueProvider;", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "counter", "Lnet/rsprot/protocol/api/GameMessageCounter;", "consumers", "", "Ljava/lang/Class;", "Lnet/rsprot/protocol/message/codec/incoming/MessageConsumer;", "globalConsumers", "", "loginBlock", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "incomingGameMessageConsumerExceptionHandler", "Lnet/rsprot/protocol/api/IncomingGameMessageConsumerExceptionHandler;", "(Lio/netty/channel/ChannelHandlerContext;Ljava/util/Queue;Lnet/rsprot/protocol/api/MessageQueueProvider;Lnet/rsprot/protocol/api/GameMessageCounter;Ljava/util/Map;Ljava/util/List;Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;Lnet/rsprot/protocol/api/IncomingGameMessageConsumerExceptionHandler;)V", "channelStatus", "Lnet/rsprot/protocol/api/Session$ChannelStatus;", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "disconnectionHook", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Runnable;", "inetAddress", "Ljava/net/InetAddress;", "getInetAddress", "()Ljava/net/InetAddress;", "lastFlush", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "J", "getLoginBlock", "()Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "loginTransitionStatus", "Ljava/util/concurrent/atomic/AtomicInteger;", "lowPriorityCategoryPacketsDiscarded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "outgoingMessageQueues", "", "[Ljava/util/Queue;", "addIncomingMessage", "", "incomingGameMessage", "checkIdle", "clear", "discardLowPriorityCategoryPackets", "discard", "", "flush", "incrementCounter", "incrementCounter$osrs_223_api", "internalRequestClose", "invokeDisconnectionHook", "isFull", "isFull$osrs_223_api", "onLoginTransitionComplete", "onLoginTransitionComplete$osrs_223_api", "onPollComplete", "pollIncomingMessage", "processIncomingPackets", "", "receiver", "(Ljava/lang/Object;)I", "queue", "message", "category", "Lnet/rsprot/protocol/ServerProtCategory;", "requestClose", "resumeReading", "resumeReading$osrs_223_api", "setDisconnectionHook", "hook", "setReadStatus", "stopReading", "stopReading$osrs_223_api", "triggerIdleClosing", "triggerIdleClosing$osrs_223_api", "updateLastFlush", "writeAndFlush", "ChannelStatus", "Companion", "osrs-223-api"})
@SourceDebugExtension(value={"SMAP\nSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Session.kt\nnet/rsprot/protocol/api/Session\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,515:1\n104#2,4:516\n32#2,4:527\n56#2,4:532\n80#2,4:537\n104#2,4:542\n128#2,4:547\n32#2,4:562\n56#2,4:567\n80#2,4:572\n104#2,4:577\n128#2,4:582\n32#2,4:595\n56#2,4:600\n80#2,4:605\n104#2,4:610\n128#2,4:615\n32#2,2:628\n35#2:631\n56#2,4:633\n80#2,4:638\n104#2,4:643\n128#2,4:648\n62#2,4:654\n62#2,4:658\n20#3:520\n44#3,6:521\n52#3:531\n55#3:536\n58#3:541\n61#3:546\n64#3:551\n21#3:552\n20#3:555\n44#3,6:556\n52#3:566\n55#3:571\n58#3:576\n61#3:581\n64#3:586\n21#3:587\n20#3:588\n44#3,6:589\n52#3:599\n55#3:604\n58#3:609\n61#3:614\n64#3:619\n21#3:620\n20#3:621\n44#3,6:622\n52#3:632\n55#3:637\n58#3:642\n61#3:647\n64#3:652\n21#3:653\n12271#4,2:553\n1#5:630\n11#6,2:662\n*S KotlinDebug\n*F\n+ 1 Session.kt\nnet/rsprot/protocol/api/Session\n*L\n107#1:516,4\n183#1:527,4\n183#1:532,4\n183#1:537,4\n183#1:542,4\n183#1:547,4\n391#1:562,4\n391#1:567,4\n391#1:572,4\n391#1:577,4\n391#1:582,4\n402#1:595,4\n402#1:600,4\n402#1:605,4\n402#1:610,4\n402#1:615,4\n407#1:628,2\n407#1:631\n407#1:633,4\n407#1:638,4\n407#1:643,4\n407#1:648,4\n428#1:654,4\n442#1:658,4\n183#1:520\n183#1:521,6\n183#1:531\n183#1:536\n183#1:541\n183#1:546\n183#1:551\n183#1:552\n391#1:555\n391#1:556,6\n391#1:566\n391#1:571\n391#1:576\n391#1:581\n391#1:586\n391#1:587\n402#1:588\n402#1:589,6\n402#1:599\n402#1:604\n402#1:609\n402#1:614\n402#1:619\n402#1:620\n407#1:621\n407#1:622,6\n407#1:632\n407#1:637\n407#1:642\n407#1:647\n407#1:652\n407#1:653\n315#1:553,2\n509#1:662,2\n*E\n"})
public final class Session<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelHandlerContext ctx;
    @NotNull
    private final Queue<IncomingGameMessage> incomingMessageQueue;
    @NotNull
    private final GameMessageCounter counter;
    @NotNull
    private final Map<Class<? extends IncomingGameMessage>, MessageConsumer<R, IncomingGameMessage>> consumers;
    @NotNull
    private final List<MessageConsumer<R, IncomingGameMessage>> globalConsumers;
    @NotNull
    private final LoginBlock<?> loginBlock;
    @NotNull
    private final IncomingGameMessageConsumerExceptionHandler<R> incomingGameMessageConsumerExceptionHandler;
    @NotNull
    private final Queue<OutgoingGameMessage>[] outgoingMessageQueues;
    @NotNull
    private final InetAddress inetAddress;
    @NotNull
    private AtomicReference<Runnable> disconnectionHook;
    @NotNull
    private volatile ChannelStatus channelStatus;
    private long lastFlush;
    @NotNull
    private AtomicBoolean lowPriorityCategoryPacketsDiscarded;
    @NotNull
    private AtomicInteger loginTransitionStatus;
    @NotNull
    private static final Logger logger;
    private static final long limboIdleDuration;
    private static final int LOGIN_TRANSITION_COMPLETE = 1;
    private static final int FLUSH_REQUESTED = 2;

    public Session(@NotNull ChannelHandlerContext ctx, @NotNull Queue<IncomingGameMessage> incomingMessageQueue, @NotNull MessageQueueProvider<OutgoingGameMessage> outgoingMessageQueueProvider, @NotNull GameMessageCounter counter, @NotNull Map<Class<? extends IncomingGameMessage>, ? extends MessageConsumer<? super R, ? super IncomingGameMessage>> consumers, @NotNull List<? extends MessageConsumer<? super R, ? super IncomingGameMessage>> globalConsumers, @NotNull LoginBlock<?> loginBlock, @NotNull IncomingGameMessageConsumerExceptionHandler<R> incomingGameMessageConsumerExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(incomingMessageQueue, (String)"incomingMessageQueue");
        Intrinsics.checkNotNullParameter(outgoingMessageQueueProvider, (String)"outgoingMessageQueueProvider");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter(consumers, (String)"consumers");
        Intrinsics.checkNotNullParameter(globalConsumers, (String)"globalConsumers");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        Intrinsics.checkNotNullParameter(incomingGameMessageConsumerExceptionHandler, (String)"incomingGameMessageConsumerExceptionHandler");
        this.ctx = ctx;
        this.incomingMessageQueue = incomingMessageQueue;
        this.counter = counter;
        this.consumers = consumers;
        this.globalConsumers = globalConsumers;
        this.loginBlock = loginBlock;
        this.incomingGameMessageConsumerExceptionHandler = incomingGameMessageConsumerExceptionHandler;
        int n = 0;
        Queue[] queueArray = new Queue[2];
        Session session = this;
        while (n < 2) {
            int n2 = n++;
            queueArray[n2] = outgoingMessageQueueProvider.provide();
        }
        session.outgoingMessageQueues = queueArray;
        this.inetAddress = ChannelExtensionsKt.inetAddress(this.ctx);
        this.disconnectionHook = new AtomicReference<Object>(null);
        this.channelStatus = ChannelStatus.OPEN;
        this.lastFlush = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        this.lowPriorityCategoryPacketsDiscarded = new AtomicBoolean();
        this.loginTransitionStatus = new AtomicInteger(0);
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public final LoginBlock<?> getLoginBlock() {
        return this.loginBlock;
    }

    @NotNull
    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @JvmOverloads
    public final void discardLowPriorityCategoryPackets(boolean discard) {
        this.lowPriorityCategoryPacketsDiscarded.set(discard);
    }

    public static /* synthetic */ void discardLowPriorityCategoryPackets$default(Session session, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        session.discardLowPriorityCategoryPackets(bl);
    }

    private final void updateLastFlush() {
        this.lastFlush = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
    }

    private final void checkIdle() {
        long elapsed = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)this.lastFlush);
        if (Duration.compareTo-LRDsOJo((long)elapsed, (long)limboIdleDuration) < 0) {
            return;
        }
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.warn(String.valueOf("Connection " + this.ctx.channel() + " has gone idle in limbo, requesting channel close for '" + this.loginBlock.getUsername() + "'."));
        }
        this.triggerIdleClosing$osrs_223_api();
    }

    public final void triggerIdleClosing$osrs_223_api() {
        if (this.internalRequestClose()) {
            this.invokeDisconnectionHook();
        }
    }

    public final void queue(@NotNull OutgoingGameMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.queue(message, message.getCategory());
    }

    public final void queue(@NotNull OutgoingGameMessage message, @NotNull ServerProtCategory category) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (this.channelStatus != ChannelStatus.OPEN) {
            message.safeRelease();
            return;
        }
        message.markConsumed();
        if (RSProtFlags.getFilterMissingPacketsInClient() && this.loginBlock.getClientType() == LoginClientType.DESKTOP && message instanceof SoundArea) {
            throw new IllegalArgumentException("SoundArea packet may only be sent as part of partial enclosed as of revision 221 on Java clients. Packet: " + message);
        }
        int categoryId = category.getId();
        Queue<OutgoingGameMessage> queue = this.outgoingMessageQueues[categoryId];
        ((Collection)queue).add(message);
        this.checkIdle();
    }

    public final int processIncomingPackets(R receiver) {
        if (this.channelStatus != ChannelStatus.OPEN) {
            return 0;
        }
        int count = 0;
        while (this.pollIncomingMessage() != null) {
            IncomingGameMessage packet;
            MessageConsumer<R, IncomingGameMessage> consumer = this.consumers.get(packet.getClass());
            if (consumer == null) {
                boolean $i$a$-checkNotNull-Session$processIncomingPackets$22 = false;
                String $i$a$-checkNotNull-Session$processIncomingPackets$22 = "Consumer for packet " + packet + " does not exist.";
                throw new IllegalStateException($i$a$-checkNotNull-Session$processIncomingPackets$22.toString());
            }
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3;
                    Logger logger;
                    boolean bl4 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.trace(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
                case 3: {
                    boolean bl3;
                    Logger logger;
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.debug(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
                case 4: {
                    boolean bl3;
                    Logger logger;
                    boolean bl6 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.info(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
                case 5: {
                    boolean bl3;
                    Logger logger;
                    boolean bl7 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.warn(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
                case 6: {
                    boolean bl3;
                    Logger logger;
                    boolean bl8 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.error(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
            }
            try {
                consumer.consume(receiver, packet);
            }
            catch (Throwable cause) {
                this.incomingGameMessageConsumerExceptionHandler.exceptionCaught(this, packet, cause);
            }
            if (!((Collection)this.globalConsumers).isEmpty()) {
                for (MessageConsumer<R, IncomingGameMessage> globalConsumer : this.globalConsumers) {
                    try {
                        globalConsumer.consume(receiver, packet);
                    }
                    catch (Throwable cause) {
                        this.incomingGameMessageConsumerExceptionHandler.exceptionCaught(this, packet, cause);
                    }
                }
            }
            ++count;
        }
        this.onPollComplete();
        return count;
    }

    public final void setDisconnectionHook(@NotNull Runnable hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        AtomicReference<Runnable> currentHook = this.disconnectionHook;
        boolean assigned = currentHook.compareAndSet(null, hook);
        if (!assigned) {
            throw new IllegalStateException("A disconnection hook has already been registered!");
        }
        if (!this.ctx.channel().isActive() && this.internalRequestClose()) {
            this.invokeDisconnectionHook();
        }
    }

    public final boolean requestClose() {
        if (this.channelStatus != ChannelStatus.OPEN) {
            return false;
        }
        this.disconnectionHook.set(null);
        this.channelStatus = ChannelStatus.CLOSING;
        this.stopReading$osrs_223_api();
        this.flush();
        return true;
    }

    private final boolean internalRequestClose() {
        if (this.channelStatus != ChannelStatus.OPEN) {
            return false;
        }
        this.channelStatus = ChannelStatus.CLOSING;
        this.stopReading$osrs_223_api();
        this.flush();
        return true;
    }

    private final IncomingGameMessage pollIncomingMessage() {
        return this.incomingMessageQueue.poll();
    }

    private final void onPollComplete() {
        this.counter.reset();
        this.resumeReading$osrs_223_api();
    }

    public final void onLoginTransitionComplete$osrs_223_api() {
        int flag = this.loginTransitionStatus.getAndUpdate(Session::onLoginTransitionComplete$lambda$3);
        if ((flag & 2) != 0) {
            this.flush();
        }
    }

    public final void flush() {
        int latest;
        boolean bl;
        block7: {
            if (this.channelStatus == ChannelStatus.CLOSED) {
                return;
            }
            if (!this.ctx.channel().isActive()) {
                this.triggerIdleClosing$osrs_223_api();
                return;
            }
            Queue<OutgoingGameMessage>[] $this$all$iv = this.outgoingMessageQueues;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                Queue<OutgoingGameMessage> element$iv;
                Queue<OutgoingGameMessage> p0 = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (p0.isEmpty()) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (bl) {
            return;
        }
        this.updateLastFlush();
        if ((this.loginTransitionStatus.get() & 1) == 0 && ((latest = this.loginTransitionStatus.getAndUpdate(Session::flush$lambda$4)) & 1) == 0) {
            return;
        }
        EventLoop eventLoop = this.ctx.channel().eventLoop();
        if (eventLoop.inEventLoop()) {
            this.writeAndFlush();
        } else {
            eventLoop.execute(() -> Session.flush$lambda$5(this));
        }
    }

    public final void clear() {
        for (Queue<OutgoingGameMessage> queue : this.outgoingMessageQueues) {
            while (queue.poll() != null) {
                OutgoingGameMessage next;
                next.safeRelease();
            }
        }
        Queue<IncomingGameMessage> incomingQueue = this.incomingMessageQueue;
        while (incomingQueue.poll() != null) {
            IncomingGameMessage next;
            next.safeRelease();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeAndFlush() {
        LogLevel level$iv$iv;
        Logger logger$iv;
        Logger logger;
        block49: {
            Channel channel = this.ctx.channel();
            block24: for (GameServerProtCategory category : EntriesMappings.entries$0) {
                OutgoingGameMessage next;
                Queue<OutgoingGameMessage> queue = this.outgoingMessageQueues[category.getId()];
                if (category == GameServerProtCategory.LOW_PRIORITY_PROT && this.lowPriorityCategoryPacketsDiscarded.get()) {
                    while (queue.poll() != null) {
                        next.safeRelease();
                    }
                    continue;
                }
                while (channel.isWritable()) {
                    if (queue.poll() == null) continue block24;
                    Logger logger$iv2 = Session.logger;
                    boolean bl = false;
                    LogLevel level$iv$iv2 = RSProtFlags.getNetworkLogging();
                    boolean bl2 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv2.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl3;
                            boolean bl4 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl3 = false;
                                logger.trace(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl3;
                            boolean bl5 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl3 = false;
                                logger.debug(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl3;
                            boolean bl6 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl3 = false;
                                logger.info(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl3;
                            boolean bl7 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl3 = false;
                                logger.warn(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl3;
                            boolean bl8 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl3 = false;
                                logger.error(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                    }
                    channel.write((Object)next, channel.voidPromise());
                }
                break;
            }
            channel.flush();
            if (this.channelStatus != ChannelStatus.CLOSING) break block49;
            this.channelStatus = ChannelStatus.CLOSED;
            channel.close();
            this.clear();
            logger$iv = Session.logger;
            boolean bl = false;
            level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl9 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl10;
                    boolean bl11 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl10 = false;
                        logger.trace(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
                case 3: {
                    boolean bl10;
                    boolean bl12 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl10 = false;
                        logger.debug(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
                case 4: {
                    boolean bl10;
                    boolean bl13 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl10 = false;
                        logger.info(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
                case 5: {
                    boolean bl10;
                    boolean bl14 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl10 = false;
                        logger.warn(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
                case 6: {
                    boolean bl10;
                    boolean bl15 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl10 = false;
                        logger.error(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
            }
            return;
        }
        logger$iv = Session.logger;
        boolean bl = false;
        level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl16 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                int n;
                int n2;
                int n3;
                Queue<OutgoingGameMessage>[] queueArray;
                boolean bl17;
                boolean bl18 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    bl17 = false;
                    queueArray = this.outgoingMessageQueues;
                    n3 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        void p0;
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> queue2 = queue = queueArray[n];
                        int n4 = n3;
                        boolean bl19 = false;
                        int n5 = p0.size();
                        n3 = n4 + n5;
                    }
                    int leftoverPackets = n3;
                    logger.trace(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
            case 3: {
                int n;
                int n2;
                int n3;
                Queue<OutgoingGameMessage>[] queueArray;
                boolean bl17;
                boolean bl20 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    bl17 = false;
                    queueArray = this.outgoingMessageQueues;
                    n3 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> p0 = queue = queueArray[n];
                        int n6 = n3;
                        boolean bl21 = false;
                        int n7 = p0.size();
                        n3 = n6 + n7;
                    }
                    int leftoverPackets = n3;
                    logger.debug(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
            case 4: {
                int n;
                int n2;
                int n3;
                Queue<OutgoingGameMessage>[] queueArray;
                boolean bl17;
                boolean bl22 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    bl17 = false;
                    queueArray = this.outgoingMessageQueues;
                    n3 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> p0 = queue = queueArray[n];
                        int n8 = n3;
                        boolean bl23 = false;
                        int n9 = p0.size();
                        n3 = n8 + n9;
                    }
                    int leftoverPackets = n3;
                    logger.info(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
            case 5: {
                int n;
                int n2;
                int n3;
                Queue<OutgoingGameMessage>[] queueArray;
                boolean bl17;
                boolean bl24 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    bl17 = false;
                    queueArray = this.outgoingMessageQueues;
                    n3 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> p0 = queue = queueArray[n];
                        int n10 = n3;
                        boolean bl25 = false;
                        int n11 = p0.size();
                        n3 = n10 + n11;
                    }
                    int leftoverPackets = n3;
                    logger.warn(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
            case 6: {
                int n;
                int n2;
                int n3;
                Queue<OutgoingGameMessage>[] queueArray;
                boolean bl17;
                boolean bl26 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    bl17 = false;
                    queueArray = this.outgoingMessageQueues;
                    n3 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> p0 = queue = queueArray[n];
                        int n12 = n3;
                        boolean bl27 = false;
                        int n13 = p0.size();
                        n3 = n12 + n13;
                    }
                    int leftoverPackets = n3;
                    logger.error(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
        }
    }

    public final void resumeReading$osrs_223_api() {
        block3: {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            try {
                this.setReadStatus(false);
            }
            catch (Exception e) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (!InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) break block3;
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.debug(String.valueOf("Unable to continue reading from the channel - channel already closed."), (Throwable)e);
            }
        }
    }

    public final void stopReading$osrs_223_api() {
        block3: {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            try {
                this.setReadStatus(true);
            }
            catch (Exception e) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (!InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) break block3;
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.debug(String.valueOf("Unable to stop reading from the channel - channel already closed."), (Throwable)e);
            }
        }
    }

    private final void setReadStatus(boolean stopReading) {
        Channel channel = this.ctx.channel();
        GameMessageDecoder gameMessageDecoder = (GameMessageDecoder)channel.pipeline().get(GameMessageDecoder.class);
        if (gameMessageDecoder == null) {
            return;
        }
        GameMessageDecoder decoder = gameMessageDecoder;
        decoder.setSingleDecode(stopReading);
        channel.config().setAutoRead(!stopReading);
    }

    public final void addIncomingMessage(@NotNull IncomingGameMessage incomingGameMessage) {
        Intrinsics.checkNotNullParameter((Object)incomingGameMessage, (String)"incomingGameMessage");
        if (this.channelStatus != ChannelStatus.OPEN) {
            return;
        }
        ((Collection)this.incomingMessageQueue).add(incomingGameMessage);
    }

    public final void incrementCounter$osrs_223_api(@NotNull IncomingGameMessage incomingGameMessage) {
        Intrinsics.checkNotNullParameter((Object)incomingGameMessage, (String)"incomingGameMessage");
        if (this.channelStatus != ChannelStatus.OPEN) {
            return;
        }
        this.counter.increment(incomingGameMessage.getCategory());
    }

    public final boolean isFull$osrs_223_api() {
        return this.counter.isFull();
    }

    private final void invokeDisconnectionHook() {
        block0: {
            Runnable runnable = this.disconnectionHook.getAndSet(null);
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    @JvmOverloads
    public final void discardLowPriorityCategoryPackets() {
        Session.discardLowPriorityCategoryPackets$default(this, false, 1, null);
    }

    private static final int onLoginTransitionComplete$lambda$3(int old) {
        return old | 1;
    }

    private static final int flush$lambda$4(int old) {
        return old | 2;
    }

    private static final void flush$lambda$5(Session this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writeAndFlush();
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
        limboIdleDuration = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/Session$ChannelStatus;", "", "(Ljava/lang/String;I)V", "OPEN", "CLOSING", "CLOSED", "osrs-223-api"})
    private static final class ChannelStatus
    extends Enum<ChannelStatus> {
        public static final /* enum */ ChannelStatus OPEN = new ChannelStatus();
        public static final /* enum */ ChannelStatus CLOSING = new ChannelStatus();
        public static final /* enum */ ChannelStatus CLOSED = new ChannelStatus();
        private static final /* synthetic */ ChannelStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChannelStatus[] values() {
            return (ChannelStatus[])$VALUES.clone();
        }

        public static ChannelStatus valueOf(String value) {
            return Enum.valueOf(ChannelStatus.class, value);
        }

        @NotNull
        public static EnumEntries<ChannelStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = channelStatusArray = new ChannelStatus[]{ChannelStatus.OPEN, ChannelStatus.CLOSING, ChannelStatus.CLOSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\u00020\nX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\f"}, d2={"Lnet/rsprot/protocol/api/Session$Companion;", "", "()V", "FLUSH_REQUESTED", "", "LOGIN_TRANSITION_COMPLETE", "limboIdleDuration", "Lkotlin/time/Duration;", "J", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-223-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<GameServerProtCategory> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])GameServerProtCategory.values()));
        }
    }
}

