/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.text.NumberFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.crypto.xtea.XteaKey;
import net.rsprot.protocol.api.ChannelExceptionHandler;
import net.rsprot.protocol.api.GameConnectionHandler;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.GameLoginResponseHandler;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.common.LogLevel;
import net.rsprot.protocol.common.RSProtFlags;
import net.rsprot.protocol.common.loginprot.incoming.codec.shared.exceptions.InvalidVersionException;
import net.rsprot.protocol.loginprot.incoming.GameLogin;
import net.rsprot.protocol.loginprot.incoming.GameReconnect;
import net.rsprot.protocol.loginprot.incoming.ProofOfWorkReply;
import net.rsprot.protocol.loginprot.incoming.RemainingBetaArchives;
import net.rsprot.protocol.loginprot.incoming.pow.ProofOfWork;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.ChallengeMetaData;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.ChallengeType;
import net.rsprot.protocol.loginprot.incoming.util.AuthenticationType;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlockDecodingFunction;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.IncomingLoginMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002>?B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0002J0\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0002JB\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H$0#0\"\"\u0004\b\u0001\u0010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H$0*H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,J\u001a\u0010-\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u00102\u001a\u00020\u000fH\u0002J\u0010\u00103\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u00104\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00105\u001a\u000206H\u0016JD\u00107\u001a\b\u0012\u0004\u0012\u00020(0\"\"\u000e\b\u0001\u00108*\b\u0012\u0004\u0012\u0002H:09\"\b\b\u0002\u0010:*\u00020;2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u0002H:0\r2\u0006\u0010=\u001a\u00020\u0007H\u0002R\u000e\u0010\t\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006@"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler;", "R", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingLoginMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "sessionId", "", "(Lnet/rsprot/protocol/api/NetworkService;J)V", "loginPacket", "loginState", "Lnet/rsprot/protocol/api/login/LoginConnectionHandler$LoginState;", "proofOfWork", "Lnet/rsprot/protocol/loginprot/incoming/pow/ProofOfWork;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelReadComplete", "channelUnregistered", "continueLogin", "decodeGameLoginBuffer", "packet", "Lnet/rsprot/protocol/loginprot/incoming/GameLogin;", "remainingBetaArchives", "Lnet/rsprot/protocol/loginprot/incoming/RemainingBetaArchives;", "responseHandler", "Lnet/rsprot/protocol/api/login/GameLoginResponseHandler;", "decodeGameReconnectBuffer", "Lnet/rsprot/protocol/loginprot/incoming/GameReconnect;", "decodeLogin", "Ljava/util/concurrent/CompletableFuture;", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "Fun", "buf", "Lnet/rsprot/buffer/JagByteBuf;", "betaWorld", "", "function", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlockDecodingFunction;", "decodeLogin-6j-XqWU", "(Lio/netty/buffer/ByteBuf;ZLnet/rsprot/protocol/loginprot/incoming/util/LoginBlockDecodingFunction;)Ljava/util/concurrent/CompletableFuture;", "decodeLoginPacket", "exceptionCaught", "cause", "", "handlerAdded", "releaseLoginBlock", "requestProofOfWork", "userEventTriggered", "evt", "", "verifyProofOfWork", "T", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/ChallengeType;", "MetaData", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/ChallengeMetaData;", "pow", "result", "Companion", "LoginState", "osrs-223-api"})
@SourceDebugExtension(value={"SMAP\nLoginConnectionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginConnectionHandler.kt\nnet/rsprot/protocol/api/login/LoginConnectionHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,406:1\n20#2:407\n44#2,6:408\n52#2:418\n55#2:423\n58#2:428\n61#2:433\n64#2:438\n21#2:439\n20#2:440\n44#2,6:441\n52#2:451\n55#2:456\n58#2:461\n61#2:466\n64#2:471\n21#2:472\n20#2:473\n44#2,6:474\n52#2:484\n55#2:489\n58#2:494\n61#2:499\n64#2:504\n21#2:505\n20#2:506\n44#2,6:507\n52#2:517\n55#2:522\n58#2:527\n61#2:532\n64#2:537\n21#2:538\n20#2:539\n44#2,6:540\n52#2:550\n55#2:555\n58#2:560\n61#2:565\n64#2:570\n21#2:571\n20#2:572\n44#2,6:573\n52#2:583\n55#2:588\n58#2:593\n61#2:598\n64#2:603\n21#2:604\n32#3,4:414\n56#3,4:419\n80#3,4:424\n104#3,4:429\n128#3,4:434\n32#3,4:447\n56#3,4:452\n80#3,4:457\n104#3,4:462\n128#3,4:467\n32#3,4:480\n56#3,4:485\n80#3,4:490\n104#3,4:495\n128#3,4:500\n32#3,4:513\n56#3,4:518\n80#3,4:523\n104#3,4:528\n128#3,4:533\n32#3,4:546\n56#3,4:551\n80#3,4:556\n104#3,4:561\n128#3,4:566\n32#3,4:579\n56#3,4:584\n80#3,4:589\n104#3,4:594\n128#3,4:599\n11#4,2:605\n*S KotlinDebug\n*F\n+ 1 LoginConnectionHandler.kt\nnet/rsprot/protocol/api/login/LoginConnectionHandler\n*L\n51#1:407\n51#1:408,6\n51#1:418\n51#1:423\n51#1:428\n51#1:433\n51#1:438\n51#1:439\n62#1:440\n62#1:441,6\n62#1:451\n62#1:456\n62#1:461\n62#1:466\n62#1:471\n62#1:472\n101#1:473\n101#1:474,6\n101#1:484\n101#1:489\n101#1:494\n101#1:499\n101#1:504\n101#1:505\n230#1:506\n230#1:507,6\n230#1:517\n230#1:522\n230#1:527\n230#1:532\n230#1:537\n230#1:538\n173#1:539\n173#1:540,6\n173#1:550\n173#1:555\n173#1:560\n173#1:565\n173#1:570\n173#1:571\n195#1:572\n195#1:573,6\n195#1:583\n195#1:588\n195#1:593\n195#1:598\n195#1:603\n195#1:604\n51#1:414,4\n51#1:419,4\n51#1:424,4\n51#1:429,4\n51#1:434,4\n62#1:447,4\n62#1:452,4\n62#1:457,4\n62#1:462,4\n62#1:467,4\n101#1:480,4\n101#1:485,4\n101#1:490,4\n101#1:495,4\n101#1:500,4\n230#1:513,4\n230#1:518,4\n230#1:523,4\n230#1:528,4\n230#1:533,4\n173#1:546,4\n173#1:551,4\n173#1:556,4\n173#1:561,4\n173#1:566,4\n195#1:579,4\n195#1:584,4\n195#1:589,4\n195#1:594,4\n195#1:599,4\n403#1:605,2\n*E\n"})
public final class LoginConnectionHandler<R>
extends SimpleChannelInboundHandler<IncomingLoginMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    private final long sessionId;
    @NotNull
    private LoginState loginState;
    private IncomingLoginMessage loginPacket;
    private ProofOfWork<?, ?> proofOfWork;
    @NotNull
    private static final Logger logger;

    public LoginConnectionHandler(@NotNull NetworkService<R> networkService, long sessionId) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingLoginMessage.class);
        this.networkService = networkService;
        this.sessionId = sessionId;
        this.loginState = LoginState.UNINITIALIZED;
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_223_api().getGameInetAddressTracker().register(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
        }
        ctx.fireChannelActive();
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_223_api().getGameInetAddressTracker().deregister(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
                break;
            }
        }
        ctx.fireChannelInactive();
    }

    public void channelUnregistered(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.loginState == LoginState.REQUESTED_PROOF_OF_WORK) {
            this.releaseLoginBlock();
        }
    }

    private final void releaseLoginBlock() {
        ByteBuf jagBuffer;
        ByteBuf byteBuf;
        IncomingLoginMessage packet;
        if (this.loginPacket == null) {
            return;
        }
        IncomingLoginMessage incomingLoginMessage = this.loginPacket;
        if (incomingLoginMessage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loginPacket");
            incomingLoginMessage = null;
        }
        if ((packet = incomingLoginMessage) instanceof GameLogin) {
            byteBuf = ((GameLogin)packet).getBuffer-07mC048();
        } else if (packet instanceof GameReconnect) {
            byteBuf = ((GameReconnect)packet).getBuffer-07mC048();
        } else {
            return;
        }
        ByteBuf buffer = jagBuffer = byteBuf;
        int refCnt = buffer.refCnt();
        if (refCnt > 0) {
            buffer.release(refCnt);
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingLoginMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
        }
        IncomingLoginMessage incomingLoginMessage = msg;
        if (incomingLoginMessage instanceof RemainingBetaArchives) {
            if (this.loginState != LoginState.AWAITING_BETA_RESPONSE) {
                ctx.close();
                return;
            }
            this.decodeLoginPacket(ctx, (RemainingBetaArchives)msg);
        } else if (incomingLoginMessage instanceof GameLogin) {
            if (this.loginState != LoginState.UNINITIALIZED) {
                ctx.close();
                return;
            }
            this.loginPacket = msg;
            this.requestProofOfWork(ctx);
        } else if (incomingLoginMessage instanceof GameReconnect) {
            this.loginPacket = msg;
            this.continueLogin(ctx);
        } else if (incomingLoginMessage instanceof ProofOfWorkReply) {
            if (this.loginState != LoginState.REQUESTED_PROOF_OF_WORK) {
                ctx.close();
                return;
            }
            ProofOfWork<?, ?> proofOfWork = this.proofOfWork;
            if (proofOfWork == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"proofOfWork");
                proofOfWork = null;
            }
            ProofOfWork<?, ?> pow = proofOfWork;
            this.verifyProofOfWork(pow, ((ProofOfWorkReply)msg).getResult()).handle((arg_0, arg_1) -> LoginConnectionHandler.channelRead0$lambda$3((Function2)new Function2<Boolean, Throwable, Unit>(ctx, this, msg, pow){
                final /* synthetic */ ChannelHandlerContext $ctx;
                final /* synthetic */ LoginConnectionHandler<R> this$0;
                final /* synthetic */ IncomingLoginMessage $msg;
                final /* synthetic */ ProofOfWork<?, ?> $pow;
                {
                    this.$ctx = $ctx;
                    this.this$0 = $receiver;
                    this.$msg = $msg;
                    this.$pow = $pow;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(Boolean success, Throwable exception) {
                    Logger logger;
                    Logger arg0$iv;
                    ChannelHandlerContext channelHandlerContext;
                    Logger logger$iv2;
                    block28: {
                        if (Intrinsics.areEqual((Object)success, (Object)true)) break block28;
                        Logger logger2 = LoginConnectionHandler.access$getLogger$cp();
                        ChannelHandlerContext channelHandlerContext2 = this.$ctx;
                        IncomingLoginMessage incomingLoginMessage = this.$msg;
                        ProofOfWork<?, ?> proofOfWork = this.$pow;
                        boolean bl = false;
                        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                        boolean bl2 = false;
                        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                void logger$iv2;
                                boolean bl3 = false;
                                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv2)) {
                                    void var12_32 = logger$iv2;
                                    boolean bl4 = false;
                                    var12_32.trace(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                }
                                break;
                            }
                            case 3: {
                                void logger$iv2;
                                boolean bl5 = false;
                                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                                    void var12_33 = logger$iv2;
                                    boolean bl6 = false;
                                    var12_33.debug(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                }
                                break;
                            }
                            case 4: {
                                void logger$iv2;
                                boolean bl7 = false;
                                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv2)) {
                                    void var12_34 = logger$iv2;
                                    boolean bl8 = false;
                                    var12_34.info(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                }
                                break;
                            }
                            case 5: {
                                void logger$iv2;
                                boolean bl9 = false;
                                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv2)) {
                                    void var12_35 = logger$iv2;
                                    boolean bl10 = false;
                                    var12_35.warn(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                }
                                break;
                            }
                            case 6: {
                                void logger$iv2;
                                boolean bl11 = false;
                                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv2)) {
                                    void var12_36 = logger$iv2;
                                    boolean bl12 = false;
                                    var12_36.error(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                }
                                break;
                            }
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail1.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    if (exception != null) {
                        logger$iv2 = LoginConnectionHandler.access$getLogger$cp();
                        channelHandlerContext = this.$ctx;
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            logger = arg0$iv;
                            boolean bl13 = false;
                            logger.error(String.valueOf("Exception during proof of work verification from channel '" + channelHandlerContext.channel() + "': " + exception), exception);
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail1.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                    arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    channelHandlerContext = this.$ctx;
                    IncomingLoginMessage incomingLoginMessage = this.$msg;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl14 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl15 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                boolean bl16 = false;
                                logger.trace(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult()));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl17 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                boolean bl18 = false;
                                logger.debug(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult()));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl19 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                boolean bl20 = false;
                                logger.info(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult()));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl21 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                boolean bl22 = false;
                                logger.warn(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult()));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl23 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                boolean bl24 = false;
                                logger.error(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult()));
                            }
                            break;
                        }
                    }
                    LoginConnectionHandler.access$continueLogin(this.this$0, this.$ctx);
                }
            }, arg_0, arg_1));
        } else {
            throw new IllegalStateException("Unknown login connection handler");
        }
    }

    private final void requestProofOfWork(ChannelHandlerContext ctx) {
        ProofOfWork proofOfWork = this.networkService.getLoginHandlers$osrs_223_api().getProofOfWorkProvider().provide(ChannelExtensionsKt.inetAddress(ctx));
        if (proofOfWork == null) {
            this.continueLogin(ctx);
            return;
        }
        ProofOfWork pow = proofOfWork;
        this.loginState = LoginState.REQUESTED_PROOF_OF_WORK;
        this.proofOfWork = pow;
        ctx.writeAndFlush((Object)new LoginResponse.ProofOfWork(pow)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginConnectionHandler.requestProofOfWork$lambda$5(ctx, arg_0)));
    }

    private final void continueLogin(ChannelHandlerContext ctx) {
        if (this.networkService.getBetaWorld$osrs_223_api()) {
            this.loginState = LoginState.AWAITING_BETA_RESPONSE;
            ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(2)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginConnectionHandler.continueLogin$lambda$7(ctx, arg_0)));
        } else {
            this.decodeLoginPacket(ctx, null);
        }
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_223_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.close();
        }
    }

    private final void decodeLoginPacket(ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives) {
        IncomingLoginMessage packet;
        GameLoginResponseHandler<R> responseHandler = new GameLoginResponseHandler<R>(this.networkService, ctx);
        IncomingLoginMessage incomingLoginMessage = this.loginPacket;
        if (incomingLoginMessage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loginPacket");
            incomingLoginMessage = null;
        }
        if ((packet = incomingLoginMessage) instanceof GameLogin) {
            this.decodeGameLoginBuffer((GameLogin)packet, ctx, remainingBetaArchives, responseHandler);
        } else if (packet instanceof GameReconnect) {
            this.decodeGameReconnectBuffer((GameReconnect)packet, ctx, remainingBetaArchives, responseHandler);
        } else {
            throw new IllegalStateException("Unknown login packet: " + packet);
        }
    }

    private final void decodeGameLoginBuffer(GameLogin packet, ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives, GameLoginResponseHandler<R> responseHandler) {
        this.decodeLogin-6j-XqWU(packet.getBuffer-07mC048(), this.networkService.getBetaWorld$osrs_223_api(), packet.getDecoder()).handle((arg_0, arg_1) -> LoginConnectionHandler.decodeGameLoginBuffer$lambda$9((Function2)new Function2<LoginBlock<AuthenticationType<?>>, Throwable, Unit>(ctx, this, remainingBetaArchives, responseHandler){
            final /* synthetic */ ChannelHandlerContext $ctx;
            final /* synthetic */ LoginConnectionHandler<R> this$0;
            final /* synthetic */ RemainingBetaArchives $remainingBetaArchives;
            final /* synthetic */ GameLoginResponseHandler<R> $responseHandler;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                this.$remainingBetaArchives = $remainingBetaArchives;
                this.$responseHandler = $responseHandler;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(LoginBlock<AuthenticationType<?>> block, Throwable exception) {
                block31: {
                    if (block == null || exception != null) {
                        if (exception instanceof CompletionException && Intrinsics.areEqual((Object)exception.getCause(), (Object)InvalidVersionException.INSTANCE)) {
                            this.$ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        ChannelExceptionHandler channelExceptionHandler = LoginConnectionHandler.access$getNetworkService$p(this.this$0).getExceptionHandlers$osrs_223_api().getChannelExceptionHandler();
                        Intrinsics.checkNotNull((Object)exception);
                        channelExceptionHandler.exceptionCaught(this.$ctx, exception);
                        return;
                    }
                    if (LoginConnectionHandler.access$getSessionId$p(this.this$0) == block.getSessionId()) break block31;
                    Logger logger = LoginConnectionHandler.access$getLogger$cp();
                    ChannelHandlerContext channelHandlerContext = this.$ctx;
                    LoginConnectionHandler<R> loginConnectionHandler = this.this$0;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl2 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            void logger$iv;
                            boolean bl3 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                void var11_29 = logger$iv;
                                boolean bl4 = false;
                                var11_29.trace(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                            }
                            break;
                        }
                        case 3: {
                            void logger$iv;
                            boolean bl5 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                void var11_30 = logger$iv;
                                boolean bl6 = false;
                                var11_30.debug(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                            }
                            break;
                        }
                        case 4: {
                            void logger$iv;
                            boolean bl7 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                void var11_31 = logger$iv;
                                boolean bl8 = false;
                                var11_31.info(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                            }
                            break;
                        }
                        case 5: {
                            void logger$iv;
                            boolean bl9 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                void var11_32 = logger$iv;
                                boolean bl10 = false;
                                var11_32.warn(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                            }
                            break;
                        }
                        case 6: {
                            void logger$iv;
                            boolean bl11 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                void var11_33 = logger$iv;
                                boolean bl12 = false;
                                var11_33.error(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(loginConnectionHandler))));
                            }
                            break;
                        }
                    }
                    this.$ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.$remainingBetaArchives != null) {
                    block.mergeBetaCrcs(this.$remainingBetaArchives);
                }
                Logger logger$iv = LoginConnectionHandler.access$getLogger$cp();
                ChannelHandlerContext channelHandlerContext = this.$ctx;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl13 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl14 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl15 = false;
                            logger.trace(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl16 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl17 = false;
                            logger.debug(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl18 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl19 = false;
                            logger.info(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl20 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl21 = false;
                            logger.warn(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl22 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl23 = false;
                            logger.error(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                }
                ExecutorService executor = LoginConnectionHandler.access$getNetworkService$p(this.this$0).getLoginHandlers$osrs_223_api().getLoginFlowExecutor();
                if (executor != null) {
                    executor.submit(() -> decodeGameLoginBuffer.1.invoke$lambda$2(this.this$0, this.$responseHandler, block, this.$ctx));
                } else {
                    LoginConnectionHandler.access$getNetworkService$p(this.this$0).getGameConnectionHandler$osrs_223_api().onLogin(this.$responseHandler, block);
                }
            }

            private static final void invoke$lambda$2(LoginConnectionHandler this$0, GameLoginResponseHandler $responseHandler, LoginBlock $block, ChannelHandlerContext $ctx) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$responseHandler, (String)"$responseHandler");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                try {
                    GameConnectionHandler<R> gameConnectionHandler = LoginConnectionHandler.access$getNetworkService$p(this$0).getGameConnectionHandler$osrs_223_api();
                    Intrinsics.checkNotNull((Object)$block);
                    gameConnectionHandler.onLogin($responseHandler, $block);
                }
                catch (Throwable t) {
                    this$0.exceptionCaught($ctx, t);
                }
            }
        }, arg_0, arg_1));
    }

    private final void decodeGameReconnectBuffer(GameReconnect packet, ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives, GameLoginResponseHandler<R> responseHandler) {
        this.decodeLogin-6j-XqWU(packet.getBuffer-07mC048(), this.networkService.getBetaWorld$osrs_223_api(), packet.getDecoder()).handle((arg_0, arg_1) -> LoginConnectionHandler.decodeGameReconnectBuffer$lambda$10((Function2)new Function2<LoginBlock<XteaKey>, Throwable, Unit>(ctx, this, remainingBetaArchives, responseHandler){
            final /* synthetic */ ChannelHandlerContext $ctx;
            final /* synthetic */ LoginConnectionHandler<R> this$0;
            final /* synthetic */ RemainingBetaArchives $remainingBetaArchives;
            final /* synthetic */ GameLoginResponseHandler<R> $responseHandler;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                this.$remainingBetaArchives = $remainingBetaArchives;
                this.$responseHandler = $responseHandler;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(LoginBlock<XteaKey> block, Throwable exception) {
                block32: {
                    if (block == null || exception != null) {
                        void arg0$iv;
                        if (exception instanceof CompletionException && Intrinsics.areEqual((Object)exception.getCause(), (Object)InvalidVersionException.INSTANCE)) {
                            this.$ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        Logger logger = LoginConnectionHandler.access$getLogger$cp();
                        ChannelHandlerContext channelHandlerContext = this.$ctx;
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            void var11_12 = arg0$iv;
                            boolean bl2 = false;
                            var11_12.error(String.valueOf("Failed to decode game reconnect block for channel " + channelHandlerContext.channel()), exception);
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail2.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    if (LoginConnectionHandler.access$getSessionId$p(this.this$0) == block.getSessionId()) break block32;
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    ChannelHandlerContext channelHandlerContext = this.$ctx;
                    LoginConnectionHandler<R> bl = this.this$0;
                    boolean bl3 = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl4 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            void logger$iv;
                            boolean bl5 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                void var11_13 = logger$iv;
                                boolean bl6 = false;
                                var11_13.trace(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                            }
                            break;
                        }
                        case 3: {
                            void logger$iv;
                            boolean bl7 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                void var11_14 = logger$iv;
                                boolean bl8 = false;
                                var11_14.debug(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                            }
                            break;
                        }
                        case 4: {
                            void logger$iv;
                            boolean bl9 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                void var11_15 = logger$iv;
                                boolean bl10 = false;
                                var11_15.info(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                            }
                            break;
                        }
                        case 5: {
                            void logger$iv;
                            boolean bl11 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                void var11_16 = logger$iv;
                                boolean bl12 = false;
                                var11_16.warn(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                            }
                            break;
                        }
                        case 6: {
                            void logger$iv;
                            boolean bl13 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                void var11_17 = logger$iv;
                                boolean bl14 = false;
                                var11_17.error(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                            }
                            break;
                        }
                    }
                    this.$ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.$remainingBetaArchives != null) {
                    block.mergeBetaCrcs(this.$remainingBetaArchives);
                }
                Logger logger$iv = LoginConnectionHandler.access$getLogger$cp();
                ChannelHandlerContext channelHandlerContext = this.$ctx;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl15 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl16 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl17 = false;
                            logger.trace(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl18 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl19 = false;
                            logger.debug(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl20 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl21 = false;
                            logger.info(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl22 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl23 = false;
                            logger.warn(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl24 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl25 = false;
                            logger.error(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                        break;
                    }
                }
                ExecutorService executor = LoginConnectionHandler.access$getNetworkService$p(this.this$0).getLoginHandlers$osrs_223_api().getLoginFlowExecutor();
                if (executor != null) {
                    executor.submit(() -> decodeGameReconnectBuffer.1.invoke$lambda$3(this.this$0, this.$responseHandler, block, this.$ctx));
                } else {
                    LoginConnectionHandler.access$getNetworkService$p(this.this$0).getGameConnectionHandler$osrs_223_api().onReconnect(this.$responseHandler, block);
                }
            }

            private static final void invoke$lambda$3(LoginConnectionHandler this$0, GameLoginResponseHandler $responseHandler, LoginBlock $block, ChannelHandlerContext $ctx) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$responseHandler, (String)"$responseHandler");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                try {
                    GameConnectionHandler<R> gameConnectionHandler = LoginConnectionHandler.access$getNetworkService$p(this$0).getGameConnectionHandler$osrs_223_api();
                    Intrinsics.checkNotNull((Object)$block);
                    gameConnectionHandler.onReconnect($responseHandler, (LoginBlock<XteaKey>)$block);
                }
                catch (Throwable t) {
                    this$0.exceptionCaught($ctx, t);
                }
            }
        }, arg_0, arg_1));
    }

    private final <Fun> CompletableFuture<LoginBlock<Fun>> decodeLogin-6j-XqWU(ByteBuf buf, boolean betaWorld, LoginBlockDecodingFunction<Fun> function) {
        return this.networkService.getLoginHandlers$osrs_223_api().getLoginDecoderService().decode-6j-XqWU(buf, betaWorld, function);
    }

    private final <T extends ChallengeType<? super MetaData>, MetaData extends ChallengeMetaData> CompletableFuture<Boolean> verifyProofOfWork(ProofOfWork<T, ? super MetaData> pow, long result) {
        return this.networkService.getLoginHandlers$osrs_223_api().getProofOfWorkChallengeWorker().verify(result, pow.getChallengeType(), pow.getChallengeVerifier());
    }

    private static final Unit channelRead0$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final void requestProofOfWork$lambda$5(ChannelHandlerContext $ctx, ChannelFuture future2) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
            if (future2.isSuccess()) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                    }
                    break;
                }
            }
            future2.channel().pipeline().fireExceptionCaught(future2.cause());
            future2.channel().close();
            return;
        }
        $ctx.read();
    }

    private static final void continueLogin$lambda$7(ChannelHandlerContext $ctx, ChannelFuture future2) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
            if (future2.isSuccess()) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                    }
                    break;
                }
            }
            future2.channel().pipeline().fireExceptionCaught(future2.cause());
            future2.channel().close();
            return;
        }
        $ctx.read();
    }

    private static final Unit decodeGameLoginBuffer$lambda$9(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit decodeGameReconnectBuffer$lambda$10(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$continueLogin(LoginConnectionHandler $this, ChannelHandlerContext ctx) {
        $this.continueLogin(ctx);
    }

    public static final /* synthetic */ NetworkService access$getNetworkService$p(LoginConnectionHandler $this) {
        return $this.networkService;
    }

    public static final /* synthetic */ long access$getSessionId$p(LoginConnectionHandler $this) {
        return $this.sessionId;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-223-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler$LoginState;", "", "(Ljava/lang/String;I)V", "UNINITIALIZED", "REQUESTED_PROOF_OF_WORK", "AWAITING_BETA_RESPONSE", "osrs-223-api"})
    private static final class LoginState
    extends Enum<LoginState> {
        public static final /* enum */ LoginState UNINITIALIZED = new LoginState();
        public static final /* enum */ LoginState REQUESTED_PROOF_OF_WORK = new LoginState();
        public static final /* enum */ LoginState AWAITING_BETA_RESPONSE = new LoginState();
        private static final /* synthetic */ LoginState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LoginState[] values() {
            return (LoginState[])$VALUES.clone();
        }

        public static LoginState valueOf(String value) {
            return Enum.valueOf(LoginState.class, value);
        }

        @NotNull
        public static EnumEntries<LoginState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = loginStateArray = new LoginState[]{LoginState.UNINITIALIZED, LoginState.REQUESTED_PROOF_OF_WORK, LoginState.AWAITING_BETA_RESPONSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

