/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.crypto.cipher.StreamCipherPair;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.Session;
import net.rsprot.protocol.api.StreamCipherProvider;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.game.GameMessageDecoder;
import net.rsprot.protocol.api.game.GameMessageEncoder;
import net.rsprot.protocol.api.game.GameMessageHandler;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.common.LogLevel;
import net.rsprot.protocol.common.RSProtFlags;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.incoming.util.LoginClientType;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.incoming.GameMessageConsumerRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001!B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J:\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00152\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u001f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\"\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020 2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler;", "R", "", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "(Lnet/rsprot/protocol/api/NetworkService;Lio/netty/channel/ChannelHandlerContext;)V", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "createSession", "Lnet/rsprot/protocol/api/Session;", "loginBlock", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "pipeline", "Lio/netty/channel/ChannelPipeline;", "decodingCipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "encodingCipher", "createStreamCipherPair", "Lnet/rsprot/crypto/cipher/StreamCipherPair;", "getOldSchoolClientType", "writeFailedResponse", "", "response", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse;", "writeSuccessfulResponse", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$Ok;", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$ReconnectOk;", "Companion", "osrs-223-api"})
@SourceDebugExtension(value={"SMAP\nGameLoginResponseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 5 ChannelExtensions.kt\nnet/rsprot/protocol/api/channel/ChannelExtensionsKt\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,265:1\n20#2:266\n44#2,6:267\n52#2:277\n55#2:282\n58#2:287\n61#2:292\n64#2:297\n21#2:298\n20#2:299\n44#2,6:300\n52#2:310\n55#2:315\n58#2:320\n61#2:325\n64#2:330\n21#2:331\n20#2:332\n44#2,6:333\n52#2:343\n55#2:348\n58#2:353\n61#2:358\n64#2:363\n21#2:364\n20#2:367\n44#2,6:368\n52#2:378\n55#2:383\n58#2:388\n61#2:393\n64#2:398\n21#2:399\n20#2:400\n44#2,6:401\n52#2:411\n55#2:416\n58#2:421\n61#2:426\n64#2:431\n21#2:432\n20#2:433\n44#2,6:434\n52#2:444\n55#2:449\n58#2:454\n61#2:459\n64#2:464\n21#2:465\n20#2:466\n44#2,6:467\n52#2:477\n55#2:482\n58#2:487\n61#2:492\n64#2:497\n21#2:498\n20#2:503\n44#2,6:504\n52#2:514\n55#2:519\n58#2:524\n61#2:529\n64#2:534\n21#2:535\n20#2:536\n44#2,6:537\n52#2:547\n55#2:552\n58#2:557\n61#2:562\n64#2:567\n21#2:568\n32#3,4:273\n56#3,4:278\n80#3,4:283\n104#3,4:288\n128#3,4:293\n32#3,4:306\n56#3,4:311\n80#3,4:316\n104#3,4:321\n128#3,4:326\n32#3,4:339\n56#3,4:344\n80#3,4:349\n104#3,4:354\n128#3,4:359\n32#3,4:374\n56#3,4:379\n80#3,4:384\n104#3,4:389\n128#3,4:394\n32#3,4:407\n56#3,4:412\n80#3,4:417\n104#3,4:422\n128#3,4:427\n32#3,4:440\n56#3,4:445\n80#3,4:450\n104#3,4:455\n128#3,4:460\n32#3,4:473\n56#3,4:478\n80#3,4:483\n104#3,4:488\n128#3,4:493\n32#3,4:510\n56#3,4:515\n80#3,4:520\n104#3,4:525\n128#3,4:530\n32#3,4:543\n56#3,4:548\n80#3,4:553\n104#3,4:558\n128#3,4:563\n158#4,2:365\n36#5:499\n36#5:500\n36#5:501\n36#5:502\n11#6,2:569\n*S KotlinDebug\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n*L\n50#1:266\n50#1:267,6\n50#1:277\n50#1:282\n50#1:287\n50#1:292\n50#1:297\n50#1:298\n60#1:299\n60#1:300,6\n60#1:310\n60#1:315\n60#1:320\n60#1:325\n60#1:330\n60#1:331\n78#1:332\n78#1:333,6\n78#1:343\n78#1:348\n78#1:353\n78#1:358\n78#1:363\n78#1:364\n106#1:367\n106#1:368,6\n106#1:378\n106#1:383\n106#1:388\n106#1:393\n106#1:398\n106#1:399\n119#1:400\n119#1:401,6\n119#1:411\n119#1:416\n119#1:421\n119#1:426\n119#1:431\n119#1:432\n127#1:433\n127#1:434,6\n127#1:444\n127#1:449\n127#1:454\n127#1:459\n127#1:464\n127#1:465\n141#1:466\n141#1:467,6\n141#1:477\n141#1:482\n141#1:487\n141#1:492\n141#1:497\n141#1:498\n246#1:503\n246#1:504,6\n246#1:514\n246#1:519\n246#1:524\n246#1:529\n246#1:534\n246#1:535\n251#1:536\n251#1:537,6\n251#1:547\n251#1:552\n251#1:557\n251#1:562\n251#1:567\n251#1:568\n50#1:273,4\n50#1:278,4\n50#1:283,4\n50#1:288,4\n50#1:293,4\n60#1:306,4\n60#1:311,4\n60#1:316,4\n60#1:321,4\n60#1:326,4\n78#1:339,4\n78#1:344,4\n78#1:349,4\n78#1:354,4\n78#1:359,4\n106#1:374,4\n106#1:379,4\n106#1:384,4\n106#1:389,4\n106#1:394,4\n119#1:407,4\n119#1:412,4\n119#1:417,4\n119#1:422,4\n119#1:427,4\n127#1:440,4\n127#1:445,4\n127#1:450,4\n127#1:455,4\n127#1:460,4\n141#1:473,4\n141#1:478,4\n141#1:483,4\n141#1:488,4\n141#1:493,4\n246#1:510,4\n246#1:515,4\n246#1:520,4\n246#1:525,4\n246#1:530,4\n251#1:543,4\n251#1:548,4\n251#1:553,4\n251#1:558,4\n251#1:563,4\n95#1:365,2\n206#1:499\n214#1:500\n217#1:501\n218#1:502\n262#1:569,2\n*E\n"})
public final class GameLoginResponseHandler<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private final ChannelHandlerContext ctx;
    private static final int DECODE_SEED_OFFSET = 50;
    @NotNull
    private static final Logger logger;

    public GameLoginResponseHandler(@NotNull NetworkService<R> networkService, @NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService = networkService;
        this.ctx = ctx;
    }

    @NotNull
    public final NetworkService<R> getNetworkService() {
        return this.networkService;
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.Ok response, @NotNull LoginBlock<?> loginBlock) {
        OldSchoolClientType oldSchoolClientType;
        block58: {
            block56: {
                block54: {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
                    oldSchoolClientType = this.getOldSchoolClientType(loginBlock);
                    if (oldSchoolClientType != null && this.networkService.isSupported(oldSchoolClientType)) break block54;
                    Logger logger$iv = logger;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl2 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl3 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl4 = false;
                                logger.trace(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl5 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl6 = false;
                                logger.debug(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl7 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl8 = false;
                                logger.info(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl9 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl10 = false;
                                logger.warn(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl11 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl12 = false;
                                logger.error(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                    }
                    this.ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    return null;
                }
                if (this.ctx.channel().isActive()) break block56;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl13 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl14 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl15 = false;
                            logger.trace(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl16 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl17 = false;
                            logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl18 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl19 = false;
                            logger.info(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl20 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl21 = false;
                            logger.warn(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl22 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl23 = false;
                            logger.error(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                }
                return null;
            }
            InetAddress address = ChannelExtensionsKt.inetAddress(this.ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_223_api().getGameInetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_223_api().getInetAddressValidator().acceptGameConnection(address, count);
            if (accepted) break block58;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl24 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl25 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl26 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl27 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl28 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl29 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl30 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl31 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl32 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl33 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl34 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
            }
            this.ctx.writeAndFlush((Object)LoginResponse.TooManyAttempts.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return null;
        }
        StreamCipherPair cipher = this.createStreamCipherPair(loginBlock);
        if (this.networkService.getBetaWorld$osrs_223_api()) {
            MessageEncoder encoder = this.networkService.getEncoderRepositories$osrs_223_api().getLoginMessageEncoderRepository().getEncoder(response.getClass());
            ByteBuf byteBuf = this.ctx.alloc().buffer(38);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
            ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)byteBuf);
            int value$iv = 37;
            boolean bl = false;
            JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
            encoder.encode-WFbGaZ8(cipher.getEncoderCipher(), buffer, (OutgoingMessage)response);
            this.ctx.writeAndFlush((Object)buffer);
        } else {
            this.ctx.writeAndFlush((Object)response);
        }
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, cipher.getDecodeCipher(), oldSchoolClientType, cipher.getEncoderCipher());
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl35 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl36 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl37 = false;
                    logger.trace(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 3: {
                boolean bl38 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl39 = false;
                    logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 4: {
                boolean bl40 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl41 = false;
                    logger.info(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 5: {
                boolean bl42 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl43 = false;
                    logger.warn(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 6: {
                boolean bl44 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl45 = false;
                    logger.error(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
        }
        return session;
    }

    @Nullable
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.ReconnectOk response, @NotNull LoginBlock<?> loginBlock) {
        OldSchoolClientType oldSchoolClientType;
        block41: {
            block39: {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
                oldSchoolClientType = this.getOldSchoolClientType(loginBlock);
                if (oldSchoolClientType != null && this.networkService.isSupported(oldSchoolClientType)) break block39;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                }
                this.ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE);
                return null;
            }
            if (this.ctx.channel().isActive()) break block41;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
            }
            return null;
        }
        StreamCipherPair streamCipherPair = this.createStreamCipherPair(loginBlock);
        StreamCipher encodingCipher = streamCipherPair.component1();
        StreamCipher decodingCipher = streamCipherPair.component2();
        this.ctx.write((Object)response, this.ctx.voidPromise());
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, decodingCipher, oldSchoolClientType, encodingCipher);
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl24 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl25 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl26 = false;
                    logger.trace(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 3: {
                boolean bl27 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl28 = false;
                    logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 4: {
                boolean bl29 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl30 = false;
                    logger.info(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 5: {
                boolean bl31 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl32 = false;
                    logger.warn(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 6: {
                boolean bl33 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl34 = false;
                    logger.error(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
        }
        return session;
    }

    private final StreamCipherPair createStreamCipherPair(LoginBlock<?> loginBlock) {
        int[] encodeSeed = loginBlock.getSeed();
        int n = 0;
        int n2 = encodeSeed.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = encodeSeed[n3] + 50;
        }
        int[] decodeSeed = nArray;
        StreamCipherProvider provider = this.networkService.getLoginHandlers$osrs_223_api().getStreamCipherProvider();
        StreamCipher encodingCipher = provider.provide(decodeSeed);
        StreamCipher decodingCipher = provider.provide(encodeSeed);
        return new StreamCipherPair(encodingCipher, decodingCipher);
    }

    private final OldSchoolClientType getOldSchoolClientType(LoginBlock<?> loginBlock) {
        OldSchoolClientType oldSchoolClientType;
        switch (WhenMappings.$EnumSwitchMapping$0[loginBlock.getClientType().ordinal()]) {
            case 1: {
                oldSchoolClientType = OldSchoolClientType.DESKTOP;
                break;
            }
            case 2: {
                oldSchoolClientType = OldSchoolClientType.DESKTOP;
                break;
            }
            case 3: {
                oldSchoolClientType = OldSchoolClientType.DESKTOP;
                break;
            }
            case 4: {
                oldSchoolClientType = OldSchoolClientType.DESKTOP;
                break;
            }
            default: {
                oldSchoolClientType = null;
            }
        }
        OldSchoolClientType oldSchoolClientType2 = oldSchoolClientType;
        return oldSchoolClientType2;
    }

    private final Session<R> createSession(LoginBlock<?> loginBlock, ChannelPipeline pipeline, StreamCipher decodingCipher, OldSchoolClientType oldSchoolClientType, StreamCipher encodingCipher) {
        ChannelHandler newHandler$iv;
        ChannelPipeline $this$replace$iv;
        GameMessageConsumerRepository gameMessageConsumerRepository = this.networkService.getGameMessageConsumerRepositoryProvider().provide();
        Session<R> session = new Session<R>(this.ctx, this.networkService.getGameMessageHandlers$osrs_223_api().getIncomingGameMessageQueueProvider().provide(), this.networkService.getGameMessageHandlers$osrs_223_api().getOutgoingGameMessageQueueProvider(), this.networkService.getGameMessageHandlers$osrs_223_api().getGameMessageCounterProvider().provide(), gameMessageConsumerRepository.getConsumers(), gameMessageConsumerRepository.getGlobalConsumers(), loginBlock, this.networkService.getExceptionHandlers$osrs_223_api().getIncomingGameMessageConsumerExceptionHandler());
        ChannelPipeline channelPipeline = pipeline;
        ChannelHandler channelHandler = (ChannelHandler)new GameMessageDecoder<R>(this.networkService, session, decodingCipher, oldSchoolClientType);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageEncoder(this.networkService, encodingCipher, oldSchoolClientType);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageHandler<R>(this.networkService, session);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginConnectionHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 15L, 15L, 15L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        return session;
    }

    public final void writeFailedResponse(@NotNull LoginResponse response) {
        block28: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (response instanceof LoginResponse.ProofOfWork) {
                throw new IllegalStateException("Proof of Work is handled at the engine level.");
            }
            if (response instanceof LoginResponse.Successful) {
                throw new IllegalStateException("Successful login response is handled at the engine level.");
            }
            if (this.ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
            }
            return;
        }
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl13 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl14 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl15 = false;
                    logger.trace(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 3: {
                boolean bl16 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl17 = false;
                    logger.debug(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 4: {
                boolean bl18 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl19 = false;
                    logger.info(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 5: {
                boolean bl20 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl21 = false;
                    logger.warn(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 6: {
                boolean bl22 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl23 = false;
                    logger.error(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
        }
        this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler$Companion;", "", "()V", "DECODE_SEED_OFFSET", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-223-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoginClientType.values().length];
            try {
                nArray[LoginClientType.DESKTOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginClientType.ENHANCED_WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginClientType.ENHANCED_LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginClientType.ENHANCED_MAC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

