/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.rsprot.protocol.api.js5.Js5Client;
import net.rsprot.protocol.api.js5.Js5Configuration;
import net.rsprot.protocol.api.js5.Js5GroupProvider;
import net.rsprot.protocol.api.js5.util.UniqueQueue;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.common.LogLevel;
import net.rsprot.protocol.common.RSProtFlags;
import net.rsprot.protocol.js5.incoming.Js5GroupRequest;
import net.rsprot.protocol.js5.outgoing.Js5GroupResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u0015\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0001H\u0002J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\b\u0010\"\u001a\u00020\u0017H\u0016J \u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0006\u0010'\u001a\u00020\u0017J\u001a\u0010(\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170*H\u0081\b\u00f8\u0001\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\n\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006,"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Service;", "Ljava/lang/Runnable;", "configuration", "Lnet/rsprot/protocol/api/js5/Js5Configuration;", "provider", "Lnet/rsprot/protocol/api/js5/Js5GroupProvider;", "(Lnet/rsprot/protocol/api/js5/Js5Configuration;Lnet/rsprot/protocol/api/js5/Js5GroupProvider;)V", "clientLock", "Ljava/lang/Object;", "getClientLock$annotations", "()V", "clients", "Lnet/rsprot/protocol/api/js5/util/UniqueQueue;", "Lnet/rsprot/protocol/api/js5/Js5Client;", "connectedClients", "Lkotlin/collections/ArrayDeque;", "isRunning", "", "lock", "getLock$annotations", "getLock", "()Ljava/lang/Object;", "notifyIfNotEmpty", "", "client", "onClientConnected", "onClientConnected$osrs_223_api", "onClientDisconnected", "onClientDisconnected$osrs_223_api", "prefetch", "push", "request", "Lnet/rsprot/protocol/js5/incoming/Js5GroupRequest;", "readIfNotFull", "run", "serveClient", "response", "Lnet/rsprot/protocol/js5/outgoing/Js5GroupResponse;", "flush", "triggerShutdown", "use", "block", "Lkotlin/Function0;", "Companion", "osrs-223-api"})
@SourceDebugExtension(value={"SMAP\nJs5Service.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,331:1\n110#2,4:332\n134#2,4:336\n134#2,4:340\n32#2,4:358\n56#2,4:363\n80#2,4:368\n104#2,4:373\n128#2,4:378\n32#2,4:397\n56#2,4:402\n80#2,4:407\n104#2,4:412\n128#2,4:417\n32#2,4:437\n56#2,4:442\n80#2,4:447\n104#2,4:452\n128#2,4:457\n32#2,4:477\n56#2,4:482\n80#2,4:487\n104#2,4:492\n128#2,4:497\n32#2,4:517\n56#2,4:522\n80#2,4:527\n104#2,4:532\n128#2,4:537\n32#2,4:557\n56#2,4:562\n80#2,4:567\n104#2,4:572\n128#2,4:577\n32#2,4:597\n56#2,4:602\n80#2,4:607\n104#2,4:612\n128#2,4:617\n36#3,14:344\n52#3:362\n55#3:367\n58#3:372\n61#3:377\n64#3:382\n36#3,14:383\n52#3:401\n55#3:406\n58#3:411\n61#3:416\n64#3:421\n37#3:422\n36#3,14:423\n52#3:441\n55#3:446\n58#3:451\n61#3:456\n64#3:461\n37#3:462\n36#3,14:463\n52#3:481\n55#3:486\n58#3:491\n61#3:496\n64#3:501\n37#3:502\n36#3,14:503\n52#3:521\n55#3:526\n58#3:531\n61#3:536\n64#3:541\n37#3:542\n36#3,14:543\n52#3:561\n55#3:566\n58#3:571\n61#3:576\n64#3:581\n37#3:582\n36#3,14:583\n52#3:601\n55#3:606\n58#3:611\n61#3:616\n64#3:621\n37#3:622\n11#4,2:623\n*S KotlinDebug\n*F\n+ 1 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n*L\n71#1:332,4\n92#1:336,4\n98#1:340,4\n156#1:358,4\n156#1:363,4\n156#1:368,4\n156#1:373,4\n156#1:378,4\n160#1:397,4\n160#1:402,4\n160#1:407,4\n160#1:412,4\n160#1:417,4\n167#1:437,4\n167#1:442,4\n167#1:447,4\n167#1:452,4\n167#1:457,4\n172#1:477,4\n172#1:482,4\n172#1:487,4\n172#1:492,4\n172#1:497,4\n181#1:517,4\n181#1:522,4\n181#1:527,4\n181#1:532,4\n181#1:537,4\n217#1:557,4\n217#1:562,4\n217#1:567,4\n217#1:572,4\n217#1:577,4\n232#1:597,4\n232#1:602,4\n232#1:607,4\n232#1:612,4\n232#1:617,4\n156#1:344,14\n156#1:362\n156#1:367\n156#1:372\n156#1:377\n156#1:382\n160#1:383,14\n160#1:401\n160#1:406\n160#1:411\n160#1:416\n160#1:421\n160#1:422\n167#1:423,14\n167#1:441\n167#1:446\n167#1:451\n167#1:456\n167#1:461\n167#1:462\n172#1:463,14\n172#1:481\n172#1:486\n172#1:491\n172#1:496\n172#1:501\n172#1:502\n181#1:503,14\n181#1:521\n181#1:526\n181#1:531\n181#1:536\n181#1:541\n181#1:542\n217#1:543,14\n217#1:561\n217#1:566\n217#1:571\n217#1:576\n217#1:581\n217#1:582\n232#1:583,14\n232#1:601\n232#1:606\n232#1:611\n232#1:616\n232#1:621\n232#1:622\n266#1:623,2\n*E\n"})
public final class Js5Service
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Js5Configuration configuration;
    @NotNull
    private final Js5GroupProvider provider;
    @NotNull
    private final UniqueQueue<Js5Client> clients;
    @NotNull
    private final ArrayDeque<Js5Client> connectedClients;
    @NotNull
    private final Object lock;
    @NotNull
    private final Object clientLock;
    private volatile boolean isRunning;
    public static final int BLOCK_LENGTH = 512;
    @NotNull
    private static final Logger logger;

    public Js5Service(@NotNull Js5Configuration configuration, @NotNull Js5GroupProvider provider) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.configuration = configuration;
        this.provider = provider;
        this.clients = new UniqueQueue();
        this.connectedClients = new ArrayDeque();
        this.lock = new Object();
        this.clientLock = new Object();
        this.isRunning = true;
    }

    @NotNull
    public final Object getLock() {
        return this.lock;
    }

    @PublishedApi
    public static /* synthetic */ void getLock$annotations() {
    }

    private static /* synthetic */ void getClientLock$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Logger logger;
            try {
                Js5Client client = null;
                Js5GroupResponse response = null;
                boolean flush = false;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl = false;
                    while (true) {
                        if (!this.isRunning) {
                            return;
                        }
                        Js5Client next = this.clients.removeFirstOrNull();
                        if (next == null) {
                            this.lock.wait();
                            continue;
                        }
                        client = next;
                        if (!client.getCtx().channel().isActive()) continue;
                        Js5Client.ClientPriority priority = client.getPriority();
                        int ratio = priority == Js5Client.ClientPriority.HIGH ? this.configuration.getPriorityRatio() : 1;
                        try {
                            Js5GroupResponse js5GroupResponse = client.getNextBlock(this.configuration.getMissingGroupBehaviour(), this.provider, this.configuration.getBlockSizeInBytes() * ratio);
                            if (js5GroupResponse == null) continue;
                            response = js5GroupResponse;
                        }
                        catch (Throwable t) {
                            Logger arg0$iv = Js5Service.logger;
                            boolean bl2 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                Logger logger2 = arg0$iv;
                                boolean bl3 = false;
                                logger2.warn(String.valueOf("Unable to serve channel '" + client.getCtx().channel() + "', dropping connection."), t);
                            }
                            client.getCtx().close();
                            continue;
                        }
                        break;
                    }
                    flush = client.needsFlushing(this.configuration.getFlushThresholdInBytes(), this.configuration.getFlushThresholdInRequests());
                    if (flush) {
                        client.resetTracker();
                    }
                    Unit $i$a$-synchronized-Js5Service$run$2 = Unit.INSTANCE;
                }
                try {
                    this.serveClient(client, response, flush);
                }
                catch (Throwable t) {
                    Logger arg0$iv = Js5Service.logger;
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        logger = arg0$iv;
                        boolean bl4 = false;
                        logger.error(String.valueOf("Unable to serve channel " + client.getCtx().channel() + ", dropping connection."), t);
                    }
                    client.getCtx().close();
                }
            }
            catch (Throwable t) {
                Logger arg0$iv = Js5Service.logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    logger = arg0$iv;
                    boolean bl5 = false;
                    logger.error(String.valueOf("Error in JS5 service processing - JS5 service has been killed."), t);
                }
                throw t;
            }
        }
    }

    private final Runnable prefetch() {
        return () -> Js5Service.prefetch$lambda$6(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onClientConnected$osrs_223_api(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.connectedClients).add(client);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onClientDisconnected$osrs_223_api(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.connectedClients).remove(client);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void serveClient(Js5Client client, Js5GroupResponse response, boolean flush) {
        ChannelHandlerContext ctx;
        block70: {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Logger logger;
            boolean bl5;
            ctx = client.getCtx();
            ctx.write((Object)response);
            Logger logger$iv = Js5Service.logger;
            boolean bl6 = false;
            LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
            boolean bl7 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl8;
                    bl5 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.trace(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
                case 3: {
                    boolean bl8;
                    bl4 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.debug(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
                case 4: {
                    boolean bl8;
                    bl3 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.info(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
                case 5: {
                    boolean bl8;
                    bl2 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.warn(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
                case 6: {
                    boolean bl8;
                    bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.error(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
            }
            if (!flush) break block70;
            logger$iv = Js5Service.logger;
            bl6 = false;
            level$iv$iv = RSProtFlags.getJs5Logging();
            bl7 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl9;
                    bl5 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.trace(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl9;
                    bl4 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.debug(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl9;
                    bl3 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.info(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9;
                    bl2 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.warn(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl9;
                    bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.error(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.flush();
        }
        Object object = this.lock;
        synchronized (object) {
            Logger logger;
            block74: {
                boolean bl;
                boolean bl10;
                boolean bl11;
                boolean bl12;
                boolean bl13;
                boolean bl14;
                boolean bl15;
                Logger logger$iv;
                block72: {
                    boolean bl16 = false;
                    if (flush && !client.isReady()) break block72;
                    logger$iv = Js5Service.logger;
                    bl15 = false;
                    LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                    bl14 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl17;
                            bl13 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.trace(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl17;
                            bl12 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.debug(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl17;
                            bl11 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.info(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl17;
                            bl10 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.warn(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl17;
                            bl = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.error(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                    }
                    this.clients.add(client);
                    break block74;
                }
                logger$iv = Js5Service.logger;
                bl15 = false;
                LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                bl14 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl18;
                        bl13 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.trace(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl18;
                        bl12 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.debug(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl18;
                        bl11 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.info(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl18;
                        bl10 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.warn(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl18;
                        bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.error(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                }
            }
            boolean notFull = client.isNotFull();
            if (notFull) {
                ctx.read();
            }
            Logger logger$iv = Js5Service.logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
            boolean bl19 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl20 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl21 = false;
                        logger.trace(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl22 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl23 = false;
                        logger.debug(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl24 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl25 = false;
                        logger.info(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl26 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl27 = false;
                        logger.warn(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl28 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl29 = false;
                        logger.error(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void push(@NotNull Js5Client client, @NotNull Js5GroupRequest request) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            client.push(request);
            if (client.isReady()) {
                this.clients.add(client);
                this.lock.notifyAll();
            }
            if (client.isNotFull()) {
                client.getCtx().read();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readIfNotFull(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.lock;
        synchronized (object) {
            block16: {
                boolean bl = false;
                if (!client.isNotFull()) break block16;
                Logger logger$iv = logger;
                boolean bl2 = false;
                LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                boolean bl3 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl4 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl5 = false;
                            logger.trace(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl6 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl7 = false;
                            logger.debug(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl8 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl9 = false;
                            logger.info(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl10 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl11 = false;
                            logger.warn(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl12 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl13 = false;
                            logger.error(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                }
                client.getCtx().read();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyIfNotEmpty(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.lock;
        synchronized (object) {
            block16: {
                boolean bl = false;
                if (!client.isNotEmpty()) break block16;
                Logger logger$iv = logger;
                boolean bl2 = false;
                LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                boolean bl3 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl4 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl5 = false;
                            logger.trace(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl6 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl7 = false;
                            logger.debug(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl8 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl9 = false;
                            logger.info(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl10 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl11 = false;
                            logger.warn(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl12 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl13 = false;
                            logger.error(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                }
                this.clients.add(client);
                this.lock.notifyAll();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublishedApi
    public final void use(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$use = false;
        Object object = this.getLock();
        synchronized (object) {
            try {
                boolean bl = false;
                block.invoke();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                InlineMarker.finallyEnd((int)1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void triggerShutdown() {
        this.isRunning = false;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void prefetch$lambda$6(Js5Service this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.clientLock;
        synchronized (object) {
            boolean bl = false;
            for (Js5Client client : this$0.connectedClients) {
                Object object2 = this$0.lock;
                synchronized (object2) {
                    boolean bl2 = false;
                    if (client.transferPrefetch$osrs_223_api(this$0.provider, this$0.configuration.getPrefetchTransferThresholdInBytes())) {
                        this$0.clients.add(client);
                        this$0.lock.notifyAll();
                        if (client.isNotFull()) {
                            client.getCtx().read();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ\u0012\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Service$Companion;", "", "()V", "BLOCK_LENGTH", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "ensureCorrectlySliced", "", "buffer", "Lio/netty/buffer/ByteBuf;", "ensureCorrectlySliced$osrs_223_api", "prepareJs5Buffer", "", "archive", "group", "input", "output", "startPrefetching", "Ljava/util/concurrent/ScheduledFuture;", "service", "Lnet/rsprot/protocol/api/js5/Js5Service;", "osrs-223-api"})
    public static final class Companion {
        private Companion() {
        }

        public final void prepareJs5Buffer(int archive, int group, @NotNull ByteBuf input, @NotNull ByteBuf output) {
            int nextBlockLength;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            int readableBytes = input.readableBytes();
            output.writeByte(archive);
            output.writeShort(group);
            int len = Math.min(readableBytes, 509);
            output.writeBytes(input, 0, len);
            for (int offset = len; offset < readableBytes; offset += nextBlockLength) {
                output.writeByte(255);
                nextBlockLength = Math.min(readableBytes - offset, 511);
                output.writeBytes(input, offset, nextBlockLength);
            }
        }

        public final boolean ensureCorrectlySliced$osrs_223_api(@NotNull ByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int cap = buffer.readableBytes();
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)512, (int)cap)), (int)512);
            int i = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                while (true) {
                    if ((buffer.getByte(i) & 0xFF) != 255) {
                        return false;
                    }
                    if (i == n) break;
                    i += n2;
                }
            }
            return true;
        }

        @NotNull
        public final ScheduledFuture<?> startPrefetching(@NotNull Js5Service service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            ScheduledFuture<?> scheduledFuture = Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(service.prefetch(), 200L, 200L, TimeUnit.MILLISECONDS);
            Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
            return scheduledFuture;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

