/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.js5.Js5ChannelHandler;
import net.rsprot.protocol.api.js5.Js5MessageDecoder;
import net.rsprot.protocol.api.js5.Js5MessageEncoder;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.common.LogLevel;
import net.rsprot.protocol.common.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.InitGameConnection;
import net.rsprot.protocol.loginprot.incoming.InitJs5RemoteConnection;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.IncomingLoginMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingLoginMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "channelReadComplete", "exceptionCaught", "cause", "", "handleInitGameConnection", "handleInitJs5RemoteConnection", "revision", "", "seed", "", "userEventTriggered", "evt", "", "Companion", "osrs-223-api"})
@SourceDebugExtension(value={"SMAP\nLoginChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 ChannelExtensions.kt\nnet/rsprot/protocol/api/channel/ChannelExtensionsKt\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,232:1\n20#2:233\n44#2,6:234\n52#2:244\n55#2:249\n58#2:254\n61#2:259\n64#2:264\n21#2:265\n20#2:266\n44#2,6:267\n52#2:277\n55#2:282\n58#2:287\n61#2:292\n64#2:297\n21#2:298\n20#2:299\n44#2,6:300\n52#2:310\n55#2:315\n58#2:320\n61#2:325\n64#2:330\n21#2:331\n20#2:332\n44#2,6:333\n52#2:343\n55#2:348\n58#2:353\n61#2:358\n64#2:363\n21#2:364\n20#2:365\n44#2,6:366\n52#2:376\n55#2:381\n58#2:386\n61#2:391\n64#2:396\n21#2:397\n20#2:398\n44#2,6:399\n52#2:409\n55#2:414\n58#2:419\n61#2:424\n64#2:429\n21#2:430\n20#2:431\n44#2,6:432\n52#2:442\n55#2:447\n58#2:452\n61#2:457\n64#2:462\n21#2:463\n20#2:464\n44#2,6:465\n52#2:475\n55#2:480\n58#2:485\n61#2:490\n64#2:495\n21#2:496\n20#2:497\n44#2,6:498\n52#2:508\n55#2:513\n58#2:518\n61#2:523\n64#2:528\n21#2:529\n20#2:532\n44#2,6:533\n52#2:543\n55#2:548\n58#2:553\n61#2:558\n64#2:563\n21#2:564\n20#2:565\n44#2,6:566\n52#2:576\n55#2:581\n58#2:586\n61#2:591\n64#2:596\n21#2:597\n32#3,4:240\n56#3,4:245\n80#3,4:250\n104#3,4:255\n128#3,4:260\n32#3,4:273\n56#3,4:278\n80#3,4:283\n104#3,4:288\n128#3,4:293\n32#3,4:306\n56#3,4:311\n80#3,4:316\n104#3,4:321\n128#3,4:326\n32#3,4:339\n56#3,4:344\n80#3,4:349\n104#3,4:354\n128#3,4:359\n32#3,4:372\n56#3,4:377\n80#3,4:382\n104#3,4:387\n128#3,4:392\n32#3,4:405\n56#3,4:410\n80#3,4:415\n104#3,4:420\n128#3,4:425\n32#3,4:438\n56#3,4:443\n80#3,4:448\n104#3,4:453\n128#3,4:458\n32#3,4:471\n56#3,4:476\n80#3,4:481\n104#3,4:486\n128#3,4:491\n32#3,4:504\n56#3,4:509\n80#3,4:514\n104#3,4:519\n128#3,4:524\n32#3,4:539\n56#3,4:544\n80#3,4:549\n104#3,4:554\n128#3,4:559\n32#3,4:572\n56#3,4:577\n80#3,4:582\n104#3,4:587\n128#3,4:592\n36#4:530\n36#4:531\n36#4:598\n36#4:599\n36#4:600\n36#4:601\n11#5,2:602\n*S KotlinDebug\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n*L\n35#1:233\n35#1:234,6\n35#1:244\n35#1:249\n35#1:254\n35#1:259\n35#1:264\n35#1:265\n44#1:266\n44#1:267,6\n44#1:277\n44#1:282\n44#1:287\n44#1:292\n44#1:297\n44#1:298\n74#1:299\n74#1:300,6\n74#1:310\n74#1:315\n74#1:320\n74#1:325\n74#1:330\n74#1:331\n87#1:332\n87#1:333,6\n87#1:343\n87#1:348\n87#1:353\n87#1:358\n87#1:363\n87#1:364\n133#1:365\n133#1:366,6\n133#1:376\n133#1:381\n133#1:386\n133#1:391\n133#1:396\n133#1:397\n153#1:398\n153#1:399,6\n153#1:409\n153#1:414\n153#1:419\n153#1:424\n153#1:429\n153#1:430\n220#1:431\n220#1:432,6\n220#1:442\n220#1:447\n220#1:452\n220#1:457\n220#1:462\n220#1:463\n95#1:464\n95#1:465,6\n95#1:475\n95#1:480\n95#1:485\n95#1:490\n95#1:495\n95#1:496\n104#1:497\n104#1:498,6\n104#1:508\n104#1:513\n104#1:518\n104#1:523\n104#1:528\n104#1:529\n166#1:532\n166#1:533,6\n166#1:543\n166#1:548\n166#1:553\n166#1:558\n166#1:563\n166#1:564\n175#1:565\n175#1:566,6\n175#1:576\n175#1:581\n175#1:586\n175#1:591\n175#1:596\n175#1:597\n35#1:240,4\n35#1:245,4\n35#1:250,4\n35#1:255,4\n35#1:260,4\n44#1:273,4\n44#1:278,4\n44#1:283,4\n44#1:288,4\n44#1:293,4\n74#1:306,4\n74#1:311,4\n74#1:316,4\n74#1:321,4\n74#1:326,4\n87#1:339,4\n87#1:344,4\n87#1:349,4\n87#1:354,4\n87#1:359,4\n133#1:372,4\n133#1:377,4\n133#1:382,4\n133#1:387,4\n133#1:392,4\n153#1:405,4\n153#1:410,4\n153#1:415,4\n153#1:420,4\n153#1:425,4\n220#1:438,4\n220#1:443,4\n220#1:448,4\n220#1:453,4\n220#1:458,4\n95#1:471,4\n95#1:476,4\n95#1:481,4\n95#1:486,4\n95#1:491,4\n104#1:504,4\n104#1:509,4\n104#1:514,4\n104#1:519,4\n104#1:524,4\n166#1:539,4\n166#1:544,4\n166#1:549,4\n166#1:554,4\n166#1:559,4\n175#1:572,4\n175#1:577,4\n175#1:582,4\n175#1:587,4\n175#1:592,4\n113#1:530\n114#1:531\n184#1:598\n185#1:599\n186#1:600\n187#1:601\n229#1:602,2\n*E\n"})
public final class LoginChannelHandler
extends SimpleChannelInboundHandler<IncomingLoginMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private static final Logger logger;

    public LoginChannelHandler(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingLoginMessage.class);
        this.networkService = networkService;
    }

    @NotNull
    public final NetworkService<?> getNetworkService() {
        return this.networkService;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
        ctx.fireChannelActive();
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingLoginMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
        }
        IncomingLoginMessage incomingLoginMessage = msg;
        if (Intrinsics.areEqual((Object)incomingLoginMessage, (Object)InitGameConnection.INSTANCE)) {
            this.handleInitGameConnection(ctx);
        } else if (incomingLoginMessage instanceof InitJs5RemoteConnection) {
            this.handleInitJs5RemoteConnection(ctx, ((InitJs5RemoteConnection)msg).getRevision(), ((InitJs5RemoteConnection)msg).getSeed());
        } else {
            throw new IllegalStateException("Unknown login channel message: " + msg);
        }
    }

    private final void handleInitGameConnection(ChannelHandlerContext ctx) {
        InetAddress address;
        block26: {
            address = ChannelExtensionsKt.inetAddress(ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_223_api().getGameInetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_223_api().getInetAddressValidator().acceptGameConnection(address, count);
            if (accepted) break block26;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.write((Object)LoginResponse.TooManyAttempts.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        long sessionId = this.networkService.getLoginHandlers$osrs_223_api().getSessionIdGenerator().generate(address);
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl13 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl14 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl15 = false;
                    logger.trace(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 3: {
                boolean bl16 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl17 = false;
                    logger.debug(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 4: {
                boolean bl18 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl19 = false;
                    logger.info(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 5: {
                boolean bl20 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl21 = false;
                    logger.warn(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 6: {
                boolean bl22 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl23 = false;
                    logger.error(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
        }
        ctx.write((Object)new LoginResponse.Successful(Long.valueOf(sessionId))).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitGameConnection$lambda$6(ctx, this, address, sessionId, arg_0)));
    }

    private final void handleInitJs5RemoteConnection(ChannelHandlerContext ctx, int revision, int[] seed) {
        InetAddress address;
        block28: {
            block26: {
                if (revision == 223) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                }
                ctx.write((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            address = ChannelExtensionsKt.inetAddress(ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_223_api().getJs5InetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_223_api().getInetAddressValidator().acceptJs5Connection(address, count, seed);
            if (accepted) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.write((Object)LoginResponse.IPLimit.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.write((Object)new LoginResponse.Successful(null)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitJs5RemoteConnection$lambda$11(ctx, this, address, arg_0)));
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_223_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }

    private static final void handleInitGameConnection$lambda$6(ChannelHandlerContext $ctx, LoginChannelHandler this$0, InetAddress $address, long $sessionId, ChannelFuture future2) {
        ChannelPipeline $this$replace$iv;
        block28: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                if (future2.isSuccess()) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                }
                future2.channel().pipeline().fireExceptionCaught(future2.cause());
                future2.channel().close();
                return;
            }
            if (!$ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_223_api().getGameInetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = future2.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new LoginConnectionHandler(this$0.networkService, $sessionId);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 40L, 40L, 40L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    private static final void handleInitJs5RemoteConnection$lambda$11(ChannelHandlerContext $ctx, LoginChannelHandler this$0, InetAddress $address, ChannelFuture future2) {
        ChannelPipeline $this$replace$iv;
        block28: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                if (future2.isSuccess()) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                }
                future2.channel().pipeline().fireExceptionCaught(future2.cause());
                future2.channel().close();
                return;
            }
            if (!$ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_223_api().getJs5InetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = $ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new Js5MessageDecoder(this$0.networkService);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5MessageEncoder(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5ChannelHandler(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 30L, 30L, 30L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-223-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

