/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import net.rsprot.protocol.ServerProtCategory;
import net.rsprot.protocol.api.GameMessageCounter;
import net.rsprot.protocol.api.IncomingGameMessageConsumerExceptionHandler;
import net.rsprot.protocol.api.MessageQueueProvider;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.game.GameMessageDecoder;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.common.LogLevel;
import net.rsprot.protocol.common.RSProtFlags;
import net.rsprot.protocol.game.outgoing.zone.payload.SoundArea;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.incoming.util.LoginClientType;
import net.rsprot.protocol.message.IncomingGameMessage;
import net.rsprot.protocol.message.OutgoingGameMessage;
import net.rsprot.protocol.message.codec.incoming.MessageConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 M*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002LMB\u008d\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012&\u0010\r\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u000e\u0012\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u0012\u0012\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020+H\u0002J\u0006\u0010/\u001a\u00020+J\u0006\u00100\u001a\u00020+J\u0015\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u000204H\u0000\u00a2\u0006\u0002\b5J\b\u00106\u001a\u00020+H\u0002J\n\u00107\u001a\u0004\u0018\u00010\u0007H\u0002J\u0013\u00108\u001a\u0002092\u0006\u0010:\u001a\u00028\u0000\u00a2\u0006\u0002\u0010;J\u000e\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020\nJ\u0016\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u000204J\r\u0010A\u001a\u00020+H\u0000\u00a2\u0006\u0002\bBJ\u000e\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020\u001dJ\u0010\u0010E\u001a\u00020+2\u0006\u0010F\u001a\u000204H\u0002J\r\u0010F\u001a\u00020+H\u0000\u00a2\u0006\u0002\bGJ\r\u0010H\u001a\u00020+H\u0000\u00a2\u0006\u0002\bIJ\b\u0010J\u001a\u00020+H\u0002J\b\u0010K\u001a\u00020+H\u0002R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\r\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020#X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010$R\u0015\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006N"}, d2={"Lnet/rsprot/protocol/api/Session;", "R", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "incomingMessageQueue", "Ljava/util/Queue;", "Lnet/rsprot/protocol/message/IncomingGameMessage;", "outgoingMessageQueueProvider", "Lnet/rsprot/protocol/api/MessageQueueProvider;", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "counter", "Lnet/rsprot/protocol/api/GameMessageCounter;", "consumers", "", "Ljava/lang/Class;", "Lnet/rsprot/protocol/message/codec/incoming/MessageConsumer;", "globalConsumers", "", "loginBlock", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "incomingGameMessageConsumerExceptionHandler", "Lnet/rsprot/protocol/api/IncomingGameMessageConsumerExceptionHandler;", "(Lio/netty/channel/ChannelHandlerContext;Ljava/util/Queue;Lnet/rsprot/protocol/api/MessageQueueProvider;Lnet/rsprot/protocol/api/GameMessageCounter;Ljava/util/Map;Ljava/util/List;Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;Lnet/rsprot/protocol/api/IncomingGameMessageConsumerExceptionHandler;)V", "channelStatus", "Lnet/rsprot/protocol/api/Session$ChannelStatus;", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "disconnectionHook", "Ljava/lang/Runnable;", "inetAddress", "Ljava/net/InetAddress;", "getInetAddress", "()Ljava/net/InetAddress;", "lastFlush", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "J", "getLoginBlock", "()Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "outgoingMessageQueues", "", "[Ljava/util/Queue;", "addIncomingMessage", "", "incomingGameMessage", "addIncomingMessage$osrs_223_api", "checkIdle", "clear", "flush", "incrementCounter", "incrementCounter$osrs_223_api", "isFull", "", "isFull$osrs_223_api", "onPollComplete", "pollIncomingMessage", "processIncomingPackets", "", "receiver", "(Ljava/lang/Object;)I", "queue", "message", "category", "Lnet/rsprot/protocol/ServerProtCategory;", "requestClose", "resumeReading", "resumeReading$osrs_223_api", "setDisconnectionHook", "hook", "setReadStatus", "stopReading", "stopReading$osrs_223_api", "triggerIdleClosing", "triggerIdleClosing$osrs_223_api", "updateLastFlush", "writeAndFlush", "ChannelStatus", "Companion", "osrs-223-api"})
@SourceDebugExtension(value={"SMAP\nSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Session.kt\nnet/rsprot/protocol/api/Session\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,399:1\n104#2,4:400\n32#2,4:411\n56#2,4:416\n80#2,4:421\n104#2,4:426\n128#2,4:431\n32#2,4:446\n56#2,4:451\n80#2,4:456\n104#2,4:461\n128#2,4:466\n32#2,4:479\n56#2,4:484\n80#2,4:489\n104#2,4:494\n128#2,4:499\n32#2,2:512\n35#2:515\n56#2,4:517\n80#2,4:522\n104#2,4:527\n128#2,4:532\n20#3:404\n44#3,6:405\n52#3:415\n55#3:420\n58#3:425\n61#3:430\n64#3:435\n21#3:436\n20#3:439\n44#3,6:440\n52#3:450\n55#3:455\n58#3:460\n61#3:465\n64#3:470\n21#3:471\n20#3:472\n44#3,6:473\n52#3:483\n55#3:488\n58#3:493\n61#3:498\n64#3:503\n21#3:504\n20#3:505\n44#3,6:506\n52#3:516\n55#3:521\n58#3:526\n61#3:531\n64#3:536\n21#3:537\n12271#4,2:437\n1#5:514\n11#6,2:538\n*S KotlinDebug\n*F\n+ 1 Session.kt\nnet/rsprot/protocol/api/Session\n*L\n84#1:400,4\n156#1:411,4\n156#1:416,4\n156#1:421,4\n156#1:426,4\n156#1:431,4\n302#1:446,4\n302#1:451,4\n302#1:456,4\n302#1:461,4\n302#1:466,4\n313#1:479,4\n313#1:484,4\n313#1:489,4\n313#1:494,4\n313#1:499,4\n318#1:512,2\n318#1:515\n318#1:517,4\n318#1:522,4\n318#1:527,4\n318#1:532,4\n156#1:404\n156#1:405,6\n156#1:415\n156#1:420\n156#1:425\n156#1:430\n156#1:435\n156#1:436\n302#1:439\n302#1:440,6\n302#1:450\n302#1:455\n302#1:460\n302#1:465\n302#1:470\n302#1:471\n313#1:472\n313#1:473,6\n313#1:483\n313#1:488\n313#1:493\n313#1:498\n313#1:503\n313#1:504\n318#1:505\n318#1:506,6\n318#1:516\n318#1:521\n318#1:526\n318#1:531\n318#1:536\n318#1:537\n244#1:437,2\n395#1:538,2\n*E\n"})
public final class Session<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelHandlerContext ctx;
    @NotNull
    private final Queue<IncomingGameMessage> incomingMessageQueue;
    @NotNull
    private final GameMessageCounter counter;
    @NotNull
    private final Map<Class<? extends IncomingGameMessage>, MessageConsumer<R, IncomingGameMessage>> consumers;
    @NotNull
    private final List<MessageConsumer<R, IncomingGameMessage>> globalConsumers;
    @NotNull
    private final LoginBlock<?> loginBlock;
    @NotNull
    private final IncomingGameMessageConsumerExceptionHandler<R> incomingGameMessageConsumerExceptionHandler;
    @NotNull
    private final Queue<OutgoingGameMessage>[] outgoingMessageQueues;
    @NotNull
    private final InetAddress inetAddress;
    @Nullable
    private Runnable disconnectionHook;
    @NotNull
    private volatile ChannelStatus channelStatus;
    private long lastFlush;
    @NotNull
    private static final Logger logger;
    private static final long limboIdleDuration;

    public Session(@NotNull ChannelHandlerContext ctx, @NotNull Queue<IncomingGameMessage> incomingMessageQueue, @NotNull MessageQueueProvider<OutgoingGameMessage> outgoingMessageQueueProvider, @NotNull GameMessageCounter counter, @NotNull Map<Class<? extends IncomingGameMessage>, ? extends MessageConsumer<? super R, ? super IncomingGameMessage>> consumers, @NotNull List<? extends MessageConsumer<? super R, ? super IncomingGameMessage>> globalConsumers, @NotNull LoginBlock<?> loginBlock, @NotNull IncomingGameMessageConsumerExceptionHandler<R> incomingGameMessageConsumerExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(incomingMessageQueue, (String)"incomingMessageQueue");
        Intrinsics.checkNotNullParameter(outgoingMessageQueueProvider, (String)"outgoingMessageQueueProvider");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter(consumers, (String)"consumers");
        Intrinsics.checkNotNullParameter(globalConsumers, (String)"globalConsumers");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        Intrinsics.checkNotNullParameter(incomingGameMessageConsumerExceptionHandler, (String)"incomingGameMessageConsumerExceptionHandler");
        this.ctx = ctx;
        this.incomingMessageQueue = incomingMessageQueue;
        this.counter = counter;
        this.consumers = consumers;
        this.globalConsumers = globalConsumers;
        this.loginBlock = loginBlock;
        this.incomingGameMessageConsumerExceptionHandler = incomingGameMessageConsumerExceptionHandler;
        int n = 0;
        Queue[] queueArray = new Queue[2];
        Session session = this;
        while (n < 2) {
            int n2 = n++;
            queueArray[n2] = outgoingMessageQueueProvider.provide();
        }
        session.outgoingMessageQueues = queueArray;
        this.inetAddress = ChannelExtensionsKt.inetAddress(this.ctx);
        this.channelStatus = ChannelStatus.OPEN;
        this.lastFlush = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public final LoginBlock<?> getLoginBlock() {
        return this.loginBlock;
    }

    @NotNull
    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    private final void updateLastFlush() {
        this.lastFlush = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
    }

    private final void checkIdle() {
        long elapsed = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)this.lastFlush);
        if (Duration.compareTo-LRDsOJo((long)elapsed, (long)limboIdleDuration) < 0) {
            return;
        }
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.warn(String.valueOf("Connection " + this.ctx.channel() + " has gone idle in limbo, requesting channel close for '" + this.loginBlock.getUsername() + "'."));
        }
        this.triggerIdleClosing$osrs_223_api();
    }

    public final void triggerIdleClosing$osrs_223_api() {
        block1: {
            if (!this.requestClose()) break block1;
            Runnable runnable = this.disconnectionHook;
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public final void queue(@NotNull OutgoingGameMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.queue(message, message.getCategory());
    }

    public final void queue(@NotNull OutgoingGameMessage message, @NotNull ServerProtCategory category) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (this.channelStatus != ChannelStatus.OPEN) {
            return;
        }
        if (RSProtFlags.getFilterMissingPacketsInClient() && this.loginBlock.getClientType() == LoginClientType.DESKTOP && message instanceof SoundArea) {
            throw new IllegalArgumentException("SoundArea packet may only be sent as part of partial enclosed as of revision 221 on Java clients. Packet: " + message);
        }
        int categoryId = category.getId();
        Queue<OutgoingGameMessage> queue = this.outgoingMessageQueues[categoryId];
        ((Collection)queue).add(message);
        this.checkIdle();
    }

    public final int processIncomingPackets(R receiver) {
        if (this.channelStatus != ChannelStatus.OPEN) {
            return 0;
        }
        int count = 0;
        while (this.pollIncomingMessage() != null) {
            IncomingGameMessage packet;
            MessageConsumer<R, IncomingGameMessage> consumer = this.consumers.get(packet.getClass());
            if (consumer == null) {
                boolean $i$a$-checkNotNull-Session$processIncomingPackets$22 = false;
                String $i$a$-checkNotNull-Session$processIncomingPackets$22 = "Consumer for packet " + packet + " does not exist.";
                throw new IllegalStateException($i$a$-checkNotNull-Session$processIncomingPackets$22.toString());
            }
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3;
                    Logger logger;
                    boolean bl4 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.trace(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
                case 3: {
                    boolean bl3;
                    Logger logger;
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.debug(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
                case 4: {
                    boolean bl3;
                    Logger logger;
                    boolean bl6 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.info(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
                case 5: {
                    boolean bl3;
                    Logger logger;
                    boolean bl7 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.warn(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
                case 6: {
                    boolean bl3;
                    Logger logger;
                    boolean bl8 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl3 = false;
                        logger.error(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                    }
                    break;
                }
            }
            try {
                consumer.consume(receiver, packet);
            }
            catch (Throwable cause) {
                this.incomingGameMessageConsumerExceptionHandler.exceptionCaught(this, packet, cause);
            }
            if (!((Collection)this.globalConsumers).isEmpty()) {
                for (MessageConsumer<R, IncomingGameMessage> globalConsumer : this.globalConsumers) {
                    try {
                        globalConsumer.consume(receiver, packet);
                    }
                    catch (Throwable cause) {
                        this.incomingGameMessageConsumerExceptionHandler.exceptionCaught(this, packet, cause);
                    }
                }
            }
            ++count;
        }
        this.onPollComplete();
        return count;
    }

    public final void setDisconnectionHook(@NotNull Runnable hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        Runnable currentHook = this.disconnectionHook;
        if (currentHook != null) {
            throw new IllegalStateException("A disconnection hook has already been registered!");
        }
        this.disconnectionHook = hook;
        if (!this.ctx.channel().isActive() && this.requestClose()) {
            hook.run();
        }
    }

    public final boolean requestClose() {
        if (this.channelStatus != ChannelStatus.OPEN) {
            return false;
        }
        this.channelStatus = ChannelStatus.CLOSING;
        return true;
    }

    private final IncomingGameMessage pollIncomingMessage() {
        return this.incomingMessageQueue.poll();
    }

    private final void onPollComplete() {
        this.counter.reset();
        this.resumeReading$osrs_223_api();
    }

    public final void flush() {
        boolean bl;
        block6: {
            if (this.channelStatus == ChannelStatus.CLOSED) {
                return;
            }
            if (!this.ctx.channel().isActive()) {
                this.triggerIdleClosing$osrs_223_api();
                return;
            }
            Queue<OutgoingGameMessage>[] $this$all$iv = this.outgoingMessageQueues;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                Queue<OutgoingGameMessage> element$iv;
                Queue<OutgoingGameMessage> p0 = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (p0.isEmpty()) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            return;
        }
        this.updateLastFlush();
        EventLoop eventLoop = this.ctx.channel().eventLoop();
        if (eventLoop.inEventLoop()) {
            this.writeAndFlush();
        } else {
            eventLoop.execute(() -> Session.flush$lambda$3(this));
        }
    }

    public final void clear() {
        for (Queue<OutgoingGameMessage> queue : this.outgoingMessageQueues) {
            for (OutgoingGameMessage message : queue) {
                if (!(message instanceof ReferenceCounted) || ((ReferenceCounted)message).refCnt() <= 0) continue;
                ReferenceCountUtil.safeRelease((Object)message);
            }
            queue.clear();
        }
        for (IncomingGameMessage message : this.incomingMessageQueue) {
            if (!(message instanceof ReferenceCounted) || ((ReferenceCounted)message).refCnt() <= 0) continue;
            ReferenceCountUtil.safeRelease((Object)message);
        }
        this.incomingMessageQueue.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeAndFlush() {
        boolean bl;
        Logger logger$iv;
        Logger logger;
        block47: {
            Channel channel = this.ctx.channel();
            block24: for (Queue<OutgoingGameMessage> queue : this.outgoingMessageQueues) {
                while (channel.isWritable()) {
                    OutgoingGameMessage next;
                    if (queue.poll() == null) continue block24;
                    Logger logger$iv2 = Session.logger;
                    boolean bl2 = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl3 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl4;
                            boolean bl5 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl4 = false;
                                logger.trace(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl4;
                            boolean bl6 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl4 = false;
                                logger.debug(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl4;
                            boolean bl7 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl4 = false;
                                logger.info(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl4;
                            boolean bl8 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl4 = false;
                                logger.warn(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl4;
                            boolean bl9 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                bl4 = false;
                                logger.error(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                            }
                            break;
                        }
                    }
                    channel.write((Object)next, channel.voidPromise());
                }
                break block24;
            }
            channel.flush();
            if (this.channelStatus != ChannelStatus.CLOSING) break block47;
            this.channelStatus = ChannelStatus.CLOSED;
            channel.close();
            this.clear();
            logger$iv = Session.logger;
            bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl10 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl11 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl12 = false;
                        logger.trace(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
                case 3: {
                    boolean bl13 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl14 = false;
                        logger.debug(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
                case 4: {
                    boolean bl15 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl16 = false;
                        logger.info(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
                case 5: {
                    boolean bl17 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl18 = false;
                        logger.warn(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
                case 6: {
                    boolean bl19 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl20 = false;
                        logger.error(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                    }
                    break;
                }
            }
            return;
        }
        logger$iv = Session.logger;
        bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl21 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                int n;
                int n2;
                boolean bl22 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    boolean bl23 = false;
                    Queue<OutgoingGameMessage>[] queueArray = this.outgoingMessageQueues;
                    int n3 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        void p0;
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> queue2 = queue = queueArray[n];
                        int n4 = n3;
                        boolean bl24 = false;
                        int n5 = p0.size();
                        n3 = n4 + n5;
                    }
                    int leftoverPackets = n3;
                    logger.trace(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
            case 3: {
                int n;
                int n2;
                boolean bl25 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    boolean bl26 = false;
                    Queue<OutgoingGameMessage>[] queueArray = this.outgoingMessageQueues;
                    int n6 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> p0 = queue = queueArray[n];
                        int n7 = n6;
                        boolean bl27 = false;
                        int n8 = p0.size();
                        n6 = n7 + n8;
                    }
                    int leftoverPackets = n6;
                    logger.debug(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
            case 4: {
                int n;
                int n2;
                boolean bl28 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    boolean bl29 = false;
                    Queue<OutgoingGameMessage>[] queueArray = this.outgoingMessageQueues;
                    int n9 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> p0 = queue = queueArray[n];
                        int n10 = n9;
                        boolean bl30 = false;
                        int n11 = p0.size();
                        n9 = n10 + n11;
                    }
                    int leftoverPackets = n9;
                    logger.info(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
            case 5: {
                int n;
                int n2;
                boolean bl31 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    boolean bl32 = false;
                    Queue<OutgoingGameMessage>[] queueArray = this.outgoingMessageQueues;
                    int n12 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> p0 = queue = queueArray[n];
                        int n13 = n12;
                        boolean bl33 = false;
                        int n14 = p0.size();
                        n12 = n13 + n14;
                    }
                    int leftoverPackets = n12;
                    logger.warn(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
            case 6: {
                int n;
                int n2;
                boolean bl34 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    boolean bl35 = false;
                    Queue<OutgoingGameMessage>[] queueArray = this.outgoingMessageQueues;
                    int n15 = 0;
                    n2 = queueArray.length;
                    for (n = 0; n < n2; ++n) {
                        Queue<OutgoingGameMessage> queue;
                        Queue<OutgoingGameMessage> p0 = queue = queueArray[n];
                        int n16 = n15;
                        boolean bl36 = false;
                        int n17 = p0.size();
                        n15 = n16 + n17;
                    }
                    int leftoverPackets = n15;
                    logger.error(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
                }
                break;
            }
        }
    }

    public final void resumeReading$osrs_223_api() {
        this.setReadStatus(false);
    }

    public final void stopReading$osrs_223_api() {
        this.setReadStatus(true);
    }

    private final void setReadStatus(boolean stopReading) {
        Channel channel = this.ctx.channel();
        GameMessageDecoder gameMessageDecoder = (GameMessageDecoder)channel.pipeline().get(GameMessageDecoder.class);
        if (gameMessageDecoder == null) {
            return;
        }
        GameMessageDecoder decoder = gameMessageDecoder;
        decoder.setSingleDecode(stopReading);
        channel.config().setAutoRead(!stopReading);
    }

    public final void addIncomingMessage$osrs_223_api(@NotNull IncomingGameMessage incomingGameMessage) {
        Intrinsics.checkNotNullParameter((Object)incomingGameMessage, (String)"incomingGameMessage");
        if (this.channelStatus != ChannelStatus.OPEN) {
            return;
        }
        ((Collection)this.incomingMessageQueue).add(incomingGameMessage);
    }

    public final void incrementCounter$osrs_223_api(@NotNull IncomingGameMessage incomingGameMessage) {
        Intrinsics.checkNotNullParameter((Object)incomingGameMessage, (String)"incomingGameMessage");
        if (this.channelStatus != ChannelStatus.OPEN) {
            return;
        }
        this.counter.increment(incomingGameMessage.getCategory());
    }

    public final boolean isFull$osrs_223_api() {
        return this.counter.isFull();
    }

    private static final void flush$lambda$3(Session this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writeAndFlush();
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
        limboIdleDuration = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/Session$ChannelStatus;", "", "(Ljava/lang/String;I)V", "OPEN", "CLOSING", "CLOSED", "osrs-223-api"})
    private static final class ChannelStatus
    extends Enum<ChannelStatus> {
        public static final /* enum */ ChannelStatus OPEN = new ChannelStatus();
        public static final /* enum */ ChannelStatus CLOSING = new ChannelStatus();
        public static final /* enum */ ChannelStatus CLOSED = new ChannelStatus();
        private static final /* synthetic */ ChannelStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChannelStatus[] values() {
            return (ChannelStatus[])$VALUES.clone();
        }

        public static ChannelStatus valueOf(String value) {
            return Enum.valueOf(ChannelStatus.class, value);
        }

        @NotNull
        public static EnumEntries<ChannelStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = channelStatusArray = new ChannelStatus[]{ChannelStatus.OPEN, ChannelStatus.CLOSING, ChannelStatus.CLOSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\t"}, d2={"Lnet/rsprot/protocol/api/Session$Companion;", "", "()V", "limboIdleDuration", "Lkotlin/time/Duration;", "J", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-223-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

