/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.common.js5.outgoing.codec;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.protocol.ServerProt;
import net.rsprot.protocol.common.js5.outgoing.prot.Js5ServerProt;
import net.rsprot.protocol.js5.outgoing.Js5GroupResponse;
import net.rsprot.protocol.message.codec.MessageEncoder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/common/js5/outgoing/codec/Js5GroupResponseEncoder;", "Lnet/rsprot/protocol/message/codec/MessageEncoder;", "Lnet/rsprot/protocol/js5/outgoing/Js5GroupResponse;", "()V", "prot", "Lnet/rsprot/protocol/ServerProt;", "getProt", "()Lnet/rsprot/protocol/ServerProt;", "encode", "", "streamCipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "buffer", "Lnet/rsprot/buffer/JagByteBuf;", "message", "encode-WFbGaZ8", "(Lnet/rsprot/crypto/cipher/StreamCipher;Lio/netty/buffer/ByteBuf;Lnet/rsprot/protocol/js5/outgoing/Js5GroupResponse;)V", "Companion", "osrs-222-shared"})
@SourceDebugExtension(value={"SMAP\nJs5GroupResponseEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Js5GroupResponseEncoder.kt\nnet/rsprot/protocol/common/js5/outgoing/codec/Js5GroupResponseEncoder\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,60:1\n104#2,4:61\n56#2,4:65\n11#3,2:69\n*S KotlinDebug\n*F\n+ 1 Js5GroupResponseEncoder.kt\nnet/rsprot/protocol/common/js5/outgoing/codec/Js5GroupResponseEncoder\n*L\n30#1:61,4\n37#1:65,4\n57#1:69,2\n*E\n"})
public final class Js5GroupResponseEncoder
implements MessageEncoder<Js5GroupResponse> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerProt prot = Js5ServerProt.JS5_GROUP_RESPONSE;
    private static volatile boolean validatedBufferCompatibility;
    @NotNull
    private static final Logger logger;

    @NotNull
    public ServerProt getProt() {
        return this.prot;
    }

    public void encode-WFbGaZ8(@NotNull StreamCipher streamCipher, @NotNull ByteBuf buffer, @NotNull Js5GroupResponse message) {
        Intrinsics.checkNotNullParameter((Object)streamCipher, (String)"streamCipher");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int offset = message.getOffset();
        int length = message.getLength();
        ByteBuf messageBuf = message.content();
        if (!validatedBufferCompatibility) {
            Logger logger;
            Logger arg0$iv;
            boolean isMessageDirect;
            validatedBufferCompatibility = true;
            boolean isPipelineDirect = buffer.isDirect();
            if (isPipelineDirect != (isMessageDirect = messageBuf.isDirect())) {
                arg0$iv = Js5GroupResponseEncoder.logger;
                boolean bl = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                    logger = arg0$iv;
                    boolean bl2 = false;
                    logger.warn(String.valueOf("Incompatible JS5 buffer types; pipeline is direct: " + isPipelineDirect + ", message is direct: " + isMessageDirect + "; Using incompatible types means there is a more expensive copying occurring each time a buffer is written out."));
                }
            } else {
                arg0$iv = Js5GroupResponseEncoder.logger;
                boolean bl = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
                    logger = arg0$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Using compatible JS5 buffer types (direct: " + isPipelineDirect + ")"));
                }
            }
        }
        if (message.getKey() != 0) {
            ByteBuf out = buffer;
            for (int i = 0; i < length; ++i) {
                out.writeByte(messageBuf.getByte(offset + i) ^ message.getKey());
            }
        } else {
            buffer.writeBytes(messageBuf, offset, length);
        }
    }

    public boolean getEncryptedPayload() {
        return MessageEncoder.DefaultImpls.getEncryptedPayload((MessageEncoder)this);
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lnet/rsprot/protocol/common/js5/outgoing/codec/Js5GroupResponseEncoder$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "validatedBufferCompatibility", "", "osrs-222-shared"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

