/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.npcinfo;

import io.netty.buffer.ByteBufAllocator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.compression.provider.HuffmanCodecProvider;
import net.rsprot.protocol.game.outgoing.info.AvatarExtendedInfoWriter;
import net.rsprot.protocol.game.outgoing.info.filter.ExtendedInfoFilter;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatar;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarExtendedInfo;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarExtendedInfoBlocks;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoProtocol;
import net.rsprot.protocol.internal.game.outgoing.info.CoordGrid;
import net.rsprot.protocol.internal.game.outgoing.info.npcinfo.NpcAvatarDetails;
import net.rsprot.protocol.internal.game.outgoing.info.npcinfo.encoder.NpcExtendedInfoEncoders;
import net.rsprot.protocol.internal.game.outgoing.info.util.ZoneIndexStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010JB\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u00192\b\b\u0002\u0010\u001f\u001a\u00020\u0019J\u0010\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository;", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "extendedInfoFilter", "Lnet/rsprot/protocol/game/outgoing/info/filter/ExtendedInfoFilter;", "extendedInfoWriter", "", "Lnet/rsprot/protocol/game/outgoing/info/AvatarExtendedInfoWriter;", "Lnet/rsprot/protocol/internal/game/outgoing/info/npcinfo/encoder/NpcExtendedInfoEncoders;", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExtendedInfoBlocks;", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExtendedInfoWriter;", "huffmanCodec", "Lnet/rsprot/compression/provider/HuffmanCodecProvider;", "zoneIndexStorage", "Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/game/outgoing/info/filter/ExtendedInfoFilter;Ljava/util/List;Lnet/rsprot/compression/provider/HuffmanCodecProvider;Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;)V", "elements", "", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatar;", "[Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatar;", "queue", "Ljava/lang/ref/ReferenceQueue;", "getOrAlloc", "index", "", "id", "level", "x", "z", "spawnCycle", "direction", "getOrNull", "idx", "release", "", "avatar", "resetTransientDetails", "details", "Lnet/rsprot/protocol/internal/game/outgoing/info/npcinfo/NpcAvatarDetails;", "Companion", "osrs-222-model"})
public final class NpcAvatarRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final ExtendedInfoFilter extendedInfoFilter;
    @NotNull
    private final List<AvatarExtendedInfoWriter<NpcExtendedInfoEncoders, NpcAvatarExtendedInfoBlocks>> extendedInfoWriter;
    @NotNull
    private final HuffmanCodecProvider huffmanCodec;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final NpcAvatar[] elements;
    @NotNull
    private final ReferenceQueue<NpcAvatar> queue;
    public static final int AVATAR_CAPACITY = 65536;

    public NpcAvatarRepository(@NotNull ByteBufAllocator allocator, @NotNull ExtendedInfoFilter extendedInfoFilter, @NotNull List<? extends AvatarExtendedInfoWriter<NpcExtendedInfoEncoders, NpcAvatarExtendedInfoBlocks>> extendedInfoWriter, @NotNull HuffmanCodecProvider huffmanCodec, @NotNull ZoneIndexStorage zoneIndexStorage) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)extendedInfoFilter, (String)"extendedInfoFilter");
        Intrinsics.checkNotNullParameter(extendedInfoWriter, (String)"extendedInfoWriter");
        Intrinsics.checkNotNullParameter((Object)huffmanCodec, (String)"huffmanCodec");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        this.allocator = allocator;
        this.extendedInfoFilter = extendedInfoFilter;
        this.extendedInfoWriter = extendedInfoWriter;
        this.huffmanCodec = huffmanCodec;
        this.zoneIndexStorage = zoneIndexStorage;
        this.elements = new NpcAvatar[65536];
        this.queue = new ReferenceQueue();
    }

    @Nullable
    public final NpcAvatar getOrNull(int idx) {
        return this.elements[idx];
    }

    @NotNull
    public final NpcAvatar getOrAlloc(int index, int id, int level, int x, int z, int spawnCycle, int direction) {
        NpcAvatar existing;
        NpcAvatar old = this.elements[index];
        if (!(old == null)) {
            boolean $i$a$-require-NpcAvatarRepository$getOrAlloc$22 = false;
            String $i$a$-require-NpcAvatarRepository$getOrAlloc$22 = "NPC Avatar with index " + index + " is already allocated: " + old;
            throw new IllegalArgumentException($i$a$-require-NpcAvatarRepository$getOrAlloc$22.toString());
        }
        Reference<NpcAvatar> reference = this.queue.poll();
        NpcAvatar npcAvatar = existing = reference != null ? reference.get() : null;
        if (existing != null) {
            existing.resetObservers$osrs_222_model();
            NpcAvatarDetails details = existing.getDetails$osrs_222_model();
            this.resetTransientDetails(details);
            details.setIndex(index);
            details.setId(id);
            details.setCurrentCoord-1IQ_v9c(CoordGrid.constructor-impl((int)level, (int)x, (int)z));
            details.setSpawnCycle(spawnCycle);
            details.setDirection(direction);
            details.setAllocateCycle(NpcInfoProtocol.Companion.getCycleCount$osrs_222_model());
            this.zoneIndexStorage.add-262OtJs(index, details.getCurrentCoord-aQXte_c());
            this.elements[index] = existing;
            return existing;
        }
        NpcAvatarExtendedInfo extendedInfo = new NpcAvatarExtendedInfo(index, this.extendedInfoFilter, this.extendedInfoWriter, this.allocator, this.huffmanCodec);
        NpcAvatar avatar = new NpcAvatar(index, id, level, x, z, spawnCycle, direction, NpcInfoProtocol.Companion.getCycleCount$osrs_222_model(), extendedInfo, this.zoneIndexStorage);
        this.zoneIndexStorage.add-262OtJs(index, avatar.getDetails$osrs_222_model().getCurrentCoord-aQXte_c());
        this.elements[index] = avatar;
        return avatar;
    }

    public static /* synthetic */ NpcAvatar getOrAlloc$default(NpcAvatarRepository npcAvatarRepository, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        if ((n8 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x40) != 0) {
            n7 = 0;
        }
        return npcAvatarRepository.getOrAlloc(n, n2, n3, n4, n5, n6, n7);
    }

    public final void release(@NotNull NpcAvatar avatar) {
        Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
        int index = avatar.getDetails$osrs_222_model().getIndex();
        if (!(this.elements[index] == avatar)) {
            boolean bl = false;
            String string = "Attempting to release an invalid NPC avatar: " + avatar + ", " + this.elements[index];
            throw new IllegalArgumentException(string.toString());
        }
        this.zoneIndexStorage.remove-262OtJs(index, avatar.getDetails$osrs_222_model().getCurrentCoord-aQXte_c());
        this.elements[index] = null;
        avatar.getExtendedInfo().reset$osrs_222_model();
        SoftReference<NpcAvatar> reference = new SoftReference<NpcAvatar>(avatar, this.queue);
        reference.enqueue();
    }

    private final void resetTransientDetails(NpcAvatarDetails details) {
        details.setStepCount(0);
        details.setFirstStep(-1);
        details.setSecondStep(-1);
        details.setMovementType(0);
        details.setInaccessible(false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository$Companion;", "", "()V", "AVATAR_CAPACITY", "", "osrs-222-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

