/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.npcinfo;

import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.buffer.bitbuffer.UnsafeLongBackedBitBuf;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarExtendedInfo;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarTracker;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoProtocol;
import net.rsprot.protocol.game.outgoing.info.npcinfo.util.NpcCellOpcodes;
import net.rsprot.protocol.game.outgoing.info.util.Avatar;
import net.rsprot.protocol.internal.game.outgoing.info.CoordGrid;
import net.rsprot.protocol.internal.game.outgoing.info.npcinfo.NpcAvatarDetails;
import net.rsprot.protocol.internal.game.outgoing.info.util.ZoneIndexStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B[\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\"J\u0016\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0003J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(J\u0006\u0010)\u001a\u00020*J\u0006\u0010\u0005\u001a\u00020\u0003J\u0018\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0017H\u0002J\u0018\u0010/\u001a\u00020!2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020*H\u0002J\u0018\u00100\u001a\u00020!2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020*H\u0002J\b\u00101\u001a\u00020!H\u0016J\r\u00102\u001a\u00020!H\u0000\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b5J\r\u00106\u001a\u00020!H\u0000\u00a2\u0006\u0002\b7J\u000e\u00108\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u00109\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020*J \u0010<\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0002J&\u0010>\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010?\u001a\u00020*J\b\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u0003H\u0007J\u0016\u0010C\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\u0003R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006D"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatar;", "Lnet/rsprot/protocol/game/outgoing/info/util/Avatar;", "index", "", "id", "level", "x", "z", "spawnCycle", "direction", "allocateCycle", "extendedInfo", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExtendedInfo;", "zoneIndexStorage", "Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;", "(IIIIIIIILnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExtendedInfo;Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;)V", "details", "Lnet/rsprot/protocol/internal/game/outgoing/info/npcinfo/NpcAvatarDetails;", "getDetails$osrs_222_model", "()Lnet/rsprot/protocol/internal/game/outgoing/info/npcinfo/NpcAvatarDetails;", "getExtendedInfo", "()Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExtendedInfo;", "highResMovementBuffer", "Lnet/rsprot/buffer/bitbuffer/UnsafeLongBackedBitBuf;", "getHighResMovementBuffer$osrs_222_model", "()Lnet/rsprot/buffer/bitbuffer/UnsafeLongBackedBitBuf;", "setHighResMovementBuffer$osrs_222_model", "(Lnet/rsprot/buffer/bitbuffer/UnsafeLongBackedBitBuf;)V", "tracker", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarTracker;", "getZoneIndexStorage$osrs_222_model", "()Lnet/rsprot/protocol/internal/game/outgoing/info/util/ZoneIndexStorage;", "addObserver", "", "addObserver$osrs_222_model", "crawl", "deltaX", "deltaZ", "getObserverCount", "getObservingPlayerIndices", "", "isActive", "", "pCrawl", "buffer", "pExtendedInfo", "pNoUpdate", "pRun", "pWalk", "postUpdate", "prepareBitcodes", "prepareBitcodes$osrs_222_model", "removeObserver", "removeObserver$osrs_222_model", "resetObservers", "resetObservers$osrs_222_model", "setDirection", "setId", "setInaccessible", "inaccessible", "singleStepMovement", "flag", "teleport", "jump", "toString", "", "updateDirection", "walk", "osrs-222-model"})
public final class NpcAvatar
implements Avatar {
    @NotNull
    private final NpcAvatarExtendedInfo extendedInfo;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final NpcAvatarDetails details;
    @NotNull
    private final NpcAvatarTracker tracker;
    @Nullable
    private UnsafeLongBackedBitBuf highResMovementBuffer;

    public NpcAvatar(int index, int id, int level, int x, int z, int spawnCycle, int direction, int allocateCycle, @NotNull NpcAvatarExtendedInfo extendedInfo, @NotNull ZoneIndexStorage zoneIndexStorage) {
        Intrinsics.checkNotNullParameter((Object)extendedInfo, (String)"extendedInfo");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        this.extendedInfo = extendedInfo;
        this.zoneIndexStorage = zoneIndexStorage;
        this.details = new NpcAvatarDetails(index, id, level, x, z, spawnCycle, direction, allocateCycle);
        this.tracker = new NpcAvatarTracker();
    }

    public /* synthetic */ NpcAvatar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, NpcAvatarExtendedInfo npcAvatarExtendedInfo, ZoneIndexStorage zoneIndexStorage, int n9, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n9 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n9 & 0x40) != 0) {
            n7 = 0;
        }
        this(n, n2, n3, n4, n5, n6, n7, n8, npcAvatarExtendedInfo, zoneIndexStorage);
    }

    @NotNull
    public final NpcAvatarExtendedInfo getExtendedInfo() {
        return this.extendedInfo;
    }

    @NotNull
    public final ZoneIndexStorage getZoneIndexStorage$osrs_222_model() {
        return this.zoneIndexStorage;
    }

    @NotNull
    public final NpcAvatarDetails getDetails$osrs_222_model() {
        return this.details;
    }

    @Nullable
    public final UnsafeLongBackedBitBuf getHighResMovementBuffer$osrs_222_model() {
        return this.highResMovementBuffer;
    }

    public final void setHighResMovementBuffer$osrs_222_model(@Nullable UnsafeLongBackedBitBuf unsafeLongBackedBitBuf) {
        this.highResMovementBuffer = unsafeLongBackedBitBuf;
    }

    public final void addObserver$osrs_222_model(int index) {
        this.tracker.add(index);
    }

    public final void removeObserver$osrs_222_model(int index) {
        if (this.details.getAllocateCycle() == NpcInfoProtocol.Companion.getCycleCount$osrs_222_model()) {
            return;
        }
        this.tracker.remove(index);
    }

    public final void resetObservers$osrs_222_model() {
        this.tracker.reset();
    }

    @Deprecated(message="Deprecated. Use setDirection(direction) for consistency.", replaceWith=@ReplaceWith(expression="setDirection(direction)", imports={}))
    public final void updateDirection(int direction) {
        this.setDirection(direction);
    }

    public final void setDirection(int direction) {
        if (!(0 <= direction ? direction < 8 : false)) {
            boolean bl = false;
            String string = "Direction must be a value in range of 0..7. See the table in documentation. Value: " + direction;
            throw new IllegalArgumentException(string.toString());
        }
        this.details.updateDirection(direction);
    }

    public final void setId(int id) {
        if (!(0 <= id ? id < 16384 : false)) {
            boolean bl = false;
            String string = "Id must be a value in range of 0..16383. Value: " + id;
            throw new IllegalArgumentException(string.toString());
        }
        this.details.setId(id);
    }

    public final void teleport(int level, int x, int z, boolean jump) {
        int nextCoord = CoordGrid.constructor-impl((int)level, (int)x, (int)z);
        this.zoneIndexStorage.move-cM_695g(this.details.getIndex(), this.details.getCurrentCoord-aQXte_c(), nextCoord);
        this.details.setCurrentCoord-1IQ_v9c(nextCoord);
        this.details.setMovementType(this.details.getMovementType() | (jump ? 16 : 8));
    }

    public final void crawl(int deltaX, int deltaZ) throws ArrayIndexOutOfBoundsException {
        this.singleStepMovement(deltaX, deltaZ, 1);
    }

    public final void walk(int deltaX, int deltaZ) throws ArrayIndexOutOfBoundsException {
        this.singleStepMovement(deltaX, deltaZ, 2);
    }

    private final void singleStepMovement(int deltaX, int deltaZ, int flag) throws ArrayIndexOutOfBoundsException {
        int opcode = NpcCellOpcodes.INSTANCE.singleCellMovementOpcode$osrs_222_model(deltaX, deltaZ);
        int n = this.details.getCurrentCoord-aQXte_c();
        int level = CoordGrid.component1-impl((int)n);
        int x = CoordGrid.component2-impl((int)n);
        int z = CoordGrid.component3-impl((int)n);
        int nextCoord = CoordGrid.constructor-impl((int)level, (int)(x + deltaX), (int)(z + deltaZ));
        this.zoneIndexStorage.move-cM_695g(this.details.getIndex(), this.details.getCurrentCoord-aQXte_c(), nextCoord);
        this.details.setCurrentCoord-1IQ_v9c(nextCoord);
        NpcAvatarDetails npcAvatarDetails = this.details;
        npcAvatarDetails.setStepCount(npcAvatarDetails.getStepCount() + 1);
        switch (npcAvatarDetails.getStepCount()) {
            case 1: {
                this.details.setFirstStep(opcode);
                this.details.setMovementType(this.details.getMovementType() | flag);
                break;
            }
            case 2: {
                this.details.setSecondStep(opcode);
                this.details.setMovementType(this.details.getMovementType() | 4);
                break;
            }
            default: {
                this.details.setMovementType(this.details.getMovementType() | 8);
            }
        }
    }

    public final void prepareBitcodes$osrs_222_model() {
        boolean extendedInfo;
        UnsafeLongBackedBitBuf buffer;
        int movementType = this.details.getMovementType();
        if ((movementType & 0x18) != 0 || !this.tracker.hasObservers()) {
            return;
        }
        this.highResMovementBuffer = buffer = new UnsafeLongBackedBitBuf();
        boolean bl = extendedInfo = this.extendedInfo.getFlags$osrs_222_model() != 0;
        if ((movementType & 4) != 0) {
            this.pRun(buffer, extendedInfo);
        } else if ((movementType & 2) != 0) {
            this.pWalk(buffer, extendedInfo);
        } else if ((movementType & 1) != 0) {
            this.pCrawl(buffer, extendedInfo);
        } else if (extendedInfo) {
            this.pExtendedInfo(buffer);
        } else {
            this.pNoUpdate(buffer);
        }
    }

    private final void pNoUpdate(UnsafeLongBackedBitBuf buffer) {
        buffer.pBits(1, 0);
    }

    private final void pExtendedInfo(UnsafeLongBackedBitBuf buffer) {
        buffer.pBits(1, 1);
        buffer.pBits(2, 0);
    }

    private final void pCrawl(UnsafeLongBackedBitBuf buffer, boolean extendedInfo) {
        buffer.pBits(1, 1);
        buffer.pBits(2, 2);
        buffer.pBits(1, 0);
        buffer.pBits(3, this.details.getFirstStep());
        buffer.pBits(1, extendedInfo ? 1 : 0);
    }

    private final void pWalk(UnsafeLongBackedBitBuf buffer, boolean extendedInfo) {
        buffer.pBits(1, 1);
        buffer.pBits(2, 1);
        buffer.pBits(3, this.details.getFirstStep());
        buffer.pBits(1, extendedInfo ? 1 : 0);
    }

    private final void pRun(UnsafeLongBackedBitBuf buffer, boolean extendedInfo) {
        buffer.pBits(1, 1);
        buffer.pBits(2, 2);
        buffer.pBits(1, 1);
        buffer.pBits(3, this.details.getFirstStep());
        buffer.pBits(3, this.details.getSecondStep());
        buffer.pBits(1, extendedInfo ? 1 : 0);
    }

    public final int level() {
        return CoordGrid.getLevel-impl((int)this.details.getCurrentCoord-aQXte_c());
    }

    public final int x() {
        return CoordGrid.getX-impl((int)this.details.getCurrentCoord-aQXte_c());
    }

    public final int z() {
        return CoordGrid.getZ-impl((int)this.details.getCurrentCoord-aQXte_c());
    }

    public final void setInaccessible(boolean inaccessible) {
        this.details.setInaccessible(inaccessible);
    }

    public final boolean isActive() {
        return this.tracker.hasObservers();
    }

    public final int getObserverCount() {
        return this.tracker.getObserverCount();
    }

    @NotNull
    public final Set<Integer> getObservingPlayerIndices() {
        return this.tracker.getCachedSet();
    }

    @Override
    public void postUpdate() {
        this.details.setStepCount(0);
        this.details.setFirstStep(-1);
        this.details.setSecondStep(-1);
        this.details.setMovementType(0);
        this.extendedInfo.postUpdate$osrs_222_model();
    }

    @NotNull
    public String toString() {
        return "NpcAvatar(extendedInfo=" + this.extendedInfo + ", details=" + this.details + ", tracker=" + this.tracker + ", highResMovementBuffer=" + this.highResMovementBuffer + ")";
    }
}

