/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.map.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.rsprot.crypto.xtea.XteaKey;
import net.rsprot.protocol.game.outgoing.map.util.XteaProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"buildXteaKeyList", "", "Lnet/rsprot/crypto/xtea/XteaKey;", "zoneX", "", "zoneZ", "keyProvider", "Lnet/rsprot/protocol/game/outgoing/map/util/XteaProvider;", "osrs-222-model"})
public final class XteaHelperKt {
    @NotNull
    public static final List<XteaKey> buildXteaKeyList(int zoneX, int zoneZ, @NotNull XteaProvider keyProvider) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        int minMapsquareX = RangesKt.coerceAtLeast((int)(zoneX - 6), (int)0) >>> 3;
        int maxMapsquareX = RangesKt.coerceAtMost((int)(zoneX + 6), (int)2047) >>> 3;
        int minMapsquareZ = RangesKt.coerceAtLeast((int)(zoneZ - 6), (int)0) >>> 3;
        int maxMapsquareZ = RangesKt.coerceAtMost((int)(zoneZ + 6), (int)2047) >>> 3;
        int count = (maxMapsquareX - minMapsquareX + 1) * (maxMapsquareZ - minMapsquareZ + 1);
        ArrayList keys = new ArrayList(RangesKt.coerceIn((int)count, (int)4, (int)9));
        int mapsquareX = minMapsquareX;
        if (mapsquareX <= maxMapsquareX) {
            while (true) {
                int mapsquareZ;
                if ((mapsquareZ = minMapsquareZ) <= maxMapsquareZ) {
                    while (true) {
                        ((Collection)keys).add(keyProvider.provide(mapsquareX << 8 | mapsquareZ));
                        if (mapsquareZ == maxMapsquareZ) break;
                        ++mapsquareZ;
                    }
                }
                if (mapsquareX == maxMapsquareX) break;
                ++mapsquareX;
            }
        }
        return keys;
    }
}

