/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.map;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ServerProtCategory;
import net.rsprot.protocol.game.outgoing.GameServerProtCategory;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerInfo;
import net.rsprot.protocol.game.outgoing.map.util.RebuildRegionZone;
import net.rsprot.protocol.message.OutgoingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 $2\u00020\u0001:\u0002$%B?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB7\b\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016R\u0016\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006&"}, d2={"Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntity;", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "index", "", "baseX", "baseZ", "sizeX", "sizeZ", "zoneProvider", "Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntity$RebuildWorldEntityZoneProvider;", "playerInfo", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfo;", "(IIIIILnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntity$RebuildWorldEntityZoneProvider;Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfo;)V", "_index", "Lkotlin/UShort;", "_baseX", "_baseZ", "zones", "", "Lnet/rsprot/protocol/game/outgoing/map/util/RebuildRegionZone;", "gpiInitBlock", "Lio/netty/buffer/ByteBuf;", "(SSSLjava/util/List;Lio/netty/buffer/ByteBuf;)V", "S", "getBaseX", "()I", "getBaseZ", "category", "Lnet/rsprot/protocol/ServerProtCategory;", "getCategory", "()Lnet/rsprot/protocol/ServerProtCategory;", "getGpiInitBlock", "()Lio/netty/buffer/ByteBuf;", "getIndex", "getZones", "()Ljava/util/List;", "Companion", "RebuildWorldEntityZoneProvider", "osrs-222-model"})
public final class RebuildWorldEntity
implements OutgoingGameMessage {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final short _index;
    private final short _baseX;
    private final short _baseZ;
    @NotNull
    private final List<RebuildRegionZone> zones;
    @NotNull
    private final ByteBuf gpiInitBlock;
    private static final int PLAYER_INFO_BLOCK_SIZE = 4608;

    private RebuildWorldEntity(short _index, short _baseX, short _baseZ, List<RebuildRegionZone> zones, ByteBuf gpiInitBlock) {
        this._index = _index;
        this._baseX = _baseX;
        this._baseZ = _baseZ;
        this.zones = zones;
        this.gpiInitBlock = gpiInitBlock;
    }

    @NotNull
    public final List<RebuildRegionZone> getZones() {
        return this.zones;
    }

    @NotNull
    public final ByteBuf getGpiInitBlock() {
        return this.gpiInitBlock;
    }

    public RebuildWorldEntity(int index, int baseX, int baseZ, int sizeX, int sizeZ, @NotNull RebuildWorldEntityZoneProvider zoneProvider, @NotNull PlayerInfo playerInfo) {
        Intrinsics.checkNotNullParameter((Object)zoneProvider, (String)"zoneProvider");
        Intrinsics.checkNotNullParameter((Object)playerInfo, (String)"playerInfo");
        this(UShort.constructor-impl((short)((short)index)), UShort.constructor-impl((short)((short)baseX)), UShort.constructor-impl((short)((short)baseZ)), RebuildWorldEntity.Companion.buildRebuildWorldEntityZones(index, sizeX, sizeZ, zoneProvider), RebuildWorldEntity.Companion.initializePlayerInfo(playerInfo, index));
        if (!(0 <= sizeX ? sizeX < 13 : false)) {
            boolean $i$a$-require-RebuildWorldEntity$62 = false;
            String $i$a$-require-RebuildWorldEntity$62 = "Size x must be in range of 0..<13: " + sizeX;
            throw new IllegalArgumentException($i$a$-require-RebuildWorldEntity$62.toString());
        }
        if (!(0 <= sizeZ ? sizeZ < 13 : false)) {
            boolean $i$a$-require-RebuildWorldEntity$72 = false;
            String $i$a$-require-RebuildWorldEntity$72 = "Size z must be in range of 0..<13: " + sizeZ;
            throw new IllegalArgumentException($i$a$-require-RebuildWorldEntity$72.toString());
        }
        if (!(0 <= index ? index < 2048 : false)) {
            boolean $i$a$-require-RebuildWorldEntity$82 = false;
            String $i$a$-require-RebuildWorldEntity$82 = "Index must be in range of 0..<2048";
            throw new IllegalArgumentException($i$a$-require-RebuildWorldEntity$82.toString());
        }
        if (!(0 <= baseX ? baseX < 16384 : false)) {
            boolean $i$a$-require-RebuildWorldEntity$92 = false;
            String $i$a$-require-RebuildWorldEntity$92 = "Base x must be in range of 0..<16384";
            throw new IllegalArgumentException($i$a$-require-RebuildWorldEntity$92.toString());
        }
        if (!(0 <= baseZ ? baseZ < 16384 : false)) {
            boolean bl = false;
            String string = "Base z must be in range of 0..<16384";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getIndex() {
        return this._index & 0xFFFF;
    }

    public final int getBaseX() {
        return this._baseX & 0xFFFF;
    }

    public final int getBaseZ() {
        return this._baseZ & 0xFFFF;
    }

    @NotNull
    public ServerProtCategory getCategory() {
        return GameServerProtCategory.HIGH_PRIORITY_PROT;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntity$Companion;", "", "()V", "PLAYER_INFO_BLOCK_SIZE", "", "buildRebuildWorldEntityZones", "", "Lnet/rsprot/protocol/game/outgoing/map/util/RebuildRegionZone;", "index", "sizeX", "sizeZ", "zoneProvider", "Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntity$RebuildWorldEntityZoneProvider;", "initializePlayerInfo", "Lio/netty/buffer/ByteBuf;", "playerInfo", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfo;", "worldId", "osrs-222-model"})
    private static final class Companion {
        private Companion() {
        }

        private final List<RebuildRegionZone> buildRebuildWorldEntityZones(int index, int sizeX, int sizeZ, RebuildWorldEntityZoneProvider zoneProvider) {
            ArrayList zones = new ArrayList(4 * sizeX * sizeZ);
            for (int level = 0; level < 4; ++level) {
                for (int zoneX = 0; zoneX < sizeX; ++zoneX) {
                    for (int zoneZ = 0; zoneZ < sizeZ; ++zoneZ) {
                        ((Collection)zones).add(zoneProvider.provide(index, zoneX, zoneZ, level));
                    }
                }
            }
            return zones;
        }

        private final ByteBuf initializePlayerInfo(PlayerInfo playerInfo, int worldId) {
            ByteBufAllocator allocator = playerInfo.getAllocator$osrs_222_model();
            ByteBuf buffer = allocator.buffer(4608);
            Intrinsics.checkNotNull((Object)buffer);
            playerInfo.handleAbsolutePlayerPositions(worldId, buffer);
            return buffer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntity$RebuildWorldEntityZoneProvider;", "", "getMapsquareId", "", "zoneX", "zoneZ", "provide", "Lnet/rsprot/protocol/game/outgoing/map/util/RebuildRegionZone;", "index", "level", "osrs-222-model"})
    public static interface RebuildWorldEntityZoneProvider {
        @Nullable
        public RebuildRegionZone provide(int var1, int var2, int var3, int var4);

        default public int getMapsquareId(int zoneX, int zoneZ) {
            return (zoneX & 0x7FF) >>> 3 << 8 | (zoneZ & 0x7FF) >>> 3;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static int getMapsquareId(@NotNull RebuildWorldEntityZoneProvider $this, int zoneX, int zoneZ) {
                return $this.getMapsquareId(zoneX, zoneZ);
            }
        }
    }
}

