/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.game;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.Session;
import net.rsprot.protocol.channel.ChannelExtensions;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.message.IncomingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u0018B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/rsprot/protocol/api/game/GameMessageHandler;", "R", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingGameMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "session", "Lnet/rsprot/protocol/api/Session;", "(Lnet/rsprot/protocol/api/NetworkService;Lnet/rsprot/protocol/api/Session;)V", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelWritabilityChanged", "exceptionCaught", "cause", "", "handlerAdded", "userEventTriggered", "evt", "", "Companion", "osrs-222-api"})
@SourceDebugExtension(value={"SMAP\nGameMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameMessageHandler.kt\nnet/rsprot/protocol/api/game/GameMessageHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,109:1\n19#2,2:110\n22#2:116\n19#2,2:117\n22#2:123\n19#2,2:124\n22#2:130\n19#2,2:131\n22#2:137\n19#2,2:138\n22#2:144\n56#3,4:112\n56#3,4:119\n56#3,4:126\n56#3,4:133\n56#3,4:140\n11#4,2:145\n*S KotlinDebug\n*F\n+ 1 GameMessageHandler.kt\nnet/rsprot/protocol/api/game/GameMessageHandler\n*L\n32#1:110,2\n32#1:116\n51#1:117,2\n51#1:123\n61#1:124,2\n61#1:130\n69#1:131,2\n69#1:137\n98#1:138,2\n98#1:144\n32#1:112,4\n51#1:119,4\n61#1:126,4\n69#1:133,4\n98#1:140,4\n106#1:145,2\n*E\n"})
public final class GameMessageHandler<R>
extends SimpleChannelInboundHandler<IncomingGameMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private final Session<R> session;
    @NotNull
    private static final Logger logger;

    public GameMessageHandler(@NotNull NetworkService<R> networkService, @NotNull Session<R> session) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter(session, (String)"session");
        this.networkService = networkService;
        this.session = session;
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_222_api().getGameInetAddressTracker().register(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            this.session.triggerIdleClosing$osrs_222_api();
        }
        finally {
            ctx.fireChannelInactive();
            String address = ChannelExtensions.hostAddress((ChannelHandlerContext)ctx);
            this.networkService.getJs5Authorizer().unauthorize(address);
            this.networkService.getINetAddressHandlers$osrs_222_api().getGameInetAddressTracker().deregister(address);
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Channel is now inactive: " + ctx.channel()));
                }
            }
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingGameMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Incoming game message accepted from channel '" + ctx.channel() + "': " + msg));
            }
        }
        this.session.addIncomingMessage(msg);
    }

    public void channelWritabilityChanged(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.channel().isWritable()) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Channel '" + ctx.channel() + "' is now writable again, continuing to write game packets"));
                }
            }
            this.session.flush();
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_222_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt instanceof IdleStateEvent) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                }
            }
            ctx.close();
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/game/GameMessageHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-222-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

