/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.crypto.cipher.StreamCipherPair;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.Session;
import net.rsprot.protocol.api.StreamCipherProvider;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.game.GameMessageDecoder;
import net.rsprot.protocol.api.game.GameMessageEncoder;
import net.rsprot.protocol.api.game.GameMessageHandler;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.incoming.GameMessageConsumerRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J:\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u001d\u001a\u00020 2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u001d\u001a\u00020!2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler;", "R", "", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "(Lnet/rsprot/protocol/api/NetworkService;Lio/netty/channel/ChannelHandlerContext;)V", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "createSession", "Lnet/rsprot/protocol/api/Session;", "loginBlock", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "pipeline", "Lio/netty/channel/ChannelPipeline;", "decodingCipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "encodingCipher", "createStreamCipherPair", "Lnet/rsprot/crypto/cipher/StreamCipherPair;", "validateNewConnection", "", "writeFailedResponse", "", "response", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse;", "writeSuccessfulResponse", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$Ok;", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$ReconnectOk;", "Companion", "osrs-222-api"})
@SourceDebugExtension(value={"SMAP\nGameLoginResponseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n+ 2 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 5 ChannelExtensions.kt\nnet/rsprot/protocol/api/channel/ChannelExtensionsKt\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,273:1\n164#2,2:274\n164#2,2:276\n164#2,2:285\n136#2:287\n216#2,2:288\n136#2:290\n136#2:291\n140#2,2:292\n216#2,2:294\n140#2,2:296\n19#3,2:278\n22#3:284\n19#3,2:298\n22#3:304\n19#3,2:309\n22#3:315\n19#3,2:316\n22#3:322\n56#4,4:280\n56#4,4:300\n56#4,4:311\n56#4,4:318\n36#5:305\n36#5:306\n36#5:307\n36#5:308\n11#6,2:323\n*S KotlinDebug\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n*L\n95#1:274,2\n99#1:276,2\n137#1:285,2\n140#1:287\n141#1:288,2\n144#1:290\n146#1:291\n150#1:292,2\n151#1:294,2\n152#1:296,2\n110#1:278,2\n110#1:284\n162#1:298,2\n162#1:304\n254#1:309,2\n254#1:315\n259#1:316,2\n259#1:322\n110#1:280,4\n162#1:300,4\n254#1:311,4\n259#1:318,4\n214#1:305\n222#1:306\n225#1:307\n226#1:308\n270#1:323,2\n*E\n"})
public final class GameLoginResponseHandler<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private final ChannelHandlerContext ctx;
    private static final int DECODE_SEED_OFFSET = 50;
    @NotNull
    private static final Logger logger;

    public GameLoginResponseHandler(@NotNull NetworkService<R> networkService, @NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService = networkService;
        this.ctx = ctx;
    }

    @NotNull
    public final NetworkService<R> getNetworkService() {
        return this.networkService;
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public final boolean validateNewConnection() {
        InetAddress address = ChannelExtensionsKt.inetAddress(this.ctx);
        int count = this.networkService.getINetAddressHandlers$osrs_222_api().getGameInetAddressTracker().getCount(address);
        return this.networkService.getINetAddressHandlers$osrs_222_api().getInetAddressValidator().acceptGameConnection(address, count);
    }

    @NotNull
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.Ok response, @NotNull LoginBlock<?> loginBlock) {
        boolean bl;
        int value$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        OldSchoolClientType oldSchoolClientType = loginBlock.getClientType().toOldSchoolClientType();
        if (oldSchoolClientType == null) {
            boolean $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22 = false;
            String $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22 = "Login client type cannot be null";
            throw new IllegalStateException($i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22.toString());
        }
        OldSchoolClientType oldSchoolClientType2 = oldSchoolClientType;
        StreamCipherPair cipher = this.createStreamCipherPair(loginBlock);
        MessageEncoder encoder = this.networkService.getEncoderRepositories$osrs_222_api().getLoginMessageEncoderRepository().getEncoder(response.getClass());
        ByteBuf byteBuf = this.ctx.alloc().buffer(37);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
        ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)byteBuf);
        if (!this.networkService.getBetaWorld$osrs_222_api()) {
            value$iv = encoder.getProt().getOpcode();
            bl = false;
            JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
        }
        value$iv = 37;
        bl = false;
        JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
        encoder.encode-WFbGaZ8(cipher.getEncoderCipher(), buffer, (OutgoingMessage)response);
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, cipher.getDecodeCipher(), oldSchoolClientType2, cipher.getEncoderCipher());
        this.ctx.executor().submit(() -> GameLoginResponseHandler.writeSuccessfulResponse$lambda$1(this, buffer, session));
        Logger logger$iv = logger;
        boolean bl2 = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl3 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl4 = false;
                logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
            }
        }
        return session;
    }

    @NotNull
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.ReconnectOk response, @NotNull LoginBlock<?> loginBlock) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        OldSchoolClientType oldSchoolClientType = loginBlock.getClientType().toOldSchoolClientType();
        if (oldSchoolClientType == null) {
            boolean $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32 = false;
            String $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32 = "Login client type cannot be null";
            throw new IllegalStateException($i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32.toString());
        }
        OldSchoolClientType oldSchoolClientType2 = oldSchoolClientType;
        StreamCipherPair streamCipherPair = this.createStreamCipherPair(loginBlock);
        StreamCipher encodingCipher = streamCipherPair.component1();
        StreamCipher decodingCipher = streamCipherPair.component2();
        MessageEncoder encoder = this.networkService.getEncoderRepositories$osrs_222_api().getLoginMessageEncoderRepository().getEncoder(response.getClass());
        int bufLength = 3 + response.content().readableBytes();
        ByteBuf byteBuf = this.ctx.alloc().buffer(bufLength);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
        ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)byteBuf);
        int value$iv = encoder.getProt().getOpcode();
        boolean bl = false;
        JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
        boolean bl2 = false;
        int lengthPos = buffer.writerIndex();
        int value$iv2 = 0;
        boolean bl3 = false;
        JagexByteBufExtensionsKt.p2((ByteBuf)buffer, (int)value$iv2);
        $i$f$writerIndex-impl = false;
        int start2 = buffer.writerIndex();
        encoder.encode-WFbGaZ8(encodingCipher, buffer, (OutgoingMessage)response);
        $i$f$writerIndex-impl = false;
        int end = buffer.writerIndex();
        int written = end - start2;
        boolean bl4 = false;
        buffer.writerIndex(lengthPos);
        $i$f$p2-JhZ6y6I = false;
        JagexByteBufExtensionsKt.p2((ByteBuf)buffer, (int)written);
        bl4 = false;
        buffer.writerIndex(end);
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, decodingCipher, oldSchoolClientType2, encodingCipher);
        this.ctx.executor().submit(() -> GameLoginResponseHandler.writeSuccessfulResponse$lambda$4(this, buffer, session));
        Logger logger$iv = logger;
        boolean bl5 = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl6 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl7 = false;
                logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
            }
        }
        return session;
    }

    private final StreamCipherPair createStreamCipherPair(LoginBlock<?> loginBlock) {
        int[] encodeSeed = loginBlock.getSeed();
        int n = 0;
        int n2 = encodeSeed.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = encodeSeed[n3] + 50;
        }
        int[] decodeSeed = nArray;
        StreamCipherProvider provider = this.networkService.getLoginHandlers$osrs_222_api().getStreamCipherProvider();
        StreamCipher encodingCipher = provider.provide(decodeSeed);
        StreamCipher decodingCipher = provider.provide(encodeSeed);
        return new StreamCipherPair(encodingCipher, decodingCipher);
    }

    private final Session<R> createSession(LoginBlock<?> loginBlock, ChannelPipeline pipeline, StreamCipher decodingCipher, OldSchoolClientType oldSchoolClientType, StreamCipher encodingCipher) {
        ChannelHandler newHandler$iv;
        ChannelPipeline $this$replace$iv;
        GameMessageConsumerRepository gameMessageConsumerRepository = this.networkService.getGameMessageConsumerRepositoryProvider().provide();
        Session<R> session = new Session<R>(this.ctx, this.networkService.getGameMessageHandlers$osrs_222_api().getIncomingGameMessageQueueProvider().provide(), this.networkService.getGameMessageHandlers$osrs_222_api().getOutgoingGameMessageQueueProvider(), this.networkService.getGameMessageHandlers$osrs_222_api().getGameMessageCounterProvider().provide(), gameMessageConsumerRepository.getConsumers(), gameMessageConsumerRepository.getGlobalConsumers(), loginBlock, this.networkService.getExceptionHandlers$osrs_222_api().getIncomingGameMessageConsumerExceptionHandler());
        ChannelPipeline channelPipeline = pipeline;
        ChannelHandler channelHandler = (ChannelHandler)new GameMessageDecoder<R>(this.networkService, session, decodingCipher, oldSchoolClientType);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageEncoder(this.networkService, encodingCipher, oldSchoolClientType);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageHandler<R>(this.networkService, session);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginConnectionHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 15L, 15L, 15L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        return session;
    }

    public final void writeFailedResponse(@NotNull LoginResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response instanceof LoginResponse.ProofOfWork) {
            throw new IllegalStateException("Proof of Work is handled at the engine level.");
        }
        if (response instanceof LoginResponse.Successful) {
            throw new IllegalStateException("Successful login response is handled at the engine level.");
        }
        if (!this.ctx.channel().isActive()) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                }
            }
            return;
        }
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl4 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl5 = false;
                logger.debug(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
            }
        }
        this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static final void writeSuccessfulResponse$lambda$1(GameLoginResponseHandler this$0, ByteBuf $buffer, Session $session) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        this$0.ctx.write((Object)$buffer);
        $session.onLoginTransitionComplete$osrs_222_api();
    }

    private static final void writeSuccessfulResponse$lambda$4(GameLoginResponseHandler this$0, ByteBuf $buffer, Session $session) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        this$0.ctx.write((Object)$buffer);
        $session.onLoginTransitionComplete$osrs_222_api();
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler$Companion;", "", "()V", "DECODE_SEED_OFFSET", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-222-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

