/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.rsprot.protocol.api.js5.Js5Client;
import net.rsprot.protocol.api.js5.Js5Configuration;
import net.rsprot.protocol.api.js5.Js5GroupProvider;
import net.rsprot.protocol.api.js5.util.UniqueQueue;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.js5.incoming.Js5GroupRequest;
import net.rsprot.protocol.js5.outgoing.Js5GroupResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u0015\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0001H\u0002J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\b\u0010\"\u001a\u00020\u0017H\u0016J \u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0006\u0010'\u001a\u00020\u0017J\u001a\u0010(\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170*H\u0081\b\u00f8\u0001\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\n\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006,"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Service;", "Ljava/lang/Runnable;", "configuration", "Lnet/rsprot/protocol/api/js5/Js5Configuration;", "provider", "Lnet/rsprot/protocol/api/js5/Js5GroupProvider;", "(Lnet/rsprot/protocol/api/js5/Js5Configuration;Lnet/rsprot/protocol/api/js5/Js5GroupProvider;)V", "clientLock", "Ljava/lang/Object;", "getClientLock$annotations", "()V", "clients", "Lnet/rsprot/protocol/api/js5/util/UniqueQueue;", "Lnet/rsprot/protocol/api/js5/Js5Client;", "connectedClients", "Lkotlin/collections/ArrayDeque;", "isRunning", "", "lock", "getLock$annotations", "getLock", "()Ljava/lang/Object;", "notifyIfNotEmpty", "", "client", "onClientConnected", "onClientConnected$osrs_222_api", "onClientDisconnected", "onClientDisconnected$osrs_222_api", "prefetch", "push", "request", "Lnet/rsprot/protocol/js5/incoming/Js5GroupRequest;", "readIfNotFull", "run", "serveClient", "response", "Lnet/rsprot/protocol/js5/outgoing/Js5GroupResponse;", "flush", "triggerShutdown", "use", "block", "Lkotlin/Function0;", "Companion", "osrs-222-api"})
@SourceDebugExtension(value={"SMAP\nJs5Service.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,331:1\n110#2,4:332\n134#2,4:336\n134#2,4:340\n56#2,4:346\n56#2,4:353\n56#2,4:360\n56#2,4:367\n56#2,4:374\n56#2,4:381\n56#2,4:388\n37#3,2:344\n40#3:350\n37#3,2:351\n40#3:357\n37#3,2:358\n40#3:364\n37#3,2:365\n40#3:371\n37#3,2:372\n40#3:378\n37#3,2:379\n40#3:385\n37#3,2:386\n40#3:392\n11#4,2:393\n*S KotlinDebug\n*F\n+ 1 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n*L\n71#1:332,4\n92#1:336,4\n98#1:340,4\n156#1:346,4\n160#1:353,4\n167#1:360,4\n172#1:367,4\n181#1:374,4\n217#1:381,4\n232#1:388,4\n156#1:344,2\n156#1:350\n160#1:351,2\n160#1:357\n167#1:358,2\n167#1:364\n172#1:365,2\n172#1:371\n181#1:372,2\n181#1:378\n217#1:379,2\n217#1:385\n232#1:386,2\n232#1:392\n266#1:393,2\n*E\n"})
public final class Js5Service
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Js5Configuration configuration;
    @NotNull
    private final Js5GroupProvider provider;
    @NotNull
    private final UniqueQueue<Js5Client> clients;
    @NotNull
    private final ArrayDeque<Js5Client> connectedClients;
    @NotNull
    private final Object lock;
    @NotNull
    private final Object clientLock;
    private volatile boolean isRunning;
    public static final int BLOCK_LENGTH = 512;
    @NotNull
    private static final Logger logger;

    public Js5Service(@NotNull Js5Configuration configuration, @NotNull Js5GroupProvider provider) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.configuration = configuration;
        this.provider = provider;
        this.clients = new UniqueQueue();
        this.connectedClients = new ArrayDeque();
        this.lock = new Object();
        this.clientLock = new Object();
        this.isRunning = true;
    }

    @NotNull
    public final Object getLock() {
        return this.lock;
    }

    @PublishedApi
    public static /* synthetic */ void getLock$annotations() {
    }

    private static /* synthetic */ void getClientLock$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Logger logger;
            try {
                Js5Client client = null;
                Js5GroupResponse response = null;
                boolean flush = false;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl = false;
                    while (true) {
                        if (!this.isRunning) {
                            return;
                        }
                        Js5Client next = this.clients.removeFirstOrNull();
                        if (next == null) {
                            this.lock.wait();
                            continue;
                        }
                        client = next;
                        if (!client.getCtx().channel().isActive()) continue;
                        Js5Client.ClientPriority priority = client.getPriority();
                        int ratio = priority == Js5Client.ClientPriority.HIGH ? this.configuration.getPriorityRatio() : 1;
                        try {
                            Js5GroupResponse js5GroupResponse = client.getNextBlock(this.configuration.getMissingGroupBehaviour(), this.provider, this.configuration.getBlockSizeInBytes() * ratio);
                            if (js5GroupResponse == null) continue;
                            response = js5GroupResponse;
                        }
                        catch (Throwable t) {
                            Logger arg0$iv = Js5Service.logger;
                            boolean bl2 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                Logger logger2 = arg0$iv;
                                boolean bl3 = false;
                                logger2.warn(String.valueOf("Unable to serve channel '" + client.getCtx().channel() + "', dropping connection."), t);
                            }
                            client.getCtx().close();
                            continue;
                        }
                        break;
                    }
                    flush = client.needsFlushing(this.configuration.getFlushThresholdInBytes(), this.configuration.getFlushThresholdInRequests());
                    if (flush) {
                        client.resetTracker();
                    }
                    Unit $i$a$-synchronized-Js5Service$run$2 = Unit.INSTANCE;
                }
                try {
                    this.serveClient(client, response, flush);
                }
                catch (Throwable t) {
                    Logger arg0$iv = Js5Service.logger;
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        logger = arg0$iv;
                        boolean bl4 = false;
                        logger.error(String.valueOf("Unable to serve channel " + client.getCtx().channel() + ", dropping connection."), t);
                    }
                    client.getCtx().close();
                }
            }
            catch (Throwable t) {
                Logger arg0$iv = Js5Service.logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    logger = arg0$iv;
                    boolean bl5 = false;
                    logger.error(String.valueOf("Error in JS5 service processing - JS5 service has been killed."), t);
                }
                throw t;
            }
        }
    }

    private final Runnable prefetch() {
        return () -> Js5Service.prefetch$lambda$6(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onClientConnected$osrs_222_api(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.connectedClients).add(client);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onClientDisconnected$osrs_222_api(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.connectedClients).remove(client);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void serveClient(Js5Client client, Js5GroupResponse response, boolean flush) {
        Logger logger;
        boolean bl;
        ChannelHandlerContext ctx = client.getCtx();
        ctx.write((Object)response);
        Logger logger$iv = Js5Service.logger;
        boolean bl2 = false;
        if (RSProtFlags.getJs5Logging()) {
            bl = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
            }
        }
        if (flush) {
            logger$iv = Js5Service.logger;
            bl2 = false;
            if (RSProtFlags.getJs5Logging()) {
                bl = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    boolean bl4 = false;
                    logger.debug(String.valueOf("Flushing channel " + ctx.channel()));
                }
            }
            ctx.flush();
        }
        Object object = this.lock;
        synchronized (object) {
            Logger logger2;
            boolean bl5;
            Logger logger$iv2;
            boolean bl6 = false;
            if (!flush || client.isReady()) {
                logger$iv2 = Js5Service.logger;
                $i$f$js5Log-G3pwApI = false;
                if (RSProtFlags.getJs5Logging()) {
                    bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                        logger2 = logger$iv2;
                        boolean bl7 = false;
                        logger2.debug(String.valueOf("Continuing to serve channel " + ctx.channel()));
                    }
                }
                this.clients.add(client);
            } else {
                logger$iv2 = Js5Service.logger;
                $i$f$js5Log-G3pwApI = false;
                if (RSProtFlags.getJs5Logging()) {
                    bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                        logger2 = logger$iv2;
                        boolean bl8 = false;
                        logger2.debug(String.valueOf("No longer serving channel " + ctx.channel()));
                    }
                }
            }
            boolean notFull = client.isNotFull();
            if (notFull) {
                ctx.read();
            }
            Logger logger$iv3 = Js5Service.logger;
            $i$f$js5Log-G3pwApI = false;
            if (RSProtFlags.getJs5Logging()) {
                boolean bl9 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv3)) {
                    logger2 = logger$iv3;
                    boolean bl10 = false;
                    logger2.debug(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void push(@NotNull Js5Client client, @NotNull Js5GroupRequest request) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            client.push(request);
            if (client.isReady()) {
                this.clients.add(client);
                this.lock.notifyAll();
            }
            if (client.isNotFull()) {
                client.getCtx().read();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readIfNotFull(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (client.isNotFull()) {
                Logger logger$iv = logger;
                boolean bl2 = false;
                if (RSProtFlags.getJs5Logging()) {
                    boolean bl3 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.debug(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                    }
                }
                client.getCtx().read();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyIfNotEmpty(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (client.isNotEmpty()) {
                Logger logger$iv = logger;
                boolean bl2 = false;
                if (RSProtFlags.getJs5Logging()) {
                    boolean bl3 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.debug(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                    }
                }
                this.clients.add(client);
                this.lock.notifyAll();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublishedApi
    public final void use(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$use = false;
        Object object = this.getLock();
        synchronized (object) {
            try {
                boolean bl = false;
                block.invoke();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                InlineMarker.finallyEnd((int)1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void triggerShutdown() {
        this.isRunning = false;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void prefetch$lambda$6(Js5Service this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.clientLock;
        synchronized (object) {
            boolean bl = false;
            for (Js5Client client : this$0.connectedClients) {
                Object object2 = this$0.lock;
                synchronized (object2) {
                    boolean bl2 = false;
                    if (client.transferPrefetch$osrs_222_api(this$0.provider, this$0.configuration.getPrefetchTransferThresholdInBytes())) {
                        this$0.clients.add(client);
                        this$0.lock.notifyAll();
                        if (client.isNotFull()) {
                            client.getCtx().read();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ\u0012\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Service$Companion;", "", "()V", "BLOCK_LENGTH", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "ensureCorrectlySliced", "", "buffer", "Lio/netty/buffer/ByteBuf;", "ensureCorrectlySliced$osrs_222_api", "prepareJs5Buffer", "", "archive", "group", "input", "output", "startPrefetching", "Ljava/util/concurrent/ScheduledFuture;", "service", "Lnet/rsprot/protocol/api/js5/Js5Service;", "osrs-222-api"})
    public static final class Companion {
        private Companion() {
        }

        public final void prepareJs5Buffer(int archive, int group, @NotNull ByteBuf input, @NotNull ByteBuf output) {
            int nextBlockLength;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            int readableBytes = input.readableBytes();
            output.writeByte(archive);
            output.writeShort(group);
            int len = Math.min(readableBytes, 509);
            output.writeBytes(input, 0, len);
            for (int offset = len; offset < readableBytes; offset += nextBlockLength) {
                output.writeByte(255);
                nextBlockLength = Math.min(readableBytes - offset, 511);
                output.writeBytes(input, offset, nextBlockLength);
            }
        }

        public final boolean ensureCorrectlySliced$osrs_222_api(@NotNull ByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int cap = buffer.readableBytes();
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)512, (int)cap)), (int)512);
            int i = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                while (true) {
                    if ((buffer.getByte(i) & 0xFF) != 255) {
                        return false;
                    }
                    if (i == n) break;
                    i += n2;
                }
            }
            return true;
        }

        @NotNull
        public final ScheduledFuture<?> startPrefetching(@NotNull Js5Service service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            ScheduledFuture<?> scheduledFuture = Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(service.prefetch(), 200L, 200L, TimeUnit.MILLISECONDS);
            Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
            return scheduledFuture;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

