/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.bootstrap;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.internal.RSProtFlags;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/api/bootstrap/BootstrapFactory;", "", "alloc", "Lio/netty/buffer/ByteBufAllocator;", "(Lio/netty/buffer/ByteBufAllocator;)V", "createChildLoopGroup", "Lio/netty/channel/EventLoopGroup;", "createParentLoopGroup", "createServerBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "parentGroup", "childGroup", "Companion", "osrs-222-api"})
@SourceDebugExtension(value={"SMAP\nBootstrapFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootstrapFactory.kt\nnet/rsprot/protocol/api/bootstrap/BootstrapFactory\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,95:1\n19#2,2:96\n22#2:102\n56#3,4:98\n11#4,2:103\n*S KotlinDebug\n*F\n+ 1 BootstrapFactory.kt\nnet/rsprot/protocol/api/bootstrap/BootstrapFactory\n*L\n70#1:96,2\n70#1:102\n70#1:98,4\n92#1:103,2\n*E\n"})
public final class BootstrapFactory {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator alloc;
    @NotNull
    private static final Logger logger;

    public BootstrapFactory(@NotNull ByteBufAllocator alloc) {
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        this.alloc = alloc;
    }

    @NotNull
    public final EventLoopGroup createParentLoopGroup() {
        return IOUring.isAvailable() ? (EventLoopGroup)new IOUringEventLoopGroup(1) : (Epoll.isAvailable() ? (EventLoopGroup)new EpollEventLoopGroup(1) : (KQueue.isAvailable() ? (EventLoopGroup)new KQueueEventLoopGroup(1) : (EventLoopGroup)new NioEventLoopGroup(1)));
    }

    @NotNull
    public final EventLoopGroup createChildLoopGroup() {
        return IOUring.isAvailable() ? (EventLoopGroup)new IOUringEventLoopGroup() : (Epoll.isAvailable() ? (EventLoopGroup)new EpollEventLoopGroup() : (KQueue.isAvailable() ? (EventLoopGroup)new KQueueEventLoopGroup() : (EventLoopGroup)new NioEventLoopGroup()));
    }

    @NotNull
    public final ServerBootstrap createServerBootstrap(@NotNull EventLoopGroup parentGroup, @NotNull EventLoopGroup childGroup) {
        ServerBootstrap serverBootstrap;
        Class<IOUringServerSocketChannel> clazz;
        Intrinsics.checkNotNullParameter((Object)parentGroup, (String)"parentGroup");
        Intrinsics.checkNotNullParameter((Object)childGroup, (String)"childGroup");
        EventLoopGroup eventLoopGroup = parentGroup;
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            clazz = IOUringServerSocketChannel.class;
        } else if (eventLoopGroup instanceof EpollEventLoopGroup) {
            clazz = EpollServerSocketChannel.class;
        } else if (eventLoopGroup instanceof KQueueEventLoopGroup) {
            clazz = KQueueServerSocketChannel.class;
        } else if (eventLoopGroup instanceof NioEventLoopGroup) {
            clazz = NioServerSocketChannel.class;
        } else {
            throw new IllegalArgumentException("Unknown EventLoopGroup type");
        }
        Class<IOUringServerSocketChannel> channel = clazz;
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Bootstrap event loop group: " + parentGroup.getClass().getSimpleName()));
            }
        }
        ServerBootstrap it = serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(parentGroup, childGroup).channel(channel)).option(ChannelOption.ALLOCATOR, (Object)this.alloc)).childOption(ChannelOption.ALLOCATOR, (Object)this.alloc).childOption(ChannelOption.AUTO_READ, (Object)false).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_RCVBUF, (Object)65536).childOption(ChannelOption.SO_SNDBUF, (Object)65536).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(524288, 0x200000));
        boolean bl4 = false;
        if (parentGroup instanceof EpollEventLoopGroup) {
            it.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.LEVEL_TRIGGERED);
        }
        eventLoopGroup = serverBootstrap;
        Intrinsics.checkNotNullExpressionValue((Object)eventLoopGroup, (String)"also(...)");
        return eventLoopGroup;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/bootstrap/BootstrapFactory$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-222-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

