/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.js5.Js5Client;
import net.rsprot.protocol.api.js5.Js5Service;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.js5.incoming.Js5GroupRequest;
import net.rsprot.protocol.js5.incoming.PriorityChangeHigh;
import net.rsprot.protocol.js5.incoming.PriorityChangeLow;
import net.rsprot.protocol.js5.incoming.XorChange;
import net.rsprot.protocol.message.IncomingJs5Message;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lnet/rsprot/protocol/api/js5/Js5ChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingJs5Message;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "client", "Lnet/rsprot/protocol/api/js5/Js5Client;", "service", "Lnet/rsprot/protocol/api/js5/Js5Service;", "getService", "()Lnet/rsprot/protocol/api/js5/Js5Service;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelReadComplete", "channelWritabilityChanged", "exceptionCaught", "cause", "", "handlerAdded", "handlerRemoved", "userEventTriggered", "evt", "", "Companion", "osrs-222-api"})
@SourceDebugExtension(value={"SMAP\nJs5ChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Js5ChannelHandler.kt\nnet/rsprot/protocol/api/js5/Js5ChannelHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,144:1\n19#2,2:145\n22#2:151\n19#2,2:152\n22#2:158\n37#2,2:159\n40#2:165\n37#2,2:166\n40#2:172\n37#2,2:173\n40#2:179\n37#2,2:180\n40#2:186\n19#2,2:191\n22#2:197\n56#3,4:147\n56#3,4:154\n56#3,4:161\n56#3,4:168\n56#3,4:175\n56#3,4:182\n56#3,4:193\n246#4,4:187\n11#5,2:198\n*S KotlinDebug\n*F\n+ 1 Js5ChannelHandler.kt\nnet/rsprot/protocol/api/js5/Js5ChannelHandler\n*L\n32#1:145,2\n32#1:151\n42#1:152,2\n42#1:158\n65#1:159,2\n65#1:165\n71#1:166,2\n71#1:172\n80#1:173,2\n80#1:179\n87#1:180,2\n87#1:186\n133#1:191,2\n133#1:197\n32#1:147,4\n42#1:154,4\n65#1:161,4\n71#1:168,4\n80#1:175,4\n87#1:182,4\n133#1:193,4\n90#1:187,4\n141#1:198,2\n*E\n"})
public final class Js5ChannelHandler
extends SimpleChannelInboundHandler<IncomingJs5Message> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    private Js5Client client;
    @NotNull
    private static final Logger logger;

    public Js5ChannelHandler(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingJs5Message.class);
        this.networkService = networkService;
    }

    private final Js5Service getService() {
        return this.networkService.getJs5Service$osrs_222_api();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_222_api().getJs5InetAddressTracker().register(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
            }
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_222_api().getJs5InetAddressTracker().deregister(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
            }
        }
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ChannelHandlerContext channelHandlerContext = ctx.read();
        Intrinsics.checkNotNullExpressionValue((Object)channelHandlerContext, (String)"read(...)");
        this.client = new Js5Client(channelHandlerContext);
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.onClientConnected$osrs_222_api(js5Client);
    }

    public void handlerRemoved(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.onClientDisconnected$osrs_222_api(js5Client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingJs5Message msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        IncomingJs5Message incomingJs5Message = msg;
        if (incomingJs5Message instanceof Js5GroupRequest) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getJs5Logging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                }
            }
            Js5Service js5Service = this.getService();
            Js5Client js5Client = this.client;
            if (js5Client == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client = null;
            }
            js5Service.push(js5Client, (Js5GroupRequest)msg);
        } else if (Intrinsics.areEqual((Object)incomingJs5Message, (Object)PriorityChangeLow.INSTANCE)) {
            Js5Client js5Client;
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getJs5Logging()) {
                boolean bl4 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl5 = false;
                    logger.debug(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                }
            }
            if ((js5Client = this.client) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client = null;
            }
            js5Client.setLowPriority();
            Js5Service js5Service = this.getService();
            Js5Client js5Client2 = this.client;
            if (js5Client2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client2 = null;
            }
            js5Service.readIfNotFull(js5Client2);
            Js5Service js5Service2 = this.getService();
            Js5Client js5Client3 = this.client;
            if (js5Client3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client3 = null;
            }
            js5Service2.notifyIfNotEmpty(js5Client3);
        } else if (Intrinsics.areEqual((Object)incomingJs5Message, (Object)PriorityChangeHigh.INSTANCE)) {
            Js5Client js5Client;
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getJs5Logging()) {
                boolean bl6 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl7 = false;
                    logger.debug(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                }
            }
            if ((js5Client = this.client) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client = null;
            }
            js5Client.setHighPriority();
            Js5Service js5Service = this.getService();
            Js5Client js5Client4 = this.client;
            if (js5Client4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client4 = null;
            }
            js5Service.readIfNotFull(js5Client4);
        } else if (incomingJs5Message instanceof XorChange) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getJs5Logging()) {
                boolean bl8 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl9 = false;
                    logger.debug(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                }
            }
            Js5Service this_$iv = this.getService();
            boolean $i$f$use = false;
            Object object = this_$iv.getLock();
            synchronized (object) {
                boolean bl10 = false;
                boolean bl11 = false;
                Js5Client js5Client = this.client;
                if (js5Client == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    js5Client = null;
                }
                js5Client.setXorKey(((XorChange)msg).getKey());
                Js5Service js5Service = this.getService();
                Js5Client js5Client5 = this.client;
                if (js5Client5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    js5Client5 = null;
                }
                js5Service.readIfNotFull(js5Client5);
            }
        } else {
            throw new IllegalStateException("Unknown JS5 message: " + msg);
        }
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.readIfNotFull(js5Client);
    }

    public void channelWritabilityChanged(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.channel().isWritable()) {
            Js5Service js5Service = this.getService();
            Js5Client js5Client = this.client;
            if (js5Client == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client = null;
            }
            js5Service.notifyIfNotEmpty(js5Client);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_222_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt instanceof IdleStateEvent) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                }
            }
            ctx.close();
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/js5/Js5ChannelHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-222-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

