/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import net.rsprot.protocol.ServerProtCategory;
import net.rsprot.protocol.api.GameMessageCounter;
import net.rsprot.protocol.api.IncomingGameMessageConsumerExceptionHandler;
import net.rsprot.protocol.api.MessageQueueProvider;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.game.GameMessageDecoder;
import net.rsprot.protocol.game.outgoing.zone.payload.SoundArea;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.incoming.util.LoginClientType;
import net.rsprot.protocol.message.ConsumableMessage;
import net.rsprot.protocol.message.IncomingGameMessage;
import net.rsprot.protocol.message.OutgoingGameMessage;
import net.rsprot.protocol.message.codec.incoming.MessageConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 O*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002NOB\u008d\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012&\u0010\r\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u000e\u0012\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u0012\u0012\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0007J\b\u0010.\u001a\u00020,H\u0002J\u0006\u0010/\u001a\u00020,J\u0006\u00100\u001a\u00020,J\u0015\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b2J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020,H\u0002J\r\u00106\u001a\u000204H\u0000\u00a2\u0006\u0002\b7J\b\u00108\u001a\u00020,H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u0007H\u0002J\u0013\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00028\u0000\u00a2\u0006\u0002\u0010=J\u000e\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020\nJ\u0016\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020AJ\u0006\u0010B\u001a\u000204J\r\u0010C\u001a\u00020,H\u0000\u00a2\u0006\u0002\bDJ\u000e\u0010E\u001a\u00020,2\u0006\u0010F\u001a\u00020\u001eJ\u0010\u0010G\u001a\u00020,2\u0006\u0010H\u001a\u000204H\u0002J\r\u0010H\u001a\u00020,H\u0000\u00a2\u0006\u0002\bIJ\r\u0010J\u001a\u00020,H\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u00020,H\u0002J\b\u0010M\u001a\u00020,H\u0002R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\r\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020$X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010%R\u0015\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060)X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006P"}, d2={"Lnet/rsprot/protocol/api/Session;", "R", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "incomingMessageQueue", "Ljava/util/Queue;", "Lnet/rsprot/protocol/message/IncomingGameMessage;", "outgoingMessageQueueProvider", "Lnet/rsprot/protocol/api/MessageQueueProvider;", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "counter", "Lnet/rsprot/protocol/api/GameMessageCounter;", "consumers", "", "Ljava/lang/Class;", "Lnet/rsprot/protocol/message/codec/incoming/MessageConsumer;", "globalConsumers", "", "loginBlock", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "incomingGameMessageConsumerExceptionHandler", "Lnet/rsprot/protocol/api/IncomingGameMessageConsumerExceptionHandler;", "(Lio/netty/channel/ChannelHandlerContext;Ljava/util/Queue;Lnet/rsprot/protocol/api/MessageQueueProvider;Lnet/rsprot/protocol/api/GameMessageCounter;Ljava/util/Map;Ljava/util/List;Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;Lnet/rsprot/protocol/api/IncomingGameMessageConsumerExceptionHandler;)V", "channelStatus", "Lnet/rsprot/protocol/api/Session$ChannelStatus;", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "disconnectionHook", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Runnable;", "inetAddress", "Ljava/net/InetAddress;", "getInetAddress", "()Ljava/net/InetAddress;", "lastFlush", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "J", "getLoginBlock", "()Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "outgoingMessageQueues", "", "[Ljava/util/Queue;", "addIncomingMessage", "", "incomingGameMessage", "checkIdle", "clear", "flush", "incrementCounter", "incrementCounter$osrs_222_api", "internalRequestClose", "", "invokeDisconnectionHook", "isFull", "isFull$osrs_222_api", "onPollComplete", "pollIncomingMessage", "processIncomingPackets", "", "receiver", "(Ljava/lang/Object;)I", "queue", "message", "category", "Lnet/rsprot/protocol/ServerProtCategory;", "requestClose", "resumeReading", "resumeReading$osrs_222_api", "setDisconnectionHook", "hook", "setReadStatus", "stopReading", "stopReading$osrs_222_api", "triggerIdleClosing", "triggerIdleClosing$osrs_222_api", "updateLastFlush", "writeAndFlush", "ChannelStatus", "Companion", "osrs-222-api"})
@SourceDebugExtension(value={"SMAP\nSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Session.kt\nnet/rsprot/protocol/api/Session\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,439:1\n104#2,4:440\n56#2,4:446\n56#2,4:455\n56#2,4:462\n56#2,2:469\n59#2:472\n19#3,2:444\n22#3:450\n19#3,2:453\n22#3:459\n19#3,2:460\n22#3:466\n19#3,2:467\n22#3:473\n12271#4,2:451\n1#5:471\n11#6,2:474\n*S KotlinDebug\n*F\n+ 1 Session.kt\nnet/rsprot/protocol/api/Session\n*L\n86#1:440,4\n168#1:446,4\n331#1:455,4\n342#1:462,4\n347#1:469,2\n347#1:472\n168#1:444,2\n168#1:450\n331#1:453,2\n331#1:459\n342#1:460,2\n342#1:466\n347#1:467,2\n347#1:473\n273#1:451,2\n435#1:474,2\n*E\n"})
public final class Session<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelHandlerContext ctx;
    @NotNull
    private final Queue<IncomingGameMessage> incomingMessageQueue;
    @NotNull
    private final GameMessageCounter counter;
    @NotNull
    private final Map<Class<? extends IncomingGameMessage>, MessageConsumer<R, IncomingGameMessage>> consumers;
    @NotNull
    private final List<MessageConsumer<R, IncomingGameMessage>> globalConsumers;
    @NotNull
    private final LoginBlock<?> loginBlock;
    @NotNull
    private final IncomingGameMessageConsumerExceptionHandler<R> incomingGameMessageConsumerExceptionHandler;
    @NotNull
    private final Queue<OutgoingGameMessage>[] outgoingMessageQueues;
    @NotNull
    private final InetAddress inetAddress;
    @NotNull
    private AtomicReference<Runnable> disconnectionHook;
    @NotNull
    private volatile ChannelStatus channelStatus;
    private long lastFlush;
    @NotNull
    private static final Logger logger;
    private static final long limboIdleDuration;

    public Session(@NotNull ChannelHandlerContext ctx, @NotNull Queue<IncomingGameMessage> incomingMessageQueue, @NotNull MessageQueueProvider<OutgoingGameMessage> outgoingMessageQueueProvider, @NotNull GameMessageCounter counter, @NotNull Map<Class<? extends IncomingGameMessage>, ? extends MessageConsumer<? super R, ? super IncomingGameMessage>> consumers, @NotNull List<? extends MessageConsumer<? super R, ? super IncomingGameMessage>> globalConsumers, @NotNull LoginBlock<?> loginBlock, @NotNull IncomingGameMessageConsumerExceptionHandler<R> incomingGameMessageConsumerExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(incomingMessageQueue, (String)"incomingMessageQueue");
        Intrinsics.checkNotNullParameter(outgoingMessageQueueProvider, (String)"outgoingMessageQueueProvider");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter(consumers, (String)"consumers");
        Intrinsics.checkNotNullParameter(globalConsumers, (String)"globalConsumers");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        Intrinsics.checkNotNullParameter(incomingGameMessageConsumerExceptionHandler, (String)"incomingGameMessageConsumerExceptionHandler");
        this.ctx = ctx;
        this.incomingMessageQueue = incomingMessageQueue;
        this.counter = counter;
        this.consumers = consumers;
        this.globalConsumers = globalConsumers;
        this.loginBlock = loginBlock;
        this.incomingGameMessageConsumerExceptionHandler = incomingGameMessageConsumerExceptionHandler;
        int n = 0;
        Queue[] queueArray = new Queue[2];
        Session session = this;
        while (n < 2) {
            int n2 = n++;
            queueArray[n2] = outgoingMessageQueueProvider.provide();
        }
        session.outgoingMessageQueues = queueArray;
        this.inetAddress = ChannelExtensionsKt.inetAddress(this.ctx);
        this.disconnectionHook = new AtomicReference<Object>(null);
        this.channelStatus = ChannelStatus.OPEN;
        this.lastFlush = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public final LoginBlock<?> getLoginBlock() {
        return this.loginBlock;
    }

    @NotNull
    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    private final void updateLastFlush() {
        this.lastFlush = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
    }

    private final void checkIdle() {
        long elapsed = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)this.lastFlush);
        if (Duration.compareTo-LRDsOJo((long)elapsed, (long)limboIdleDuration) < 0) {
            return;
        }
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.warn(String.valueOf("Connection " + this.ctx.channel() + " has gone idle in limbo, requesting channel close for '" + this.loginBlock.getUsername() + "'."));
        }
        this.triggerIdleClosing$osrs_222_api();
    }

    public final void triggerIdleClosing$osrs_222_api() {
        if (this.internalRequestClose()) {
            this.invokeDisconnectionHook();
        }
    }

    public final void queue(@NotNull OutgoingGameMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.queue(message, message.getCategory());
    }

    public final void queue(@NotNull OutgoingGameMessage message, @NotNull ServerProtCategory category) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (message instanceof ConsumableMessage) {
            ((ConsumableMessage)message).consume();
        }
        if (this.channelStatus != ChannelStatus.OPEN) {
            if (message instanceof ReferenceCounted && ((ReferenceCounted)message).refCnt() > 0) {
                ReferenceCountUtil.safeRelease((Object)message);
            }
            return;
        }
        if (RSProtFlags.getFilterMissingPacketsInClient() && this.loginBlock.getClientType() == LoginClientType.DESKTOP && message instanceof SoundArea) {
            throw new IllegalArgumentException("SoundArea packet may only be sent as part of partial enclosed as of revision 221 on Java clients. Packet: " + message);
        }
        int categoryId = category.getId();
        Queue<OutgoingGameMessage> queue = this.outgoingMessageQueues[categoryId];
        ((Collection)queue).add(message);
        this.checkIdle();
    }

    public final int processIncomingPackets(R receiver) {
        if (this.channelStatus != ChannelStatus.OPEN) {
            return 0;
        }
        int count = 0;
        while (this.pollIncomingMessage() != null) {
            IncomingGameMessage packet;
            MessageConsumer<R, IncomingGameMessage> consumer = this.consumers.get(packet.getClass());
            if (consumer == null) {
                boolean $i$a$-checkNotNull-Session$processIncomingPackets$22 = false;
                String $i$a$-checkNotNull-Session$processIncomingPackets$22 = "Consumer for packet " + packet + " does not exist.";
                throw new IllegalStateException($i$a$-checkNotNull-Session$processIncomingPackets$22.toString());
            }
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Processing incoming game packet from channel '" + this.ctx.channel() + "': " + packet));
                }
            }
            try {
                consumer.consume(receiver, packet);
            }
            catch (Throwable cause) {
                this.incomingGameMessageConsumerExceptionHandler.exceptionCaught(this, packet, cause);
            }
            if (!((Collection)this.globalConsumers).isEmpty()) {
                for (MessageConsumer<R, IncomingGameMessage> globalConsumer : this.globalConsumers) {
                    try {
                        globalConsumer.consume(receiver, packet);
                    }
                    catch (Throwable cause) {
                        this.incomingGameMessageConsumerExceptionHandler.exceptionCaught(this, packet, cause);
                    }
                }
            }
            ++count;
        }
        this.onPollComplete();
        return count;
    }

    public final void setDisconnectionHook(@NotNull Runnable hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        AtomicReference<Runnable> currentHook = this.disconnectionHook;
        boolean assigned = currentHook.compareAndSet(null, hook);
        if (!assigned) {
            throw new IllegalStateException("A disconnection hook has already been registered!");
        }
        if (!this.ctx.channel().isActive() && this.internalRequestClose()) {
            this.invokeDisconnectionHook();
        }
    }

    public final boolean requestClose() {
        if (this.channelStatus != ChannelStatus.OPEN) {
            return false;
        }
        this.disconnectionHook.set(null);
        this.channelStatus = ChannelStatus.CLOSING;
        this.flush();
        return true;
    }

    private final boolean internalRequestClose() {
        if (this.channelStatus != ChannelStatus.OPEN) {
            return false;
        }
        this.channelStatus = ChannelStatus.CLOSING;
        this.flush();
        return true;
    }

    private final IncomingGameMessage pollIncomingMessage() {
        return this.incomingMessageQueue.poll();
    }

    private final void onPollComplete() {
        this.counter.reset();
        this.resumeReading$osrs_222_api();
    }

    public final void flush() {
        boolean bl;
        block6: {
            if (this.channelStatus == ChannelStatus.CLOSED) {
                return;
            }
            if (!this.ctx.channel().isActive()) {
                this.triggerIdleClosing$osrs_222_api();
                return;
            }
            Queue<OutgoingGameMessage>[] $this$all$iv = this.outgoingMessageQueues;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                Queue<OutgoingGameMessage> element$iv;
                Queue<OutgoingGameMessage> p0 = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (p0.isEmpty()) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            return;
        }
        this.updateLastFlush();
        EventLoop eventLoop = this.ctx.channel().eventLoop();
        if (eventLoop.inEventLoop()) {
            this.writeAndFlush();
        } else {
            eventLoop.execute(() -> Session.flush$lambda$3(this));
        }
    }

    public final void clear() {
        for (Queue<OutgoingGameMessage> queue : this.outgoingMessageQueues) {
            for (OutgoingGameMessage message : queue) {
                if (!(message instanceof ReferenceCounted) || ((ReferenceCounted)message).refCnt() <= 0) continue;
                ReferenceCountUtil.safeRelease((Object)message);
            }
            queue.clear();
        }
        for (IncomingGameMessage message : this.incomingMessageQueue) {
            if (!(message instanceof ReferenceCounted) || ((ReferenceCounted)message).refCnt() <= 0) continue;
            ReferenceCountUtil.safeRelease((Object)message);
        }
        this.incomingMessageQueue.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeAndFlush() {
        boolean bl;
        boolean bl2;
        Logger logger$iv;
        Logger logger;
        Channel channel = this.ctx.channel();
        block0: for (Queue<OutgoingGameMessage> queue : this.outgoingMessageQueues) {
            while (channel.isWritable()) {
                OutgoingGameMessage next;
                if (queue.poll() == null) continue block0;
                Logger logger$iv2 = Session.logger;
                boolean bl3 = false;
                if (RSProtFlags.getNetworkLogging()) {
                    boolean bl4 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                        logger = logger$iv2;
                        boolean bl5 = false;
                        logger.debug(String.valueOf("Writing outgoing game packet to channel '" + this.ctx.channel() + "': " + next));
                    }
                }
                channel.write((Object)next, channel.voidPromise());
            }
            break block0;
        }
        channel.flush();
        if (this.channelStatus == ChannelStatus.CLOSING) {
            this.channelStatus = ChannelStatus.CLOSED;
            channel.close();
            this.clear();
            logger$iv = Session.logger;
            bl2 = false;
            if (RSProtFlags.getNetworkLogging()) {
                bl = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Flushed outgoing game packets to channel '" + this.ctx.channel() + "', closing channel."));
                }
            }
            return;
        }
        logger$iv = Session.logger;
        bl2 = false;
        if (RSProtFlags.getNetworkLogging()) {
            bl = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                logger = logger$iv;
                boolean bl7 = false;
                Queue<OutgoingGameMessage>[] queueArray = this.outgoingMessageQueues;
                int n = 0;
                int n2 = queueArray.length;
                for (int i = 0; i < n2; ++i) {
                    void p0;
                    Queue<OutgoingGameMessage> queue;
                    Queue<OutgoingGameMessage> queue2 = queue = queueArray[i];
                    int n3 = n;
                    boolean bl8 = false;
                    int n4 = p0.size();
                    n = n3 + n4;
                }
                int leftoverPackets = n;
                logger.debug(String.valueOf(leftoverPackets > 0 ? "Flushing outgoing game packets to channel '" + this.ctx.channel() + "': " + leftoverPackets + " leftover packets remaining" : "Flushing outgoing game packets to channel " + this.ctx.channel()));
            }
        }
    }

    public final void resumeReading$osrs_222_api() {
        this.setReadStatus(false);
    }

    public final void stopReading$osrs_222_api() {
        this.setReadStatus(true);
    }

    private final void setReadStatus(boolean stopReading) {
        Channel channel = this.ctx.channel();
        GameMessageDecoder gameMessageDecoder = (GameMessageDecoder)channel.pipeline().get(GameMessageDecoder.class);
        if (gameMessageDecoder == null) {
            return;
        }
        GameMessageDecoder decoder = gameMessageDecoder;
        decoder.setSingleDecode(stopReading);
        channel.config().setAutoRead(!stopReading);
    }

    public final void addIncomingMessage(@NotNull IncomingGameMessage incomingGameMessage) {
        Intrinsics.checkNotNullParameter((Object)incomingGameMessage, (String)"incomingGameMessage");
        if (this.channelStatus != ChannelStatus.OPEN) {
            return;
        }
        ((Collection)this.incomingMessageQueue).add(incomingGameMessage);
    }

    public final void incrementCounter$osrs_222_api(@NotNull IncomingGameMessage incomingGameMessage) {
        Intrinsics.checkNotNullParameter((Object)incomingGameMessage, (String)"incomingGameMessage");
        if (this.channelStatus != ChannelStatus.OPEN) {
            return;
        }
        this.counter.increment(incomingGameMessage.getCategory());
    }

    public final boolean isFull$osrs_222_api() {
        return this.counter.isFull();
    }

    private final void invokeDisconnectionHook() {
        block0: {
            Runnable runnable = this.disconnectionHook.getAndSet(null);
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private static final void flush$lambda$3(Session this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writeAndFlush();
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
        limboIdleDuration = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/Session$ChannelStatus;", "", "(Ljava/lang/String;I)V", "OPEN", "CLOSING", "CLOSED", "osrs-222-api"})
    private static final class ChannelStatus
    extends Enum<ChannelStatus> {
        public static final /* enum */ ChannelStatus OPEN = new ChannelStatus();
        public static final /* enum */ ChannelStatus CLOSING = new ChannelStatus();
        public static final /* enum */ ChannelStatus CLOSED = new ChannelStatus();
        private static final /* synthetic */ ChannelStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChannelStatus[] values() {
            return (ChannelStatus[])$VALUES.clone();
        }

        public static ChannelStatus valueOf(String value) {
            return Enum.valueOf(ChannelStatus.class, value);
        }

        @NotNull
        public static EnumEntries<ChannelStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = channelStatusArray = new ChannelStatus[]{ChannelStatus.OPEN, ChannelStatus.CLOSING, ChannelStatus.CLOSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\t"}, d2={"Lnet/rsprot/protocol/api/Session$Companion;", "", "()V", "limboIdleDuration", "Lkotlin/time/Duration;", "J", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-222-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

