/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.playerinfo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.bitbuffer.BitBuf;
import net.rsprot.buffer.bitbuffer.BitBufKt;
import net.rsprot.buffer.bitbuffer.UnsafeLongBackedBitBuf;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.game.outgoing.info.ByteBufRecycler;
import net.rsprot.protocol.game.outgoing.info.ObserverExtendedInfoFlags;
import net.rsprot.protocol.game.outgoing.info.exceptions.InfoProcessException;
import net.rsprot.protocol.game.outgoing.info.playerinfo.GlobalLowResolutionPositionRepository;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerAvatar;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerInfoPacket;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerInfoProtocol;
import net.rsprot.protocol.game.outgoing.info.playerinfo.util.CellOpcodes;
import net.rsprot.protocol.game.outgoing.info.util.BuildArea;
import net.rsprot.protocol.game.outgoing.info.util.ReferencePooledObject;
import net.rsprot.protocol.internal.game.outgoing.info.CoordGrid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 \u0080\u00012\u00020\u0001:\u0002\u0080\u0001B?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u00107\u001a\u00020\u0016H\u0002J#\u00108\u001a\u0002H9\"\u000e\b\u0000\u00109*\b\u0012\u0004\u0012\u00020\u00050:2\u0006\u0010;\u001a\u0002H9\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020\u0016H\u0002J\r\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\b@J\u0016\u0010A\u001a\u0012\u0012\u0004\u0012\u00020\u00050Bj\b\u0012\u0004\u0012\u00020\u0005`CJ\u000e\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020\u0016J\b\u0010F\u001a\u00020GH\u0002J\b\u0010H\u001a\u00020GH\u0016J\u0010\u0010I\u001a\u00020G2\u0006\u0010J\u001a\u00020\u0005H\u0002J\u0010\u0010K\u001a\u00020G2\u0006\u0010J\u001a\u00020\u0005H\u0002J\u0018\u0010L\u001a\u00020?2\u0006\u0010J\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010M\u001a\u00020?H\u0016J\u0006\u0010N\u001a\u00020?J\r\u0010O\u001a\u00020?H\u0000\u00a2\u0006\u0002\bPJ*\u0010Q\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020R2\u0006\u0010J\u001a\u00020\u00052\u0006\u0010S\u001a\u00020G2\b\u0010T\u001a\u0004\u0018\u00010%H\u0002J\u0018\u0010U\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020R2\u0006\u0010J\u001a\u00020\u0005H\u0002J(\u0010V\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020%2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u0005H\u0002J\u0018\u0010Z\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020R2\u0006\u0010[\u001a\u00020\u0000H\u0002J \u0010\\\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020%2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u0005H\u0002J(\u0010]\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020%2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u0005H\u0002J\u0018\u0010^\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020R2\u0006\u0010_\u001a\u00020\u0005H\u0002J \u0010`\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020%2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u0005H\u0002J\r\u0010a\u001a\u00020?H\u0000\u00a2\u0006\u0002\bbJ\r\u0010c\u001a\u00020?H\u0000\u00a2\u0006\u0002\bdJ\r\u0010e\u001a\u00020?H\u0000\u00a2\u0006\u0002\bfJ\n\u0010g\u001a\u0004\u0018\u00010%H\u0002J\u0018\u0010h\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020R2\u0006\u0010i\u001a\u00020GH\u0002J\u0018\u0010j\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020R2\u0006\u0010i\u001a\u00020GH\u0002J\r\u0010k\u001a\u00020?H\u0000\u00a2\u0006\u0002\blJ\u0010\u0010m\u001a\u00020?2\u0006\u0010J\u001a\u00020\u0005H\u0002J\u0010\u0010n\u001a\u00020?2\u0006\u0010J\u001a\u00020\u0005H\u0002J#\u0010o\u001a\u00020G2\b\u0010[\u001a\u0004\u0018\u00010\u0000H\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001J#\u0010p\u001a\u00020G2\b\u0010[\u001a\u0004\u0018\u00010\u0000H\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001J\u0006\u0010q\u001a\u00020rJ\u0010\u0010s\u001a\u00020?2\u0006\u0010J\u001a\u00020\u0005H\u0002J\u0010\u0010t\u001a\u00020?2\u0006\u0010J\u001a\u00020\u0005H\u0002J,\u0010u\u001a\u00020?2\u0006\u0010v\u001a\u00020\u00052\u0006\u0010w\u001a\u00020\u00052\b\b\u0002\u0010x\u001a\u00020\u00052\b\b\u0002\u0010y\u001a\u00020\u0005H\u0007J\u0018\u0010u\u001a\u00020?2\u0006\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00a2\u0006\u0004\bz\u0010{J\u001e\u0010|\u001a\u00020?2\u0006\u0010}\u001a\u00020\u00052\u0006\u0010~\u001a\u00020\u00052\u0006\u0010\u007f\u001a\u00020\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0019R\"\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u000202X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0081\u0001"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfo;", "Lnet/rsprot/protocol/game/outgoing/info/util/ReferencePooledObject;", "protocol", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol;", "localIndex", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "avatar", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerAvatar;", "recycler", "Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;", "globalLowResolutionPositionRepository", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/GlobalLowResolutionPositionRepository;", "(Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol;ILio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/common/client/OldSchoolClientType;Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerAvatar;Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;Lnet/rsprot/protocol/game/outgoing/info/playerinfo/GlobalLowResolutionPositionRepository;)V", "getAllocator$osrs_221_model", "()Lio/netty/buffer/ByteBufAllocator;", "getAvatar", "()Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerAvatar;", "buffer", "Lio/netty/buffer/ByteBuf;", "buildArea", "Lnet/rsprot/protocol/game/outgoing/info/util/BuildArea;", "J", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getException$osrs_221_model", "()Ljava/lang/Exception;", "setException$osrs_221_model", "(Ljava/lang/Exception;)V", "extendedInfoCount", "extendedInfoIndices", "", "highResMovementBuffer", "Lnet/rsprot/buffer/bitbuffer/UnsafeLongBackedBitBuf;", "highResolutionCount", "highResolutionExtendedInfoTrackedPlayers", "", "highResolutionIndices", "highResolutionPlayers", "getLocalIndex$osrs_221_model", "()I", "setLocalIndex$osrs_221_model", "(I)V", "lowResolutionCount", "lowResolutionIndices", "observerExtendedInfoFlags", "Lnet/rsprot/protocol/game/outgoing/info/ObserverExtendedInfoFlags;", "getObserverExtendedInfoFlags$osrs_221_model", "()Lnet/rsprot/protocol/game/outgoing/info/ObserverExtendedInfoFlags;", "stationary", "", "allocBuffer", "appendHighResolutionIndices", "T", "", "collection", "(Ljava/util/Collection;)Ljava/util/Collection;", "backingBuffer", "ensureReconnectCalled", "", "ensureReconnectCalled$osrs_221_model", "getHighResolutionIndices", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "handleAbsolutePlayerPositions", "byteBuf", "isCleanState", "", "isDestroyed", "isHighResolution", "index", "isHighResolutionExtendedInfoTracked", "onAlloc", "onDealloc", "onReconnect", "pBitcodes", "pBitcodes$osrs_221_model", "pHighRes", "Lnet/rsprot/buffer/bitbuffer/BitBuf;", "extendedInfo", "highResBuf", "pHighToLowResChange", "pLargeTeleport", "deltaX", "deltaZ", "deltaLevel", "pLowResToHighRes", "other", "pRun", "pSmallTeleport", "pStationary", "count", "pWalk", "postUpdate", "postUpdate$osrs_221_model", "precomputeExtendedInfo", "precomputeExtendedInfo$osrs_221_model", "prepareBitcodes", "prepareBitcodes$osrs_221_model", "prepareHighResMovement", "processHighResolution", "skipStationary", "processLowResolution", "putExtendedInfo", "putExtendedInfo$osrs_221_model", "setHighResolution", "setHighResolutionExtendedInfoTracked", "shouldMoveToHighResolution", "shouldStayInHighResolution", "toPacket", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoPacket;", "unsetHighResolution", "unsetHighResolutionExtendedInfoTracked", "updateBuildArea", "zoneX", "zoneZ", "widthInZones", "heightInZones", "updateBuildArea-4IFMqhs", "(J)V", "updateCoord", "level", "x", "z", "Companion", "osrs-221-model"})
@SourceDebugExtension(value={"SMAP\nPlayerInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInfo.kt\nnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfo\n+ 2 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1012:1\n164#2,2:1013\n1#3:1015\n*S KotlinDebug\n*F\n+ 1 PlayerInfo.kt\nnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfo\n*L\n457#1:1013,2\n*E\n"})
public final class PlayerInfo
implements ReferencePooledObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlayerInfoProtocol protocol;
    private int localIndex;
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private OldSchoolClientType oldSchoolClientType;
    @NotNull
    private final PlayerAvatar avatar;
    @NotNull
    private final ByteBufRecycler recycler;
    @NotNull
    private final GlobalLowResolutionPositionRepository globalLowResolutionPositionRepository;
    @NotNull
    private final short[] lowResolutionIndices;
    private int lowResolutionCount;
    @NotNull
    private final long[] highResolutionPlayers;
    @NotNull
    private final short[] highResolutionIndices;
    @NotNull
    private final long[] highResolutionExtendedInfoTrackedPlayers;
    private int highResolutionCount;
    @NotNull
    private final short[] extendedInfoIndices;
    private int extendedInfoCount;
    @NotNull
    private final byte[] stationary;
    @NotNull
    private final ObserverExtendedInfoFlags observerExtendedInfoFlags;
    @Nullable
    private UnsafeLongBackedBitBuf highResMovementBuffer;
    @Nullable
    private ByteBuf buffer;
    @Nullable
    private volatile Exception exception;
    private long buildArea;
    private static final int BUF_CAPACITY = 40000;
    private static final int WAS_STATIONARY = 1;
    private static final int IS_STATIONARY = 2;

    public PlayerInfo(@NotNull PlayerInfoProtocol protocol, int localIndex, @NotNull ByteBufAllocator allocator, @NotNull OldSchoolClientType oldSchoolClientType, @NotNull PlayerAvatar avatar, @NotNull ByteBufRecycler recycler, @NotNull GlobalLowResolutionPositionRepository globalLowResolutionPositionRepository) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)globalLowResolutionPositionRepository, (String)"globalLowResolutionPositionRepository");
        this.protocol = protocol;
        this.localIndex = localIndex;
        this.allocator = allocator;
        this.oldSchoolClientType = oldSchoolClientType;
        this.avatar = avatar;
        this.recycler = recycler;
        this.globalLowResolutionPositionRepository = globalLowResolutionPositionRepository;
        this.lowResolutionIndices = new short[2048];
        this.highResolutionPlayers = new long[32];
        this.highResolutionIndices = new short[2048];
        this.highResolutionExtendedInfoTrackedPlayers = new long[32];
        this.extendedInfoIndices = new short[2048];
        this.stationary = new byte[2048];
        this.observerExtendedInfoFlags = new ObserverExtendedInfoFlags(2048);
        this.buildArea = BuildArea.Companion.getINVALID-RDuwMps();
    }

    public final int getLocalIndex$osrs_221_model() {
        return this.localIndex;
    }

    public final void setLocalIndex$osrs_221_model(int n) {
        this.localIndex = n;
    }

    @NotNull
    public final ByteBufAllocator getAllocator$osrs_221_model() {
        return this.allocator;
    }

    @NotNull
    public final PlayerAvatar getAvatar() {
        return this.avatar;
    }

    @NotNull
    public final ObserverExtendedInfoFlags getObserverExtendedInfoFlags$osrs_221_model() {
        return this.observerExtendedInfoFlags;
    }

    @Nullable
    public final Exception getException$osrs_221_model() {
        return this.exception;
    }

    public final void setException$osrs_221_model(@Nullable Exception exception) {
        this.exception = exception;
    }

    private final ByteBuf backingBuffer() throws IllegalStateException {
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return byteBuf;
    }

    @Override
    public boolean isDestroyed() {
        return this.exception != null;
    }

    public final void updateBuildArea-4IFMqhs(long buildArea) {
        if (this.isDestroyed()) {
            return;
        }
        this.buildArea = buildArea;
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ, int widthInZones, int heightInZones) {
        if (this.isDestroyed()) {
            return;
        }
        this.buildArea = BuildArea.constructor-impl(zoneX, zoneZ, widthInZones, heightInZones);
    }

    public static /* synthetic */ void updateBuildArea$default(PlayerInfo playerInfo, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n3 = 13;
        }
        if ((n5 & 8) != 0) {
            n4 = 13;
        }
        playerInfo.updateBuildArea(n, n2, n3, n4);
    }

    @NotNull
    public final ArrayList<Integer> getHighResolutionIndices() {
        if (this.isDestroyed()) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> collection = new ArrayList<Integer>(this.highResolutionCount);
        int n = this.highResolutionCount;
        for (int i = 0; i < n; ++i) {
            short index = this.highResolutionIndices[i];
            collection.add(Integer.valueOf(index));
        }
        return collection;
    }

    @NotNull
    public final <T extends Collection<Integer>> T appendHighResolutionIndices(@NotNull T collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        if (this.isDestroyed()) {
            return collection;
        }
        int n = this.highResolutionCount;
        for (int i = 0; i < n; ++i) {
            short index = this.highResolutionIndices[i];
            collection.add((Integer)Integer.valueOf(index));
        }
        return collection;
    }

    @NotNull
    public final PlayerInfoPacket toPacket() {
        Exception exception = this.exception;
        if (exception != null) {
            throw new InfoProcessException("Exception occurred during player info processing for index " + this.localIndex, exception);
        }
        return new PlayerInfoPacket(this.backingBuffer());
    }

    public final void updateCoord(int level, int x, int z) throws IllegalArgumentException {
        if (this.isDestroyed()) {
            return;
        }
        this.avatar.updateCoord(level, x, z);
    }

    private final boolean isHighResolution(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        return (this.highResolutionPlayers[longIndex] & bit) != 0L;
    }

    private final void setHighResolution(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        long cur = this.highResolutionPlayers[longIndex];
        this.highResolutionPlayers[longIndex] = cur | bit;
    }

    private final void unsetHighResolution(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        long cur = this.highResolutionPlayers[longIndex];
        this.highResolutionPlayers[longIndex] = cur & (bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private final boolean isHighResolutionExtendedInfoTracked(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        return (this.highResolutionExtendedInfoTrackedPlayers[longIndex] & bit) != 0L;
    }

    private final void setHighResolutionExtendedInfoTracked(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        long cur = this.highResolutionExtendedInfoTrackedPlayers[longIndex];
        this.highResolutionExtendedInfoTrackedPlayers[longIndex] = cur | bit;
    }

    private final void unsetHighResolutionExtendedInfoTracked(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        long cur = this.highResolutionExtendedInfoTrackedPlayers[longIndex];
        this.highResolutionExtendedInfoTrackedPlayers[longIndex] = cur & (bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleAbsolutePlayerPositions(@NotNull ByteBuf byteBuf) {
        Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
        if (this.isDestroyed()) {
            return;
        }
        if (!(!CoordGrid.equals-impl0((int)this.avatar.getCurrentCoord-aQXte_c(), (int)CoordGrid.Companion.getINVALID-aQXte_c()))) {
            boolean bl = false;
            String string = "Avatar position must be updated via playerinfo#updateCoord before sending RebuildLogin/ReconnectOk.";
            throw new IllegalStateException(string.toString());
        }
        AutoCloseable autoCloseable = (AutoCloseable)BitBufKt.toBitBuf((ByteBuf)byteBuf);
        Throwable throwable = null;
        try {
            BitBuf buffer = (BitBuf)autoCloseable;
            boolean bl = false;
            buffer.pBits(30, this.avatar.getCurrentCoord-aQXte_c());
            this.setHighResolution(this.localIndex);
            int n = this.highResolutionCount;
            this.highResolutionCount = n + 1;
            this.highResolutionIndices[n] = (short)this.localIndex;
            for (int i = 1; i < 2048; ++i) {
                if (i == this.localIndex) continue;
                int lowResolutionPosition = this.protocol.getLowResolutionPosition-EmiGOc0$osrs_221_model(i);
                buffer.pBits(18, lowResolutionPosition);
                int n2 = this.lowResolutionCount;
                this.lowResolutionCount = n2 + 1;
                this.lowResolutionIndices[n2] = (short)i;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.avatar.postUpdate();
    }

    public final void onReconnect() {
        if (this.isDestroyed()) {
            return;
        }
        this.buffer = null;
        this.highResMovementBuffer = null;
        ArraysKt.fill$default((short[])this.lowResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        this.lowResolutionCount = 0;
        ArraysKt.fill$default((short[])this.highResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        this.highResolutionCount = 0;
        ArraysKt.fill$default((long[])this.highResolutionPlayers, (long)0L, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((long[])this.highResolutionExtendedInfoTrackedPlayers, (long)0L, (int)0, (int)0, (int)6, null);
        this.extendedInfoCount = 0;
        ArraysKt.fill$default((short[])this.extendedInfoIndices, (short)0, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((byte[])this.stationary, (byte)0, (int)0, (int)0, (int)6, null);
        this.observerExtendedInfoFlags.reset();
        this.avatar.postUpdate();
        this.avatar.getExtendedInfo().onReconnect$osrs_221_model();
    }

    public final void ensureReconnectCalled$osrs_221_model() {
        if (!this.isCleanState()) {
            throw new IllegalStateException("In order to use LoginResponse.ReconnectOk packet, playerinfo#onReconnect, npcInfo#onReconnect and worldEntityInfo#onReconnect must be called!");
        }
    }

    private final boolean isCleanState() {
        return this.buffer == null && this.highResMovementBuffer == null && this.lowResolutionCount == 0 && this.highResolutionCount == 0 && this.extendedInfoCount == 0;
    }

    public final void prepareBitcodes$osrs_221_model() {
        this.avatar.getExtendedInfo().getObservedChatStorage().reset$osrs_221_model();
        this.highResMovementBuffer = this.prepareHighResMovement();
    }

    public final void precomputeExtendedInfo$osrs_221_model() {
        this.avatar.getExtendedInfo().precompute$osrs_221_model();
    }

    public final void putExtendedInfo$osrs_221_model() {
        ByteBuf jagBuffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)this.backingBuffer());
        int n = this.extendedInfoCount;
        for (int i = 0; i < n; ++i) {
            short index = this.extendedInfoIndices[i];
            PlayerInfo other = this.protocol.getPlayerInfo$osrs_221_model(index);
            if (other == null) {
                int value$iv = 0;
                boolean bl = false;
                JagexByteBufExtensionsKt.p1((ByteBuf)jagBuffer, (int)value$iv);
                continue;
            }
            int observerFlag = this.observerExtendedInfoFlags.getFlag(index);
            boolean tracked = other.avatar.getExtendedInfo().pExtendedInfo-lJsHVMs$osrs_221_model(this.oldSchoolClientType, jagBuffer, observerFlag, this.avatar.getExtendedInfo(), this.extendedInfoCount - i);
            if (!tracked) continue;
            this.setHighResolutionExtendedInfoTracked(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pBitcodes$osrs_221_model() {
        BitBuf it2;
        this.avatar.resize$osrs_221_model(this.highResolutionCount);
        ByteBuf buffer = this.allocBuffer();
        BitBuf bitBuf = BitBufKt.toBitBuf((ByteBuf)buffer);
        AutoCloseable autoCloseable = (AutoCloseable)bitBuf;
        Throwable throwable = null;
        try {
            it2 = (BitBuf)autoCloseable;
            boolean bl = false;
            this.processHighResolution(it2, true);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        autoCloseable = (AutoCloseable)bitBuf;
        throwable = null;
        try {
            it2 = (BitBuf)autoCloseable;
            boolean bl = false;
            this.processHighResolution(it2, false);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it3) {
            throwable = it3;
            throw it3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        autoCloseable = (AutoCloseable)bitBuf;
        throwable = null;
        try {
            it2 = (BitBuf)autoCloseable;
            boolean bl = false;
            this.processLowResolution(it2, false);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it4) {
            throwable = it4;
            throw it4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        autoCloseable = (AutoCloseable)bitBuf;
        throwable = null;
        try {
            it2 = (BitBuf)autoCloseable;
            boolean bl = false;
            this.processLowResolution(it2, true);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void processLowResolution(BitBuf buffer, boolean skipStationary) {
        int skips = -1;
        int n = this.lowResolutionCount;
        for (int i = 0; i < n; ++i) {
            boolean wasStationary;
            short index = this.lowResolutionIndices[i];
            boolean bl = wasStationary = (this.stationary[index] & 1) != 0;
            if (skipStationary == wasStationary) continue;
            PlayerInfo other = this.protocol.getPlayerInfo$osrs_221_model(index);
            UnsafeLongBackedBitBuf lowResolutionBuffer = this.globalLowResolutionPositionRepository.getBuffer$osrs_221_model(index);
            if (other == null) {
                if (lowResolutionBuffer != null) {
                    if (skips > -1) {
                        this.pStationary(buffer, skips);
                        skips = -1;
                    }
                    buffer.pBits(1, 1);
                    buffer.pBits(lowResolutionBuffer);
                    continue;
                }
                ++skips;
                this.stationary[index] = (byte)(this.stationary[index] | 2);
                continue;
            }
            boolean visible = this.shouldMoveToHighResolution(other);
            if (!visible && lowResolutionBuffer == null) {
                ++skips;
                this.stationary[index] = (byte)(this.stationary[index] | 2);
                continue;
            }
            if (skips > -1) {
                this.pStationary(buffer, skips);
                skips = -1;
            }
            if (!visible) {
                buffer.pBits(1, 1);
                UnsafeLongBackedBitBuf unsafeLongBackedBitBuf = lowResolutionBuffer;
                Intrinsics.checkNotNull((Object)unsafeLongBackedBitBuf);
                buffer.pBits(unsafeLongBackedBitBuf);
                continue;
            }
            this.pLowResToHighRes(buffer, other);
        }
        if (skips > -1) {
            this.pStationary(buffer, skips);
        }
    }

    private final void pLowResToHighRes(BitBuf buffer, PlayerInfo other) {
        boolean hasExtendedInfoBlock;
        int index = other.localIndex;
        buffer.pBits(3, 4);
        UnsafeLongBackedBitBuf lowResBuf = this.globalLowResolutionPositionRepository.getBuffer$osrs_221_model(index);
        if (lowResBuf != null) {
            buffer.pBits(1, 1);
            buffer.pBits(lowResBuf);
        } else {
            buffer.pBits(1, 0);
        }
        int n = other.avatar.getCurrentCoord-aQXte_c();
        int x = CoordGrid.component2-impl((int)n);
        int z = CoordGrid.component3-impl((int)n);
        buffer.pBits(13, x);
        buffer.pBits(13, z);
        int extraFlags = other.avatar.getExtendedInfo().getLowToHighResChangeExtendedInfoFlags$osrs_221_model(this.avatar.getExtendedInfo(), this.oldSchoolClientType);
        this.observerExtendedInfoFlags.addFlag(index, extraFlags);
        this.stationary[index] = (byte)(this.stationary[index] | 2);
        this.setHighResolution(index);
        int flag = other.avatar.getExtendedInfo().getFlags$osrs_221_model() | this.observerExtendedInfoFlags.getFlag(index);
        boolean bl = hasExtendedInfoBlock = flag != 0;
        if (hasExtendedInfoBlock) {
            int n2 = this.extendedInfoCount;
            this.extendedInfoCount = n2 + 1;
            this.extendedInfoIndices[n2] = (short)index;
            buffer.pBits(1, 1);
        } else {
            this.setHighResolutionExtendedInfoTracked(index);
            buffer.pBits(1, 0);
        }
    }

    private final void processHighResolution(BitBuf buffer, boolean skipStationary) {
        int skips = -1;
        int n = this.highResolutionCount;
        for (int i = 0; i < n; ++i) {
            boolean skipped;
            int flag;
            boolean hasExtendedInfoBlock;
            boolean wasStationary;
            short index = this.highResolutionIndices[i];
            boolean bl = wasStationary = (this.stationary[index] & 1) != 0;
            if (skipStationary == wasStationary) continue;
            PlayerInfo other = this.protocol.getPlayerInfo$osrs_221_model(index);
            if (!this.shouldStayInHighResolution(other)) {
                if (skips > -1) {
                    this.pStationary(buffer, skips);
                    skips = -1;
                }
                this.pHighToLowResChange(buffer, index);
                continue;
            }
            if (!this.isHighResolutionExtendedInfoTracked(index)) {
                int extraFlags = other.avatar.getExtendedInfo().getLowToHighResChangeExtendedInfoFlags$osrs_221_model(this.avatar.getExtendedInfo(), this.oldSchoolClientType);
                this.observerExtendedInfoFlags.addFlag(index, extraFlags);
            }
            boolean bl2 = hasExtendedInfoBlock = (flag = other.avatar.getExtendedInfo().getFlags$osrs_221_model() | this.observerExtendedInfoFlags.getFlag(index)) != 0;
            if (!hasExtendedInfoBlock) {
                this.setHighResolutionExtendedInfoTracked(index);
            }
            UnsafeLongBackedBitBuf highResBuf = other.highResMovementBuffer;
            boolean bl3 = skipped = !hasExtendedInfoBlock && highResBuf == null;
            if (!skipped) {
                if (skips > -1) {
                    this.pStationary(buffer, skips);
                    skips = -1;
                }
                this.pHighRes(buffer, index, hasExtendedInfoBlock, highResBuf);
                continue;
            }
            ++skips;
            this.stationary[index] = (byte)(this.stationary[index] | 2);
        }
        if (skips > -1) {
            this.pStationary(buffer, skips);
        }
    }

    private final void pStationary(BitBuf buffer, int count) {
        int lowerBits = -count >>> 31;
        int higherBits = (-(count >> 5) >>> 31) + (-(count >> 8) >>> 31);
        int bitCountOpcode = lowerBits + higherBits;
        int valueBitCount = lowerBits * 5 + higherBits * 3;
        buffer.pBits(3 + valueBitCount, count | bitCountOpcode << valueBitCount);
    }

    private final void pHighRes(BitBuf buffer, int index, boolean extendedInfo, UnsafeLongBackedBitBuf highResBuf) {
        buffer.pBits(1, 1);
        if (extendedInfo) {
            int n = this.extendedInfoCount;
            this.extendedInfoCount = n + 1;
            this.extendedInfoIndices[n] = (short)index;
            buffer.pBits(1, 1);
        } else {
            buffer.pBits(1, 0);
        }
        if (highResBuf != null) {
            buffer.pBits(highResBuf);
        } else {
            buffer.pBits(2, 0);
        }
    }

    private final void pHighToLowResChange(BitBuf buffer, int index) {
        this.unsetHighResolution(index);
        this.unsetHighResolutionExtendedInfoTracked(index);
        buffer.pBits(4, 8);
        UnsafeLongBackedBitBuf buf = this.globalLowResolutionPositionRepository.getBuffer$osrs_221_model(index);
        if (buf != null) {
            buffer.pBits(1, 1);
            buffer.pBits(buf);
        } else {
            buffer.pBits(1, 0);
        }
    }

    private final boolean shouldStayInHighResolution(PlayerInfo other) {
        if (other == null) {
            return false;
        }
        if (other.localIndex == this.localIndex) {
            return true;
        }
        if (other.avatar.getHidden()) {
            return false;
        }
        if (other.avatar.getAllocateCycle$osrs_221_model() == PlayerInfoProtocol.Companion.getCycleCount$osrs_221_model()) {
            return false;
        }
        int coord = other.avatar.getCurrentCoord-aQXte_c();
        if (!CoordGrid.inDistance-XODtI-Q((int)coord, (int)this.avatar.getCurrentCoord-aQXte_c(), (int)this.avatar.getResizeRange$osrs_221_model())) {
            return false;
        }
        long buildArea = this.buildArea;
        return BuildArea.equals-impl0(buildArea, BuildArea.Companion.getINVALID-RDuwMps()) || BuildArea.contains-1IQ_v9c$osrs_221_model(buildArea, coord);
    }

    private final boolean shouldMoveToHighResolution(PlayerInfo other) {
        if (other == null || other.localIndex == this.localIndex) {
            return false;
        }
        if (other.avatar.getHidden()) {
            return false;
        }
        int coord = other.avatar.getCurrentCoord-aQXte_c();
        if (!CoordGrid.inDistance-XODtI-Q((int)coord, (int)this.avatar.getCurrentCoord-aQXte_c(), (int)this.avatar.getResizeRange$osrs_221_model())) {
            return false;
        }
        long buildArea = this.buildArea;
        return BuildArea.equals-impl0(buildArea, BuildArea.Companion.getINVALID-RDuwMps()) || BuildArea.contains-1IQ_v9c$osrs_221_model(buildArea, coord);
    }

    private final ByteBuf allocBuffer() {
        ByteBuf buffer;
        this.buffer = buffer = this.allocator.buffer(40000, 40000);
        Intrinsics.checkNotNull((Object)buffer);
        this.recycler.plusAssign(buffer);
        return buffer;
    }

    public final void postUpdate$osrs_221_model() {
        this.avatar.postUpdate();
        this.avatar.getExtendedInfo().postUpdate$osrs_221_model();
        this.lowResolutionCount = 0;
        this.highResolutionCount = 0;
        this.extendedInfoCount = 0;
        for (int i = 1; i < 2048; ++i) {
            int n;
            this.stationary[i] = (byte)(this.stationary[i] >> 1);
            if (this.isHighResolution(i)) {
                n = this.highResolutionCount;
                this.highResolutionCount = n + 1;
                this.highResolutionIndices[n] = (short)i;
                continue;
            }
            n = this.lowResolutionCount;
            this.lowResolutionCount = n + 1;
            this.lowResolutionIndices[n] = (short)i;
        }
        this.observerExtendedInfoFlags.reset();
        this.avatar.getExtendedInfo().postUpdate$osrs_221_model();
    }

    @Override
    public void onAlloc(int index, @NotNull OldSchoolClientType oldSchoolClientType) {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        this.localIndex = index;
        this.avatar.getExtendedInfo().setLocalIndex$osrs_221_model(index);
        this.oldSchoolClientType = oldSchoolClientType;
        this.buildArea = BuildArea.Companion.getINVALID-RDuwMps();
        this.avatar.reset$osrs_221_model();
        this.avatar.setAllocateCycle$osrs_221_model(PlayerInfoProtocol.Companion.getCycleCount$osrs_221_model());
        ArraysKt.fill$default((short[])this.lowResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        this.lowResolutionCount = 0;
        ArraysKt.fill$default((short[])this.highResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        this.highResolutionCount = 0;
        ArraysKt.fill$default((long[])this.highResolutionPlayers, (long)0L, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((long[])this.highResolutionExtendedInfoTrackedPlayers, (long)0L, (int)0, (int)0, (int)6, null);
        this.extendedInfoCount = 0;
        ArraysKt.fill$default((short[])this.extendedInfoIndices, (short)0, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((byte[])this.stationary, (byte)0, (int)0, (int)0, (int)6, null);
        this.observerExtendedInfoFlags.reset();
        this.buffer = null;
    }

    @Override
    public void onDealloc() {
        this.buffer = null;
        this.avatar.getExtendedInfo().reset$osrs_221_model();
        this.highResMovementBuffer = null;
    }

    private final UnsafeLongBackedBitBuf prepareHighResMovement() {
        int newCoord;
        int oldCoord = this.avatar.getLastCoord-aQXte_c$osrs_221_model();
        if (CoordGrid.equals-impl0((int)oldCoord, (int)(newCoord = this.avatar.getCurrentCoord-aQXte_c()))) {
            return null;
        }
        UnsafeLongBackedBitBuf buffer = new UnsafeLongBackedBitBuf();
        int deltaX = CoordGrid.getX-impl((int)newCoord) - CoordGrid.getX-impl((int)oldCoord);
        int deltaZ = CoordGrid.getZ-impl((int)newCoord) - CoordGrid.getZ-impl((int)oldCoord);
        int deltaLevel = CoordGrid.getLevel-impl((int)newCoord) - CoordGrid.getLevel-impl((int)oldCoord);
        int absX = Math.abs(deltaX);
        int absZ = Math.abs(deltaZ);
        if (deltaLevel != 0 || absX > 2 || absZ > 2) {
            if (absX >= 16 || absZ >= 16) {
                this.pLargeTeleport(buffer, deltaX, deltaZ, deltaLevel);
            } else {
                this.pSmallTeleport(buffer, deltaX, deltaZ, deltaLevel);
            }
        } else if (absX == 2 || absZ == 2) {
            this.pRun(buffer, deltaX, deltaZ);
        } else {
            this.pWalk(buffer, deltaX, deltaZ);
        }
        return buffer;
    }

    private final void pWalk(UnsafeLongBackedBitBuf buffer, int deltaX, int deltaZ) throws ArrayIndexOutOfBoundsException {
        buffer.pBits(2, 1);
        buffer.pBits(3, CellOpcodes.INSTANCE.singleCellMovementOpcode$osrs_221_model(deltaX, deltaZ));
    }

    private final void pRun(UnsafeLongBackedBitBuf buffer, int deltaX, int deltaZ) throws ArrayIndexOutOfBoundsException {
        buffer.pBits(2, 2);
        buffer.pBits(4, CellOpcodes.INSTANCE.dualCellMovementOpcode$osrs_221_model(deltaX, deltaZ));
    }

    private final void pSmallTeleport(UnsafeLongBackedBitBuf buffer, int deltaX, int deltaZ, int deltaLevel) {
        buffer.pBits(2, 3);
        buffer.pBits(1, 0);
        buffer.pBits(2, deltaLevel & 3);
        buffer.pBits(5, deltaX & 0x1F);
        buffer.pBits(5, deltaZ & 0x1F);
    }

    private final void pLargeTeleport(UnsafeLongBackedBitBuf buffer, int deltaX, int deltaZ, int deltaLevel) {
        buffer.pBits(2, 3);
        buffer.pBits(1, 1);
        buffer.pBits(2, deltaLevel & 3);
        buffer.pBits(14, deltaX & 0x3FFF);
        buffer.pBits(14, deltaZ & 0x3FFF);
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ, int widthInZones) {
        PlayerInfo.updateBuildArea$default(this, zoneX, zoneZ, widthInZones, 0, 8, null);
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ) {
        PlayerInfo.updateBuildArea$default(this, zoneX, zoneZ, 0, 0, 12, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfo$Companion;", "", "()V", "BUF_CAPACITY", "", "IS_STATIONARY", "WAS_STATIONARY", "osrs-221-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

