/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.incoming.misc.client;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.protocol.ClientProtCategory;
import net.rsprot.protocol.game.incoming.GameClientProtCategory;
import net.rsprot.protocol.game.outgoing.misc.client.ReflectionChecker;
import net.rsprot.protocol.message.IncomingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001:\f\u001b\u001c\u001d\u001e\u001f !\"#$%&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply;", "Lnet/rsprot/protocol/message/IncomingGameMessage;", "id", "", "result", "Lio/netty/buffer/ByteBuf;", "(ILio/netty/buffer/ByteBuf;)V", "category", "Lnet/rsprot/protocol/ClientProtCategory;", "getCategory", "()Lnet/rsprot/protocol/ClientProtCategory;", "getId", "()I", "getResult", "()Lio/netty/buffer/ByteBuf;", "decode", "", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ReflectionCheckResult;", "request", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker;", "getConstructionThrowableClass", "Ljava/lang/Class;", "", "opcode", "getExecutionThrowableClass", "toString", "", "ErrorResult", "GetFieldModifiersResult", "GetFieldValueResult", "GetMethodModifiersResult", "InvokeMethodResult", "MethodInvocationReturnValue", "NullReturnValue", "NumberReturnValue", "ReflectionCheckResult", "SetFieldValueResult", "StringReturnValue", "UnknownReturnValue", "osrs-221-model"})
@SourceDebugExtension(value={"SMAP\nReflectionCheckReply.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionCheckReply.kt\nnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply\n+ 2 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n*L\n1#1,475:1\n145#2,2:476\n154#2:478\n306#2:479\n306#2:480\n342#2:481\n382#2:482\n306#2:483\n*S KotlinDebug\n*F\n+ 1 ReflectionCheckReply.kt\nnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply\n*L\n42#1:476,2\n45#1:478\n66#1:479\n75#1:480\n83#1:481\n84#1:482\n91#1:483\n*E\n"})
public final class ReflectionCheckReply
implements IncomingGameMessage {
    private final int id;
    @NotNull
    private final ByteBuf result;

    public ReflectionCheckReply(int id, @NotNull ByteBuf result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.id = id;
        this.result = result;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final ByteBuf getResult() {
        return this.result;
    }

    @NotNull
    public ClientProtCategory getCategory() {
        return GameClientProtCategory.CLIENT_EVENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ReflectionCheckResult<?>> decode(@NotNull ReflectionChecker request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)this.result);
            int num$iv = 4;
            boolean bl = false;
            buffer.skipBytes(num$iv);
            ArrayList results = new ArrayList(request.getChecks().size());
            for (ReflectionChecker.ReflectionCheck check : request.getChecks()) {
                boolean bl2 = false;
                int opcode = JagexByteBufExtensionsKt.g1s((ByteBuf)buffer);
                if (opcode < 0) {
                    Class<? extends Throwable> throwable;
                    if (opcode <= -10) {
                        throwable = this.getExecutionThrowableClass(opcode);
                        ((Collection)results).add(new ErrorResult(check, new ErrorResult.ThrowableResultType.ExecutionThrowable<Class<? extends Throwable>>(throwable)));
                        continue;
                    }
                    throwable = this.getConstructionThrowableClass(opcode);
                    ((Collection)results).add(new ErrorResult(check, new ErrorResult.ThrowableResultType.ConstructionThrowable<Class<? extends Throwable>>(throwable)));
                    continue;
                }
                ReflectionChecker.ReflectionCheck reflectionCheck = check;
                if (reflectionCheck instanceof ReflectionChecker.GetFieldValue) {
                    boolean bl3 = false;
                    int result = JagexByteBufExtensionsKt.g4((ByteBuf)buffer);
                    ((Collection)results).add(new GetFieldValueResult((ReflectionChecker.GetFieldValue)check, result));
                    continue;
                }
                if (reflectionCheck instanceof ReflectionChecker.SetFieldValue) {
                    ((Collection)results).add(new SetFieldValueResult((ReflectionChecker.SetFieldValue)check));
                    continue;
                }
                if (reflectionCheck instanceof ReflectionChecker.GetFieldModifiers) {
                    boolean bl4 = false;
                    int modifiers = JagexByteBufExtensionsKt.g4((ByteBuf)buffer);
                    ((Collection)results).add(new GetFieldModifiersResult((ReflectionChecker.GetFieldModifiers)check, modifiers));
                    continue;
                }
                if (reflectionCheck instanceof ReflectionChecker.InvokeMethod) {
                    InvokeMethodResult<MethodInvocationReturnValue> invokeMethodResult;
                    Collection modifiers = results;
                    switch (opcode) {
                        case 0: {
                            invokeMethodResult = new InvokeMethodResult<MethodInvocationReturnValue>((ReflectionChecker.InvokeMethod)check, NullReturnValue.INSTANCE);
                            break;
                        }
                        case 1: {
                            boolean bl5 = false;
                            invokeMethodResult = new InvokeMethodResult<MethodInvocationReturnValue>((ReflectionChecker.InvokeMethod)check, new NumberReturnValue(JagexByteBufExtensionsKt.g8((ByteBuf)buffer)));
                            break;
                        }
                        case 2: {
                            boolean bl6 = false;
                            invokeMethodResult = new InvokeMethodResult<MethodInvocationReturnValue>((ReflectionChecker.InvokeMethod)check, new StringReturnValue(JagexByteBufExtensionsKt.gjstr((ByteBuf)buffer)));
                            break;
                        }
                        case 4: {
                            invokeMethodResult = new InvokeMethodResult<MethodInvocationReturnValue>((ReflectionChecker.InvokeMethod)check, UnknownReturnValue.INSTANCE);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown opcode for method invocation: " + opcode);
                        }
                    }
                    InvokeMethodResult<MethodInvocationReturnValue> bl4 = invokeMethodResult;
                    modifiers.add(bl4);
                    continue;
                }
                if (!(reflectionCheck instanceof ReflectionChecker.GetMethodModifiers)) continue;
                boolean bl7 = false;
                int modifiers = JagexByteBufExtensionsKt.g4((ByteBuf)buffer);
                ((Collection)results).add(new GetMethodModifiersResult((ReflectionChecker.GetMethodModifiers)check, modifiers));
            }
            this.result.readerIndex(this.result.writerIndex());
            if (!JagexByteBufExtensionsKt.checkCRC32((ByteBuf)this.result)) {
                throw new IllegalStateException("CRC mismatch!");
            }
            List list = results;
            return list;
        }
        finally {
            this.result.release();
        }
    }

    private final Class<? extends Throwable> getExecutionThrowableClass(int opcode) {
        Class clazz;
        switch (opcode) {
            case -10: {
                clazz = ClassNotFoundException.class;
                break;
            }
            case -11: {
                clazz = InvalidClassException.class;
                break;
            }
            case -12: {
                clazz = StreamCorruptedException.class;
                break;
            }
            case -13: {
                clazz = OptionalDataException.class;
                break;
            }
            case -14: {
                clazz = IllegalAccessException.class;
                break;
            }
            case -15: {
                clazz = IllegalArgumentException.class;
                break;
            }
            case -16: {
                clazz = InvocationTargetException.class;
                break;
            }
            case -17: {
                clazz = SecurityException.class;
                break;
            }
            case -18: {
                clazz = IOException.class;
                break;
            }
            case -19: {
                clazz = NullPointerException.class;
                break;
            }
            case -20: {
                clazz = Exception.class;
                break;
            }
            case -21: {
                clazz = Throwable.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown execution throwable opcode: " + opcode);
            }
        }
        return clazz;
    }

    private final Class<? extends Throwable> getConstructionThrowableClass(int opcode) {
        Class clazz;
        switch (opcode) {
            case -1: {
                clazz = ClassNotFoundException.class;
                break;
            }
            case -2: {
                clazz = SecurityException.class;
                break;
            }
            case -3: {
                clazz = NullPointerException.class;
                break;
            }
            case -4: {
                clazz = Exception.class;
                break;
            }
            case -5: {
                clazz = Throwable.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown construction throwable opcode: " + opcode);
            }
        }
        return clazz;
    }

    @NotNull
    public String toString() {
        return "ReflectionCheckReply(id=" + this.id + ", result=" + this.result + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0010\b\u0001\u0010\u0003*\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0006:\u0001\u0018B\u001b\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0016\u0010\u0007\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult;", "T", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$ReflectionCheck;", "E", "Ljava/lang/Class;", "", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ReflectionCheckResult;", "check", "throwable", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType;", "(Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$ReflectionCheck;Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType;)V", "getCheck", "()Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$ReflectionCheck;", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$ReflectionCheck;", "getThrowable", "()Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType;", "equals", "", "other", "", "hashCode", "", "toString", "", "ThrowableResultType", "osrs-221-model"})
    public static final class ErrorResult<T extends ReflectionChecker.ReflectionCheck, E extends Class<? extends Throwable>>
    implements ReflectionCheckResult<T> {
        @NotNull
        private final T check;
        @NotNull
        private final ThrowableResultType<E> throwable;

        public ErrorResult(@NotNull T check, @NotNull ThrowableResultType<E> throwable) {
            Intrinsics.checkNotNullParameter(check, (String)"check");
            Intrinsics.checkNotNullParameter(throwable, (String)"throwable");
            this.check = check;
            this.throwable = throwable;
        }

        @Override
        @NotNull
        public T getCheck() {
            return this.check;
        }

        @NotNull
        public final ThrowableResultType<E> getThrowable() {
            return this.throwable;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.misc.client.ReflectionCheckReply.ErrorResult<*, *>");
            ErrorResult cfr_ignored_0 = (ErrorResult)other;
            if (!Intrinsics.areEqual(this.getCheck(), ((ErrorResult)other).getCheck())) {
                return false;
            }
            return Intrinsics.areEqual(this.throwable, ((ErrorResult)other).throwable);
        }

        public int hashCode() {
            int result = this.getCheck().hashCode();
            result = 31 * result + this.throwable.hashCode();
            return result;
        }

        @NotNull
        public String toString() {
            return "ErrorResult(check=" + this.getCheck() + ", throwable=" + this.throwable + ")";
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0010\b\u0002\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u00020\u0004:\u0002\b\tR\u0012\u0010\u0005\u001a\u00028\u0002X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType;", "E", "Ljava/lang/Class;", "", "", "throwableClass", "getThrowableClass", "()Ljava/lang/Class;", "ConstructionThrowable", "ExecutionThrowable", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType$ConstructionThrowable;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType$ExecutionThrowable;", "osrs-221-model"})
        public static interface ThrowableResultType<E extends Class<? extends Throwable>> {
            @NotNull
            public E getThrowableClass();

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0010\b\u0003\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0005\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType$ConstructionThrowable;", "E", "Ljava/lang/Class;", "", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType;", "throwableClass", "(Ljava/lang/Class;)V", "getThrowableClass", "()Ljava/lang/Class;", "Ljava/lang/Class;", "equals", "", "other", "", "hashCode", "", "toString", "", "osrs-221-model"})
            public static final class ConstructionThrowable<E extends Class<? extends Throwable>>
            implements ThrowableResultType<E> {
                @NotNull
                private final E throwableClass;

                public ConstructionThrowable(@NotNull E throwableClass) {
                    Intrinsics.checkNotNullParameter(throwableClass, (String)"throwableClass");
                    this.throwableClass = throwableClass;
                }

                @Override
                @NotNull
                public E getThrowableClass() {
                    return this.throwableClass;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ConstructionThrowable)) {
                        return false;
                    }
                    return Intrinsics.areEqual(this.getThrowableClass(), ((ConstructionThrowable)other).getThrowableClass());
                }

                public int hashCode() {
                    return this.getThrowableClass().hashCode();
                }

                @NotNull
                public String toString() {
                    return "ConstructionThrowable(throwableClass=" + this.getThrowableClass() + ")";
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0010\b\u0003\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0005\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType$ExecutionThrowable;", "E", "Ljava/lang/Class;", "", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult$ThrowableResultType;", "throwableClass", "(Ljava/lang/Class;)V", "getThrowableClass", "()Ljava/lang/Class;", "Ljava/lang/Class;", "equals", "", "other", "", "hashCode", "", "toString", "", "osrs-221-model"})
            public static final class ExecutionThrowable<E extends Class<? extends Throwable>>
            implements ThrowableResultType<E> {
                @NotNull
                private final E throwableClass;

                public ExecutionThrowable(@NotNull E throwableClass) {
                    Intrinsics.checkNotNullParameter(throwableClass, (String)"throwableClass");
                    this.throwableClass = throwableClass;
                }

                @Override
                @NotNull
                public E getThrowableClass() {
                    return this.throwableClass;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ExecutionThrowable)) {
                        return false;
                    }
                    return Intrinsics.areEqual(this.getThrowableClass(), ((ExecutionThrowable)other).getThrowableClass());
                }

                public int hashCode() {
                    return this.getThrowableClass().hashCode();
                }

                @NotNull
                public String toString() {
                    return "ExecutionThrowable(throwableClass=" + this.getThrowableClass() + ")";
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$GetFieldModifiersResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ReflectionCheckResult;", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetFieldModifiers;", "check", "modifiers", "", "(Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetFieldModifiers;I)V", "getCheck", "()Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetFieldModifiers;", "getModifiers", "()I", "equals", "", "other", "", "hashCode", "toString", "", "osrs-221-model"})
    public static final class GetFieldModifiersResult
    implements ReflectionCheckResult<ReflectionChecker.GetFieldModifiers> {
        @NotNull
        private final ReflectionChecker.GetFieldModifiers check;
        private final int modifiers;

        public GetFieldModifiersResult(@NotNull ReflectionChecker.GetFieldModifiers check, int modifiers) {
            Intrinsics.checkNotNullParameter((Object)check, (String)"check");
            this.check = check;
            this.modifiers = modifiers;
        }

        @Override
        @NotNull
        public ReflectionChecker.GetFieldModifiers getCheck() {
            return this.check;
        }

        public final int getModifiers() {
            return this.modifiers;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.misc.client.ReflectionCheckReply.GetFieldModifiersResult");
            GetFieldModifiersResult cfr_ignored_0 = (GetFieldModifiersResult)other;
            if (!Intrinsics.areEqual((Object)this.getCheck(), (Object)((GetFieldModifiersResult)other).getCheck())) {
                return false;
            }
            return this.modifiers == ((GetFieldModifiersResult)other).modifiers;
        }

        public int hashCode() {
            int result = this.getCheck().hashCode();
            result = 31 * result + this.modifiers;
            return result;
        }

        @NotNull
        public String toString() {
            return "GetFieldModifiersResult(check=" + this.getCheck() + ", modifiers=" + this.modifiers + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$GetFieldValueResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ReflectionCheckResult;", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetFieldValue;", "check", "value", "", "(Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetFieldValue;I)V", "getCheck", "()Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetFieldValue;", "getValue", "()I", "equals", "", "other", "", "hashCode", "toString", "", "osrs-221-model"})
    public static final class GetFieldValueResult
    implements ReflectionCheckResult<ReflectionChecker.GetFieldValue> {
        @NotNull
        private final ReflectionChecker.GetFieldValue check;
        private final int value;

        public GetFieldValueResult(@NotNull ReflectionChecker.GetFieldValue check, int value) {
            Intrinsics.checkNotNullParameter((Object)check, (String)"check");
            this.check = check;
            this.value = value;
        }

        @Override
        @NotNull
        public ReflectionChecker.GetFieldValue getCheck() {
            return this.check;
        }

        public final int getValue() {
            return this.value;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.misc.client.ReflectionCheckReply.GetFieldValueResult");
            GetFieldValueResult cfr_ignored_0 = (GetFieldValueResult)other;
            if (!Intrinsics.areEqual((Object)this.getCheck(), (Object)((GetFieldValueResult)other).getCheck())) {
                return false;
            }
            return this.value == ((GetFieldValueResult)other).value;
        }

        public int hashCode() {
            int result = this.getCheck().hashCode();
            result = 31 * result + this.value;
            return result;
        }

        @NotNull
        public String toString() {
            return "GetFieldValueResult(check=" + this.getCheck() + ", value=" + this.value + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$GetMethodModifiersResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ReflectionCheckResult;", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetMethodModifiers;", "check", "modifiers", "", "(Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetMethodModifiers;I)V", "getCheck", "()Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$GetMethodModifiers;", "getModifiers", "()I", "equals", "", "other", "", "hashCode", "toString", "", "osrs-221-model"})
    public static final class GetMethodModifiersResult
    implements ReflectionCheckResult<ReflectionChecker.GetMethodModifiers> {
        @NotNull
        private final ReflectionChecker.GetMethodModifiers check;
        private final int modifiers;

        public GetMethodModifiersResult(@NotNull ReflectionChecker.GetMethodModifiers check, int modifiers) {
            Intrinsics.checkNotNullParameter((Object)check, (String)"check");
            this.check = check;
            this.modifiers = modifiers;
        }

        @Override
        @NotNull
        public ReflectionChecker.GetMethodModifiers getCheck() {
            return this.check;
        }

        public final int getModifiers() {
            return this.modifiers;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.misc.client.ReflectionCheckReply.GetMethodModifiersResult");
            GetMethodModifiersResult cfr_ignored_0 = (GetMethodModifiersResult)other;
            if (!Intrinsics.areEqual((Object)this.getCheck(), (Object)((GetMethodModifiersResult)other).getCheck())) {
                return false;
            }
            return this.modifiers == ((GetMethodModifiersResult)other).modifiers;
        }

        public int hashCode() {
            int result = this.getCheck().hashCode();
            result = 31 * result + this.modifiers;
            return result;
        }

        @NotNull
        public String toString() {
            return "GetMethodModifiersResult(check=" + this.getCheck() + ", modifiers=" + this.modifiers + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$InvokeMethodResult;", "T", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ReflectionCheckResult;", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$InvokeMethod;", "check", "result", "(Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$InvokeMethod;Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;)V", "getCheck", "()Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$InvokeMethod;", "getResult", "()Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;", "equals", "", "other", "", "hashCode", "", "toString", "", "osrs-221-model"})
    public static final class InvokeMethodResult<T extends MethodInvocationReturnValue>
    implements ReflectionCheckResult<ReflectionChecker.InvokeMethod> {
        @NotNull
        private final ReflectionChecker.InvokeMethod check;
        @NotNull
        private final T result;

        public InvokeMethodResult(@NotNull ReflectionChecker.InvokeMethod check, @NotNull T result) {
            Intrinsics.checkNotNullParameter((Object)check, (String)"check");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            this.check = check;
            this.result = result;
        }

        @Override
        @NotNull
        public ReflectionChecker.InvokeMethod getCheck() {
            return this.check;
        }

        @NotNull
        public final T getResult() {
            return this.result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.misc.client.ReflectionCheckReply.InvokeMethodResult<*>");
            InvokeMethodResult cfr_ignored_0 = (InvokeMethodResult)other;
            if (!Intrinsics.areEqual((Object)this.getCheck(), (Object)((InvokeMethodResult)other).getCheck())) {
                return false;
            }
            return Intrinsics.areEqual(this.result, ((InvokeMethodResult)other).result);
        }

        public int hashCode() {
            int result1 = this.getCheck().hashCode();
            result1 = 31 * result1 + this.result.hashCode();
            return result1;
        }

        @NotNull
        public String toString() {
            return "InvokeMethodResult(check=" + this.getCheck() + ", result=" + this.result + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0004\u0002\u0003\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;", "", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$NullReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$NumberReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$StringReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$UnknownReturnValue;", "osrs-221-model"})
    public static interface MethodInvocationReturnValue {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$NullReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "osrs-221-model"})
    public static final class NullReturnValue
    implements MethodInvocationReturnValue {
        @NotNull
        public static final NullReturnValue INSTANCE = new NullReturnValue();

        private NullReturnValue() {
        }

        @NotNull
        public String toString() {
            return "NullReturnValue";
        }

        public int hashCode() {
            return -1640442041;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NullReturnValue)) {
                return false;
            }
            NullReturnValue cfr_ignored_0 = (NullReturnValue)other;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$NumberReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;", "longValue", "", "(J)V", "getLongValue", "()J", "equals", "", "other", "", "hashCode", "", "toString", "", "osrs-221-model"})
    public static final class NumberReturnValue
    implements MethodInvocationReturnValue {
        private final long longValue;

        public NumberReturnValue(long longValue) {
            this.longValue = longValue;
        }

        public final long getLongValue() {
            return this.longValue;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.misc.client.ReflectionCheckReply.NumberReturnValue");
            NumberReturnValue cfr_ignored_0 = (NumberReturnValue)other;
            return this.longValue == ((NumberReturnValue)other).longValue;
        }

        public int hashCode() {
            return Long.hashCode(this.longValue);
        }

        @NotNull
        public String toString() {
            return "NumberReturnValue(longValue=" + this.longValue + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003R\u0012\u0010\u0004\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0006\u0007\b\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ReflectionCheckResult;", "T", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$ReflectionCheck;", "", "check", "getCheck", "()Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$ReflectionCheck;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ErrorResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$GetFieldModifiersResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$GetFieldValueResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$GetMethodModifiersResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$InvokeMethodResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$SetFieldValueResult;", "osrs-221-model"})
    public static interface ReflectionCheckResult<T extends ReflectionChecker.ReflectionCheck> {
        @NotNull
        public T getCheck();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$SetFieldValueResult;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$ReflectionCheckResult;", "Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$SetFieldValue;", "check", "(Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$SetFieldValue;)V", "getCheck", "()Lnet/rsprot/protocol/game/outgoing/misc/client/ReflectionChecker$SetFieldValue;", "equals", "", "other", "", "hashCode", "", "toString", "", "osrs-221-model"})
    public static final class SetFieldValueResult
    implements ReflectionCheckResult<ReflectionChecker.SetFieldValue> {
        @NotNull
        private final ReflectionChecker.SetFieldValue check;

        public SetFieldValueResult(@NotNull ReflectionChecker.SetFieldValue check) {
            Intrinsics.checkNotNullParameter((Object)check, (String)"check");
            this.check = check;
        }

        @Override
        @NotNull
        public ReflectionChecker.SetFieldValue getCheck() {
            return this.check;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.misc.client.ReflectionCheckReply.SetFieldValueResult");
            SetFieldValueResult cfr_ignored_0 = (SetFieldValueResult)other;
            return Intrinsics.areEqual((Object)this.getCheck(), (Object)((SetFieldValueResult)other).getCheck());
        }

        public int hashCode() {
            return this.getCheck().hashCode();
        }

        @NotNull
        public String toString() {
            return "SetFieldValueResult(check=" + this.getCheck() + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$StringReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;", "stringValue", "", "(Ljava/lang/String;)V", "getStringValue", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "osrs-221-model"})
    public static final class StringReturnValue
    implements MethodInvocationReturnValue {
        @NotNull
        private final String stringValue;

        public StringReturnValue(@NotNull String stringValue) {
            Intrinsics.checkNotNullParameter((Object)stringValue, (String)"stringValue");
            this.stringValue = stringValue;
        }

        @NotNull
        public final String getStringValue() {
            return this.stringValue;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.misc.client.ReflectionCheckReply.StringReturnValue");
            StringReturnValue cfr_ignored_0 = (StringReturnValue)other;
            return Intrinsics.areEqual((Object)this.stringValue, (Object)((StringReturnValue)other).stringValue);
        }

        public int hashCode() {
            return this.stringValue.hashCode();
        }

        @NotNull
        public String toString() {
            return "StringReturnValue(stringValue='" + this.stringValue + "')";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$UnknownReturnValue;", "Lnet/rsprot/protocol/game/incoming/misc/client/ReflectionCheckReply$MethodInvocationReturnValue;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "osrs-221-model"})
    public static final class UnknownReturnValue
    implements MethodInvocationReturnValue {
        @NotNull
        public static final UnknownReturnValue INSTANCE = new UnknownReturnValue();

        private UnknownReturnValue() {
        }

        @NotNull
        public String toString() {
            return "UnknownReturnValue";
        }

        public int hashCode() {
            return 1932264234;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnknownReturnValue)) {
                return false;
            }
            UnknownReturnValue cfr_ignored_0 = (UnknownReturnValue)other;
            return true;
        }
    }
}

