/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.loginprot.incoming.pow.challenges.sha256;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.ChallengeVerifier;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.sha256.Sha256Challenge;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.sha256.hashing.DefaultSha256MessageDigestHashFunction;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.sha256.hashing.Sha256HashFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/sha256/Sha256ChallengeVerifier;", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/ChallengeVerifier;", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/sha256/Sha256Challenge;", "hashFunction", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/sha256/hashing/Sha256HashFunction;", "(Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/sha256/hashing/Sha256HashFunction;)V", "equals", "", "other", "", "hashCode", "", "leadingZeros", "byte", "", "byteArray", "", "toString", "", "verify", "result", "", "challenge", "osrs-221-model"})
public final class Sha256ChallengeVerifier
implements ChallengeVerifier<Sha256Challenge> {
    @NotNull
    private final Sha256HashFunction hashFunction;

    public Sha256ChallengeVerifier(@NotNull Sha256HashFunction hashFunction) {
        Intrinsics.checkNotNullParameter((Object)hashFunction, (String)"hashFunction");
        this.hashFunction = hashFunction;
    }

    public /* synthetic */ Sha256ChallengeVerifier(Sha256HashFunction sha256HashFunction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sha256HashFunction = DefaultSha256MessageDigestHashFunction.INSTANCE;
        }
        this(sha256HashFunction);
    }

    @Override
    public boolean verify(long result, @NotNull Sha256Challenge challenge) {
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        String baseString = challenge.getBaseString();
        StringBuilder builder = new StringBuilder(baseString);
        builder.append(Long.toHexString(result));
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] utf8ByteArray = byArray;
        byte[] hash = this.hashFunction.hash(utf8ByteArray);
        return this.leadingZeros(hash) >= challenge.getDifficulty();
    }

    private final int leadingZeros(byte[] byteArray) {
        int numBits = 0;
        for (byte by : byteArray) {
            int bitCount = this.leadingZeros(by);
            numBits += bitCount;
            if (bitCount != 8) break;
        }
        return numBits;
    }

    private final int leadingZeros(byte by) {
        int value = by & 0xFF;
        if (value == 0) {
            return 8;
        }
        int numBits = 0;
        while ((value & 0x80) == 0) {
            ++numBits;
            value <<= 1;
        }
        return numBits;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Sha256ChallengeVerifier)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.hashFunction, (Object)((Sha256ChallengeVerifier)other).hashFunction);
    }

    public int hashCode() {
        return this.hashFunction.hashCode();
    }

    @NotNull
    public String toString() {
        return "Sha256ChallengeVerifier(hashFunction=" + this.hashFunction + ")";
    }

    public Sha256ChallengeVerifier() {
        this(null, 1, null);
    }
}

