/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.misc.player;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ServerProtCategory;
import net.rsprot.protocol.common.RSProtFlags;
import net.rsprot.protocol.game.outgoing.GameServerProtCategory;
import net.rsprot.protocol.message.OutgoingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lnet/rsprot/protocol/game/outgoing/misc/player/RunClientScript;", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "id", "", "types", "", "values", "", "", "(I[CLjava/util/List;)V", "(ILjava/util/List;)V", "category", "Lnet/rsprot/protocol/ServerProtCategory;", "getCategory", "()Lnet/rsprot/protocol/ServerProtCategory;", "getId", "()I", "getTypes", "()[C", "getValues", "()Ljava/util/List;", "equals", "", "other", "hashCode", "toString", "", "osrs-221-model"})
public final class RunClientScript
implements OutgoingGameMessage {
    private final int id;
    @NotNull
    private final char[] types;
    @NotNull
    private final List<Object> values;

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final char[] getTypes() {
        return this.types;
    }

    @NotNull
    public final List<Object> getValues() {
        return this.values;
    }

    public RunClientScript(int id, @NotNull char[] types, @NotNull List<? extends Object> values) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.id = id;
        this.types = types;
        this.values = values;
        if (RSProtFlags.getClientscriptVerification()) {
            if (!(types.length == values.size())) {
                boolean bl = false;
                String string = "Types and values sizes must match: " + types.length + ", " + values.size();
                throw new IllegalArgumentException(string.toString());
            }
            int n = types.length;
            for (int i = 0; i < n; ++i) {
                char type = types[i];
                Object value = values.get(i);
                if (type == 's') {
                    if (value instanceof String) continue;
                    boolean $i$a$-require-RunClientScript$42 = false;
                    String $i$a$-require-RunClientScript$42 = "Expected string value at index " + i + " for char " + type + ", got: " + value;
                    throw new IllegalArgumentException($i$a$-require-RunClientScript$42.toString());
                }
                if (value instanceof Integer) continue;
                boolean bl = false;
                String string = "Expected int value at index " + i + " for char " + type + ", got: " + value;
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public RunClientScript(int id, @NotNull List<? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.id = id;
        this.values = values;
        int n = values.size();
        char[] cArray = new char[n];
        RunClientScript runClientScript = this;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i;
            Object value = values.get(n3);
            if (value instanceof Integer) {
                n2 = 105;
            } else if (value instanceof String) {
                n2 = 115;
            } else {
                throw new IllegalArgumentException("Unknown clientscript value type: " + value.getClass() + " @ " + value + ", accepted types only include integers and strings.");
            }
            cArray[n3] = n2;
        }
        runClientScript.types = cArray;
    }

    @NotNull
    public ServerProtCategory getCategory() {
        return GameServerProtCategory.LOW_PRIORITY_PROT;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.outgoing.misc.player.RunClientScript");
        RunClientScript cfr_ignored_0 = (RunClientScript)other;
        if (this.id != ((RunClientScript)other).id) {
            return false;
        }
        if (!Arrays.equals(this.types, ((RunClientScript)other).types)) {
            return false;
        }
        return Intrinsics.areEqual(this.values, ((RunClientScript)other).values);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + Arrays.hashCode(this.types);
        result = 31 * result + ((Object)this.values).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.types);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "RunClientScript(id=" + this.id + ", types=" + string + ", values=" + this.values + ")";
    }
}

