/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.npcinfo;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.common.client.ClientTypeMap;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.common.game.outgoing.info.npcinfo.encoder.NpcResolutionChangeEncoder;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatar;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarExceptionHandler;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarFactory;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarRepository;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcIndexSupplier;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfo;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoRepository;
import net.rsprot.protocol.game.outgoing.info.worker.DefaultProtocolWorker;
import net.rsprot.protocol.game.outgoing.info.worker.ProtocolWorker;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 02\u00020\u0001:\u00010B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001b2\n\u0010 \u001a\u00060!j\u0002`\"H\u0002J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0019J$\u0010%\u001a\u00020\u00152\u0019\b\u0004\u0010&\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150'\u00a2\u0006\u0002\b(H\u0082\bJ\u0011\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002J\b\u0010*\u001a\u00020\u0015H\u0002J\b\u0010+\u001a\u00020\u0015H\u0002J\b\u0010,\u001a\u00020\u0015H\u0002J\b\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020\u0015H\u0002J\u0006\u0010/\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol;", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "npcIndexSupplier", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcIndexSupplier;", "resolutionChangeEncoders", "Lnet/rsprot/protocol/common/client/ClientTypeMap;", "Lnet/rsprot/protocol/common/game/outgoing/info/npcinfo/encoder/NpcResolutionChangeEncoder;", "avatarFactory", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFactory;", "exceptionHandler", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExceptionHandler;", "worker", "Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcIndexSupplier;Lnet/rsprot/protocol/common/client/ClientTypeMap;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFactory;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExceptionHandler;Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;)V", "avatarRepository", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository;", "callables", "", "Ljava/util/concurrent/Callable;", "", "npcInfoRepository", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoRepository;", "alloc", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfo;", "idx", "", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "catchException", "index", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "dealloc", "info", "execute", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "get", "postUpdate", "prepareBitcodes", "prepareExtendedInfo", "putBitcodes", "putExtendedInfo", "update", "Companion", "osrs-221-model"})
@SourceDebugExtension(value={"SMAP\nNpcInfoProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpcInfoProtocol.kt\nnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,256:1\n196#1,3:265\n212#1,3:268\n196#1,3:271\n212#1,3:274\n134#2,4:257\n134#2,4:261\n11#3,2:277\n*S KotlinDebug\n*F\n+ 1 NpcInfoProtocol.kt\nnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol\n*L\n158#1:265,3\n158#1:268,3\n168#1:271,3\n168#1:274,3\n117#1:257,4\n145#1:261,4\n237#1:277,2\n*E\n"})
public final class NpcInfoProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final NpcIndexSupplier npcIndexSupplier;
    @NotNull
    private final ClientTypeMap<NpcResolutionChangeEncoder> resolutionChangeEncoders;
    @NotNull
    private final NpcAvatarExceptionHandler exceptionHandler;
    @NotNull
    private final ProtocolWorker worker;
    @NotNull
    private final NpcAvatarRepository avatarRepository;
    @NotNull
    private final NpcInfoRepository npcInfoRepository;
    @NotNull
    private final List<Callable<Unit>> callables;
    public static final int PROTOCOL_CAPACITY = 2048;
    @NotNull
    private static final Logger logger;
    private static int cycleCount;

    public NpcInfoProtocol(@NotNull ByteBufAllocator allocator, @NotNull NpcIndexSupplier npcIndexSupplier, @NotNull ClientTypeMap<? extends NpcResolutionChangeEncoder> resolutionChangeEncoders, @NotNull NpcAvatarFactory avatarFactory, @NotNull NpcAvatarExceptionHandler exceptionHandler, @NotNull ProtocolWorker worker) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)npcIndexSupplier, (String)"npcIndexSupplier");
        Intrinsics.checkNotNullParameter(resolutionChangeEncoders, (String)"resolutionChangeEncoders");
        Intrinsics.checkNotNullParameter((Object)avatarFactory, (String)"avatarFactory");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        this.allocator = allocator;
        this.npcIndexSupplier = npcIndexSupplier;
        this.resolutionChangeEncoders = resolutionChangeEncoders;
        this.exceptionHandler = exceptionHandler;
        this.worker = worker;
        this.avatarRepository = avatarFactory.getAvatarRepository$osrs_221_model();
        this.npcInfoRepository = new NpcInfoRepository((Function2<? super Integer, ? super OldSchoolClientType, NpcInfo>)((Function2)new Function2<Integer, OldSchoolClientType, NpcInfo>(this){
            final /* synthetic */ NpcInfoProtocol this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final NpcInfo invoke(int localIndex, @NotNull OldSchoolClientType clientType) {
                Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
                return new NpcInfo(NpcInfoProtocol.access$getAllocator$p(this.this$0), NpcInfoProtocol.access$getAvatarRepository$p(this.this$0), clientType, localIndex, NpcInfoProtocol.access$getNpcIndexSupplier$p(this.this$0), (ClientTypeMap<? extends NpcResolutionChangeEncoder>)NpcInfoProtocol.access$getResolutionChangeEncoders$p(this.this$0));
            }
        }));
        this.callables = new ArrayList(2048);
    }

    public /* synthetic */ NpcInfoProtocol(ByteBufAllocator byteBufAllocator, NpcIndexSupplier npcIndexSupplier, ClientTypeMap clientTypeMap, NpcAvatarFactory npcAvatarFactory, NpcAvatarExceptionHandler npcAvatarExceptionHandler, ProtocolWorker protocolWorker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            protocolWorker = new DefaultProtocolWorker();
        }
        this(byteBufAllocator, npcIndexSupplier, (ClientTypeMap<? extends NpcResolutionChangeEncoder>)clientTypeMap, npcAvatarFactory, npcAvatarExceptionHandler, protocolWorker);
    }

    @NotNull
    public final NpcInfo alloc(int idx, @NotNull OldSchoolClientType oldSchoolClientType) {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        return (NpcInfo)this.npcInfoRepository.alloc(idx, oldSchoolClientType);
    }

    public final void dealloc(@NotNull NpcInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.npcInfoRepository.dealloc(info.getLocalPlayerIndex$osrs_221_model());
    }

    @NotNull
    public final NpcInfo get(int idx) {
        return (NpcInfo)this.npcInfoRepository.get(idx);
    }

    public final void update() {
        this.prepareBitcodes();
        this.putBitcodes();
        this.prepareExtendedInfo();
        this.putExtendedInfo();
        this.postUpdate();
        int n = cycleCount;
        cycleCount = n + 1;
    }

    private final void prepareBitcodes() {
        for (int i = 0; i < 65536; ++i) {
            NpcAvatar avatar;
            if (this.avatarRepository.getOrNull(i) == null || !avatar.hasObservers$osrs_221_model()) continue;
            try {
                avatar.prepareBitcodes$osrs_221_model();
                continue;
            }
            catch (Exception e) {
                this.exceptionHandler.exceptionCaught(i, e);
                continue;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Error during npc bitcode preparation"), t);
                }
                throw t;
            }
        }
    }

    private final void prepareExtendedInfo() {
        for (int i = 0; i < 65536; ++i) {
            if (this.avatarRepository.getOrNull(i) == null) continue;
            try {
                NpcAvatar avatar;
                if (!avatar.hasObservers$osrs_221_model()) {
                    avatar.getExtendedInfo().precomputeCached$osrs_221_model();
                    continue;
                }
                avatar.getExtendedInfo().precompute$osrs_221_model();
                continue;
            }
            catch (Exception e) {
                this.exceptionHandler.exceptionCaught(i, e);
                continue;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Error during npc extended info preparation"), t);
                }
                throw t;
            }
        }
    }

    private final void putBitcodes() {
        NpcInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            NpcInfo info$iv;
            if ((NpcInfo)this_$iv.npcInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ NpcInfo $info;
                final /* synthetic */ NpcInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        NpcInfo $this$putBitcodes_u24lambda_u242 = this.$info;
                        boolean bl = false;
                        $this$putBitcodes_u24lambda_u242.compute();
                    }
                    catch (Exception e) {
                        NpcInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = NpcInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during npc updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void putExtendedInfo() {
        NpcInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            NpcInfo info$iv;
            if ((NpcInfo)this_$iv.npcInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ NpcInfo $info;
                final /* synthetic */ NpcInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        NpcInfo $this$putExtendedInfo_u24lambda_u243 = this.$info;
                        boolean bl = false;
                        $this$putExtendedInfo_u24lambda_u243.putExtendedInfo$osrs_221_model();
                    }
                    catch (Exception e) {
                        NpcInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = NpcInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during npc updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void postUpdate() {
        int i;
        for (i = 1; i < 2048; ++i) {
            NpcInfo info;
            if ((NpcInfo)this.npcInfoRepository.getOrNull(i) == null) continue;
            info.afterUpdate();
        }
        for (i = 0; i < 65536; ++i) {
            NpcAvatar avatar;
            if (this.avatarRepository.getOrNull(i) == null) continue;
            avatar.postUpdate();
        }
    }

    private final void execute(Function1<? super NpcInfo, Unit> block) {
        boolean $i$f$execute = false;
        for (int i = 1; i < 2048; ++i) {
            NpcInfo info;
            if ((NpcInfo)this.npcInfoRepository.getOrNull(i) == null) continue;
            ((Collection)this.callables).add(new Callable(block, info, this, i){
                final /* synthetic */ Function1<NpcInfo, Unit> $block;
                final /* synthetic */ NpcInfo $info;
                final /* synthetic */ NpcInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$block = $block;
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        this.$block.invoke((Object)this.$info);
                    }
                    catch (Exception e) {
                        NpcInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = NpcInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during npc updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this.worker.execute(this.callables);
        this.callables.clear();
    }

    private final void catchException(int index, Exception exception) {
        NpcInfo npcInfo = (NpcInfo)this.npcInfoRepository.getOrNull(index);
        if (npcInfo == null) {
            return;
        }
        NpcInfo info = npcInfo;
        this.npcInfoRepository.destroy(index);
        info.setException$osrs_221_model(exception);
    }

    public static final /* synthetic */ void access$catchException(NpcInfoProtocol $this, int index, Exception exception) {
        $this.catchException(index, exception);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ByteBufAllocator access$getAllocator$p(NpcInfoProtocol $this) {
        return $this.allocator;
    }

    public static final /* synthetic */ NpcAvatarRepository access$getAvatarRepository$p(NpcInfoProtocol $this) {
        return $this.avatarRepository;
    }

    public static final /* synthetic */ NpcIndexSupplier access$getNpcIndexSupplier$p(NpcInfoProtocol $this) {
        return $this.npcIndexSupplier;
    }

    public static final /* synthetic */ ClientTypeMap access$getResolutionChangeEncoders$p(NpcInfoProtocol $this) {
        return $this.resolutionChangeEncoders;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol$Companion;", "", "()V", "PROTOCOL_CAPACITY", "", "cycleCount", "getCycleCount$osrs_221_model", "()I", "setCycleCount$osrs_221_model", "(I)V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-221-model"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCycleCount$osrs_221_model() {
            return cycleCount;
        }

        public final void setCycleCount$osrs_221_model(int n) {
            cycleCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

