/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.npcinfo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Iterator;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.UShortArray;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.buffer.bitbuffer.BitBuf;
import net.rsprot.buffer.bitbuffer.BitBufKt;
import net.rsprot.buffer.bitbuffer.UnsafeLongBackedBitBuf;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.protocol.client.ClientType;
import net.rsprot.protocol.common.client.ClientTypeMap;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.common.game.outgoing.info.CoordGrid;
import net.rsprot.protocol.common.game.outgoing.info.npcinfo.encoder.NpcResolutionChangeEncoder;
import net.rsprot.protocol.game.outgoing.info.ObserverExtendedInfoFlags;
import net.rsprot.protocol.game.outgoing.info.exceptions.InfoProcessException;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatar;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarRepository;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcIndexSupplier;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoLarge;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoSmall;
import net.rsprot.protocol.game.outgoing.info.util.BuildArea;
import net.rsprot.protocol.game.outgoing.info.util.ReferencePooledObject;
import net.rsprot.protocol.message.OutgoingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 W2\u00020\u0001:\u0001WB=\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020\u0011H\u0002J\u0006\u00103\u001a\u00020\u0011J\u0006\u00104\u001a\u000201J\b\u00105\u001a\u000201H\u0002J\u0010\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u00020\tH\u0002J\u0010\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\tH\u0002J\u0018\u0010<\u001a\u0002012\u0006\u00107\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010=\u001a\u000201H\u0016J\u0006\u0010>\u001a\u000201J\u0018\u0010?\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020@2\u0006\u0010/\u001a\u00020\tH\u0002J\u0018\u0010A\u001a\u0002012\u0006\u0010\u0010\u001a\u00020@2\u0006\u0010/\u001a\u00020\tH\u0002J\r\u0010B\u001a\u000201H\u0000\u00a2\u0006\u0002\bCJ+\u0010D\u001a\u00020\u00162\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010/\u001a\u00020\tH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0003\u0010\u0001J\u0006\u0010E\u001a\u000201J\u000e\u0010F\u001a\u0002012\u0006\u0010G\u001a\u00020\tJ\u0006\u0010H\u001a\u00020IJ\u0018\u0010J\u001a\u0002012\u0006\u0010\u0012\u001a\u00020\u0013\u00f8\u0001\u0000\u00a2\u0006\u0004\bK\u0010LJ\u001e\u0010M\u001a\u0002012\u0006\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020\tJ*\u0010Q\u001a\u00020\u00162\u0006\u0010R\u001a\u00020%2\u0006\u0010S\u001a\u00020%2\u0006\u0010T\u001a\u00020\tH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bU\u0010VR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\u00020 X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\u00020 X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\u00020%X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010&R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020%X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010&R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\u00020 X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010/\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006X"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfo;", "Lnet/rsprot/protocol/game/outgoing/info/util/ReferencePooledObject;", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "repository", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "localPlayerIndex", "", "indexSupplier", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcIndexSupplier;", "lowResolutionToHighResolutionEncoders", "Lnet/rsprot/protocol/common/client/ClientTypeMap;", "Lnet/rsprot/protocol/common/game/outgoing/info/npcinfo/encoder/NpcResolutionChangeEncoder;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository;Lnet/rsprot/protocol/common/client/OldSchoolClientType;ILnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcIndexSupplier;Lnet/rsprot/protocol/common/client/ClientTypeMap;)V", "buffer", "Lio/netty/buffer/ByteBuf;", "buildArea", "Lnet/rsprot/protocol/game/outgoing/info/util/BuildArea;", "J", "builtIntoPacket", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getException$osrs_221_model", "()Ljava/lang/Exception;", "setException$osrs_221_model", "(Ljava/lang/Exception;)V", "extendedInfoCount", "extendedInfoIndices", "Lkotlin/UShortArray;", "[S", "highResolutionNpcIndexCount", "highResolutionNpcIndices", "localPlayerCurrentCoord", "Lnet/rsprot/protocol/common/game/outgoing/info/CoordGrid;", "I", "getLocalPlayerIndex$osrs_221_model", "()I", "setLocalPlayerIndex$osrs_221_model", "(I)V", "localPlayerLastCoord", "observerExtendedInfoFlags", "Lnet/rsprot/protocol/game/outgoing/info/ObserverExtendedInfoFlags;", "temporaryHighResolutionNpcIndices", "viewDistance", "afterUpdate", "", "allocBuffer", "backingBuffer", "compute", "defragmentIndices", "isHighResolution", "index", "isInBuildArea", "avatar", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatar;", "isTooFar", "onAlloc", "onDealloc", "onReconnect", "processHighResolution", "Lnet/rsprot/buffer/bitbuffer/BitBuf;", "processLowResolution", "putExtendedInfo", "putExtendedInfo$osrs_221_model", "removeHighResolutionNpc", "resetViewDistance", "setViewDistance", "num", "toNpcInfoPacket", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "updateBuildArea", "updateBuildArea-4IFMqhs", "(J)V", "updateCoord", "level", "x", "z", "withinDistance", "localPlayerCoordGrid", "coord", "distance", "withinDistance-QbmAAsE", "(III)Z", "Companion", "osrs-221-model"})
@ExperimentalUnsignedTypes
public final class NpcInfo
implements ReferencePooledObject {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final NpcAvatarRepository repository;
    @NotNull
    private OldSchoolClientType oldSchoolClientType;
    private int localPlayerIndex;
    @NotNull
    private final NpcIndexSupplier indexSupplier;
    @NotNull
    private final ClientTypeMap<NpcResolutionChangeEncoder> lowResolutionToHighResolutionEncoders;
    private int localPlayerLastCoord;
    private int localPlayerCurrentCoord;
    private long buildArea;
    private int viewDistance;
    @NotNull
    private short[] highResolutionNpcIndices;
    @NotNull
    private short[] temporaryHighResolutionNpcIndices;
    private int highResolutionNpcIndexCount;
    @NotNull
    private final short[] extendedInfoIndices;
    private int extendedInfoCount;
    @NotNull
    private final ObserverExtendedInfoFlags observerExtendedInfoFlags;
    @Nullable
    private ByteBuf buffer;
    @Nullable
    private Exception exception;
    private boolean builtIntoPacket;
    private static final int BUF_CAPACITY = 40000;
    private static final int MAX_SMALL_PACKET_DISTANCE = 15;
    private static final int MAX_HIGH_RESOLUTION_NPCS = 250;
    private static final short NPC_INDEX_TERMINATOR = -1;
    private static final int NPC_INFO_CAPACITY = 65535;

    public NpcInfo(@NotNull ByteBufAllocator allocator, @NotNull NpcAvatarRepository repository, @NotNull OldSchoolClientType oldSchoolClientType, int localPlayerIndex, @NotNull NpcIndexSupplier indexSupplier, @NotNull ClientTypeMap<? extends NpcResolutionChangeEncoder> lowResolutionToHighResolutionEncoders) {
        int n;
        short[] sArray;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        Intrinsics.checkNotNullParameter((Object)indexSupplier, (String)"indexSupplier");
        Intrinsics.checkNotNullParameter(lowResolutionToHighResolutionEncoders, (String)"lowResolutionToHighResolutionEncoders");
        this.allocator = allocator;
        this.repository = repository;
        this.oldSchoolClientType = oldSchoolClientType;
        this.localPlayerIndex = localPlayerIndex;
        this.indexSupplier = indexSupplier;
        this.lowResolutionToHighResolutionEncoders = lowResolutionToHighResolutionEncoders;
        this.localPlayerLastCoord = CoordGrid.Companion.getINVALID-9LJGAnM();
        this.localPlayerCurrentCoord = CoordGrid.Companion.getINVALID-9LJGAnM();
        this.buildArea = BuildArea.Companion.getINVALID-RDuwMps();
        this.viewDistance = 15;
        int n4 = 250;
        NpcInfo npcInfo = this;
        int n5 = 0;
        short[] sArray2 = new short[n4];
        while (n5 < n4) {
            int n6 = n3 = n5++;
            n2 = n3;
            sArray = sArray2;
            boolean bl = false;
            sArray[n2] = n = -1;
        }
        npcInfo.highResolutionNpcIndices = UShortArray.constructor-impl((short[])sArray2);
        n4 = 250;
        npcInfo = this;
        n5 = 0;
        sArray2 = new short[n4];
        while (n5 < n4) {
            int it = n3 = n5++;
            n2 = n3;
            sArray = sArray2;
            boolean bl = false;
            sArray[n2] = n = -1;
        }
        npcInfo.temporaryHighResolutionNpcIndices = UShortArray.constructor-impl((short[])sArray2);
        this.extendedInfoIndices = UShortArray.constructor-impl((int)250);
        this.observerExtendedInfoFlags = new ObserverExtendedInfoFlags(250);
    }

    public final int getLocalPlayerIndex$osrs_221_model() {
        return this.localPlayerIndex;
    }

    public final void setLocalPlayerIndex$osrs_221_model(int n) {
        this.localPlayerIndex = n;
    }

    @Nullable
    public final Exception getException$osrs_221_model() {
        return this.exception;
    }

    public final void setException$osrs_221_model(@Nullable Exception exception) {
        this.exception = exception;
    }

    @NotNull
    public final ByteBuf backingBuffer() throws IllegalStateException {
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return byteBuf;
    }

    public final void setViewDistance(int num) {
        this.viewDistance = num;
    }

    public final void resetViewDistance() {
        this.viewDistance = 15;
    }

    @NotNull
    public final OutgoingGameMessage toNpcInfoPacket() {
        Exception exception = this.exception;
        if (exception != null) {
            throw new InfoProcessException("Exception occurred during npc info processing for index " + this.localPlayerIndex, exception);
        }
        this.builtIntoPacket = true;
        return this.viewDistance > 15 ? (OutgoingGameMessage)new NpcInfoLarge(this.backingBuffer()) : (OutgoingGameMessage)new NpcInfoSmall(this.backingBuffer());
    }

    public final void updateBuildArea-4IFMqhs(long buildArea) {
        this.buildArea = buildArea;
    }

    private final ByteBuf allocBuffer() {
        ByteBuf buffer;
        ByteBuf oldBuf;
        if (!this.builtIntoPacket && (oldBuf = this.buffer) != null && oldBuf.refCnt() > 0) {
            oldBuf.release();
        }
        this.buffer = buffer = this.allocator.buffer(40000, 40000);
        this.builtIntoPacket = false;
        Intrinsics.checkNotNull((Object)buffer);
        return buffer;
    }

    public final void updateCoord(int level, int x, int z) {
        this.localPlayerCurrentCoord = CoordGrid.constructor-impl((int)level, (int)x, (int)z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compute() {
        int viewDistance = this.viewDistance;
        ByteBuf buffer = this.allocBuffer();
        AutoCloseable autoCloseable = (AutoCloseable)BitBufKt.toBitBuf((ByteBuf)buffer);
        Throwable throwable = null;
        try {
            BitBuf bitBuffer = (BitBuf)autoCloseable;
            boolean bl = false;
            boolean fragmented = this.processHighResolution(bitBuffer, viewDistance);
            if (fragmented) {
                this.defragmentIndices();
            }
            this.processLowResolution(bitBuffer, viewDistance);
            if (this.extendedInfoCount > 0) {
                bitBuffer.pBits(16, 65535);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void afterUpdate() {
        this.localPlayerLastCoord = this.localPlayerCurrentCoord;
        this.extendedInfoCount = 0;
        this.observerExtendedInfoFlags.reset();
    }

    public final void putExtendedInfo$osrs_221_model() {
        ByteBuf jagBuffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)this.backingBuffer());
        int n = this.extendedInfoCount;
        for (int i = 0; i < n; ++i) {
            NpcAvatar other;
            int index = UShortArray.get-Mh2AYeg((short[])this.extendedInfoIndices, (int)i) & 0xFFFF;
            if (this.repository.getOrNull(index) == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            int observerFlag = other.getExtendedInfo().getFlags$osrs_221_model() | this.observerExtendedInfoFlags.getFlag(i);
            other.getExtendedInfo().pExtendedInfo-lJsHVMs$osrs_221_model(this.oldSchoolClientType, jagBuffer, this.localPlayerIndex, this.extendedInfoCount - i, observerFlag);
        }
    }

    private final void defragmentIndices() {
        int count = 0;
        int n = UShortArray.getSize-impl((short[])this.highResolutionNpcIndices);
        for (int i = 0; i < n && count < this.highResolutionNpcIndexCount; ++i) {
            short index = UShortArray.get-Mh2AYeg((short[])this.highResolutionNpcIndices, (int)i);
            if (index == -1) continue;
            UShortArray.set-01HTLdE((short[])this.temporaryHighResolutionNpcIndices, (int)count++, (short)index);
        }
        short[] uncompressed = this.highResolutionNpcIndices;
        this.highResolutionNpcIndices = this.temporaryHighResolutionNpcIndices;
        this.temporaryHighResolutionNpcIndices = uncompressed;
    }

    private final boolean processHighResolution(BitBuf buffer, int viewDistance) {
        int npcIndex;
        NpcAvatar avatar;
        if (this.highResolutionNpcIndexCount == 0) {
            buffer.pBits(8, 0);
            return false;
        }
        if (this.isTooFar(viewDistance)) {
            buffer.pBits(8, 0);
            int n = this.highResolutionNpcIndexCount;
            for (int i = 0; i < n; ++i) {
                NpcAvatar avatar2;
                int npcIndex2 = UShortArray.get-Mh2AYeg((short[])this.highResolutionNpcIndices, (int)i) & 0xFFFF;
                if (this.repository.getOrNull(npcIndex2) == null) continue;
                avatar2.removeObserver$osrs_221_model();
            }
            this.highResolutionNpcIndexCount = 0;
            return false;
        }
        for (int i = this.highResolutionNpcIndexCount - 1; -1 < i && this.removeHighResolutionNpc(avatar = this.repository.getOrNull(npcIndex = UShortArray.get-Mh2AYeg((short[])this.highResolutionNpcIndices, (int)i) & 0xFFFF), viewDistance); --i) {
            NpcAvatar npcAvatar = avatar;
            if (npcAvatar != null) {
                npcAvatar.removeObserver$osrs_221_model();
            }
            int avatar2 = this.highResolutionNpcIndexCount;
            this.highResolutionNpcIndexCount = avatar2 + -1;
        }
        int processedCount = this.highResolutionNpcIndexCount;
        buffer.pBits(8, processedCount);
        for (int i = 0; i < processedCount; ++i) {
            UnsafeLongBackedBitBuf movementBuffer;
            int n;
            int npcIndex3 = UShortArray.get-Mh2AYeg((short[])this.highResolutionNpcIndices, (int)i) & 0xFFFF;
            NpcAvatar avatar3 = this.repository.getOrNull(npcIndex3);
            if (this.removeHighResolutionNpc(avatar3, viewDistance)) {
                buffer.pBits(1, 1);
                buffer.pBits(2, 3);
                NpcAvatar npcAvatar = avatar3;
                if (npcAvatar != null) {
                    npcAvatar.removeObserver$osrs_221_model();
                }
                UShortArray.set-01HTLdE((short[])this.highResolutionNpcIndices, (int)i, (short)-1);
                n = this.highResolutionNpcIndexCount;
                this.highResolutionNpcIndexCount = n + -1;
                continue;
            }
            if (avatar3.getExtendedInfo().getFlags$osrs_221_model() != 0) {
                n = this.extendedInfoCount;
                this.extendedInfoCount = n + 1;
                UShortArray.set-01HTLdE((short[])this.extendedInfoIndices, (int)n, (short)UShort.constructor-impl((short)((short)npcIndex3)));
            }
            if (avatar3.getHighResMovementBuffer$osrs_221_model() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            buffer.pBits(movementBuffer);
        }
        return processedCount != this.highResolutionNpcIndexCount;
    }

    private final boolean removeHighResolutionNpc(NpcAvatar avatar, int viewDistance) {
        if (avatar == null || avatar.getDetails$osrs_221_model().getInaccessible() || avatar.getDetails$osrs_221_model().isTeleporting()) {
            return true;
        }
        int coord = avatar.getDetails$osrs_221_model().getCurrentCoord-9LJGAnM();
        if (!this.withinDistance-QbmAAsE(this.localPlayerCurrentCoord, coord, viewDistance)) {
            return true;
        }
        return !BuildArea.contains-ah1LTL0$osrs_221_model(this.buildArea, coord);
    }

    private final boolean isInBuildArea(NpcAvatar avatar) {
        return BuildArea.contains-ah1LTL0$osrs_221_model(this.buildArea, avatar.getDetails$osrs_221_model().getCurrentCoord-9LJGAnM());
    }

    private final boolean isTooFar(int viewDistance) {
        return !this.withinDistance-QbmAAsE(this.localPlayerLastCoord, this.localPlayerCurrentCoord, viewDistance);
    }

    private final void processLowResolution(BitBuf buffer, int viewDistance) {
        if (this.highResolutionNpcIndexCount >= 250) {
            return;
        }
        NpcResolutionChangeEncoder encoder = (NpcResolutionChangeEncoder)this.lowResolutionToHighResolutionEncoders.get((ClientType)this.oldSchoolClientType);
        boolean largeDistance = viewDistance > 15;
        Iterator<Integer> npcs = this.indexSupplier.supply(this.localPlayerIndex, CoordGrid.getLevel-impl((int)this.localPlayerCurrentCoord), CoordGrid.getX-impl((int)this.localPlayerCurrentCoord), CoordGrid.getZ-impl((int)this.localPlayerCurrentCoord), viewDistance);
        while (npcs.hasNext()) {
            boolean extendedInfo;
            NpcAvatar avatar;
            int index = ((Number)npcs.next()).intValue() & 0xFFFF;
            if (index == 65535 || this.isHighResolution(index)) continue;
            if (this.highResolutionNpcIndexCount >= 250) break;
            if (this.repository.getOrNull(index) == null || avatar.getDetails$osrs_221_model().getInaccessible() || !this.isInBuildArea(avatar)) continue;
            avatar.addObserver$osrs_221_model();
            int n = this.highResolutionNpcIndexCount;
            this.highResolutionNpcIndexCount = n + 1;
            int i = n;
            UShortArray.set-01HTLdE((short[])this.highResolutionNpcIndices, (int)i, (short)UShort.constructor-impl((short)((short)index)));
            int observerFlags = avatar.getExtendedInfo().getLowToHighResChangeExtendedInfoFlags$osrs_221_model();
            this.observerExtendedInfoFlags.addFlag(this.extendedInfoCount, observerFlags);
            boolean bl = extendedInfo = (avatar.getExtendedInfo().getFlags$osrs_221_model() | observerFlags) != 0;
            if (extendedInfo) {
                int n2 = this.extendedInfoCount;
                this.extendedInfoCount = n2 + 1;
                UShortArray.set-01HTLdE((short[])this.extendedInfoIndices, (int)n2, (short)UShort.constructor-impl((short)((short)index)));
            }
            encoder.encode-KSZAmeY(buffer, avatar.getDetails$osrs_221_model(), extendedInfo, this.localPlayerCurrentCoord, largeDistance);
        }
    }

    private final boolean isHighResolution(int index) {
        int n = this.highResolutionNpcIndexCount;
        for (int i = 0; i < n; ++i) {
            if ((UShortArray.get-Mh2AYeg((short[])this.highResolutionNpcIndices, (int)i) & 0xFFFF) != index) continue;
            return true;
        }
        return false;
    }

    private final boolean withinDistance-QbmAAsE(int localPlayerCoordGrid, int coord, int distance) {
        return CoordGrid.inDistance-YdbEnh8((int)localPlayerCoordGrid, (int)coord, (int)distance);
    }

    public final void onReconnect() {
        this.onDealloc();
        this.highResolutionNpcIndexCount = 0;
        this.extendedInfoCount = 0;
        this.observerExtendedInfoFlags.reset();
    }

    @Override
    public void onAlloc(int index, @NotNull OldSchoolClientType oldSchoolClientType) {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        this.localPlayerIndex = index;
        this.oldSchoolClientType = oldSchoolClientType;
        this.localPlayerLastCoord = CoordGrid.Companion.getINVALID-9LJGAnM();
        this.viewDistance = 15;
        this.highResolutionNpcIndexCount = 0;
        this.extendedInfoCount = 0;
        this.observerExtendedInfoFlags.reset();
    }

    @Override
    public void onDealloc() {
        ByteBuf buffer;
        if (!this.builtIntoPacket && (buffer = this.buffer) != null && buffer.refCnt() > 0) {
            buffer.release(buffer.refCnt());
        }
        this.buffer = null;
        int n = this.highResolutionNpcIndexCount;
        for (int i = 0; i < n; ++i) {
            NpcAvatar avatar;
            int npcIndex = UShortArray.get-Mh2AYeg((short[])this.highResolutionNpcIndices, (int)i) & 0xFFFF;
            if (this.repository.getOrNull(npcIndex) == null) continue;
            avatar.removeObserver$osrs_221_model();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\bX\u0082T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfo$Companion;", "", "()V", "BUF_CAPACITY", "", "MAX_HIGH_RESOLUTION_NPCS", "MAX_SMALL_PACKET_DISTANCE", "NPC_INDEX_TERMINATOR", "Lkotlin/UShort;", "S", "NPC_INFO_CAPACITY", "osrs-221-model"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

