/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.text.NumberFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.JagByteBuf;
import net.rsprot.crypto.xtea.XteaKey;
import net.rsprot.protocol.api.GameConnectionHandler;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.login.GameLoginResponseHandler;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.channel.ChannelExtensions;
import net.rsprot.protocol.common.loginprot.incoming.codec.shared.exceptions.InvalidVersionException;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.GameLogin;
import net.rsprot.protocol.loginprot.incoming.GameReconnect;
import net.rsprot.protocol.loginprot.incoming.ProofOfWorkReply;
import net.rsprot.protocol.loginprot.incoming.RemainingBetaArchives;
import net.rsprot.protocol.loginprot.incoming.pow.ProofOfWork;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.ChallengeMetaData;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.ChallengeType;
import net.rsprot.protocol.loginprot.incoming.util.AuthenticationType;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.IncomingLoginMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 <*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002<=B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0002J0\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0002JI\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0001\u0010$\"\u0004\b\u0002\u0010#2\u0006\u0010%\u001a\u0002H$2\u0006\u0010&\u001a\u00020'2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H#0)H\u0002\u00a2\u0006\u0002\u0010*J\u001a\u0010+\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u00100\u001a\u00020\u000fH\u0002J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u00102\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00103\u001a\u000204H\u0016JD\u00105\u001a\b\u0012\u0004\u0012\u00020'0\"\"\u000e\b\u0001\u00106*\b\u0012\u0004\u0012\u0002H807\"\b\b\u0002\u00108*\u0002092\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002H80\r2\u0006\u0010;\u001a\u00020\u0007H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler;", "R", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingLoginMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "sessionId", "", "(Lnet/rsprot/protocol/api/NetworkService;J)V", "loginPacket", "loginState", "Lnet/rsprot/protocol/api/login/LoginConnectionHandler$LoginState;", "proofOfWork", "Lnet/rsprot/protocol/loginprot/incoming/pow/ProofOfWork;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelReadComplete", "channelUnregistered", "continueLogin", "decodeGameLoginBuffer", "packet", "Lnet/rsprot/protocol/loginprot/incoming/GameLogin;", "remainingBetaArchives", "Lnet/rsprot/protocol/loginprot/incoming/RemainingBetaArchives;", "responseHandler", "Lnet/rsprot/protocol/api/login/GameLoginResponseHandler;", "decodeGameReconnectBuffer", "Lnet/rsprot/protocol/loginprot/incoming/GameReconnect;", "decodeLogin", "Ljava/util/concurrent/CompletableFuture;", "Fun", "Buf", "buf", "betaWorld", "", "function", "Ljava/util/function/BiFunction;", "(Ljava/lang/Object;ZLjava/util/function/BiFunction;)Ljava/util/concurrent/CompletableFuture;", "decodeLoginPacket", "exceptionCaught", "cause", "", "handlerAdded", "releaseLoginBlock", "requestProofOfWork", "userEventTriggered", "evt", "", "verifyProofOfWork", "T", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/ChallengeType;", "MetaData", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/ChallengeMetaData;", "pow", "result", "Companion", "LoginState", "osrs-221-api"})
@SourceDebugExtension(value={"SMAP\nLoginConnectionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginConnectionHandler.kt\nnet/rsprot/protocol/api/login/LoginConnectionHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,441:1\n19#2,2:442\n22#2:448\n19#2,2:449\n22#2:455\n19#2,2:456\n22#2:462\n19#2,2:463\n22#2:469\n19#2,2:470\n22#2:476\n19#2,2:477\n22#2:483\n56#3,4:444\n56#3,4:451\n56#3,4:458\n56#3,4:465\n56#3,4:472\n56#3,4:479\n11#4,2:484\n*S KotlinDebug\n*F\n+ 1 LoginConnectionHandler.kt\nnet/rsprot/protocol/api/login/LoginConnectionHandler\n*L\n49#1:442,2\n49#1:448\n60#1:449,2\n60#1:455\n96#1:456,2\n96#1:462\n239#1:463,2\n239#1:469\n178#1:470,2\n178#1:476\n200#1:477,2\n200#1:483\n49#1:444,4\n60#1:451,4\n96#1:458,4\n239#1:465,4\n178#1:472,4\n200#1:479,4\n438#1:484,2\n*E\n"})
public final class LoginConnectionHandler<R>
extends SimpleChannelInboundHandler<IncomingLoginMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    private final long sessionId;
    @NotNull
    private LoginState loginState;
    @Nullable
    private IncomingLoginMessage loginPacket;
    private ProofOfWork<?, ?> proofOfWork;
    @NotNull
    private static final Logger logger;

    public LoginConnectionHandler(@NotNull NetworkService<R> networkService, long sessionId) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingLoginMessage.class);
        this.networkService = networkService;
        this.sessionId = sessionId;
        this.loginState = LoginState.UNINITIALIZED;
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_221_api().getGameInetAddressTracker().register(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
            }
        }
        ctx.fireChannelActive();
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_221_api().getGameInetAddressTracker().deregister(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Channel is now inactive: " + ctx.channel()));
            }
        }
        ctx.fireChannelInactive();
    }

    public void channelUnregistered(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.releaseLoginBlock();
    }

    private final void releaseLoginBlock() {
        ByteBuf jagBuffer;
        ByteBuf byteBuf;
        IncomingLoginMessage incomingLoginMessage = this.loginPacket;
        if (incomingLoginMessage == null) {
            return;
        }
        IncomingLoginMessage loginPacket = incomingLoginMessage;
        this.loginPacket = null;
        IncomingLoginMessage packet = loginPacket;
        if (packet instanceof GameLogin) {
            byteBuf = ((GameLogin)packet).getBuffer-07mC048();
        } else if (packet instanceof GameReconnect) {
            byteBuf = ((GameReconnect)packet).getBuffer-07mC048();
        } else {
            return;
        }
        ByteBuf buffer = jagBuffer = byteBuf;
        int refCnt = buffer.refCnt();
        if (refCnt > 0) {
            buffer.release(refCnt);
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingLoginMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Login connection message in channel '" + ctx.channel() + "': " + msg));
            }
        }
        IncomingLoginMessage incomingLoginMessage = msg;
        if (incomingLoginMessage instanceof RemainingBetaArchives) {
            if (this.loginState != LoginState.AWAITING_BETA_RESPONSE) {
                ctx.close();
                return;
            }
            this.decodeLoginPacket(ctx, (RemainingBetaArchives)msg);
        } else if (incomingLoginMessage instanceof GameLogin) {
            if (this.loginState != LoginState.UNINITIALIZED) {
                ctx.close();
                return;
            }
            this.loginPacket = msg;
            this.requestProofOfWork(ctx);
        } else if (incomingLoginMessage instanceof GameReconnect) {
            this.loginPacket = msg;
            this.continueLogin(ctx);
        } else if (incomingLoginMessage instanceof ProofOfWorkReply) {
            if (this.loginState != LoginState.REQUESTED_PROOF_OF_WORK) {
                ctx.close();
                return;
            }
            ProofOfWork<?, ?> proofOfWork = this.proofOfWork;
            if (proofOfWork == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"proofOfWork");
                proofOfWork = null;
            }
            ProofOfWork<?, ?> pow = proofOfWork;
            this.verifyProofOfWork(pow, ((ProofOfWorkReply)msg).getResult()).handle((arg_0, arg_1) -> LoginConnectionHandler.channelRead0$lambda$3((Function2)new Function2<Boolean, Throwable, Unit>(ctx, this, msg, pow){
                final /* synthetic */ ChannelHandlerContext $ctx;
                final /* synthetic */ LoginConnectionHandler<R> this$0;
                final /* synthetic */ IncomingLoginMessage $msg;
                final /* synthetic */ ProofOfWork<?, ?> $pow;
                {
                    this.$ctx = $ctx;
                    this.this$0 = $receiver;
                    this.$msg = $msg;
                    this.$pow = $pow;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(Boolean success, Throwable exception) {
                    try {
                        Logger logger;
                        Logger arg0$iv;
                        ChannelHandlerContext channelHandlerContext;
                        Logger logger$iv2;
                        if (!Intrinsics.areEqual((Object)success, (Object)true)) {
                            Logger logger2 = LoginConnectionHandler.access$getLogger$cp();
                            ChannelHandlerContext channelHandlerContext2 = this.$ctx;
                            IncomingLoginMessage incomingLoginMessage = this.$msg;
                            ProofOfWork<?, ?> proofOfWork = this.$pow;
                            boolean bl = false;
                            if (RSProtFlags.getNetworkLogging()) {
                                void logger$iv2;
                                boolean bl2 = false;
                                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                                    void var10_24 = logger$iv2;
                                    boolean bl3 = false;
                                    var10_24.debug(String.valueOf("Incorrect proof of work response received from channel '" + channelHandlerContext2.channel() + "': " + ((ProofOfWorkReply)incomingLoginMessage).getResult() + ", challenge was: " + proofOfWork));
                                }
                            }
                            this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail1.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (exception != null) {
                            logger$iv2 = LoginConnectionHandler.access$getLogger$cp();
                            channelHandlerContext = this.$ctx;
                            boolean bl = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                                logger = arg0$iv;
                                boolean bl4 = false;
                                logger.error(String.valueOf("Exception during proof of work verification from channel '" + channelHandlerContext.channel() + "': " + exception), exception);
                            }
                            this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail1.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        }
                        arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        channelHandlerContext = this.$ctx;
                        IncomingLoginMessage bl = this.$msg;
                        boolean bl5 = false;
                        if (RSProtFlags.getNetworkLogging()) {
                            boolean bl6 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv2)) {
                                logger = logger$iv2;
                                boolean bl7 = false;
                                logger.debug(String.valueOf("Correct proof of work response received from channel '" + channelHandlerContext.channel() + "': " + ((ProofOfWorkReply)bl).getResult()));
                            }
                        }
                        LoginConnectionHandler.access$continueLogin(this.this$0, this.$ctx);
                    }
                    catch (Exception e) {
                        Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl8 = false;
                            logger.error(String.valueOf("Error in handling processed proof of work."), (Throwable)e);
                        }
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl9 = false;
                            logger.error(String.valueOf("Fatal error in handling processed proof of work."), t);
                        }
                        throw t;
                    }
                }
            }, arg_0, arg_1));
        } else {
            throw new IllegalStateException("Unknown login connection handler");
        }
    }

    private final void requestProofOfWork(ChannelHandlerContext ctx) {
        ProofOfWork proofOfWork = this.networkService.getLoginHandlers$osrs_221_api().getProofOfWorkProvider().provide(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
        if (proofOfWork == null) {
            this.continueLogin(ctx);
            return;
        }
        ProofOfWork pow = proofOfWork;
        this.loginState = LoginState.REQUESTED_PROOF_OF_WORK;
        this.proofOfWork = pow;
        ctx.writeAndFlush((Object)new LoginResponse.ProofOfWork(pow)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginConnectionHandler.requestProofOfWork$lambda$5(ctx, arg_0)));
    }

    private final void continueLogin(ChannelHandlerContext ctx) {
        if (this.networkService.getBetaWorld$osrs_221_api()) {
            this.loginState = LoginState.AWAITING_BETA_RESPONSE;
            ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(2)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginConnectionHandler.continueLogin$lambda$7(ctx, arg_0)));
        } else {
            this.decodeLoginPacket(ctx, null);
        }
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_221_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt instanceof IdleStateEvent) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Login connection has gone idle, closing channel " + ctx.channel()));
                }
            }
            ctx.close();
        }
    }

    private final void decodeLoginPacket(ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives) {
        IncomingLoginMessage incomingLoginMessage = this.loginPacket;
        if (incomingLoginMessage == null) {
            return;
        }
        IncomingLoginMessage loginPacket = incomingLoginMessage;
        this.loginPacket = null;
        GameLoginResponseHandler<R> responseHandler = new GameLoginResponseHandler<R>(this.networkService, ctx);
        IncomingLoginMessage packet = loginPacket;
        if (packet instanceof GameLogin) {
            this.decodeGameLoginBuffer((GameLogin)packet, ctx, remainingBetaArchives, responseHandler);
        } else if (packet instanceof GameReconnect) {
            this.decodeGameReconnectBuffer((GameReconnect)packet, ctx, remainingBetaArchives, responseHandler);
        } else {
            throw new IllegalStateException("Unknown login packet: " + packet);
        }
    }

    private final void decodeGameLoginBuffer(GameLogin packet, ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives, GameLoginResponseHandler<R> responseHandler) {
        this.decodeLogin(JagByteBuf.box-impl((ByteBuf)packet.getBuffer-07mC048()), this.networkService.getBetaWorld$osrs_221_api(), packet.getDecoder()).handle((arg_0, arg_1) -> LoginConnectionHandler.decodeGameLoginBuffer$lambda$9((Function2)new Function2<LoginBlock<AuthenticationType>, Throwable, Unit>(ctx, this, remainingBetaArchives, responseHandler){
            final /* synthetic */ ChannelHandlerContext $ctx;
            final /* synthetic */ LoginConnectionHandler<R> this$0;
            final /* synthetic */ RemainingBetaArchives $remainingBetaArchives;
            final /* synthetic */ GameLoginResponseHandler<R> $responseHandler;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                this.$remainingBetaArchives = $remainingBetaArchives;
                this.$responseHandler = $responseHandler;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(LoginBlock<AuthenticationType> block, Throwable exception) {
                try {
                    if (block == null || exception != null) {
                        void arg0$iv;
                        if (exception instanceof CompletionException && Intrinsics.areEqual((Object)exception.getCause(), (Object)InvalidVersionException.INSTANCE)) {
                            this.$ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        Logger logger = LoginConnectionHandler.access$getLogger$cp();
                        ChannelHandlerContext channelHandlerContext = this.$ctx;
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            void var9_18 = arg0$iv;
                            boolean bl2 = false;
                            var9_18.error(String.valueOf("Failed to decode game login block for channel " + channelHandlerContext.channel()), exception);
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail2.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    if (LoginConnectionHandler.access$getSessionId$p(this.this$0) != block.getSessionId()) {
                        Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        ChannelHandlerContext channelHandlerContext = this.$ctx;
                        LoginConnectionHandler<R> bl = this.this$0;
                        boolean bl3 = false;
                        if (RSProtFlags.getNetworkLogging()) {
                            void logger$iv;
                            boolean bl4 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                void var9_19 = logger$iv;
                                boolean bl5 = false;
                                var9_19.debug(String.valueOf("Mismatching game login session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                            }
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    if (this.$remainingBetaArchives != null) {
                        block.mergeBetaCrcs(this.$remainingBetaArchives);
                    }
                    Logger logger$iv = LoginConnectionHandler.access$getLogger$cp();
                    ChannelHandlerContext channelHandlerContext = this.$ctx;
                    boolean bl = false;
                    if (RSProtFlags.getNetworkLogging()) {
                        boolean bl6 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl7 = false;
                            logger.debug(String.valueOf("Successful game login from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                    }
                    ExecutorService executor = LoginConnectionHandler.access$getNetworkService$p(this.this$0).getLoginHandlers$osrs_221_api().getLoginFlowExecutor();
                    if (executor != null) {
                        executor.submit(() -> decodeGameLoginBuffer.1.invoke$lambda$3(this.this$0, this.$responseHandler, block, this.$ctx));
                    } else {
                        LoginConnectionHandler.access$getNetworkService$p(this.this$0).getGameConnectionHandler$osrs_221_api().onLogin(this.$responseHandler, block);
                    }
                }
                catch (Exception e) {
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        Logger logger = arg0$iv;
                        boolean bl8 = false;
                        logger.error(String.valueOf("Error in handling decoded login block."), (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        Logger logger = arg0$iv;
                        boolean bl9 = false;
                        logger.error(String.valueOf("Fatal error in handling decoded login block."), t);
                    }
                    throw t;
                }
            }

            private static final void invoke$lambda$3(LoginConnectionHandler this$0, GameLoginResponseHandler $responseHandler, LoginBlock $block, ChannelHandlerContext $ctx) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$responseHandler, (String)"$responseHandler");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                try {
                    GameConnectionHandler<R> gameConnectionHandler = LoginConnectionHandler.access$getNetworkService$p(this$0).getGameConnectionHandler$osrs_221_api();
                    Intrinsics.checkNotNull((Object)$block);
                    gameConnectionHandler.onLogin($responseHandler, (LoginBlock<AuthenticationType>)$block);
                }
                catch (Throwable t) {
                    this$0.exceptionCaught($ctx, t);
                }
            }
        }, arg_0, arg_1));
    }

    private final void decodeGameReconnectBuffer(GameReconnect packet, ChannelHandlerContext ctx, RemainingBetaArchives remainingBetaArchives, GameLoginResponseHandler<R> responseHandler) {
        this.decodeLogin(JagByteBuf.box-impl((ByteBuf)packet.getBuffer-07mC048()), this.networkService.getBetaWorld$osrs_221_api(), packet.getDecoder()).handle((arg_0, arg_1) -> LoginConnectionHandler.decodeGameReconnectBuffer$lambda$10((Function2)new Function2<LoginBlock<XteaKey>, Throwable, Unit>(ctx, this, remainingBetaArchives, responseHandler){
            final /* synthetic */ ChannelHandlerContext $ctx;
            final /* synthetic */ LoginConnectionHandler<R> this$0;
            final /* synthetic */ RemainingBetaArchives $remainingBetaArchives;
            final /* synthetic */ GameLoginResponseHandler<R> $responseHandler;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                this.$remainingBetaArchives = $remainingBetaArchives;
                this.$responseHandler = $responseHandler;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(LoginBlock<XteaKey> block, Throwable exception) {
                try {
                    if (block == null || exception != null) {
                        void arg0$iv;
                        if (exception instanceof CompletionException && Intrinsics.areEqual((Object)exception.getCause(), (Object)InvalidVersionException.INSTANCE)) {
                            this.$ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        Logger logger = LoginConnectionHandler.access$getLogger$cp();
                        ChannelHandlerContext channelHandlerContext = this.$ctx;
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            void var9_18 = arg0$iv;
                            boolean bl2 = false;
                            var9_18.error(String.valueOf("Failed to decode game reconnect block for channel " + channelHandlerContext.channel()), exception);
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.LoginFail2.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    if (LoginConnectionHandler.access$getSessionId$p(this.this$0) != block.getSessionId()) {
                        Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                        ChannelHandlerContext channelHandlerContext = this.$ctx;
                        LoginConnectionHandler<R> bl = this.this$0;
                        boolean bl3 = false;
                        if (RSProtFlags.getNetworkLogging()) {
                            void logger$iv;
                            boolean bl4 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                void var9_19 = logger$iv;
                                boolean bl5 = false;
                                var9_19.debug(String.valueOf("Mismatching reconnect session id received from channel '" + channelHandlerContext.channel() + "': " + NumberFormat.getNumberInstance().format(block.getSessionId()) + ", expected value: " + NumberFormat.getNumberInstance().format(LoginConnectionHandler.access$getSessionId$p(bl))));
                            }
                        }
                        this.$ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    if (this.$remainingBetaArchives != null) {
                        block.mergeBetaCrcs(this.$remainingBetaArchives);
                    }
                    Logger logger$iv = LoginConnectionHandler.access$getLogger$cp();
                    ChannelHandlerContext channelHandlerContext = this.$ctx;
                    boolean bl = false;
                    if (RSProtFlags.getNetworkLogging()) {
                        boolean bl6 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl7 = false;
                            logger.debug(String.valueOf("Successful game reconnection from channel '" + channelHandlerContext.channel() + "': " + block));
                        }
                    }
                    ExecutorService executor = LoginConnectionHandler.access$getNetworkService$p(this.this$0).getLoginHandlers$osrs_221_api().getLoginFlowExecutor();
                    if (executor != null) {
                        executor.submit(() -> decodeGameReconnectBuffer.1.invoke$lambda$3(this.this$0, this.$responseHandler, block, this.$ctx));
                    } else {
                        LoginConnectionHandler.access$getNetworkService$p(this.this$0).getGameConnectionHandler$osrs_221_api().onReconnect(this.$responseHandler, block);
                    }
                }
                catch (Exception e) {
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        Logger logger = arg0$iv;
                        boolean bl8 = false;
                        logger.error(String.valueOf("Error in handling decoded login block."), (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    Logger arg0$iv = LoginConnectionHandler.access$getLogger$cp();
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        Logger logger = arg0$iv;
                        boolean bl9 = false;
                        logger.error(String.valueOf("Fatal error in handling decoded login block."), t);
                    }
                    throw t;
                }
            }

            private static final void invoke$lambda$3(LoginConnectionHandler this$0, GameLoginResponseHandler $responseHandler, LoginBlock $block, ChannelHandlerContext $ctx) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$responseHandler, (String)"$responseHandler");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                try {
                    GameConnectionHandler<R> gameConnectionHandler = LoginConnectionHandler.access$getNetworkService$p(this$0).getGameConnectionHandler$osrs_221_api();
                    Intrinsics.checkNotNull((Object)$block);
                    gameConnectionHandler.onReconnect($responseHandler, (LoginBlock<XteaKey>)$block);
                }
                catch (Throwable t) {
                    this$0.exceptionCaught($ctx, t);
                }
            }
        }, arg_0, arg_1));
    }

    private final <Buf, Fun> CompletableFuture<Fun> decodeLogin(Buf buf, boolean betaWorld, BiFunction<Buf, Boolean, Fun> function) {
        return this.networkService.getLoginHandlers$osrs_221_api().getLoginDecoderService().decode(buf, betaWorld, function);
    }

    private final <T extends ChallengeType<? super MetaData>, MetaData extends ChallengeMetaData> CompletableFuture<Boolean> verifyProofOfWork(ProofOfWork<T, ? super MetaData> pow, long result) {
        return this.networkService.getLoginHandlers$osrs_221_api().getProofOfWorkChallengeWorker().verify(result, pow.getChallengeType(), pow.getChallengeVerifier());
    }

    private static final Unit channelRead0$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final void requestProofOfWork$lambda$5(ChannelHandlerContext $ctx, ChannelFuture future2) {
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        if (!future2.isSuccess()) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Failed to write a successful proof of work request to channel " + $ctx.channel()));
                }
            }
            future2.channel().pipeline().fireExceptionCaught(future2.cause());
            future2.channel().close();
            return;
        }
        $ctx.read();
    }

    private static final void continueLogin$lambda$7(ChannelHandlerContext $ctx, ChannelFuture future2) {
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        if (!future2.isSuccess()) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Failed to write beta crc request to channel " + $ctx.channel()));
                }
            }
            future2.channel().pipeline().fireExceptionCaught(future2.cause());
            future2.channel().close();
            return;
        }
        $ctx.read();
    }

    private static final Unit decodeGameLoginBuffer$lambda$9(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit decodeGameReconnectBuffer$lambda$10(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$continueLogin(LoginConnectionHandler $this, ChannelHandlerContext ctx) {
        $this.continueLogin(ctx);
    }

    public static final /* synthetic */ long access$getSessionId$p(LoginConnectionHandler $this) {
        return $this.sessionId;
    }

    public static final /* synthetic */ NetworkService access$getNetworkService$p(LoginConnectionHandler $this) {
        return $this.networkService;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-221-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginConnectionHandler$LoginState;", "", "(Ljava/lang/String;I)V", "UNINITIALIZED", "REQUESTED_PROOF_OF_WORK", "AWAITING_BETA_RESPONSE", "osrs-221-api"})
    private static final class LoginState
    extends Enum<LoginState> {
        public static final /* enum */ LoginState UNINITIALIZED = new LoginState();
        public static final /* enum */ LoginState REQUESTED_PROOF_OF_WORK = new LoginState();
        public static final /* enum */ LoginState AWAITING_BETA_RESPONSE = new LoginState();
        private static final /* synthetic */ LoginState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LoginState[] values() {
            return (LoginState[])$VALUES.clone();
        }

        public static LoginState valueOf(String value) {
            return Enum.valueOf(LoginState.class, value);
        }

        @NotNull
        public static EnumEntries<LoginState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = loginStateArray = new LoginState[]{LoginState.UNINITIALIZED, LoginState.REQUESTED_PROOF_OF_WORK, LoginState.AWAITING_BETA_RESPONSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

