/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.game;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.UByteArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.protocol.ClientProt;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.Session;
import net.rsprot.protocol.api.decoder.DecoderState;
import net.rsprot.protocol.api.obfuscation.OpcodeMapper;
import net.rsprot.protocol.client.ClientType;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.message.IncomingGameMessage;
import net.rsprot.protocol.message.IncomingMessage;
import net.rsprot.protocol.message.codec.MessageDecoder;
import net.rsprot.protocol.message.codec.incoming.GameMessageConsumerRepository;
import net.rsprot.protocol.message.codec.incoming.MessageConsumer;
import net.rsprot.protocol.message.codec.incoming.MessageDecoderRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u0000 )*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001)B1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0014J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lnet/rsprot/protocol/api/game/GameMessageDecoder;", "R", "Lio/netty/handler/codec/ByteToMessageDecoder;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "session", "Lnet/rsprot/protocol/api/Session;", "streamCipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "(Lnet/rsprot/protocol/api/NetworkService;Lnet/rsprot/protocol/api/Session;Lnet/rsprot/crypto/cipher/StreamCipher;Lnet/rsprot/protocol/common/client/OldSchoolClientType;)V", "decoder", "Lnet/rsprot/protocol/message/codec/MessageDecoder;", "decoders", "Lnet/rsprot/protocol/message/codec/incoming/MessageDecoderRepository;", "Lnet/rsprot/protocol/ClientProt;", "length", "", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "opcode", "previousPacketIndex", "previousPackets", "", "state", "Lnet/rsprot/protocol/api/decoder/DecoderState;", "buildPreviousPacketLog", "", "decode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "input", "Lio/netty/buffer/ByteBuf;", "out", "", "", "invalidOpcodeException", "", "mapOpcode", "Companion", "osrs-221-api"})
@SourceDebugExtension(value={"SMAP\nGameMessageDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameMessageDecoder.kt\nnet/rsprot/protocol/api/game/GameMessageDecoder\n+ 2 OpcodeMapper.kt\nnet/rsprot/protocol/api/obfuscation/OpcodeMapper\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,180:1\n26#2:181\n19#3,2:182\n22#3:188\n19#3,2:189\n22#3:195\n56#4,4:184\n56#4,4:191\n11#5,2:196\n*S KotlinDebug\n*F\n+ 1 GameMessageDecoder.kt\nnet/rsprot/protocol/api/game/GameMessageDecoder\n*L\n72#1:181\n141#1:182,2\n141#1:188\n159#1:189,2\n159#1:195\n141#1:184,4\n159#1:191,4\n177#1:196,2\n*E\n"})
public final class GameMessageDecoder<R>
extends ByteToMessageDecoder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private final Session<R> session;
    @NotNull
    private final StreamCipher streamCipher;
    @NotNull
    private final MessageDecoderRepository<ClientProt> decoders;
    @NotNull
    private DecoderState state;
    private MessageDecoder<?> decoder;
    private int opcode;
    private int length;
    @NotNull
    private final int[] previousPackets;
    private int previousPacketIndex;
    private static final int SINGLE_PACKET_MAX_PAYLOAD_LENGTH = 5000;
    @NotNull
    private static final Logger logger;

    public GameMessageDecoder(@NotNull NetworkService<R> networkService, @NotNull Session<R> session, @NotNull StreamCipher streamCipher, @NotNull OldSchoolClientType oldSchoolClientType) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter(session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)streamCipher, (String)"streamCipher");
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        this.networkService = networkService;
        this.session = session;
        this.streamCipher = streamCipher;
        this.decoders = (MessageDecoderRepository)this.networkService.getDecoderRepositories$osrs_221_api().getGameMessageDecoderRepositories().get((ClientType)oldSchoolClientType);
        this.state = DecoderState.READ_OPCODE;
        this.opcode = -1;
        int n = 0;
        int n2 = this.networkService.getConfiguration$osrs_221_api().getIncomingGamePacketBacklog();
        int[] nArray = new int[n2];
        GameMessageDecoder gameMessageDecoder = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = -1;
        }
        gameMessageDecoder.previousPackets = nArray;
    }

    @NotNull
    public final NetworkService<R> getNetworkService() {
        return this.networkService;
    }

    private final Void invalidOpcodeException() {
        throw new IllegalStateException("Invalid opcode received! Previous packets: " + this.buildPreviousPacketLog());
    }

    private final String buildPreviousPacketLog() {
        int previousPacketIndex;
        int i;
        StringBuilder stringBuilder;
        StringBuilder $this$buildPreviousPacketLog_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int[] previousPackets = this.previousPackets;
        for (i = previousPacketIndex = (this.previousPacketIndex - 1) % previousPackets.length; -1 < i; --i) {
            $this$buildPreviousPacketLog_u24lambda_u240.append(previousPackets[i]).append(", ");
        }
        int n = previousPacketIndex + 1;
        i = previousPackets.length - 1;
        if (n <= i) {
            while (true) {
                $this$buildPreviousPacketLog_u24lambda_u240.append(previousPackets[i]).append(", ");
                if (i == n) break;
                --i;
            }
        }
        $this$buildPreviousPacketLog_u24lambda_u240.delete($this$buildPreviousPacketLog_u24lambda_u240.length() - 2, $this$buildPreviousPacketLog_u24lambda_u240.length());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final int mapOpcode(int opcode) {
        OpcodeMapper mapper;
        OpcodeMapper opcodeMapper = this.networkService.getClientToServerOpcodeMapper();
        if (opcodeMapper == null) {
            return opcode;
        }
        OpcodeMapper this_$iv = mapper = opcodeMapper;
        boolean $i$f$decode = false;
        return UByteArray.get-w2LRezQ((byte[])this_$iv.getObfuscatedOpcodes-TcUX1vc(), (int)opcode) & 0xFF;
    }

    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf input, @NotNull List<Object> out) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(out, (String)"out");
        if (this.state == DecoderState.READ_OPCODE) {
            if (!input.isReadable()) {
                return;
            }
            this.opcode = this.mapOpcode(JagexByteBufExtensionsKt.g1((ByteBuf)input) - this.streamCipher.nextInt() & 0xFF);
            int n = this.previousPacketIndex;
            this.previousPacketIndex = n + 1;
            this.previousPackets[n % this.previousPackets.length] = this.opcode;
            MessageDecoder decoderOrNull = this.decoders.getDecoderOrNull(this.opcode);
            if (decoderOrNull == null) {
                this.invalidOpcodeException();
                throw new KotlinNothingValueException();
            }
            this.decoder = decoderOrNull;
            MessageDecoder<?> messageDecoder = this.decoder;
            if (messageDecoder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                messageDecoder = null;
            }
            this.length = messageDecoder.getProt().getSize();
            DecoderState decoderState = this.state = this.length >= 0 ? DecoderState.READ_PAYLOAD : DecoderState.READ_LENGTH;
        }
        if (this.state == DecoderState.READ_LENGTH) {
            switch (this.length) {
                case -1: {
                    if (!input.isReadable(1)) {
                        return;
                    }
                    this.length = JagexByteBufExtensionsKt.g1((ByteBuf)input);
                    break;
                }
                case -2: {
                    if (!input.isReadable(2)) {
                        return;
                    }
                    this.length = JagexByteBufExtensionsKt.g2((ByteBuf)input);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid length: " + this.length + " of opcode " + this.opcode + ", previous packets: " + this.buildPreviousPacketLog());
                }
            }
            this.state = DecoderState.READ_PAYLOAD;
        }
        if (this.state == DecoderState.READ_PAYLOAD) {
            if (!input.isReadable(this.length)) {
                return;
            }
            if (this.length > RSProtFlags.getSingleVarShortPacketMaxAcceptedLength()) {
                throw new DecoderException("Opcode " + this.opcode + " exceeds the natural maximum allowed length in OldSchool: " + this.length + " > " + RSProtFlags.getSingleVarShortPacketMaxAcceptedLength() + ", previous packets: " + this.buildPreviousPacketLog());
            }
            MessageDecoder<?> messageDecoder = this.decoder;
            if (messageDecoder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                messageDecoder = null;
            }
            Class messageClass = this.decoders.getMessageClass(messageDecoder.getClass());
            GameMessageConsumerRepository consumerRepository = this.networkService.getGameMessageConsumerRepositoryProvider().provide();
            MessageConsumer consumer = (MessageConsumer)consumerRepository.getConsumers().get(messageClass);
            if (consumer == null) {
                Logger logger$iv = logger;
                boolean bl = false;
                if (RSProtFlags.getNetworkLogging()) {
                    boolean bl2 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl3 = false;
                        logger.debug(String.valueOf("Discarding incoming game packet from channel '" + ctx.channel() + "': " + messageClass.getSimpleName()));
                    }
                }
                input.skipBytes(this.length);
                this.state = DecoderState.READ_OPCODE;
                return;
            }
            ByteBuf payload = input.readSlice(this.length);
            MessageDecoder<?> messageDecoder2 = this.decoder;
            if (messageDecoder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                messageDecoder2 = null;
            }
            Intrinsics.checkNotNull((Object)payload);
            IncomingMessage message = messageDecoder2.decode-lwEbYT4(JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)payload));
            if (payload.isReadable()) {
                MessageDecoder<?> messageDecoder3 = this.decoder;
                if (messageDecoder3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                    messageDecoder3 = null;
                }
                throw new DecoderException("Decoder " + messageDecoder3.getClass() + " did not read entire payload: " + payload.readableBytes() + ", previous packets: " + this.buildPreviousPacketLog());
            }
            ((Collection)out).add(message);
            Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type net.rsprot.protocol.message.IncomingGameMessage");
            this.session.incrementCounter$osrs_221_api((IncomingGameMessage)message);
            if (this.session.isFull$osrs_221_api()) {
                Logger logger$iv = logger;
                boolean bl = false;
                if (RSProtFlags.getNetworkLogging()) {
                    boolean bl4 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl5 = false;
                        logger.debug(String.valueOf("Incoming packet limit reached, no longer reading incoming game packets from channel " + ctx.channel()));
                    }
                }
                this.session.stopReading$osrs_221_api();
            }
            this.state = DecoderState.READ_OPCODE;
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lnet/rsprot/protocol/api/game/GameMessageDecoder$Companion;", "", "()V", "SINGLE_PACKET_MAX_PAYLOAD_LENGTH", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-221-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

