/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.js5.Js5ChannelHandler;
import net.rsprot.protocol.api.js5.Js5MessageDecoder;
import net.rsprot.protocol.api.js5.Js5MessageEncoder;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.InitGameConnection;
import net.rsprot.protocol.loginprot.incoming.InitJs5RemoteConnection;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.IncomingLoginMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingLoginMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "channelReadComplete", "exceptionCaught", "cause", "", "handleInitGameConnection", "handleInitJs5RemoteConnection", "revision", "", "userEventTriggered", "evt", "", "Companion", "osrs-221-api"})
@SourceDebugExtension(value={"SMAP\nLoginChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 ChannelExtensions.kt\nnet/rsprot/protocol/api/channel/ChannelExtensionsKt\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,235:1\n19#2,2:236\n22#2:242\n19#2,2:243\n22#2:249\n19#2,2:250\n22#2:256\n19#2,2:257\n22#2:263\n19#2,2:264\n22#2:270\n19#2,2:271\n22#2:277\n19#2,2:278\n22#2:284\n19#2,2:285\n22#2:291\n19#2,2:292\n22#2:298\n19#2,2:301\n22#2:307\n19#2,2:308\n22#2:314\n56#3,4:238\n56#3,4:245\n56#3,4:252\n56#3,4:259\n56#3,4:266\n56#3,4:273\n56#3,4:280\n56#3,4:287\n56#3,4:294\n56#3,4:303\n56#3,4:310\n36#4:299\n36#4:300\n36#4:315\n36#4:316\n36#4:317\n36#4:318\n11#5,2:319\n*S KotlinDebug\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n*L\n35#1:236,2\n35#1:242\n44#1:243,2\n44#1:249\n74#1:250,2\n74#1:256\n87#1:257,2\n87#1:263\n132#1:264,2\n132#1:270\n152#1:271,2\n152#1:277\n223#1:278,2\n223#1:284\n95#1:285,2\n95#1:291\n104#1:292,2\n104#1:298\n165#1:301,2\n165#1:307\n174#1:308,2\n174#1:314\n35#1:238,4\n44#1:245,4\n74#1:252,4\n87#1:259,4\n132#1:266,4\n152#1:273,4\n223#1:280,4\n95#1:287,4\n104#1:294,4\n165#1:303,4\n174#1:310,4\n113#1:299\n114#1:300\n183#1:315\n184#1:316\n185#1:317\n186#1:318\n232#1:319,2\n*E\n"})
public final class LoginChannelHandler
extends SimpleChannelInboundHandler<IncomingLoginMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private static final Logger logger;

    public LoginChannelHandler(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingLoginMessage.class);
        this.networkService = networkService;
    }

    @NotNull
    public final NetworkService<?> getNetworkService() {
        return this.networkService;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
        ctx.fireChannelActive();
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
            }
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingLoginMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl2 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl3 = false;
                logger.debug(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
            }
        }
        IncomingLoginMessage incomingLoginMessage = msg;
        if (Intrinsics.areEqual((Object)incomingLoginMessage, (Object)InitGameConnection.INSTANCE)) {
            this.handleInitGameConnection(ctx);
        } else if (incomingLoginMessage instanceof InitJs5RemoteConnection) {
            this.handleInitJs5RemoteConnection(ctx, ((InitJs5RemoteConnection)msg).getRevision());
        } else {
            throw new IllegalStateException("Unknown login channel message: " + msg);
        }
    }

    private final void handleInitGameConnection(ChannelHandlerContext ctx) {
        InetAddress address = ChannelExtensionsKt.inetAddress(ctx);
        int count = this.networkService.getINetAddressHandlers$osrs_221_api().getGameInetAddressTracker().getCount(address);
        boolean accepted = this.networkService.getINetAddressHandlers$osrs_221_api().getInetAddressValidator().acceptGameConnection(address, count);
        if (!accepted) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                }
            }
            ctx.writeAndFlush((Object)LoginResponse.TooManyAttempts.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        long sessionId = this.networkService.getLoginHandlers$osrs_221_api().getSessionIdGenerator().generate(address);
        Logger logger$iv = logger;
        boolean bl = false;
        if (RSProtFlags.getNetworkLogging()) {
            boolean bl4 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                Logger logger = logger$iv;
                boolean bl5 = false;
                logger.debug(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
            }
        }
        ctx.writeAndFlush((Object)new LoginResponse.Successful(Long.valueOf(sessionId))).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitGameConnection$lambda$6(ctx, this, address, sessionId, arg_0)));
    }

    private final void handleInitJs5RemoteConnection(ChannelHandlerContext ctx, int revision) {
        if (revision != 221) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                }
            }
            ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        InetAddress address = ChannelExtensionsKt.inetAddress(ctx);
        int count = this.networkService.getINetAddressHandlers$osrs_221_api().getJs5InetAddressTracker().getCount(address);
        boolean accepted = this.networkService.getINetAddressHandlers$osrs_221_api().getInetAddressValidator().acceptJs5Connection(address, count);
        if (!accepted) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl4 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl5 = false;
                    logger.debug(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                }
            }
            ctx.writeAndFlush((Object)LoginResponse.IPLimit.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.writeAndFlush((Object)new LoginResponse.Successful(null)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitJs5RemoteConnection$lambda$11(ctx, this, address, arg_0)));
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_221_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt instanceof IdleStateEvent) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                }
            }
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }

    private static final void handleInitGameConnection$lambda$6(ChannelHandlerContext $ctx, LoginChannelHandler this$0, InetAddress $address, long $sessionId, ChannelFuture future2) {
        ChannelPipeline $this$replace$iv;
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
        if (!future2.isSuccess()) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                }
            }
            future2.channel().pipeline().fireExceptionCaught(future2.cause());
            future2.channel().close();
            return;
        }
        if ($ctx.channel().isActive()) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl4 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl5 = false;
                    logger.debug(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_221_api().getGameInetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = future2.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new LoginConnectionHandler(this$0.networkService, $sessionId);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 40L, 40L, 40L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    private static final void handleInitJs5RemoteConnection$lambda$11(ChannelHandlerContext $ctx, LoginChannelHandler this$0, InetAddress $address, ChannelFuture future2) {
        ChannelPipeline $this$replace$iv;
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
        if (!future2.isSuccess()) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl2 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl3 = false;
                    logger.debug(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                }
            }
            future2.channel().pipeline().fireExceptionCaught(future2.cause());
            future2.channel().close();
            return;
        }
        if ($ctx.channel().isActive()) {
            Logger logger$iv = logger;
            boolean bl = false;
            if (RSProtFlags.getNetworkLogging()) {
                boolean bl4 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl5 = false;
                    logger.debug(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_221_api().getJs5InetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = $ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new Js5MessageDecoder(this$0.networkService);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5MessageEncoder(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5ChannelHandler(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 30L, 30L, 30L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-221-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

