/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.compression.provider.HuffmanCodecProvider;
import net.rsprot.crypto.rsa.RsaKeyPair;
import net.rsprot.protocol.api.EntityInfoProtocols;
import net.rsprot.protocol.api.GameConnectionHandler;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.bootstrap.BootstrapFactory;
import net.rsprot.protocol.api.config.NetworkConfiguration;
import net.rsprot.protocol.api.handlers.ExceptionHandlers;
import net.rsprot.protocol.api.handlers.GameMessageHandlers;
import net.rsprot.protocol.api.handlers.INetAddressHandlers;
import net.rsprot.protocol.api.handlers.LoginHandlers;
import net.rsprot.protocol.api.js5.Js5Configuration;
import net.rsprot.protocol.api.js5.Js5GroupProvider;
import net.rsprot.protocol.api.suppliers.NpcInfoSupplier;
import net.rsprot.protocol.api.suppliers.PlayerInfoSupplier;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarFilter;
import net.rsprot.protocol.message.codec.incoming.provider.GameMessageConsumerRepositoryProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 B*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eJ\u001f\u0010\u001f\u001a\u00020 2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020#0\"\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020&H&J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H&J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*H&J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,H&J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H&J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H&J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020 H\u0016J\n\u0010:\u001a\u0004\u0018\u00010;H\u0016J\b\u0010<\u001a\u00020=H&J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020AH&R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006C"}, d2={"Lnet/rsprot/protocol/api/AbstractNetworkServiceFactory;", "R", "", "()V", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "getAllocator", "()Lio/netty/buffer/ByteBufAllocator;", "betaWorld", "", "getBetaWorld", "()Z", "bufRetentionCountBeforeRelease", "", "getBufRetentionCountBeforeRelease", "()I", "host", "", "getHost", "()Ljava/lang/String;", "ports", "", "getPorts", "()Ljava/util/List;", "supportedClientTypes", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "getSupportedClientTypes", "zoneCountBeforeLeakWarning", "getZoneCountBeforeLeakWarning", "build", "Lnet/rsprot/protocol/api/NetworkService;", "configure", "Lnet/rsprot/protocol/api/config/NetworkConfiguration$Builder;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getBootstrapFactory", "Lnet/rsprot/protocol/api/bootstrap/BootstrapFactory;", "getExceptionHandlers", "Lnet/rsprot/protocol/api/handlers/ExceptionHandlers;", "getGameConnectionHandler", "Lnet/rsprot/protocol/api/GameConnectionHandler;", "getGameMessageConsumerRepositoryProvider", "Lnet/rsprot/protocol/message/codec/incoming/provider/GameMessageConsumerRepositoryProvider;", "getGameMessageHandlers", "Lnet/rsprot/protocol/api/handlers/GameMessageHandlers;", "getHuffmanCodecProvider", "Lnet/rsprot/compression/provider/HuffmanCodecProvider;", "getINetAddressHandlers", "Lnet/rsprot/protocol/api/handlers/INetAddressHandlers;", "getJs5Configuration", "Lnet/rsprot/protocol/api/js5/Js5Configuration;", "getJs5GroupProvider", "Lnet/rsprot/protocol/api/js5/Js5GroupProvider;", "getLoginHandlers", "Lnet/rsprot/protocol/api/handlers/LoginHandlers;", "getNetworkConfiguration", "getNpcAvatarFilter", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFilter;", "getNpcInfoSupplier", "Lnet/rsprot/protocol/api/suppliers/NpcInfoSupplier;", "getPlayerInfoSupplier", "Lnet/rsprot/protocol/api/suppliers/PlayerInfoSupplier;", "getRsaKeyPair", "Lnet/rsprot/crypto/rsa/RsaKeyPair;", "Companion", "osrs-221-api"})
public abstract class AbstractNetworkServiceFactory<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final int DEFAULT_ZONE_COUNT_BEFORE_LEAK_WARNING = 25000;
    private static final int DEFAULT_BUF_RETENTION_COUNT_BEFORE_RELEASE = 100;

    @NotNull
    public ByteBufAllocator getAllocator() {
        PooledByteBufAllocator pooledByteBufAllocator = PooledByteBufAllocator.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)pooledByteBufAllocator, (String)"DEFAULT");
        return (ByteBufAllocator)pooledByteBufAllocator;
    }

    @Nullable
    public String getHost() {
        return null;
    }

    @NotNull
    public abstract List<Integer> getPorts();

    @NotNull
    public abstract List<OldSchoolClientType> getSupportedClientTypes();

    public boolean getBetaWorld() {
        return false;
    }

    public int getZoneCountBeforeLeakWarning() {
        return 25000;
    }

    public int getBufRetentionCountBeforeRelease() {
        return 100;
    }

    @NotNull
    public abstract BootstrapFactory getBootstrapFactory();

    @NotNull
    public abstract RsaKeyPair getRsaKeyPair();

    @NotNull
    public abstract HuffmanCodecProvider getHuffmanCodecProvider();

    @NotNull
    public Js5Configuration getJs5Configuration() {
        return new Js5Configuration(0, 0, 0, 0, 0, null, 63, null);
    }

    @NotNull
    public abstract Js5GroupProvider getJs5GroupProvider();

    @NotNull
    public abstract GameMessageConsumerRepositoryProvider<R> getGameMessageConsumerRepositoryProvider();

    @NotNull
    public abstract GameConnectionHandler<R> getGameConnectionHandler();

    @NotNull
    public abstract NpcInfoSupplier getNpcInfoSupplier();

    @NotNull
    public PlayerInfoSupplier getPlayerInfoSupplier() {
        return new PlayerInfoSupplier(null, null, 3, null);
    }

    @NotNull
    public abstract ExceptionHandlers<R> getExceptionHandlers();

    @NotNull
    public INetAddressHandlers getINetAddressHandlers() {
        return new INetAddressHandlers(null, null, null, 7, null);
    }

    @NotNull
    public GameMessageHandlers getGameMessageHandlers() {
        return new GameMessageHandlers(null, null, null, 7, null);
    }

    @NotNull
    public LoginHandlers getLoginHandlers() {
        return new LoginHandlers(null, null, null, null, null, null, false, 127, null);
    }

    @NotNull
    public NetworkConfiguration.Builder getNetworkConfiguration() {
        return new NetworkConfiguration.Builder();
    }

    @Nullable
    public NpcAvatarFilter getNpcAvatarFilter() {
        return null;
    }

    public final /* synthetic */ NetworkConfiguration.Builder configure(Function1 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        NetworkConfiguration.Builder builder = new NetworkConfiguration.Builder();
        block.invoke((Object)builder);
        return builder;
    }

    @NotNull
    public final NetworkService<R> build() {
        ByteBufAllocator allocator = this.getAllocator();
        String host = this.getHost();
        List<Integer> ports = this.getPorts();
        List<OldSchoolClientType> supportedClientTypes = this.getSupportedClientTypes();
        HuffmanCodecProvider huffman = this.getHuffmanCodecProvider();
        EntityInfoProtocols entityInfoProtocols = EntityInfoProtocols.Companion.initialize(allocator, supportedClientTypes, huffman, this.getPlayerInfoSupplier(), this.getNpcInfoSupplier(), this.getNpcAvatarFilter());
        return new NetworkService<R>(allocator, host, ports, this.getBetaWorld(), this.getBootstrapFactory(), entityInfoProtocols, supportedClientTypes, this.getGameConnectionHandler(), this.getExceptionHandlers(), this.getINetAddressHandlers(), this.getGameMessageHandlers(), this.getLoginHandlers(), this.getNetworkConfiguration().build$osrs_221_api(), this.getZoneCountBeforeLeakWarning(), this.getBufRetentionCountBeforeRelease(), huffman, this.getGameMessageConsumerRepositoryProvider(), this.getRsaKeyPair(), this.getJs5Configuration(), this.getJs5GroupProvider());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/AbstractNetworkServiceFactory$Companion;", "", "()V", "DEFAULT_BUF_RETENTION_COUNT_BEFORE_RELEASE", "", "DEFAULT_ZONE_COUNT_BEFORE_LEAK_WARNING", "osrs-221-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

