/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.crypto.rsa;

import com.github.michaelbull.logging.InlineLogger;
import com.squareup.jnagmp.Gmp;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u0004J\b\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000f"}, d2={"Lnet/rsprot/crypto/rsa/Rsa;", "", "()V", "jnaGmpSupport", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "modPow", "Ljava/math/BigInteger;", "base", "exp", "mod", "preferNative", "supportsNative", "crypto"})
@SourceDebugExtension(value={"SMAP\nRsa.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rsa.kt\nnet/rsprot/crypto/rsa/Rsa\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,78:1\n104#2,4:79\n56#2,4:85\n11#3,2:83\n*S KotlinDebug\n*F\n+ 1 Rsa.kt\nnet/rsprot/crypto/rsa/Rsa\n*L\n67#1:79,4\n27#1:85,4\n15#1:83,2\n*E\n"})
public final class Rsa {
    @NotNull
    public static final Rsa INSTANCE = new Rsa();
    private static boolean jnaGmpSupport;
    @NotNull
    private static final Logger logger;

    private Rsa() {
    }

    private final boolean supportsNative() {
        return jnaGmpSupport;
    }

    @NotNull
    public final BigInteger modPow(@NotNull BigInteger base, @NotNull BigInteger exp, @NotNull BigInteger mod, boolean preferNative) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)exp, (String)"exp");
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        if (preferNative && this.supportsNative()) {
            BigInteger bigInteger2;
            try {
                bigInteger2 = Gmp.modPowSecure((BigInteger)base, (BigInteger)exp, (BigInteger)mod);
            }
            catch (IllegalArgumentException e) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.warn(String.valueOf("Even modulo " + mod + " provided; native RSA support is not supported for even modulo."));
                }
                jnaGmpSupport = false;
                bigInteger2 = this.modPow(base, exp, mod, false);
            }
            BigInteger bigInteger3 = bigInteger2;
            Intrinsics.checkNotNull((Object)bigInteger3);
            bigInteger = bigInteger3;
        } else {
            BigInteger bigInteger4 = base.modPow(exp, mod);
            Intrinsics.checkNotNull((Object)bigInteger4);
            bigInteger = bigInteger4;
        }
        return bigInteger;
    }

    public static /* synthetic */ BigInteger modPow$default(Rsa rsa, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return rsa.modPow(bigInteger, bigInteger2, bigInteger3, bl);
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
        try {
            Gmp.checkLoaded();
            $i$f$InlineLogger = true;
        }
        catch (Throwable t) {
            $i$f$InlineLogger = false;
        }
        jnaGmpSupport = $i$f$InlineLogger;
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.debug(String.valueOf("Native JNA-GMP support: " + jnaGmpSupport));
        }
    }
}

