/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.crypto.cipher;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.rsprot.crypto.cipher.StreamCipher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/rsprot/crypto/cipher/IsaacRandom;", "Lnet/rsprot/crypto/cipher/StreamCipher;", "()V", "seed", "", "([I)V", "a", "", "b", "c", "count", "mem", "rsl", "init", "", "flag", "", "isaac", "nextInt", "Companion", "crypto"})
public final class IsaacRandom
implements StreamCipher {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private int count;
    @NotNull
    private final int[] rsl;
    @NotNull
    private final int[] mem;
    private int a;
    private int b;
    private int c;
    private static final int SIZEL = 8;
    private static final int SIZE = 256;
    private static final int MASK = 1020;
    private static final int GOLDEN_RATIO = -1640531527;

    public IsaacRandom() {
        this.mem = new int[256];
        this.rsl = new int[256];
        this.init(false);
    }

    public IsaacRandom(@NotNull int[] seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        this.mem = new int[256];
        if (!(seed.length <= 256)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] nArray = Arrays.copyOf(seed, 256);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.rsl = nArray;
        this.init(true);
    }

    private final void init(boolean flag) {
        int a = -1640531527;
        int b = -1640531527;
        int c = -1640531527;
        int d = -1640531527;
        int e = -1640531527;
        int f = -1640531527;
        int g = -1640531527;
        int h = -1640531527;
        for (int i = 0; i < 4; ++i) {
            d += (a ^= b << 11);
            b += c;
            e += (b ^= c >>> 2);
            c += d;
            f += (c ^= d << 8);
            d += e;
            g += (d ^= e >>> 16);
            e += f;
            h += (e ^= f << 10);
            f += g;
            a += (f ^= g >>> 4);
            g += h;
            b += (g ^= h << 8);
            h += a;
            c += (h ^= a >>> 9);
            a += b;
        }
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)256)), (int)8);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                if (flag) {
                    a += this.rsl[i];
                    b += this.rsl[i + 1];
                    c += this.rsl[i + 2];
                    d += this.rsl[i + 3];
                    e += this.rsl[i + 4];
                    f += this.rsl[i + 5];
                    g += this.rsl[i + 6];
                    h += this.rsl[i + 7];
                }
                d += (a ^= b << 11);
                b += c;
                e += (b ^= c >>> 2);
                c += d;
                f += (c ^= d << 8);
                d += e;
                g += (d ^= e >>> 16);
                e += f;
                h += (e ^= f << 10);
                f += g;
                a += (f ^= g >>> 4);
                g += h;
                b += (g ^= h << 8);
                h += a;
                c += (h ^= a >>> 9);
                this.mem[i] = a += b;
                this.mem[i + 1] = b;
                this.mem[i + 2] = c;
                this.mem[i + 3] = d;
                this.mem[i + 4] = e;
                this.mem[i + 5] = f;
                this.mem[i + 6] = g;
                this.mem[i + 7] = h;
                if (i == n) break;
                i += n2;
            }
        }
        if (flag) {
            intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)256)), (int)8);
            i = intProgression.getFirst();
            n = intProgression.getLast();
            n2 = intProgression.getStep();
            if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                while (true) {
                    a += this.mem[i];
                    b += this.mem[i + 1];
                    c += this.mem[i + 2];
                    d += this.mem[i + 3];
                    e += this.mem[i + 4];
                    f += this.mem[i + 5];
                    g += this.mem[i + 6];
                    h += this.mem[i + 7];
                    d += (a ^= b << 11);
                    b += c;
                    e += (b ^= c >>> 2);
                    c += d;
                    f += (c ^= d << 8);
                    d += e;
                    g += (d ^= e >>> 16);
                    e += f;
                    h += (e ^= f << 10);
                    f += g;
                    a += (f ^= g >>> 4);
                    g += h;
                    b += (g ^= h << 8);
                    h += a;
                    c += (h ^= a >>> 9);
                    this.mem[i] = a += b;
                    this.mem[i + 1] = b;
                    this.mem[i + 2] = c;
                    this.mem[i + 3] = d;
                    this.mem[i + 4] = e;
                    this.mem[i + 5] = f;
                    this.mem[i + 6] = g;
                    this.mem[i + 7] = h;
                    if (i == n) break;
                    i += n2;
                }
            }
        }
        this.isaac();
        this.count = 256;
    }

    private final void isaac() {
        int a = this.a;
        ++this.c;
        int b = this.b + this.c;
        int i = 0;
        int j = 128;
        int x = 0;
        int y = 0;
        while (i < 128) {
            x = this.mem[i];
            a ^= a << 13;
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + (a += this.mem[j++]) + b;
            b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            this.rsl[i++] = b;
            x = this.mem[i];
            a ^= a >>> 6;
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + (a += this.mem[j++]) + b;
            b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            this.rsl[i++] = b;
            x = this.mem[i];
            a ^= a << 2;
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + (a += this.mem[j++]) + b;
            b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            this.rsl[i++] = b;
            x = this.mem[i];
            a ^= a >>> 16;
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + (a += this.mem[j++]) + b;
            b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            this.rsl[i++] = b;
        }
        j = 0;
        while (j < 128) {
            x = this.mem[i];
            a ^= a << 13;
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + (a += this.mem[j++]) + b;
            b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            this.rsl[i++] = b;
            x = this.mem[i];
            a ^= a >>> 6;
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + (a += this.mem[j++]) + b;
            b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            this.rsl[i++] = b;
            x = this.mem[i];
            a ^= a << 2;
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + (a += this.mem[j++]) + b;
            b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            this.rsl[i++] = b;
            x = this.mem[i];
            a ^= a >>> 16;
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + (a += this.mem[j++]) + b;
            b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            this.rsl[i++] = b;
        }
        this.b = b;
        this.a = a;
    }

    @Override
    public int nextInt() {
        int n = this.count;
        this.count = n + -1;
        if (n == 0) {
            this.isaac();
            this.count = 255;
        }
        return this.rsl[this.count];
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/rsprot/crypto/cipher/IsaacRandom$Companion;", "", "()V", "GOLDEN_RATIO", "", "MASK", "SIZE", "SIZEL", "crypto"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

