/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.buffer.util.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0096\u0002J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/buffer/util/charset/Cp1252Charset;", "Ljava/nio/charset/Charset;", "()V", "CODE_PAGE", "", "DECODE_TABLE", "ENCODE_TABLE", "", "REPLACEMENT_BYTE", "", "REPLACEMENT_CHAR", "", "contains", "", "cs", "decode", "byte", "encode", "char", "newDecoder", "Ljava/nio/charset/CharsetDecoder;", "newEncoder", "Ljava/nio/charset/CharsetEncoder;", "buffer"})
public final class Cp1252Charset
extends Charset {
    @NotNull
    public static final Cp1252Charset INSTANCE = new Cp1252Charset();
    @NotNull
    private static final char[] CODE_PAGE;
    @NotNull
    private static final byte[] ENCODE_TABLE;
    @NotNull
    private static final char[] DECODE_TABLE;
    private static final char REPLACEMENT_CHAR = '\ufffd';
    private static final byte REPLACEMENT_BYTE = 63;

    private Cp1252Charset() {
        super("Cp1252", null);
    }

    public final char decode(byte by) {
        char c = DECODE_TABLE[by & 0xFF];
        return c == '\u0000' ? (char)'\ufffd' : c;
    }

    public final byte encode(char c) {
        byte by = ENCODE_TABLE[c];
        return by == 0 ? (byte)63 : by;
    }

    @Override
    public boolean contains(@NotNull Charset cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        return Charsets.US_ASCII.contains(cs) || cs instanceof Cp1252Charset;
    }

    @Override
    @NotNull
    public CharsetEncoder newEncoder() {
        Cp1252Charset cp1252Charset = INSTANCE;
        byte[] byArray = new byte[]{63};
        byte[] byArray2 = byArray;
        return new CharsetEncoder(cp1252Charset, byArray2){

            @NotNull
            protected CoderResult encodeLoop(@NotNull CharBuffer input, @NotNull ByteBuffer output) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                while (input.hasRemaining()) {
                    if (!output.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        Intrinsics.checkNotNullExpressionValue((Object)coderResult, (String)"OVERFLOW");
                        return coderResult;
                    }
                    char c = input.get();
                    byte by = Cp1252Charset.access$getENCODE_TABLE$p()[c];
                    if (by == 0) {
                        input.position(input.position() - 1);
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        Intrinsics.checkNotNullExpressionValue((Object)coderResult, (String)"unmappableForLength(...)");
                        return coderResult;
                    }
                    output.put(by);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                Intrinsics.checkNotNullExpressionValue((Object)coderResult, (String)"UNDERFLOW");
                return coderResult;
            }
        };
    }

    @Override
    @NotNull
    public CharsetDecoder newDecoder() {
        Cp1252Charset cp1252Charset = INSTANCE;
        return new CharsetDecoder(cp1252Charset){
            {
                this.replaceWith("\ufffd");
            }

            @NotNull
            protected CoderResult decodeLoop(@NotNull ByteBuffer input, @NotNull CharBuffer output) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                while (input.hasRemaining()) {
                    if (!output.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        Intrinsics.checkNotNullExpressionValue((Object)coderResult, (String)"OVERFLOW");
                        return coderResult;
                    }
                    byte by = input.get();
                    char c = Cp1252Charset.access$getDECODE_TABLE$p()[by & 0xFF];
                    if (c == '\u0000') {
                        input.position(input.position() - 1);
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        Intrinsics.checkNotNullExpressionValue((Object)coderResult, (String)"unmappableForLength(...)");
                        return coderResult;
                    }
                    output.put(c);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                Intrinsics.checkNotNullExpressionValue((Object)coderResult, (String)"UNDERFLOW");
                return coderResult;
            }
        };
    }

    public static final /* synthetic */ byte[] access$getENCODE_TABLE$p() {
        return ENCODE_TABLE;
    }

    public static final /* synthetic */ char[] access$getDECODE_TABLE$p() {
        return DECODE_TABLE;
    }

    static {
        char[] cArray = new char[]{'\u20ac', '\u0000', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u0000', '\u017d', '\u0000', '\u0000', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\u0000', '\u017e', '\u0178'};
        CODE_PAGE = cArray;
        ENCODE_TABLE = new byte[65536];
        DECODE_TABLE = new char[256];
        for (int b = 0; b < 256; ++b) {
            char c;
            char c2 = c = (128 <= b ? b < 160 : false) ? CODE_PAGE[b & 0x7F] : (char)b;
            if (c == '\u0000') continue;
            Cp1252Charset.ENCODE_TABLE[c] = (byte)b;
            Cp1252Charset.DECODE_TABLE[b] = c;
        }
    }
}

