/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.web.url;

import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import net.rpcnet.securitytoolkit.web.url.ExtendResult;
import net.rpcnet.securitytoolkit.web.url.ImmutableExtendResult;
import net.rpcnet.securitytoolkit.web.url.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlExtender {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlExtender.class);
    private static final String EXTEND_URL_ITERATION_URL = "Iteration URL: {}";

    private UrlExtender() {
    }

    public static ExtendResult extendUrl(String shortUrl) {
        String iterationResult;
        String iterationUrl = shortUrl;
        ArrayList<String> intermediateResults = new ArrayList<String>();
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        do {
            if (!Objects.nonNull(iterationResult = Utils.extendIteration(client, iterationUrl))) continue;
            LOGGER.debug(EXTEND_URL_ITERATION_URL, (Object)iterationResult);
            intermediateResults.add(iterationUrl);
            iterationUrl = iterationResult;
        } while (Objects.nonNull(iterationResult));
        intermediateResults.remove(shortUrl);
        boolean isSuccessful = !iterationUrl.equals(shortUrl);
        ImmutableExtendResult.Builder builder = ImmutableExtendResult.builder();
        builder.isSuccessful(isSuccessful);
        if (isSuccessful) {
            builder.finalResult(Optional.of(iterationUrl));
            builder.intermediateResults(intermediateResults);
        } else {
            builder.finalResult(Optional.empty());
            builder.intermediateResults(Collections.emptyList());
        }
        return builder.build();
    }
}

