/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.web.url;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.rpcnet.securitytoolkit.web.url.ExtendResult;
import org.immutables.value.Generated;

@Generated(from="ExtendResult", generator="Immutables")
public final class ImmutableExtendResult
implements ExtendResult {
    private final boolean isSuccessful;
    private final String finalResult;
    private final Collection<String> intermediateResults;

    private ImmutableExtendResult(boolean isSuccessful, String finalResult, Collection<String> intermediateResults) {
        this.isSuccessful = isSuccessful;
        this.finalResult = finalResult;
        this.intermediateResults = intermediateResults;
    }

    @Override
    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    @Override
    public Optional<String> getFinalResult() {
        return Optional.ofNullable(this.finalResult);
    }

    @Override
    public Collection<String> getIntermediateResults() {
        return this.intermediateResults;
    }

    public final ImmutableExtendResult withIsSuccessful(boolean value) {
        if (this.isSuccessful == value) {
            return this;
        }
        return new ImmutableExtendResult(value, this.finalResult, this.intermediateResults);
    }

    public final ImmutableExtendResult withFinalResult(String value) {
        String newValue = Objects.requireNonNull(value, "finalResult");
        if (Objects.equals(this.finalResult, newValue)) {
            return this;
        }
        return new ImmutableExtendResult(this.isSuccessful, newValue, this.intermediateResults);
    }

    public final ImmutableExtendResult withFinalResult(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.finalResult, value)) {
            return this;
        }
        return new ImmutableExtendResult(this.isSuccessful, value, this.intermediateResults);
    }

    public final ImmutableExtendResult withIntermediateResults(Collection<String> value) {
        if (this.intermediateResults == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "intermediateResults");
        return new ImmutableExtendResult(this.isSuccessful, this.finalResult, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtendResult && this.equalTo((ImmutableExtendResult)another);
    }

    private boolean equalTo(ImmutableExtendResult another) {
        return this.isSuccessful == another.isSuccessful && Objects.equals(this.finalResult, another.finalResult) && this.intermediateResults.equals(another.intermediateResults);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.isSuccessful);
        h += (h << 5) + Objects.hashCode(this.finalResult);
        h += (h << 5) + this.intermediateResults.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ExtendResult{");
        builder.append("isSuccessful=").append(this.isSuccessful);
        if (this.finalResult != null) {
            builder.append(", ");
            builder.append("finalResult=").append(this.finalResult);
        }
        builder.append(", ");
        builder.append("intermediateResults=").append(this.intermediateResults);
        return builder.append("}").toString();
    }

    public static ImmutableExtendResult copyOf(ExtendResult instance) {
        if (instance instanceof ImmutableExtendResult) {
            return (ImmutableExtendResult)instance;
        }
        return ImmutableExtendResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExtendResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_IS_SUCCESSFUL = 1L;
        private static final long INIT_BIT_INTERMEDIATE_RESULTS = 2L;
        private long initBits = 3L;
        private boolean isSuccessful;
        private String finalResult;
        private Collection<String> intermediateResults;

        private Builder() {
        }

        public final Builder from(ExtendResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.isSuccessful(instance.isSuccessful());
            Optional<String> finalResultOptional = instance.getFinalResult();
            if (finalResultOptional.isPresent()) {
                this.finalResult(finalResultOptional);
            }
            this.intermediateResults(instance.getIntermediateResults());
            return this;
        }

        public final Builder isSuccessful(boolean isSuccessful) {
            this.isSuccessful = isSuccessful;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder finalResult(String finalResult) {
            this.finalResult = Objects.requireNonNull(finalResult, "finalResult");
            return this;
        }

        public final Builder finalResult(Optional<String> finalResult) {
            this.finalResult = finalResult.orElse(null);
            return this;
        }

        public final Builder intermediateResults(Collection<String> intermediateResults) {
            this.intermediateResults = Objects.requireNonNull(intermediateResults, "intermediateResults");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableExtendResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtendResult(this.isSuccessful, this.finalResult, this.intermediateResults);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isSuccessful");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("intermediateResults");
            }
            return "Cannot build ExtendResult, some of required attributes are not set " + attributes;
        }
    }
}

