/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.web.ssl.caa;

import java.util.Objects;
import java.util.Optional;
import net.rpcnet.securitytoolkit.web.ssl.caa.CAAResult;
import org.immutables.value.Generated;

@Generated(from="CAAResult", generator="Immutables")
public final class ImmutableCAAResult
implements CAAResult {
    private final String tag;
    private final String value;
    private final Integer flags;

    private ImmutableCAAResult(String tag, String value, Integer flags) {
        this.tag = tag;
        this.value = value;
        this.flags = flags;
    }

    @Override
    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @Override
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Optional<Integer> getFlags() {
        return Optional.ofNullable(this.flags);
    }

    public final ImmutableCAAResult withTag(String value) {
        String newValue = Objects.requireNonNull(value, "tag");
        if (Objects.equals(this.tag, newValue)) {
            return this;
        }
        return new ImmutableCAAResult(newValue, this.value, this.flags);
    }

    public final ImmutableCAAResult withTag(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tag, value)) {
            return this;
        }
        return new ImmutableCAAResult(value, this.value, this.flags);
    }

    public final ImmutableCAAResult withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new ImmutableCAAResult(this.tag, newValue, this.flags);
    }

    public final ImmutableCAAResult withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ImmutableCAAResult(this.tag, value, this.flags);
    }

    public final ImmutableCAAResult withFlags(int value) {
        Integer newValue = value;
        if (Objects.equals(this.flags, newValue)) {
            return this;
        }
        return new ImmutableCAAResult(this.tag, this.value, newValue);
    }

    public final ImmutableCAAResult withFlags(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.flags, value)) {
            return this;
        }
        return new ImmutableCAAResult(this.tag, this.value, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCAAResult && this.equalTo((ImmutableCAAResult)another);
    }

    private boolean equalTo(ImmutableCAAResult another) {
        return Objects.equals(this.tag, another.tag) && Objects.equals(this.value, another.value) && Objects.equals(this.flags, another.flags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tag);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.flags);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CAAResult{");
        if (this.tag != null) {
            builder.append("tag=").append(this.tag);
        }
        if (this.value != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("value=").append(this.value);
        }
        if (this.flags != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("flags=").append(this.flags);
        }
        return builder.append("}").toString();
    }

    public static ImmutableCAAResult copyOf(CAAResult instance) {
        if (instance instanceof ImmutableCAAResult) {
            return (ImmutableCAAResult)instance;
        }
        return ImmutableCAAResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CAAResult", generator="Immutables")
    public static final class Builder {
        private String tag;
        private String value;
        private Integer flags;

        private Builder() {
        }

        public final Builder from(CAAResult instance) {
            Optional<Integer> flagsOptional;
            Optional<String> valueOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> tagOptional = instance.getTag();
            if (tagOptional.isPresent()) {
                this.tag(tagOptional);
            }
            if ((valueOptional = instance.getValue()).isPresent()) {
                this.value(valueOptional);
            }
            if ((flagsOptional = instance.getFlags()).isPresent()) {
                this.flags(flagsOptional);
            }
            return this;
        }

        public final Builder tag(String tag) {
            this.tag = Objects.requireNonNull(tag, "tag");
            return this;
        }

        public final Builder tag(Optional<String> tag) {
            this.tag = tag.orElse(null);
            return this;
        }

        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            return this;
        }

        public final Builder value(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public final Builder flags(Optional<Integer> flags) {
            this.flags = flags.orElse(null);
            return this;
        }

        public ImmutableCAAResult build() {
            return new ImmutableCAAResult(this.tag, this.value, this.flags);
        }
    }
}

