/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.web.ssl.caa;

import java.util.Collection;
import java.util.stream.Collectors;
import net.rpcnet.securitytoolkit.common.dns.RecordChecker;
import net.rpcnet.securitytoolkit.web.ssl.caa.CAAResult;
import net.rpcnet.securitytoolkit.web.ssl.caa.ImmutableCAAResult;

public final class DNSCAAChecker {
    private DNSCAAChecker() {
    }

    public static Collection<CAAResult> checkDNSCAA(String domain) {
        Collection caa = RecordChecker.getCAA((String)domain);
        return caa.stream().map(DNSCAAChecker::buildCAAResult).collect(Collectors.toList());
    }

    public static CAAResult buildCAAResult(RecordChecker.CAADto dto) {
        return ImmutableCAAResult.builder().flags(dto.getFlags()).tag(dto.getTag()).value(dto.getValue()).build();
    }
}

