/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.mail.spf;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.rpcnet.securitytoolkit.mail.spf.SPFElement;
import net.rpcnet.securitytoolkit.mail.spf.SPFQualifier;
import org.immutables.value.Value;

@Value.Immutable
public abstract class SPFResult {
    private static final String VERSION_KEY = "v=spf";
    private static final String MAIL_EXCHANGE_KEY = "mx";
    private static final String A_KEY = "a";
    private static final String ALL_KEY = "all";
    private static final String INCLUDE_KEY = "include:";
    private static final String IP4_KEY = "ip4:";
    private static final String IP6_KEY = "ip6:";

    public abstract Optional<Integer> getVersion();

    public abstract Optional<SPFQualifier> getMailExchangeQualifier();

    public abstract Optional<SPFQualifier> getAQualifier();

    public abstract List<SPFElement> getIp4Records();

    public abstract List<SPFElement> getIp6Records();

    public abstract Optional<SPFQualifier> getAllQualifier();

    public abstract List<SPFElement> getIncludeRecords();

    public String toString() {
        ArrayList list = new ArrayList();
        this.getMailExchangeQualifier().ifPresent(s -> list.add(s.getSign() + MAIL_EXCHANGE_KEY));
        this.getVersion().ifPresent(s -> list.add(VERSION_KEY + s));
        this.getAQualifier().ifPresent(s -> list.add(s.getSign() + A_KEY));
        this.getAllQualifier().ifPresent(s -> list.add(s.getSign() + ALL_KEY));
        this.getIncludeRecords().forEach(s -> list.add(s.getQualifier().getSign() + INCLUDE_KEY + s.getValue()));
        this.getIp4Records().forEach(s -> list.add(s.getQualifier().getSign() + INCLUDE_KEY + s.getValue()));
        this.getIp6Records().forEach(s -> list.add(s.getQualifier().getSign() + INCLUDE_KEY + s.getValue()));
        return String.join((CharSequence)" ", list);
    }
}

