/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.mail.spf;

import java.util.Optional;
import net.rpcnet.securitytoolkit.common.dns.RecordChecker;
import net.rpcnet.securitytoolkit.mail.spf.SPFParser;
import net.rpcnet.securitytoolkit.mail.spf.SPFResult;

public class SPFChecker {
    public static final String SPF = "spf";

    private SPFChecker() {
    }

    public static Optional<SPFResult> getSPF(String domain) {
        Optional<String> dnsResponse = RecordChecker.getTXT((String)domain).stream().filter(str -> str.contains(SPF)).findAny();
        if (dnsResponse.isEmpty()) {
            return Optional.empty();
        }
        return SPFParser.parseSPF(dnsResponse.get());
    }
}

